'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _desc, _value, _class, _class2, _temp, _class3, _temp2, _class4, _temp3;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _coreDecorators = require('core-decorators');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

function getClasses(staticClasses, active) {
  return (0, _classnames2.default)(...staticClasses, {
    inactive: !active,
    active
  });
}

let TabsNavigationItem = (_class = (_temp = _class2 = class TabsNavigationItem extends _react2.default.Component {

  render() {
    const classes = getClasses(['github-Tabs-NavigationItem'], this.props.active);
    return _react2.default.createElement(
      'div',
      { className: classes, onClick: this.handleClick },
      this.props.title
    );
  }

  handleClick() {
    this.props.onClick(this.props.tabIndex);
  }
}, _class2.propTypes = {
  title: _propTypes2.default.node,
  tabIndex: _propTypes2.default.number.isRequired,
  active: _propTypes2.default.bool,
  onClick: _propTypes2.default.func
}, _temp), (_applyDecoratedDescriptor(_class.prototype, 'handleClick', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'handleClick'), _class.prototype)), _class);
let Tabs = (_temp2 = _class3 = class Tabs extends _react2.default.Component {

  render() {
    const children = _react2.default.Children.toArray(this.props.children).filter(v => !!v);
    return _react2.default.createElement(
      'div',
      { className: (0, _classnames2.default)('github-Tabs', this.props.className), 'data-tabs-count': children.length },
      _react2.default.createElement(
        'nav',
        { className: 'github-Tabs-NavigationContainer' },
        children.map((child, i) => child && _react2.default.createElement(TabsNavigationItem, {
          key: i,
          title: child.props.title,
          active: this.props.activeIndex === i,
          tabIndex: i,
          onClick: this.props.onChange
        }))
      ),
      _react2.default.createElement(
        'section',
        { className: 'github-Tabs-PanelContainer' },
        children.map((child, i) => child && _react2.default.cloneElement(child, { active: i === this.props.activeIndex }))
      )
    );
  }
}, _class3.propTypes = {
  className: _propTypes2.default.string,
  activeIndex: _propTypes2.default.number.isRequired,
  children: _propTypes2.default.node,
  onChange: _propTypes2.default.func
}, _class3.defaultProps = {
  className: '',
  onChange: () => {}
}, _temp2);
exports.default = Tabs;


Tabs.Panel = (_temp3 = _class4 = class TabPanel extends _react2.default.Component {

  render() {
    // eslint-disable-next-line no-unused-vars
    var _props = this.props;

    const active = _props.active,
          children = _props.children,
          className = _props.className,
          title = _props.title,
          others = _objectWithoutProperties(_props, ['active', 'children', 'className', 'title']);

    return _react2.default.createElement(
      'div',
      _extends({ className: getClasses(['github-Tabs-Panel', className], this.props.active) }, others),
      this.props.children
    );
  }
}, _class4.propTypes = {
  className: _propTypes2.default.string,
  active: _propTypes2.default.bool,
  children: _propTypes2.default.node,
  title: _propTypes2.default.node
}, _class4.defaultProps = {
  className: '',
  active: false
}, _temp3);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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