'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _desc, _value, _class, _class2, _temp; /** @jsx etch.dom */
/* eslint react/no-unknown-property: "off" */

var _eventKit = require('event-kit');

var _electron = require('electron');

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _coreDecorators = require('core-decorators');

var _filePatchListItemView = require('./file-patch-list-item-view');

var _filePatchListItemView2 = _interopRequireDefault(_filePatchListItemView);

var _mergeConflictListItemView = require('./merge-conflict-list-item-view');

var _mergeConflictListItemView2 = _interopRequireDefault(_mergeConflictListItemView);

var _compositeListSelection = require('./composite-list-selection');

var _compositeListSelection2 = _interopRequireDefault(_compositeListSelection);

var _resolutionProgress = require('../models/conflicts/resolution-progress');

var _resolutionProgress2 = _interopRequireDefault(_resolutionProgress);

var _modelObserver = require('../models/model-observer');

var _modelObserver2 = _interopRequireDefault(_modelObserver);

var _helpers = require('../helpers');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

const Menu = _electron.remote.Menu,
      MenuItem = _electron.remote.MenuItem;


const debounce = (fn, wait) => {
  let timeout;
  return function () {
    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return new Promise(resolve => {
      clearTimeout(timeout);
      timeout = setTimeout(() => {
        resolve(fn(...args));
      }, wait);
    });
  };
};

const MAXIMUM_LISTED_ENTRIES = 1000;

let StagingView = (_class = (_temp = _class2 = class StagingView {

  constructor(props) {
    this.props = props;
    this.truncatedLists = this.calculateTruncatedLists({
      unstagedChanges: this.props.unstagedChanges,
      stagedChanges: this.props.stagedChanges,
      mergeConflicts: this.props.mergeConflicts || []
    });
    atom.config.observe('github.keyboardNavigationDelay', value => {
      if (value === 0) {
        this.debouncedDidChangeSelectedItem = this.didChangeSelectedItems;
      } else {
        this.debouncedDidChangeSelectedItem = debounce(this.didChangeSelectedItems, value);
      }
    });
    this.mouseSelectionInProgress = false;
    this.listElementsByItem = new WeakMap();

    this.selection = new _compositeListSelection2.default({
      listsByKey: {
        unstaged: this.props.unstagedChanges,
        conflicts: this.props.mergeConflicts || [],
        staged: this.props.stagedChanges
      },
      idForItem: item => item.filePath
    });

    this.resolutionProgressObserver = new _modelObserver2.default({
      didUpdate: () => {
        if (this.element) {
          _etch2.default.update(this);
        }
      }
    });
    this.resolutionProgressObserver.setActiveModel(this.props.resolutionProgress);

    _etch2.default.initialize(this);

    this.subscriptions = new _eventKit.CompositeDisposable();
    this.subscriptions.add(this.props.commandRegistry.add(this.element, {
      'core:move-up': () => this.selectPrevious(),
      'core:move-down': () => this.selectNext(),
      'core:move-left': () => this.diveIntoSelection(),
      'core:select-up': () => this.selectPrevious(true),
      'core:select-down': () => this.selectNext(true),
      'core:select-all': () => this.selectAll(),
      'core:move-to-top': () => this.selectFirst(),
      'core:move-to-bottom': () => this.selectLast(),
      'core:select-to-top': () => this.selectFirst(true),
      'core:select-to-bottom': () => this.selectLast(true),
      'core:confirm': () => this.confirmSelectedItems(),
      'github:activate-next-list': () => this.activateNextList(),
      'github:activate-previous-list': () => this.activatePreviousList(),
      'github:open-file': () => this.openFile(),
      'github:resolve-file-as-ours': () => this.resolveCurrentAsOurs(),
      'github:resolve-file-as-theirs': () => this.resolveCurrentAsTheirs(),
      'core:undo': () => this.props.hasUndoHistory && this.undoLastDiscard()
    }));
    this.subscriptions.add(this.props.commandRegistry.add('atom-workspace', {
      'github:stage-all-changes': () => this.stageAll(),
      'github:unstage-all-changes': () => this.unstageAll(),
      'github:discard-all-changes': () => this.discardAll(),
      'github:undo-last-discard-in-git-tab': () => this.props.hasUndoHistory && this.undoLastDiscard()
    }));
    this.subscriptions.add(this.props.commandRegistry.add(this.refs.unstagedChanges, {
      'github:discard-changes-in-selected-files': () => this.discardChanges()
    }));
    window.addEventListener('mouseup', this.mouseup);
    this.subscriptions.add(new _eventKit.Disposable(() => window.removeEventListener('mouseup', this.mouseup)));
  }

  getSelectedConflictPaths() {
    if (this.selection.getActiveListKey() !== 'conflicts') {
      return [];
    }
    return Array.from(this.selection.getSelectedItems(), item => item.filePath);
  }

  update(props) {
    var _this = this;

    return _asyncToGenerator(function* () {
      const oldProps = _this.props;
      _this.props = _extends({}, _this.props, props);
      _this.truncatedLists = _this.calculateTruncatedLists({
        unstagedChanges: _this.props.unstagedChanges,
        stagedChanges: _this.props.stagedChanges,
        mergeConflicts: _this.props.mergeConflicts || []
      });
      _this.selection.updateLists({
        unstaged: _this.props.unstagedChanges,
        conflicts: _this.props.mergeConflicts || [],
        staged: _this.props.stagedChanges
      });

      if (_this.props.resolutionProgress !== oldProps.resolutionProgress) {
        yield _this.resolutionProgressObserver.setActiveModel(_this.props.resolutionProgress);
      }

      return _etch2.default.update(_this);
    })();
  }

  calculateTruncatedLists(lists) {
    return Object.keys(lists).reduce((acc, key) => {
      const list = lists[key];
      if (list.length <= MAXIMUM_LISTED_ENTRIES) {
        acc[key] = list;
      } else {
        acc[key] = list.slice(0, MAXIMUM_LISTED_ENTRIES);
      }
      return acc;
    }, {});
  }

  openFile() {
    const filePaths = Array.from(this.selection.getSelectedItems()).map(item => item.filePath);
    return this.props.openFiles(filePaths);
  }

  discardChanges() {
    const filePaths = Array.from(this.selection.getSelectedItems()).map(item => item.filePath);
    return this.props.discardWorkDirChangesForPaths(filePaths);
  }

  activateNextList() {
    if (!this.selection.activateNextSelection()) {
      return false;
    }

    this.selection.coalesce();
    this.didChangeSelectedItems();
    _etch2.default.update(this);
    return true;
  }

  activatePreviousList() {
    if (!this.selection.activatePreviousSelection()) {
      return false;
    }

    this.selection.coalesce();
    this.didChangeSelectedItems();
    _etch2.default.update(this);
    return true;
  }

  activateLastList() {
    if (!this.selection.activateLastSelection()) {
      return false;
    }

    this.selection.coalesce();
    this.didChangeSelectedItems();
    _etch2.default.update(this);
    return true;
  }

  stageAll() {
    if (this.props.unstagedChanges.length === 0) {
      return null;
    }
    const filePaths = this.props.unstagedChanges.map(filePatch => filePatch.filePath);
    return this.props.attemptFileStageOperation(filePaths, 'unstaged');
  }

  unstageAll() {
    if (this.props.stagedChanges.length === 0) {
      return null;
    }
    const filePaths = this.props.stagedChanges.map(filePatch => filePatch.filePath);
    return this.props.attemptFileStageOperation(filePaths, 'staged');
  }

  stageAllMergeConflicts() {
    if (this.props.mergeConflicts.length === 0) {
      return null;
    }
    const filePaths = this.props.mergeConflicts.map(conflict => conflict.filePath);
    return this.props.attemptFileStageOperation(filePaths, 'unstaged');
  }

  discardAll() {
    if (this.props.unstagedChanges.length === 0) {
      return null;
    }
    const filePaths = this.props.unstagedChanges.map(filePatch => filePatch.filePath);
    return this.props.discardWorkDirChangesForPaths(filePaths);
  }

  confirmSelectedItems() {
    const itemPaths = Array.from(this.selection.getSelectedItems()).map(item => item.filePath);
    return this.props.attemptFileStageOperation(itemPaths, this.selection.getActiveListKey());
  }

  getNextListUpdatePromise() {
    return this.selection.getNextUpdatePromise();
  }

  selectPrevious() {
    let preserveTail = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;

    this.selection.selectPreviousItem(preserveTail);
    this.selection.coalesce();
    if (!preserveTail) {
      this.debouncedDidChangeSelectedItem();
    }
    return _etch2.default.update(this);
  }

  selectNext() {
    let preserveTail = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;

    this.selection.selectNextItem(preserveTail);
    this.selection.coalesce();
    if (!preserveTail) {
      this.debouncedDidChangeSelectedItem();
    }
    return _etch2.default.update(this);
  }

  selectAll() {
    this.selection.selectAllItems();
    this.selection.coalesce();
    return _etch2.default.update(this);
  }

  selectFirst() {
    let preserveTail = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;

    this.selection.selectFirstItem(preserveTail);
    this.selection.coalesce();
    if (!preserveTail) {
      this.debouncedDidChangeSelectedItem();
    }
    return _etch2.default.update(this);
  }

  selectLast() {
    let preserveTail = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;

    this.selection.selectLastItem(preserveTail);
    this.selection.coalesce();
    if (!preserveTail) {
      this.debouncedDidChangeSelectedItem();
    }
    return _etch2.default.update(this);
  }

  diveIntoSelection() {
    const selectedItems = this.selection.getSelectedItems();
    if (selectedItems.size !== 1) {
      return;
    }

    const selectedItem = selectedItems.values().next().value;
    const stagingStatus = this.selection.getActiveListKey();

    if (stagingStatus === 'conflicts') {
      if (this.props.didDiveIntoMergeConflictPath) {
        this.props.didDiveIntoMergeConflictPath(selectedItem.filePath);
      }
    } else {
      if (this.props.didDiveIntoFilePath) {
        const amending = this.props.isAmending && this.selection.getActiveListKey() === 'staged';
        this.props.didDiveIntoFilePath(selectedItem.filePath, this.selection.getActiveListKey(), { amending });
      }
    }
  }

  showBulkResolveMenu(event) {
    const conflictPaths = this.props.mergeConflicts.map(c => c.filePath);

    event.preventDefault();

    const menu = new Menu();

    menu.append(new MenuItem({
      label: 'Resolve All as Ours',
      click: () => this.props.resolveAsOurs(conflictPaths)
    }));

    menu.append(new MenuItem({
      label: 'Resolve All as Theirs',
      click: () => this.props.resolveAsTheirs(conflictPaths)
    }));

    menu.popup(_electron.remote.getCurrentWindow());
  }

  resolveCurrentAsOurs() {
    this.props.resolveAsOurs(this.getSelectedConflictPaths());
  }

  resolveCurrentAsTheirs() {
    this.props.resolveAsTheirs(this.getSelectedConflictPaths());
  }

  writeAfterUpdate() {
    const headItem = this.selection.getHeadItem();
    if (headItem) {
      this.listElementsByItem.get(headItem).scrollIntoViewIfNeeded();
    }
  }

  // Directly modify the selection to include only the item identified by the file path and stagingStatus tuple.
  // Re-render the component, but don't notify didSelectSingleItem() or other callback functions. This is useful to
  // avoid circular callback loops for actions originating in FilePatchView or TextEditors with merge conflicts.
  quietlySelectItem(filePath, stagingStatus) {
    const item = this.selection.findItem((each, key) => each.filePath === filePath && key === stagingStatus);
    if (!item) {
      return Promise.reject(new Error(`Unable to find item at path ${filePath} with staging status ${stagingStatus}`));
    }

    this.selection.selectItem(item);
    return _etch2.default.update(this);
  }

  didChangeSelectedItems() {
    const selectedItems = Array.from(this.selection.getSelectedItems());
    if (selectedItems.length === 1) {
      this.didSelectSingleItem(selectedItems[0]);
    }
  }

  didSelectSingleItem(selectedItem) {
    if (this.selection.getActiveListKey() === 'conflicts') {
      if (this.props.didSelectMergeConflictFile) {
        this.props.didSelectMergeConflictFile(selectedItem.filePath);
      }
    } else {
      if (this.props.didSelectFilePath) {
        const amending = this.props.isAmending && this.selection.getActiveListKey() === 'staged';
        this.props.didSelectFilePath(selectedItem.filePath, this.selection.getActiveListKey(), { amending, activate: true });
      }
    }
  }

  dblclickOnItem(event, item) {
    return this.props.attemptFileStageOperation([item.filePath], this.selection.listKeyForItem(item));
  }

  contextMenuOnItem(event, item) {
    var _this2 = this;

    return _asyncToGenerator(function* () {
      if (!_this2.selection.getSelectedItems().has(item)) {
        event.stopPropagation();
        _this2.selection.selectItem(item, event.shiftKey);
        yield _etch2.default.update(_this2);
        const newEvent = new MouseEvent(event.type, event);
        requestAnimationFrame(function () {
          event.target.parentNode.dispatchEvent(newEvent);
        });
      }
    })();
  }

  mousedownOnItem(event, item) {
    var _this3 = this;

    return _asyncToGenerator(function* () {
      const windows = process.platform === 'win32';
      if (event.ctrlKey && !windows) {
        return;
      } // simply open context menu
      if (event.button === 0) {
        _this3.mouseSelectionInProgress = true;
        _this3.selectionChanged = true;
        if (event.metaKey || event.ctrlKey && windows) {
          _this3.selection.addOrSubtractSelection(item);
        } else {
          _this3.selection.selectItem(item, event.shiftKey);
        }
        yield _etch2.default.update(_this3);
      }
    })();
  }

  mousemoveOnItem(event, item) {
    var _this4 = this;

    return _asyncToGenerator(function* () {
      if (_this4.mouseSelectionInProgress) {
        _this4.selectionChanged = true;
        _this4.selection.selectItem(item, true);
        yield _etch2.default.update(_this4);
      }
    })();
  }

  mouseup() {
    this.selection.coalesce();
    if (this.selectionChanged) {
      this.didChangeSelectedItems();
    }
    this.mouseSelectionInProgress = false;
    this.selectionChanged = false;
  }

  render() {
    const selectedItems = this.selection.getSelectedItems();

    return _etch2.default.dom(
      'div',
      {
        className: `github-StagingView ${this.selection.getActiveListKey()}-changes-focused`,
        style: { width: 200 },
        tabIndex: '-1' },
      _etch2.default.dom(
        'div',
        { className: `github-StagingView-group github-UnstagedChanges ${this.getFocusClass('unstaged')}` },
        _etch2.default.dom(
          'header',
          { className: 'github-StagingView-header' },
          _etch2.default.dom('span', { className: 'icon icon-list-unordered' }),
          _etch2.default.dom(
            'span',
            { className: 'github-StagingView-title' },
            'Unstaged Changes'
          ),
          this.props.unstagedChanges.length ? this.renderStageAllButton() : null
        ),
        this.props.hasUndoHistory ? this.renderUndoButton() : null,
        _etch2.default.dom(
          'div',
          { ref: 'unstagedChanges', className: 'github-StagingView-list github-FilePatchListView' },
          this.truncatedLists.unstagedChanges.map(filePatch => _etch2.default.dom(_filePatchListItemView2.default, {
            key: filePatch.filePath,
            registerItemElement: this.registerItemElement,
            filePatch: filePatch,
            ondblclick: event => this.dblclickOnItem(event, filePatch),
            oncontextmenu: event => this.contextMenuOnItem(event, filePatch),
            onmousedown: event => this.mousedownOnItem(event, filePatch),
            onmousemove: event => this.mousemoveOnItem(event, filePatch),
            selected: selectedItems.has(filePatch)
          }))
        ),
        this.renderTruncatedMessage(this.props.unstagedChanges)
      ),
      this.renderMergeConflicts(),
      _etch2.default.dom(
        'div',
        { className: `github-StagingView-group github-StagedChanges ${this.getFocusClass('staged')}` },
        _etch2.default.dom(
          'header',
          { className: 'github-StagingView-header' },
          _etch2.default.dom('span', { className: 'icon icon-tasklist' }),
          _etch2.default.dom(
            'span',
            { className: 'github-StagingView-title' },
            'Staged Changes',
            this.props.isAmending ? ` (amending ${(0, _helpers.shortenSha)(this.props.lastCommit.getSha())})` : ''
          ),
          this.props.stagedChanges.length ? this.renderUnstageAllButton() : null
        ),
        _etch2.default.dom(
          'div',
          { ref: 'stagedChanges', className: 'github-StagingView-list github-FilePatchListView' },
          this.truncatedLists.stagedChanges.map(filePatch => _etch2.default.dom(_filePatchListItemView2.default, {
            key: filePatch.filePath,
            filePatch: filePatch,
            registerItemElement: this.registerItemElement,
            ondblclick: event => this.dblclickOnItem(event, filePatch),
            oncontextmenu: event => this.contextMenuOnItem(event, filePatch),
            onmousedown: event => this.mousedownOnItem(event, filePatch),
            onmousemove: event => this.mousemoveOnItem(event, filePatch),
            selected: selectedItems.has(filePatch)
          }))
        ),
        this.renderTruncatedMessage(this.props.stagedChanges)
      )
    );
  }

  renderMergeConflicts() {
    const mergeConflicts = this.truncatedLists.mergeConflicts;

    if (mergeConflicts && mergeConflicts.length > 0) {
      const selectedItems = this.selection.getSelectedItems();
      const resolutionProgress = this.resolutionProgressObserver.getActiveModel() || new _resolutionProgress2.default();
      const anyUnresolved = mergeConflicts.map(conflict => _path2.default.join(this.props.workingDirectoryPath, conflict.filePath)).some(conflictPath => resolutionProgress.getRemaining(conflictPath) !== 0);

      const bulkResolveDropdown = anyUnresolved ? _etch2.default.dom('span', {
        className: 'inline-block icon icon-ellipses',
        onclick: this.showBulkResolveMenu
      }) : null;

      return _etch2.default.dom(
        'div',
        { className: `github-StagingView-group github-MergeConflictPaths ${this.getFocusClass('conflicts')}` },
        _etch2.default.dom(
          'header',
          { className: 'github-StagingView-header' },
          _etch2.default.dom('span', { className: 'github-FilePatchListView-icon icon icon-alert status-modified' }),
          _etch2.default.dom(
            'span',
            { className: 'github-StagingView-title' },
            'Merge Conflicts'
          ),
          bulkResolveDropdown,
          _etch2.default.dom(
            'button',
            {
              className: 'github-StagingView-headerButton icon icon-move-down',
              disabled: anyUnresolved,
              onclick: this.stageAllMergeConflicts },
            'Stage All'
          )
        ),
        _etch2.default.dom(
          'div',
          { ref: 'mergeConflicts', className: 'github-StagingView-list github-FilePatchListView' },
          mergeConflicts.map(mergeConflict => {
            const fullPath = _path2.default.join(this.props.workingDirectoryPath, mergeConflict.filePath);

            return _etch2.default.dom(_mergeConflictListItemView2.default, {
              key: fullPath,
              mergeConflict: mergeConflict,
              remainingConflicts: resolutionProgress.getRemaining(fullPath),
              registerItemElement: this.registerItemElement,
              ondblclick: event => this.dblclickOnItem(event, mergeConflict),
              oncontextmenu: event => this.contextMenuOnItem(event, mergeConflict),
              onmousedown: event => this.mousedownOnItem(event, mergeConflict),
              onmousemove: event => this.mousemoveOnItem(event, mergeConflict),
              selected: selectedItems.has(mergeConflict)
            });
          })
        ),
        this.renderTruncatedMessage(mergeConflicts)
      );
    } else {
      return _etch2.default.dom('noscript', null);
    }
  }

  renderStageAllButton() {
    return _etch2.default.dom(
      'button',
      {
        className: 'github-StagingView-headerButton icon icon-move-down',
        onclick: this.stageAll },
      'Stage All'
    );
  }

  renderUnstageAllButton() {
    return _etch2.default.dom(
      'button',
      { className: 'github-StagingView-headerButton icon icon-move-up',
        onclick: this.unstageAll },
      'Unstage All'
    );
  }

  renderUndoButton() {
    return _etch2.default.dom(
      'button',
      { className: 'github-StagingView-headerButton github-StagingView-headerButton--fullWidth icon icon-history',
        onclick: this.undoLastDiscard },
      'Undo Discard'
    );
  }

  renderTruncatedMessage(list) {
    if (list.length > MAXIMUM_LISTED_ENTRIES) {
      return _etch2.default.dom(
        'div',
        { className: 'github-StagingView-group-truncatedMsg' },
        'List truncated to the first ',
        MAXIMUM_LISTED_ENTRIES,
        ' items'
      );
    } else {
      return null;
    }
  }

  undoLastDiscard() {
    return this.props.undoLastDiscard();
  }

  getFocusClass(listKey) {
    return this.selection.getActiveListKey() === listKey ? 'is-focused' : '';
  }

  registerItemElement(item, element) {
    this.listElementsByItem.set(item, element);
  }

  destroy() {
    this.resolutionProgressObserver.destroy();
    this.subscriptions.dispose();
    _etch2.default.destroy(this);
  }

  rememberFocus(event) {
    return this.element.contains(event.target) ? StagingView.focus.STAGING : null;
  }

  setFocus(focus) {
    if (focus === StagingView.focus.STAGING) {
      this.element.focus();
      return true;
    }

    return false;
  }
}, _class2.focus = {
  STAGING: Symbol('staging')
}, _temp), (_applyDecoratedDescriptor(_class.prototype, 'activateNextList', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'activateNextList'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'activatePreviousList', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'activatePreviousList'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'stageAll', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'stageAll'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'unstageAll', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'unstageAll'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'stageAllMergeConflicts', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'stageAllMergeConflicts'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'discardAll', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'discardAll'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'diveIntoSelection', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'diveIntoSelection'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'showBulkResolveMenu', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'showBulkResolveMenu'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'resolveCurrentAsOurs', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'resolveCurrentAsOurs'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'resolveCurrentAsTheirs', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'resolveCurrentAsTheirs'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'didChangeSelectedItems', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'didChangeSelectedItems'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'dblclickOnItem', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'dblclickOnItem'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'contextMenuOnItem', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'contextMenuOnItem'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'mousedownOnItem', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'mousedownOnItem'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'mousemoveOnItem', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'mousemoveOnItem'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'mouseup', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'mouseup'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'renderStageAllButton', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'renderStageAllButton'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'undoLastDiscard', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'undoLastDiscard'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'registerItemElement', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'registerItemElement'), _class.prototype)), _class);
exports.default = StagingView;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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