'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactDom = require('react-dom');

var _reactDom2 = _interopRequireDefault(_reactDom);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

let SimpleTooltip = (_temp = _class = class SimpleTooltip extends _react2.default.Component {

  componentDidMount() {
    this.disposable = this.props.tooltips.add(_reactDom2.default.findDOMNode(this.child), { title: () => this.props.title });
  }

  componentWillUnmount() {
    this.disposable.dispose();
  }

  componentDidUpdate(prevProps) {
    if (prevProps.title !== this.props.title) {
      this.disposable.dispose();
      this.disposable = this.props.tooltips.add(_reactDom2.default.findDOMNode(this.child), { title: () => this.props.title });
    }
  }

  render() {
    const child = _react2.default.Children.only(this.props.children);
    return _react2.default.cloneElement(child, { ref: e => {
        this.child = e;
      } });
  }
}, _class.propTypes = {
  tooltips: _propTypes2.default.object.isRequired,
  children: _propTypes2.default.node.isRequired,
  title: _propTypes2.default.string.isRequired
}, _temp);
exports.default = SimpleTooltip;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNpbXBsZS10b29sdGlwLmpzIl0sIm5hbWVzIjpbIlNpbXBsZVRvb2x0aXAiLCJDb21wb25lbnQiLCJjb21wb25lbnREaWRNb3VudCIsImRpc3Bvc2FibGUiLCJwcm9wcyIsInRvb2x0aXBzIiwiYWRkIiwiZmluZERPTU5vZGUiLCJjaGlsZCIsInRpdGxlIiwiY29tcG9uZW50V2lsbFVubW91bnQiLCJkaXNwb3NlIiwiY29tcG9uZW50RGlkVXBkYXRlIiwicHJldlByb3BzIiwicmVuZGVyIiwiQ2hpbGRyZW4iLCJvbmx5IiwiY2hpbGRyZW4iLCJjbG9uZUVsZW1lbnQiLCJyZWYiLCJlIiwicHJvcFR5cGVzIiwib2JqZWN0IiwiaXNSZXF1aXJlZCIsIm5vZGUiLCJzdHJpbmciXSwibWFwcGluZ3MiOiI7Ozs7Ozs7OztBQUFBOzs7O0FBQ0E7Ozs7QUFDQTs7Ozs7O0lBRXFCQSxhLHFCQUFOLE1BQU1BLGFBQU4sU0FBNEIsZ0JBQU1DLFNBQWxDLENBQTRDOztBQU96REMsc0JBQW9CO0FBQ2xCLFNBQUtDLFVBQUwsR0FBa0IsS0FBS0MsS0FBTCxDQUFXQyxRQUFYLENBQW9CQyxHQUFwQixDQUF3QixtQkFBU0MsV0FBVCxDQUFxQixLQUFLQyxLQUExQixDQUF4QixFQUEwRCxFQUFDQyxPQUFPLE1BQU0sS0FBS0wsS0FBTCxDQUFXSyxLQUF6QixFQUExRCxDQUFsQjtBQUNEOztBQUVEQyx5QkFBdUI7QUFDckIsU0FBS1AsVUFBTCxDQUFnQlEsT0FBaEI7QUFDRDs7QUFFREMscUJBQW1CQyxTQUFuQixFQUE4QjtBQUM1QixRQUFJQSxVQUFVSixLQUFWLEtBQW9CLEtBQUtMLEtBQUwsQ0FBV0ssS0FBbkMsRUFBMEM7QUFDeEMsV0FBS04sVUFBTCxDQUFnQlEsT0FBaEI7QUFDQSxXQUFLUixVQUFMLEdBQWtCLEtBQUtDLEtBQUwsQ0FBV0MsUUFBWCxDQUFvQkMsR0FBcEIsQ0FBd0IsbUJBQVNDLFdBQVQsQ0FBcUIsS0FBS0MsS0FBMUIsQ0FBeEIsRUFBMEQsRUFBQ0MsT0FBTyxNQUFNLEtBQUtMLEtBQUwsQ0FBV0ssS0FBekIsRUFBMUQsQ0FBbEI7QUFDRDtBQUNGOztBQUVESyxXQUFTO0FBQ1AsVUFBTU4sUUFBUSxnQkFBTU8sUUFBTixDQUFlQyxJQUFmLENBQW9CLEtBQUtaLEtBQUwsQ0FBV2EsUUFBL0IsQ0FBZDtBQUNBLFdBQU8sZ0JBQU1DLFlBQU4sQ0FBbUJWLEtBQW5CLEVBQTBCLEVBQUNXLEtBQUtDLEtBQUs7QUFBRSxhQUFLWixLQUFMLEdBQWFZLENBQWI7QUFBaUIsT0FBOUIsRUFBMUIsQ0FBUDtBQUNEO0FBekJ3RCxDLFNBQ2xEQyxTLEdBQVk7QUFDakJoQixZQUFVLG9CQUFVaUIsTUFBVixDQUFpQkMsVUFEVjtBQUVqQk4sWUFBVSxvQkFBVU8sSUFBVixDQUFlRCxVQUZSO0FBR2pCZCxTQUFPLG9CQUFVZ0IsTUFBVixDQUFpQkY7QUFIUCxDO2tCQURBdkIsYSIsImZpbGUiOiJzaW1wbGUtdG9vbHRpcC5qcyIsInNvdXJjZVJvb3QiOiIvaG9tZS90cmF2aXMvYnVpbGQvYXRvbS9hdG9tL291dC9hcHAvbm9kZV9tb2R1bGVzL2dpdGh1YiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBSZWFjdCBmcm9tICdyZWFjdCc7XG5pbXBvcnQgUmVhY3RET00gZnJvbSAncmVhY3QtZG9tJztcbmltcG9ydCBQcm9wVHlwZXMgZnJvbSAncHJvcC10eXBlcyc7XG5cbmV4cG9ydCBkZWZhdWx0IGNsYXNzIFNpbXBsZVRvb2x0aXAgZXh0ZW5kcyBSZWFjdC5Db21wb25lbnQge1xuICBzdGF0aWMgcHJvcFR5cGVzID0ge1xuICAgIHRvb2x0aXBzOiBQcm9wVHlwZXMub2JqZWN0LmlzUmVxdWlyZWQsXG4gICAgY2hpbGRyZW46IFByb3BUeXBlcy5ub2RlLmlzUmVxdWlyZWQsXG4gICAgdGl0bGU6IFByb3BUeXBlcy5zdHJpbmcuaXNSZXF1aXJlZCxcbiAgfVxuXG4gIGNvbXBvbmVudERpZE1vdW50KCkge1xuICAgIHRoaXMuZGlzcG9zYWJsZSA9IHRoaXMucHJvcHMudG9vbHRpcHMuYWRkKFJlYWN0RE9NLmZpbmRET01Ob2RlKHRoaXMuY2hpbGQpLCB7dGl0bGU6ICgpID0+IHRoaXMucHJvcHMudGl0bGV9KTtcbiAgfVxuXG4gIGNvbXBvbmVudFdpbGxVbm1vdW50KCkge1xuICAgIHRoaXMuZGlzcG9zYWJsZS5kaXNwb3NlKCk7XG4gIH1cblxuICBjb21wb25lbnREaWRVcGRhdGUocHJldlByb3BzKSB7XG4gICAgaWYgKHByZXZQcm9wcy50aXRsZSAhPT0gdGhpcy5wcm9wcy50aXRsZSkge1xuICAgICAgdGhpcy5kaXNwb3NhYmxlLmRpc3Bvc2UoKTtcbiAgICAgIHRoaXMuZGlzcG9zYWJsZSA9IHRoaXMucHJvcHMudG9vbHRpcHMuYWRkKFJlYWN0RE9NLmZpbmRET01Ob2RlKHRoaXMuY2hpbGQpLCB7dGl0bGU6ICgpID0+IHRoaXMucHJvcHMudGl0bGV9KTtcbiAgICB9XG4gIH1cblxuICByZW5kZXIoKSB7XG4gICAgY29uc3QgY2hpbGQgPSBSZWFjdC5DaGlsZHJlbi5vbmx5KHRoaXMucHJvcHMuY2hpbGRyZW4pO1xuICAgIHJldHVybiBSZWFjdC5jbG9uZUVsZW1lbnQoY2hpbGQsIHtyZWY6IGUgPT4geyB0aGlzLmNoaWxkID0gZTsgfX0pO1xuICB9XG59XG4iXX0=