'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _desc, _value, _class, _class2, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _coreDecorators = require('core-decorators');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

let Resizer = (_class = (_temp = _class2 = class Resizer extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);
    this.state = {
      dragging: false,
      start: null,
      lastSize: props.size
    };
  }

  render() {
    var _props = this.props;

    const onChange = _props.onChange,
          children = _props.children,
          className = _props.className,
          others = _objectWithoutProperties(_props, ['onChange', 'children', 'className']); // eslint-disable-line no-unused-vars


    return _react2.default.createElement(
      'div',
      _extends({}, others, { className: (0, _classnames2.default)('resizer-container', className) }),
      _react2.default.createElement(
        'div',
        { className: 'sizing-handle', onMouseDown: this.handleMouseDown },
        '\xA0'
      ),
      _react2.default.createElement(
        'div',
        { className: 'content', style: { width: this.props.size } },
        children
      )
    );
  }

  handleMouseDown(e) {
    // save off copy since synthetic event will be recycled
    // by the time the `setState` function runs
    const clientX = e.clientX;
    this.setState(s => ({
      dragging: true,
      start: clientX,
      lastSize: this.props.size
    }));

    document.addEventListener('mousemove', this.handleMouseMove);
    document.addEventListener('mouseup', this.handleMouseUp);
  }

  handleMouseUp(e) {
    document.removeEventListener('mousemove', this.handleMouseMove);
    document.removeEventListener('mouseup', this.handleMouseUp);

    this.setState({
      dragging: false
    });
  }

  handleMouseMove(e) {
    if (!this.state.dragging) {
      return;
    }
    const oldPos = this.state.start;
    const delta = oldPos - e.clientX;
    const newSize = Math.max(0, this.state.lastSize + delta);
    this.props.onChange(newSize);
  }
}, _class2.propTypes = {
  size: _propTypes2.default.number.isRequired,
  onChange: _propTypes2.default.func.isRequired,
  className: _propTypes2.default.string,
  children: _propTypes2.default.element
}, _temp), (_applyDecoratedDescriptor(_class.prototype, 'handleMouseDown', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'handleMouseDown'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'handleMouseUp', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'handleMouseUp'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'handleMouseMove', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'handleMouseMove'), _class.prototype)), _class);
exports.default = Resizer;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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