'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _desc, _value, _class, _class2, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _coreDecorators = require('core-decorators');

var _propTypes3 = require('../prop-types');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

let PushPullMenuView = (_class = (_temp = _class2 = class PushPullMenuView extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);

    this.state = {
      errorMessage: ''
    };
  }

  render() {
    const errorMessage = this.getErrorMessage();
    const fetchDisabled = !this.props.currentRemote.isPresent() || this.props.inProgress;
    const pullDisabled = !this.props.currentRemote.isPresent() || this.props.currentBranch.isDetached() || this.props.inProgress;
    const pushDisabled = this.props.currentBranch.isDetached() || !this.props.currentRemote.isPresent() && !this.props.originExists || this.props.inProgress;

    return _react2.default.createElement(
      'div',
      { className: 'github-PushPullMenuView' + (this.props.inProgress ? ' in-progress' : '') },
      _react2.default.createElement(
        'div',
        { className: 'github-PushPullMenuView-selector' },
        _react2.default.createElement('span', { className: 'github-PushPullMenuView-item icon icon-mark-github', onClick: this.handleIconClick }),
        _react2.default.createElement(
          'button',
          { className: 'github-PushPullMenuView-item btn', onClick: this.fetch, disabled: fetchDisabled },
          'Fetch'
        ),
        _react2.default.createElement(
          'div',
          { className: 'github-PushPullMenuView-item is-flexible btn-group' },
          _react2.default.createElement(
            'button',
            { className: 'btn github-PushPullMenuView-pull', onClick: this.pull, disabled: pullDisabled },
            _react2.default.createElement('span', { className: 'icon icon-arrow-down' }),
            _react2.default.createElement(
              'span',
              null,
              'Pull ',
              this.props.behindCount ? `(${this.props.behindCount})` : ''
            )
          ),
          _react2.default.createElement(
            'button',
            { className: 'btn github-PushPullMenuView-push', onClick: this.push, disabled: pushDisabled },
            _react2.default.createElement('span', { className: 'icon icon-arrow-up' }),
            _react2.default.createElement(
              'span',
              null,
              'Push ',
              this.props.aheadCount ? `(${this.props.aheadCount})` : ''
            )
          )
        )
      ),
      _react2.default.createElement(
        'div',
        { className: 'github-PushPullMenuView-message' },
        errorMessage
      )
    );
  }

  getErrorMessage() {
    if (this.state.errorMessage !== '') {
      return this.state.errorMessage;
    }

    if (this.props.currentBranch.isDetached()) {
      return 'Note: you are not on a branch. Please create one if you wish to push your work anywhere.';
    }

    if (!this.props.currentRemote.isPresent()) {
      if (this.props.originExists) {
        return `Note: No remote detected for branch ${this.props.currentBranch.getName()}. ` + 'Pushing will set up a remote tracking branch on remote repo "origin"';
      } else {
        return `Note: No remote detected for branch ${this.props.currentBranch.getName()}. ` + 'Cannot push because there is no remote named "origin" for which to create a remote tracking branch.';
      }
    }

    return '';
  }

  handleIconClick(evt) {
    if (evt.shiftKey) {
      this.props.onMarkSpecialClick();
    }
  }

  fetch() {
    return this.props.fetch();
  }

  pull() {
    return this.props.pull();
  }

  push(e) {
    return this.props.push({ force: e.metaKey || e.ctrlKey, setUpstream: !this.props.currentRemote.isPresent() });
  }
}, _class2.propTypes = {
  currentBranch: _propTypes3.BranchPropType.isRequired,
  currentRemote: _propTypes3.RemotePropType.isRequired,
  inProgress: _propTypes2.default.bool,
  aheadCount: _propTypes2.default.number,
  behindCount: _propTypes2.default.number,
  onMarkSpecialClick: _propTypes2.default.func.isRequired,
  fetch: _propTypes2.default.func.isRequired,
  push: _propTypes2.default.func.isRequired,
  pull: _propTypes2.default.func.isRequired,
  originExists: _propTypes2.default.bool.isRequired
}, _class2.defaultProps = {
  inProgress: false,
  onMarkSpecialClick: () => {}
}, _temp), (_applyDecoratedDescriptor(_class.prototype, 'handleIconClick', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'handleIconClick'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'fetch', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'fetch'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'pull', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'pull'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'push', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'push'), _class.prototype)), _class);
exports.default = PushPullMenuView;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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