'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _eventKit = require('event-kit');

var _portal = require('./portal');

var _portal2 = _interopRequireDefault(_portal);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * `PaneItem` adds its child to the current Atom pane when rendered.
 * When the pane is closed, the component's `onDidCloseItem` is called.
 * You should use this callback to set state so that the `PaneItem` is no
 * longer rendered; you will get an error in your console if you forget.
 *
 * You may pass a `getItem` function that takes an object with `portal` and
 * `subtree` properties. `getItem` should return an item to be added to the
 * Panel. `portal` is an instance of th Portal component, and `subtree` is the
 * rendered subtree component built from the `children` prop. The default
 * implementation simply returns the Portal instance, which contains a
 * `getElement` method (to be compatible with Atom's view system).
 *
 * Unmounting the component when the item is open will close the item.
 */
let PaneItem = (_temp = _class = class PaneItem extends _react2.default.Component {

  componentDidMount() {
    this.setupPaneItem();
  }

  componentWillReceiveProps() {
    if (this.didCloseItem) {
      // eslint-disable-next-line no-console
      console.error('Unexpected update in `PaneItem`: the contained item has been closed');
    }
  }

  render() {
    return _react2.default.createElement(
      _portal2.default,
      { ref: c => {
          this.portal = c;
        } },
      this.props.children
    );
  }

  setupPaneItem() {
    if (this.paneItem) {
      return;
    }

    const itemToAdd = this.props.getItem({ portal: this.portal, subtree: this.portal.getRenderedSubtree() });
    this.subscriptions = new _eventKit.CompositeDisposable();
    if (itemToAdd.wasActivated) {
      this.subscriptions.add(this.props.workspace.onDidChangeActivePaneItem(activeItem => {
        if (activeItem === this.paneItem) {
          itemToAdd.wasActivated();
        }
      }));
    }

    let paneContainer = this.props.workspace;
    // TODO[v1.17]: remove this once bundled in v1.17
    if (this.props.workspace.getCenter) {
      paneContainer = this.props.workspace.getCenter();
    }
    this.paneItem = paneContainer.getActivePane().addItem(itemToAdd);
    this.subscriptions = this.props.workspace.onDidDestroyPaneItem((_ref) => {
      let item = _ref.item;

      if (item === this.paneItem) {
        this.didCloseItem = true;
        this.props.onDidCloseItem(this.paneItem);
      }
    });
  }

  getPaneItem() {
    return this.paneItem;
  }

  componentWillUnmount() {
    this.subscriptions && this.subscriptions.dispose();
    if (this.paneItem && !this.didCloseItem) {
      this.paneItem.destroy();
    }
  }

  activate() {
    setTimeout(() => {
      if (!this.paneItem) {
        return;
      }

      const pane = this.props.workspace.paneForItem(this.paneItem);
      if (pane) {
        pane.activateItem(this.paneItem);
      } else {
        throw new Error('Cannot find pane for item in `PaneItem#activate`');
      }
    });
  }
}, _class.propTypes = {
  workspace: _propTypes2.default.object.isRequired,
  children: _propTypes2.default.element.isRequired,
  getItem: _propTypes2.default.func,
  onDidCloseItem: _propTypes2.default.func
}, _class.defaultProps = {
  getItem: (_ref2) => {
    let portal = _ref2.portal,
        subtree = _ref2.subtree;
    return portal.getView();
  },
  onDidCloseItem: paneItem => {}
}, _temp);
exports.default = PaneItem;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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