'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _desc, _value, _class, _class2, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _coreDecorators = require('core-decorators');

var _modelObserver = require('../models/model-observer');

var _modelObserver2 = _interopRequireDefault(_modelObserver);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

let ObserveModel = (_class = (_temp = _class2 = class ObserveModel extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);
    this.state = { data: null };
    this.modelObserver = new _modelObserver2.default({ fetchData: this.fetchData, didUpdate: this.didUpdate });
  }

  componentWillMount() {
    this.mounted = true;
    this.modelObserver.setActiveModel(this.props.model);
  }

  componentWillReceiveProps(nextProps) {
    this.modelObserver.setActiveModel(nextProps.model);
  }

  fetchData(model) {
    return this.props.fetchData(model);
  }

  didUpdate(model) {
    if (this.mounted) {
      const data = this.modelObserver.getActiveModelData();
      this.setState({ data });
    }
  }

  render() {
    return this.props.children(this.state.data);
  }

  componentWillUnmount() {
    this.mounted = false;
    this.modelObserver.destroy();
  }
}, _class2.propTypes = {
  model: _propTypes2.default.shape({
    onDidUpdate: _propTypes2.default.func.isRequired
  }),
  fetchData: _propTypes2.default.func.isRequired,
  children: _propTypes2.default.func.isRequired
}, _temp), (_applyDecoratedDescriptor(_class.prototype, 'fetchData', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'fetchData'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'didUpdate', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'didUpdate'), _class.prototype)), _class);
exports.default = ObserveModel;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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