'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _helpers = require('../helpers');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; } /** @jsx etch.dom */
/* eslint react/no-unknown-property: "off" */

let FilePatchListItemView = class FilePatchListItemView {
  constructor(props) {
    this.props = props;
    _etch2.default.initialize(this);
    this.props.registerItemElement(this.props.mergeConflict, this.element);
  }

  update(props) {
    this.props = props;
    this.props.registerItemElement(this.props.mergeConflict, this.element);
    return _etch2.default.update(this);
  }

  render() {
    var _props = this.props;

    const mergeConflict = _props.mergeConflict,
          selected = _props.selected,
          others = _objectWithoutProperties(_props, ['mergeConflict', 'selected']);

    const fileStatus = _helpers.classNameForStatus[mergeConflict.status.file];
    const oursStatus = _helpers.classNameForStatus[mergeConflict.status.ours];
    const theirsStatus = _helpers.classNameForStatus[mergeConflict.status.theirs];
    const className = selected ? 'is-selected' : '';

    return _etch2.default.dom(
      'div',
      _extends({}, others, { className: `github-MergeConflictListView-item is-${fileStatus} ${className}` }),
      _etch2.default.dom(
        'div',
        { className: 'github-FilePatchListView-item github-FilePatchListView-pathItem' },
        _etch2.default.dom('span', { className: `github-FilePatchListView-icon icon icon-diff-${fileStatus} status-${fileStatus}` }),
        _etch2.default.dom(
          'span',
          { className: 'github-FilePatchListView-path' },
          mergeConflict.filePath
        ),
        _etch2.default.dom(
          'span',
          { className: 'github-FilePatchListView ours-theirs-info' },
          _etch2.default.dom('span', { className: `github-FilePatchListView-icon icon icon-diff-${oursStatus}` }),
          _etch2.default.dom('span', { className: `github-FilePatchListView-icon icon icon-diff-${theirsStatus}` })
        )
      ),
      _etch2.default.dom(
        'div',
        { className: 'github-FilePatchListView-item github-FilePatchListView-resolutionItem' },
        this.renderRemainingConflicts()
      )
    );
  }

  renderRemainingConflicts() {
    if (this.props.remainingConflicts === 0) {
      return _etch2.default.dom(
        'span',
        { className: 'icon icon-check github-RemainingConflicts text-success' },
        'ready'
      );
    } else if (this.props.remainingConflicts !== undefined) {
      const pluralConflicts = this.props.remainingConflicts === 1 ? '' : 's';

      return _etch2.default.dom(
        'span',
        { className: 'github-RemainingConflicts text-warning' },
        this.props.remainingConflicts,
        ' conflict',
        pluralConflicts,
        ' remaining'
      );
    } else {
      return _etch2.default.dom(
        'span',
        { className: 'github-RemainingConflicts text-subtle' },
        'calculating'
      );
    }
  }
};
exports.default = FilePatchListItemView;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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