'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; } /** @jsx etch.dom */
/* eslint react/no-unknown-property: "off" */

let ListView = class ListView {
  constructor(props) {
    this.props = props;
    _etch2.default.initialize(this);
  }

  didClickItem(e, item) {
    if (e.detail === 1) {
      if (this.props.didSelectItem) {
        this.props.didSelectItem(item);
        return _etch2.default.update(this);
      }
    } else if (e.detail === 2) {
      if (this.props.didConfirmItem) {
        this.props.didConfirmItem(item);
      }
    }
    return null;
  }

  update(props) {
    this.props = props;
    return _etch2.default.update(this);
  }

  render() {
    // eslint-disable-next-line no-unused-vars
    var _props = this.props;

    const ref = _props.ref,
          didSelectItem = _props.didSelectItem,
          didConfirmItem = _props.didConfirmItem,
          items = _props.items,
          selectedItems = _props.selectedItems,
          renderItem = _props.renderItem,
          others = _objectWithoutProperties(_props, ['ref', 'didSelectItem', 'didConfirmItem', 'items', 'selectedItems', 'renderItem']);

    return _etch2.default.dom(
      'div',
      others,
      items.map((item, index) => renderItem(item, selectedItems.has(item), e => this.didClickItem(e, item)))
    );
  }

  destroy() {
    _etch2.default.destroy(this);
  }
};
exports.default = ListView;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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