'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _desc, _value, _class, _class2, _temp;

var _eventKit = require('event-kit');

var _electron = require('electron');

var _url = require('url');

var _url2 = _interopRequireDefault(_url);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactDom = require('react-dom');

var _reactDom2 = _interopRequireDefault(_reactDom);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _coreDecorators = require('core-decorators');

var _issueishPaneItem = require('../atom-items/issueish-pane-item');

var _issueishPaneItem2 = _interopRequireDefault(_issueishPaneItem);

var _userMentionTooltipItem = require('../atom-items/user-mention-tooltip-item');

var _userMentionTooltipItem2 = _interopRequireDefault(_userMentionTooltipItem);

var _issueishTooltipItem = require('../atom-items/issueish-tooltip-item');

var _issueishTooltipItem2 = _interopRequireDefault(_issueishTooltipItem);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

let GithubDotcomMarkdown = (_class = (_temp = _class2 = class GithubDotcomMarkdown extends _react2.default.Component {

  componentDidMount() {
    this.commandSubscriptions = atom.commands.add(_reactDom2.default.findDOMNode(this), {
      'github:open-link-in-new-tab': this.openLinkInNewTab,
      'github:open-link-in-browser': this.openLinkInBrowser,
      'github:open-link-in-this-tab': this.openLinkInThisTab
    });
    this.checkPropValidity();
    this.setupComponentHandlers();
    this.setupTooltipHandlers();
  }

  componentDidUpdate() {
    this.checkPropValidity();
    this.setupTooltipHandlers();
  }

  checkPropValidity() {
    if (this.props.html !== undefined && this.props.markdown !== undefined) {
      // eslint-disable-next-line no-console
      console.error('Only one of `html` or `markdown` may be provided to `GithubDotcomMarkdown`');
    }
  }

  setupComponentHandlers() {
    this.component.addEventListener('click', this.handleClick);
    this.componentHandlers = new _eventKit.Disposable(() => {
      this.component.removeEventListener('click', this.handleClick);
    });
  }

  setupTooltipHandlers() {
    if (this.tooltipSubscriptions) {
      this.tooltipSubscriptions.dispose();
    }

    this.tooltipSubscriptions = new _eventKit.CompositeDisposable();
    this.component.querySelectorAll('.user-mention').forEach(node => {
      const item = new _userMentionTooltipItem2.default(node.textContent, this.context.relayEnvironment);
      this.tooltipSubscriptions.add(atom.tooltips.add(node, {
        trigger: 'hover',
        delay: 0,
        item
      }));
      this.tooltipSubscriptions.add(new _eventKit.Disposable(() => item.destroy()));
    });
    this.component.querySelectorAll('.issue-link').forEach(node => {
      const item = new _issueishTooltipItem2.default(node.getAttribute('href'), this.context.relayEnvironment);
      this.tooltipSubscriptions.add(atom.tooltips.add(node, {
        trigger: 'hover',
        delay: 0,
        item
      }));
      this.tooltipSubscriptions.add(new _eventKit.Disposable(() => item.destroy()));
    });
  }

  componentWillUnmount() {
    this.commandSubscriptions.dispose();
    this.componentHandlers.dispose();
    this.tooltipSubscriptions && this.tooltipSubscriptions.dispose();
  }

  render() {
    var _props = this.props;
    const html = _props.html,
          markdown = _props.markdown;

    const renderedHtml = html !== undefined ? html : this.markdownToHtml(markdown);
    return _react2.default.createElement('div', {
      className: 'github-DotComMarkdownHtml',
      ref: c => {
        this.component = c;
      },
      dangerouslySetInnerHTML: { __html: renderedHtml }
    });
  }

  markdownToHtml() {
    let markdown = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';

    return 'WARNING: cannot yet convert markdown to HTML 😅';
  }

  handleClick(event) {
    if (event.target.classList.contains('issue-link')) {
      const uri = this.getAtomUriForGithubUrl(event.target.dataset.url);
      if (uri && !event.shiftKey) {
        // Open in browser if shift key held
        this.openInNewTab(uri, { activate: !(event.metaKey || event.ctrlKey) });
        event.preventDefault();
        event.stopPropagation();
      }
    }
  }

  openLinkInNewTab(event) {
    const uri = this.getAtomUriForGithubUrl(event.target.dataset.url);
    if (uri) {
      this.openInNewTab(uri);
    }
  }

  openLinkInThisTab(event) {
    var _getDataFromGithubUrl = this.getDataFromGithubUrl(event.target.dataset.url);

    const repoOwner = _getDataFromGithubUrl.repoOwner,
          repoName = _getDataFromGithubUrl.repoName,
          issueishNumber = _getDataFromGithubUrl.issueishNumber;

    this.props.switchToIssueish(repoOwner, repoName, issueishNumber);
  }

  openLinkInBrowser(event) {
    const href = event.target.getAttribute('href');
    _electron.shell.openExternal(href);
  }

  getDataFromGithubUrl(githubUrl) {
    var _url$parse = _url2.default.parse(githubUrl);

    const hostname = _url$parse.hostname,
          pathname = _url$parse.pathname;

    var _pathname$split$filte = pathname.split('/').filter(s => s),
        _pathname$split$filte2 = _slicedToArray(_pathname$split$filte, 4);

    const repoOwner = _pathname$split$filte2[0],
          repoName = _pathname$split$filte2[1],
          type = _pathname$split$filte2[2],
          issueishNumber = _pathname$split$filte2[3];

    return { hostname, repoOwner, repoName, type, issueishNumber: parseInt(issueishNumber, 10) };
  }

  getUriForData(_ref) {
    let hostname = _ref.hostname,
        repoOwner = _ref.repoOwner,
        repoName = _ref.repoName,
        type = _ref.type,
        issueishNumber = _ref.issueishNumber;

    if (hostname !== 'github.com' || !['pull', 'issues'].includes(type) || !issueishNumber || isNaN(issueishNumber)) {
      return null;
    } else {
      return _url2.default.format({
        slashes: true,
        protocol: 'atom-github:',
        hostname: 'issueish',
        pathname: `/https://api.github.com/${repoOwner}/${repoName}/${issueishNumber}`
      });
    }
  }

  getAtomUriForGithubUrl(githubUrl) {
    return this.getUriForData(this.getDataFromGithubUrl(githubUrl));
  }

  openInNewTab(uri) {
    var _ref2 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : { activate: true };

    let activate = _ref2.activate;

    if (activate) {
      atom.workspace.open(uri, { activateItem: activate });
    } else {
      // TODO: use workspace.open once https://github.com/atom/atom/issues/14005 is fixed
      const item = _issueishPaneItem2.default.opener(uri);
      atom.workspace.getActivePane().addItem(item);
    }
  }
}, _class2.propTypes = {
  html: _propTypes2.default.string,
  markdown: _propTypes2.default.string,
  switchToIssueish: _propTypes2.default.func.isRequired
}, _class2.contextTypes = {
  relayEnvironment: _propTypes2.default.object.isRequired
}, _temp), (_applyDecoratedDescriptor(_class.prototype, 'handleClick', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'handleClick'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'openLinkInNewTab', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'openLinkInNewTab'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'openLinkInThisTab', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'openLinkInThisTab'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'openLinkInBrowser', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'openLinkInBrowser'), _class.prototype)), _class);
exports.default = GithubDotcomMarkdown;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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