'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _class, _temp, _desc, _value, _class2, _class3, _temp2, _desc2, _value2, _class4, _class5, _temp3, _desc3, _value3, _class6, _class7, _temp4, _desc4, _value4, _class8, _class9, _temp5;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _atom = require('atom');

var _eventKit = require('event-kit');

var _electron = require('electron');

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactDom = require('react-dom');

var _reactDom2 = _interopRequireDefault(_reactDom);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _coreDecorators = require('core-decorators');

var _lodash = require('lodash.memoize');

var _lodash2 = _interopRequireDefault(_lodash);

var _helpers = require('../helpers');

var _octicon = require('./octicon');

var _octicon2 = _interopRequireDefault(_octicon);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

const dialog = _electron.remote.dialog;


const genArray = (0, _lodash2.default)(function genArray(interval, count) {
  const arr = [];
  for (let i = 1; i <= count; i++) {
    arr.push(interval * i);
  }
  return arr;
}, (interval, count) => `${interval}:${count}`);

let Marker = class Marker {
  static deserialize(data) {
    const marker = new Marker(data.label, () => {});
    marker.end = data.end;
    marker.markers = data.markers;
    return marker;
  }

  constructor(label, didUpdate) {
    this.label = label;
    this.didUpdate = didUpdate;
    this.end = null;
    this.markers = [];
  }

  getStart() {
    return this.markers.length ? this.markers[0].start : null;
  }

  getEnd() {
    return this.end;
  }

  mark(sectionName, start) {
    this.markers.push({ name: sectionName, start: start || performance.now() });
  }

  finalize() {
    this.end = performance.now();
    this.didUpdate();
  }

  getTimings() {
    return this.markers.map((timing, idx, ary) => {
      const next = ary[idx + 1];
      const end = next ? next.start : this.getEnd();
      return _extends({}, timing, { end });
    });
  }

  serialize() {
    return {
      label: this.label,
      end: this.end,
      markers: this.markers.slice()
    };
  }
};
let MarkerTooltip = (_temp = _class = class MarkerTooltip extends _react2.default.Component {

  render() {
    const marker = this.props.marker;

    const timings = marker.getTimings();

    return _react2.default.createElement(
      'div',
      { style: { textAlign: 'left', maxWidth: 300, whiteSpace: 'initial' } },
      _react2.default.createElement(
        'strong',
        null,
        _react2.default.createElement(
          'tt',
          null,
          marker.label
        )
      ),
      _react2.default.createElement(
        'ul',
        { style: { paddingLeft: 20, marginTop: 10 } },
        timings.map((_ref) => {
          let name = _ref.name,
              start = _ref.start,
              end = _ref.end;

          const duration = end - start;
          return _react2.default.createElement(
            'li',
            { key: name },
            name,
            ': ',
            Math.floor(duration * 100) / 100,
            'ms'
          );
        })
      )
    );
  }
}, _class.propTypes = {
  marker: _propTypes2.default.instanceOf(Marker).isRequired
}, _temp);


const COLORS = {
  queued: 'red',
  prepare: 'cyan',
  nexttick: 'yellow',
  execute: 'green',
  ipc: 'pink'
};
let MarkerSpan = (_class2 = (_temp2 = _class3 = class MarkerSpan extends _react2.default.Component {

  render() {
    var _props = this.props;

    const marker = _props.marker,
          others = _objectWithoutProperties(_props, ['marker']);

    const timings = marker.getTimings();
    const totalTime = marker.getEnd() - marker.getStart();
    const percentages = timings.map((_ref2) => {
      let name = _ref2.name,
          start = _ref2.start,
          end = _ref2.end;

      const duration = end - start;
      return { color: COLORS[name], percent: duration / totalTime * 100 };
    });
    return _react2.default.createElement(
      'span',
      _extends({}, others, {
        ref: c => {
          this.element = c;
        },
        onMouseOver: this.handleMouseOver,
        onMouseOut: this.handleMouseOut }),
      percentages.map((_ref3, i) => {
        let color = _ref3.color,
            percent = _ref3.percent;

        const style = {
          width: `${percent}%`,
          background: color
        };
        return _react2.default.createElement('span', { className: 'waterfall-marker-section', key: i, style: style });
      })
    );
  }

  handleMouseOver(e) {
    const elem = document.createElement('div');
    _reactDom2.default.render(_react2.default.createElement(MarkerTooltip, { marker: this.props.marker }), elem);
    this.tooltipDisposable = atom.tooltips.add(this.element, {
      item: elem,
      placement: 'auto bottom',
      trigger: 'manual'
    });
  }

  closeTooltip() {
    this.tooltipDisposable && this.tooltipDisposable.dispose();
    this.tooltipDisposable = null;
  }

  handleMouseOut(e) {
    this.closeTooltip();
  }

  componentWillUnmount() {
    this.closeTooltip();
  }
}, _class3.propTypes = {
  marker: _propTypes2.default.instanceOf(Marker).isRequired
}, _temp2), (_applyDecoratedDescriptor(_class2.prototype, 'handleMouseOver', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class2.prototype, 'handleMouseOver'), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, 'handleMouseOut', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class2.prototype, 'handleMouseOut'), _class2.prototype)), _class2);
let Waterfall = (_class4 = (_temp3 = _class5 = class Waterfall extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);
    this.state = this.getNextState(props);
  }

  componentWillReceiveProps(nextProps) {
    this.setState(this.getNextState(nextProps));
  }

  getNextState(props) {
    const markers = props.markers;

    const firstMarker = markers[0];
    const lastMarker = markers[markers.length - 1];

    const startTime = firstMarker.getStart();
    const endTime = lastMarker.getEnd();
    const totalDuration = endTime - startTime;
    let timelineMarkInterval = null;
    if (props.zoomFactor <= 0.15) {
      timelineMarkInterval = 1000;
    } else if (props.zoomFactor <= 0.3) {
      timelineMarkInterval = 500;
    } else if (props.zoomFactor <= 0.6) {
      timelineMarkInterval = 250;
    } else {
      timelineMarkInterval = 100;
    }
    const timelineMarks = genArray(timelineMarkInterval, Math.ceil(totalDuration / timelineMarkInterval));

    return { firstMarker, lastMarker, startTime, endTime, totalDuration, timelineMarks };
  }

  render() {
    return _react2.default.createElement(
      'div',
      { className: 'waterfall-scroller' },
      _react2.default.createElement(
        'div',
        { className: 'waterfall-container' },
        this.renderTimeMarkers(),
        this.renderTimeline(),
        this.props.markers.map(this.renderMarker)
      )
    );
  }

  renderTimeline() {
    return _react2.default.createElement(
      'div',
      { className: 'waterfall-timeline' },
      '\xA0',
      this.state.timelineMarks.map(time => {
        const leftPos = time * this.props.zoomFactor;
        const style = {
          left: leftPos
        };
        return _react2.default.createElement(
          'span',
          { className: 'waterfall-timeline-label', style: style, key: `tl:${time}` },
          time,
          'ms'
        );
      })
    );
  }

  renderTimeMarkers() {
    return _react2.default.createElement(
      'div',
      { className: 'waterfall-time-markers' },
      this.state.timelineMarks.map(time => {
        const leftPos = time * this.props.zoomFactor;
        const style = {
          left: leftPos
        };
        return _react2.default.createElement('span', { className: 'waterfall-time-marker', style: style, key: `tm:${time}` });
      })
    );
  }

  renderMarker(marker, i) {
    if (marker.getStart() === null || marker.getEnd() === null) {
      return _react2.default.createElement('div', { key: i });
    }

    const startOffset = marker.getStart() - this.state.startTime;
    const duration = marker.getEnd() - marker.getStart();
    const markerStyle = {
      left: startOffset * this.props.zoomFactor,
      width: duration * this.props.zoomFactor
    };

    return _react2.default.createElement(
      'div',
      { className: 'waterfall-row', key: i },
      _react2.default.createElement(
        'span',
        {
          className: 'waterfall-row-label',
          style: { paddingLeft: markerStyle.left + markerStyle.width } },
        marker.label
      ),
      _react2.default.createElement(MarkerSpan, { className: 'waterfall-marker', style: markerStyle, marker: marker })
    );
  }
}, _class5.propTypes = {
  markers: _propTypes2.default.arrayOf(_propTypes2.default.instanceOf(Marker)).isRequired,
  zoomFactor: _propTypes2.default.number.isRequired
}, _temp3), (_applyDecoratedDescriptor(_class4.prototype, 'renderMarker', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class4.prototype, 'renderMarker'), _class4.prototype)), _class4);
let WaterfallWidget = (_class6 = (_temp4 = _class7 = class WaterfallWidget extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);
    this.state = {
      zoomFactor: 0.3,
      collapsed: false
    };
  }

  render() {
    const markers = this.props.markers;

    const firstMarker = markers[0];
    const lastMarker = markers[markers.length - 1];

    const startTime = firstMarker.getStart();
    const endTime = lastMarker.getEnd();
    const duration = endTime - startTime;

    return _react2.default.createElement(
      'div',
      { className: 'waterfall-widget inset-pannel' },
      _react2.default.createElement(
        'div',
        { className: 'waterfall-header' },
        _react2.default.createElement(
          'div',
          { className: 'waterfall-header-text' },
          _react2.default.createElement(
            'span',
            { onClick: this.handleCollapseClick, className: 'collapse-toggle' },
            this.state.collapsed ? '\u25b6' : '\u25bc'
          ),
          this.props.markers.length,
          ' event(s) over ',
          Math.floor(duration),
          'ms'
        ),
        _react2.default.createElement(
          'div',
          { className: 'waterfall-header-controls' },
          _react2.default.createElement(
            'button',
            {
              className: 'waterfall-export-button btn btn-sm',
              onClick: this.handleExportClick },
            'Export'
          ),
          _react2.default.createElement(_octicon2.default, { icon: 'search' }),
          _react2.default.createElement('input', {
            type: 'range',
            className: 'input-range',
            min: 0.1,
            max: 1,
            step: 0.01,
            value: this.state.zoomFactor,
            onChange: this.handleZoomFactorChange
          })
        )
      ),
      this.state.collapsed ? null : _react2.default.createElement(Waterfall, { markers: this.props.markers, zoomFactor: this.state.zoomFactor })
    );
  }

  handleZoomFactorChange(e) {
    this.setState({ zoomFactor: parseFloat(e.target.value) });
  }

  handleCollapseClick(e) {
    this.setState(s => ({ collapsed: !s.collapsed }));
  }

  handleExportClick(e) {
    e.preventDefault();
    const json = JSON.stringify(this.props.markers.map(m => m.serialize()), null, '  ');
    const buffer = new _atom.TextBuffer({ text: json });
    dialog.showSaveDialog({
      defaultPath: 'git-timings.json'
    }, filename => {
      if (!filename) {
        return;
      }
      buffer.saveAs(filename);
    });
  }
}, _class7.propTypes = {
  markers: _propTypes2.default.arrayOf(_propTypes2.default.instanceOf(Marker)).isRequired
}, _temp4), (_applyDecoratedDescriptor(_class6.prototype, 'handleZoomFactorChange', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class6.prototype, 'handleZoomFactorChange'), _class6.prototype), _applyDecoratedDescriptor(_class6.prototype, 'handleCollapseClick', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class6.prototype, 'handleCollapseClick'), _class6.prototype), _applyDecoratedDescriptor(_class6.prototype, 'handleExportClick', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class6.prototype, 'handleExportClick'), _class6.prototype)), _class6);


let markers = null;
let groupId = 0;
const groups = [];
let lastMarkerTime = null;
let updateTimer = null;

let GitTimingsView = (_class8 = (_temp5 = _class9 = class GitTimingsView extends _react2.default.Component {

  static createPaneItem() {
    let element;
    return {
      serialize() {
        return { deserializer: 'GitTimingsView' };
      },
      getURI() {
        return 'atom-github://debug/markers';
      },
      getTitle() {
        return 'GitHub Package Timings View';
      },
      get element() {
        if (!element) {
          element = document.createElement('div');
          _reactDom2.default.render(_react2.default.createElement(GitTimingsView, { container: element }), element);
        }
        return element;
      }
    };
  }

  static deserialize() {
    return this.createPaneItem();
  }

  static generateMarker(label) {
    const marker = new Marker(label, () => {
      GitTimingsView.scheduleUpdate();
    });
    const now = performance.now();
    if (!markers || lastMarkerTime && Math.abs(now - lastMarkerTime) >= 5000) {
      groupId++;
      markers = [];
      groups.unshift({ id: groupId, markers });
      if (groups.length > 100) {
        groups.pop();
      }
    }
    lastMarkerTime = now;
    markers.push(marker);
    GitTimingsView.scheduleUpdate();
    return marker;
  }

  static restoreGroup(group) {
    groupId++;
    groups.unshift({ id: groupId, markers: group });
    GitTimingsView.scheduleUpdate(true);
  }

  static scheduleUpdate() {
    let immediate = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;

    if (updateTimer) {
      clearTimeout(updateTimer);
    }

    updateTimer = setTimeout(() => {
      GitTimingsView.emitter.emit('did-update');
    }, immediate ? 0 : 1000);
  }

  static onDidUpdate(callback) {
    return GitTimingsView.emitter.on('did-update', callback);
  }

  componentDidMount() {
    this.subscriptions = new _eventKit.CompositeDisposable(GitTimingsView.onDidUpdate(() => this.forceUpdate()), atom.workspace.onDidDestroyPaneItem((_ref4) => {
      let item = _ref4.item;

      if (item.element === this.props.container) {
        // we just got closed
        _reactDom2.default.unmountComponentAtNode(this.props.container);
      }
    }));
  }

  componentWillUnmount() {
    this.subscriptions.dispose();
  }

  render() {
    return _react2.default.createElement(
      'div',
      { className: 'github-GitTimingsView' },
      _react2.default.createElement(
        'div',
        { className: 'github-GitTimingsView-header' },
        _react2.default.createElement(
          'button',
          { className: 'import-button btn', onClick: this.handleImportClick },
          'Import'
        )
      ),
      groups.map((group, idx) => _react2.default.createElement(WaterfallWidget, { key: group.id, markers: group.markers }))
    );
  }

  handleImportClick(e) {
    e.preventDefault();
    dialog.showOpenDialog({
      properties: ['openFile']
    }, (() => {
      var _ref5 = _asyncToGenerator(function* (filenames) {
        if (!filenames) {
          return;
        }
        const filename = filenames[0];
        try {
          const contents = yield (0, _helpers.readFile)(filename);
          const data = JSON.parse(contents);
          const restoredMarkers = data.map(function (item) {
            return Marker.deserialize(item);
          });
          GitTimingsView.restoreGroup(restoredMarkers);
        } catch (_err) {
          atom.notifications.addError(`Could not import timings from ${filename}`);
        }
      });

      return function (_x2) {
        return _ref5.apply(this, arguments);
      };
    })());
  }
}, _class9.propTypes = {
  container: _propTypes2.default.any.isRequired
}, _class9.emitter = new _eventKit.Emitter(), _temp5), (_applyDecoratedDescriptor(_class8.prototype, 'handleImportClick', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class8.prototype, 'handleImportClick'), _class8.prototype)), _class8);
exports.default = GitTimingsView;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImdpdC10aW1pbmdzLXZpZXcuanMiXSwibmFtZXMiOlsiZGlhbG9nIiwiZ2VuQXJyYXkiLCJpbnRlcnZhbCIsImNvdW50IiwiYXJyIiwiaSIsInB1c2giLCJNYXJrZXIiLCJkZXNlcmlhbGl6ZSIsImRhdGEiLCJtYXJrZXIiLCJsYWJlbCIsImVuZCIsIm1hcmtlcnMiLCJjb25zdHJ1Y3RvciIsImRpZFVwZGF0ZSIsImdldFN0YXJ0IiwibGVuZ3RoIiwic3RhcnQiLCJnZXRFbmQiLCJtYXJrIiwic2VjdGlvbk5hbWUiLCJuYW1lIiwicGVyZm9ybWFuY2UiLCJub3ciLCJmaW5hbGl6ZSIsImdldFRpbWluZ3MiLCJtYXAiLCJ0aW1pbmciLCJpZHgiLCJhcnkiLCJuZXh0Iiwic2VyaWFsaXplIiwic2xpY2UiLCJNYXJrZXJUb29sdGlwIiwiQ29tcG9uZW50IiwicmVuZGVyIiwicHJvcHMiLCJ0aW1pbmdzIiwidGV4dEFsaWduIiwibWF4V2lkdGgiLCJ3aGl0ZVNwYWNlIiwicGFkZGluZ0xlZnQiLCJtYXJnaW5Ub3AiLCJkdXJhdGlvbiIsIk1hdGgiLCJmbG9vciIsInByb3BUeXBlcyIsImluc3RhbmNlT2YiLCJpc1JlcXVpcmVkIiwiQ09MT1JTIiwicXVldWVkIiwicHJlcGFyZSIsIm5leHR0aWNrIiwiZXhlY3V0ZSIsImlwYyIsIk1hcmtlclNwYW4iLCJvdGhlcnMiLCJ0b3RhbFRpbWUiLCJwZXJjZW50YWdlcyIsImNvbG9yIiwicGVyY2VudCIsImMiLCJlbGVtZW50IiwiaGFuZGxlTW91c2VPdmVyIiwiaGFuZGxlTW91c2VPdXQiLCJzdHlsZSIsIndpZHRoIiwiYmFja2dyb3VuZCIsImUiLCJlbGVtIiwiZG9jdW1lbnQiLCJjcmVhdGVFbGVtZW50IiwidG9vbHRpcERpc3Bvc2FibGUiLCJhdG9tIiwidG9vbHRpcHMiLCJhZGQiLCJpdGVtIiwicGxhY2VtZW50IiwidHJpZ2dlciIsImNsb3NlVG9vbHRpcCIsImRpc3Bvc2UiLCJjb21wb25lbnRXaWxsVW5tb3VudCIsIldhdGVyZmFsbCIsImNvbnRleHQiLCJzdGF0ZSIsImdldE5leHRTdGF0ZSIsImNvbXBvbmVudFdpbGxSZWNlaXZlUHJvcHMiLCJuZXh0UHJvcHMiLCJzZXRTdGF0ZSIsImZpcnN0TWFya2VyIiwibGFzdE1hcmtlciIsInN0YXJ0VGltZSIsImVuZFRpbWUiLCJ0b3RhbER1cmF0aW9uIiwidGltZWxpbmVNYXJrSW50ZXJ2YWwiLCJ6b29tRmFjdG9yIiwidGltZWxpbmVNYXJrcyIsImNlaWwiLCJyZW5kZXJUaW1lTWFya2VycyIsInJlbmRlclRpbWVsaW5lIiwicmVuZGVyTWFya2VyIiwidGltZSIsImxlZnRQb3MiLCJsZWZ0Iiwic3RhcnRPZmZzZXQiLCJtYXJrZXJTdHlsZSIsImFycmF5T2YiLCJudW1iZXIiLCJXYXRlcmZhbGxXaWRnZXQiLCJjb2xsYXBzZWQiLCJoYW5kbGVDb2xsYXBzZUNsaWNrIiwiaGFuZGxlRXhwb3J0Q2xpY2siLCJoYW5kbGVab29tRmFjdG9yQ2hhbmdlIiwicGFyc2VGbG9hdCIsInRhcmdldCIsInZhbHVlIiwicyIsInByZXZlbnREZWZhdWx0IiwianNvbiIsIkpTT04iLCJzdHJpbmdpZnkiLCJtIiwiYnVmZmVyIiwidGV4dCIsInNob3dTYXZlRGlhbG9nIiwiZGVmYXVsdFBhdGgiLCJmaWxlbmFtZSIsInNhdmVBcyIsImdyb3VwSWQiLCJncm91cHMiLCJsYXN0TWFya2VyVGltZSIsInVwZGF0ZVRpbWVyIiwiR2l0VGltaW5nc1ZpZXciLCJjcmVhdGVQYW5lSXRlbSIsImRlc2VyaWFsaXplciIsImdldFVSSSIsImdldFRpdGxlIiwiZ2VuZXJhdGVNYXJrZXIiLCJzY2hlZHVsZVVwZGF0ZSIsImFicyIsInVuc2hpZnQiLCJpZCIsInBvcCIsInJlc3RvcmVHcm91cCIsImdyb3VwIiwiaW1tZWRpYXRlIiwiY2xlYXJUaW1lb3V0Iiwic2V0VGltZW91dCIsImVtaXR0ZXIiLCJlbWl0Iiwib25EaWRVcGRhdGUiLCJjYWxsYmFjayIsIm9uIiwiY29tcG9uZW50RGlkTW91bnQiLCJzdWJzY3JpcHRpb25zIiwiZm9yY2VVcGRhdGUiLCJ3b3Jrc3BhY2UiLCJvbkRpZERlc3Ryb3lQYW5lSXRlbSIsImNvbnRhaW5lciIsInVubW91bnRDb21wb25lbnRBdE5vZGUiLCJoYW5kbGVJbXBvcnRDbGljayIsInNob3dPcGVuRGlhbG9nIiwicHJvcGVydGllcyIsImZpbGVuYW1lcyIsImNvbnRlbnRzIiwicGFyc2UiLCJyZXN0b3JlZE1hcmtlcnMiLCJfZXJyIiwibm90aWZpY2F0aW9ucyIsImFkZEVycm9yIiwiYW55Il0sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7OztBQUFBOztBQUNBOztBQUNBOztBQUdBOzs7O0FBQ0E7Ozs7QUFDQTs7OztBQUNBOztBQUNBOzs7O0FBRUE7O0FBQ0E7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztNQVRPQSxNLG9CQUFBQSxNOzs7QUFXUCxNQUFNQyxXQUFXLHNCQUFRLFNBQVNBLFFBQVQsQ0FBa0JDLFFBQWxCLEVBQTRCQyxLQUE1QixFQUFtQztBQUMxRCxRQUFNQyxNQUFNLEVBQVo7QUFDQSxPQUFLLElBQUlDLElBQUksQ0FBYixFQUFnQkEsS0FBS0YsS0FBckIsRUFBNEJFLEdBQTVCLEVBQWlDO0FBQy9CRCxRQUFJRSxJQUFKLENBQVNKLFdBQVdHLENBQXBCO0FBQ0Q7QUFDRCxTQUFPRCxHQUFQO0FBQ0QsQ0FOZ0IsRUFNZCxDQUFDRixRQUFELEVBQVdDLEtBQVgsS0FBc0IsR0FBRUQsUUFBUyxJQUFHQyxLQUFNLEVBTjVCLENBQWpCOztJQVFNSSxNLEdBQU4sTUFBTUEsTUFBTixDQUFhO0FBQ1gsU0FBT0MsV0FBUCxDQUFtQkMsSUFBbkIsRUFBeUI7QUFDdkIsVUFBTUMsU0FBUyxJQUFJSCxNQUFKLENBQVdFLEtBQUtFLEtBQWhCLEVBQXVCLE1BQU0sQ0FBRSxDQUEvQixDQUFmO0FBQ0FELFdBQU9FLEdBQVAsR0FBYUgsS0FBS0csR0FBbEI7QUFDQUYsV0FBT0csT0FBUCxHQUFpQkosS0FBS0ksT0FBdEI7QUFDQSxXQUFPSCxNQUFQO0FBQ0Q7O0FBRURJLGNBQVlILEtBQVosRUFBbUJJLFNBQW5CLEVBQThCO0FBQzVCLFNBQUtKLEtBQUwsR0FBYUEsS0FBYjtBQUNBLFNBQUtJLFNBQUwsR0FBaUJBLFNBQWpCO0FBQ0EsU0FBS0gsR0FBTCxHQUFXLElBQVg7QUFDQSxTQUFLQyxPQUFMLEdBQWUsRUFBZjtBQUNEOztBQUVERyxhQUFXO0FBQ1QsV0FBTyxLQUFLSCxPQUFMLENBQWFJLE1BQWIsR0FBc0IsS0FBS0osT0FBTCxDQUFhLENBQWIsRUFBZ0JLLEtBQXRDLEdBQThDLElBQXJEO0FBQ0Q7O0FBRURDLFdBQVM7QUFDUCxXQUFPLEtBQUtQLEdBQVo7QUFDRDs7QUFFRFEsT0FBS0MsV0FBTCxFQUFrQkgsS0FBbEIsRUFBeUI7QUFDdkIsU0FBS0wsT0FBTCxDQUFhUCxJQUFiLENBQWtCLEVBQUNnQixNQUFNRCxXQUFQLEVBQW9CSCxPQUFPQSxTQUFTSyxZQUFZQyxHQUFaLEVBQXBDLEVBQWxCO0FBQ0Q7O0FBRURDLGFBQVc7QUFDVCxTQUFLYixHQUFMLEdBQVdXLFlBQVlDLEdBQVosRUFBWDtBQUNBLFNBQUtULFNBQUw7QUFDRDs7QUFFRFcsZUFBYTtBQUNYLFdBQU8sS0FBS2IsT0FBTCxDQUFhYyxHQUFiLENBQWlCLENBQUNDLE1BQUQsRUFBU0MsR0FBVCxFQUFjQyxHQUFkLEtBQXNCO0FBQzVDLFlBQU1DLE9BQU9ELElBQUlELE1BQU0sQ0FBVixDQUFiO0FBQ0EsWUFBTWpCLE1BQU1tQixPQUFPQSxLQUFLYixLQUFaLEdBQW9CLEtBQUtDLE1BQUwsRUFBaEM7QUFDQSwwQkFBV1MsTUFBWCxJQUFtQmhCLEdBQW5CO0FBQ0QsS0FKTSxDQUFQO0FBS0Q7O0FBRURvQixjQUFZO0FBQ1YsV0FBTztBQUNMckIsYUFBTyxLQUFLQSxLQURQO0FBRUxDLFdBQUssS0FBS0EsR0FGTDtBQUdMQyxlQUFTLEtBQUtBLE9BQUwsQ0FBYW9CLEtBQWI7QUFISixLQUFQO0FBS0Q7QUE5Q1UsQztJQWtEUEMsYSxxQkFBTixNQUFNQSxhQUFOLFNBQTRCLGdCQUFNQyxTQUFsQyxDQUE0Qzs7QUFLMUNDLFdBQVM7QUFBQSxVQUNBMUIsTUFEQSxHQUNVLEtBQUsyQixLQURmLENBQ0EzQixNQURBOztBQUVQLFVBQU00QixVQUFVNUIsT0FBT2dCLFVBQVAsRUFBaEI7O0FBRUEsV0FDRTtBQUFBO0FBQUEsUUFBSyxPQUFPLEVBQUNhLFdBQVcsTUFBWixFQUFvQkMsVUFBVSxHQUE5QixFQUFtQ0MsWUFBWSxTQUEvQyxFQUFaO0FBQ0U7QUFBQTtBQUFBO0FBQVE7QUFBQTtBQUFBO0FBQUsvQixpQkFBT0M7QUFBWjtBQUFSLE9BREY7QUFFRTtBQUFBO0FBQUEsVUFBSSxPQUFPLEVBQUMrQixhQUFhLEVBQWQsRUFBa0JDLFdBQVcsRUFBN0IsRUFBWDtBQUNHTCxnQkFBUVgsR0FBUixDQUFZLFVBQXdCO0FBQUEsY0FBdEJMLElBQXNCLFFBQXRCQSxJQUFzQjtBQUFBLGNBQWhCSixLQUFnQixRQUFoQkEsS0FBZ0I7QUFBQSxjQUFUTixHQUFTLFFBQVRBLEdBQVM7O0FBQ25DLGdCQUFNZ0MsV0FBV2hDLE1BQU1NLEtBQXZCO0FBQ0EsaUJBQU87QUFBQTtBQUFBLGNBQUksS0FBS0ksSUFBVDtBQUFnQkEsZ0JBQWhCO0FBQUE7QUFBd0J1QixpQkFBS0MsS0FBTCxDQUFXRixXQUFXLEdBQXRCLElBQTZCLEdBQXJEO0FBQUE7QUFBQSxXQUFQO0FBQ0QsU0FIQTtBQURIO0FBRkYsS0FERjtBQVdEO0FBcEJ5QyxDLFNBQ25DRyxTLEdBQVk7QUFDakJyQyxVQUFRLG9CQUFVc0MsVUFBVixDQUFxQnpDLE1BQXJCLEVBQTZCMEM7QUFEcEIsQzs7O0FBc0JyQixNQUFNQyxTQUFTO0FBQ2JDLFVBQVEsS0FESztBQUViQyxXQUFTLE1BRkk7QUFHYkMsWUFBVSxRQUhHO0FBSWJDLFdBQVMsT0FKSTtBQUtiQyxPQUFLO0FBTFEsQ0FBZjtJQU9NQyxVLGtDQUFOLE1BQU1BLFVBQU4sU0FBeUIsZ0JBQU1yQixTQUEvQixDQUF5Qzs7QUFLdkNDLFdBQVM7QUFBQSxpQkFDcUIsS0FBS0MsS0FEMUI7O0FBQUEsVUFDQTNCLE1BREEsVUFDQUEsTUFEQTtBQUFBLFVBQ1crQyxNQURYOztBQUVQLFVBQU1uQixVQUFVNUIsT0FBT2dCLFVBQVAsRUFBaEI7QUFDQSxVQUFNZ0MsWUFBWWhELE9BQU9TLE1BQVAsS0FBa0JULE9BQU9NLFFBQVAsRUFBcEM7QUFDQSxVQUFNMkMsY0FBY3JCLFFBQVFYLEdBQVIsQ0FBWSxXQUF3QjtBQUFBLFVBQXRCTCxJQUFzQixTQUF0QkEsSUFBc0I7QUFBQSxVQUFoQkosS0FBZ0IsU0FBaEJBLEtBQWdCO0FBQUEsVUFBVE4sR0FBUyxTQUFUQSxHQUFTOztBQUN0RCxZQUFNZ0MsV0FBV2hDLE1BQU1NLEtBQXZCO0FBQ0EsYUFBTyxFQUFDMEMsT0FBT1YsT0FBTzVCLElBQVAsQ0FBUixFQUFzQnVDLFNBQVNqQixXQUFXYyxTQUFYLEdBQXVCLEdBQXRELEVBQVA7QUFDRCxLQUhtQixDQUFwQjtBQUlBLFdBQ0U7QUFBQTtBQUFBLG1CQUNNRCxNQUROO0FBRUUsYUFBS0ssS0FBSztBQUFFLGVBQUtDLE9BQUwsR0FBZUQsQ0FBZjtBQUFtQixTQUZqQztBQUdFLHFCQUFhLEtBQUtFLGVBSHBCO0FBSUUsb0JBQVksS0FBS0MsY0FKbkI7QUFLR04sa0JBQVloQyxHQUFaLENBQWdCLFFBQW1CdEIsQ0FBbkIsS0FBeUI7QUFBQSxZQUF2QnVELEtBQXVCLFNBQXZCQSxLQUF1QjtBQUFBLFlBQWhCQyxPQUFnQixTQUFoQkEsT0FBZ0I7O0FBQ3hDLGNBQU1LLFFBQVE7QUFDWkMsaUJBQVEsR0FBRU4sT0FBUSxHQUROO0FBRVpPLHNCQUFZUjtBQUZBLFNBQWQ7QUFJQSxlQUFPLHdDQUFNLFdBQVUsMEJBQWhCLEVBQTJDLEtBQUt2RCxDQUFoRCxFQUFtRCxPQUFPNkQsS0FBMUQsR0FBUDtBQUNELE9BTkE7QUFMSCxLQURGO0FBZUQ7O0FBR0RGLGtCQUFnQkssQ0FBaEIsRUFBbUI7QUFDakIsVUFBTUMsT0FBT0MsU0FBU0MsYUFBVCxDQUF1QixLQUF2QixDQUFiO0FBQ0EsdUJBQVNwQyxNQUFULENBQWdCLDhCQUFDLGFBQUQsSUFBZSxRQUFRLEtBQUtDLEtBQUwsQ0FBVzNCLE1BQWxDLEdBQWhCLEVBQThENEQsSUFBOUQ7QUFDQSxTQUFLRyxpQkFBTCxHQUF5QkMsS0FBS0MsUUFBTCxDQUFjQyxHQUFkLENBQWtCLEtBQUtiLE9BQXZCLEVBQWdDO0FBQ3ZEYyxZQUFNUCxJQURpRDtBQUV2RFEsaUJBQVcsYUFGNEM7QUFHdkRDLGVBQVM7QUFIOEMsS0FBaEMsQ0FBekI7QUFLRDs7QUFFREMsaUJBQWU7QUFDYixTQUFLUCxpQkFBTCxJQUEwQixLQUFLQSxpQkFBTCxDQUF1QlEsT0FBdkIsRUFBMUI7QUFDQSxTQUFLUixpQkFBTCxHQUF5QixJQUF6QjtBQUNEOztBQUdEUixpQkFBZUksQ0FBZixFQUFrQjtBQUNoQixTQUFLVyxZQUFMO0FBQ0Q7O0FBRURFLHlCQUF1QjtBQUNyQixTQUFLRixZQUFMO0FBQ0Q7QUFyRHNDLEMsVUFDaENqQyxTLEdBQVk7QUFDakJyQyxVQUFRLG9CQUFVc0MsVUFBVixDQUFxQnpDLE1BQXJCLEVBQTZCMEM7QUFEcEIsQztJQXdEZmtDLFMsa0NBQU4sTUFBTUEsU0FBTixTQUF3QixnQkFBTWhELFNBQTlCLENBQXdDOztBQU10Q3JCLGNBQVl1QixLQUFaLEVBQW1CK0MsT0FBbkIsRUFBNEI7QUFDMUIsVUFBTS9DLEtBQU4sRUFBYStDLE9BQWI7QUFDQSxTQUFLQyxLQUFMLEdBQWEsS0FBS0MsWUFBTCxDQUFrQmpELEtBQWxCLENBQWI7QUFDRDs7QUFFRGtELDRCQUEwQkMsU0FBMUIsRUFBcUM7QUFDbkMsU0FBS0MsUUFBTCxDQUFjLEtBQUtILFlBQUwsQ0FBa0JFLFNBQWxCLENBQWQ7QUFDRDs7QUFFREYsZUFBYWpELEtBQWIsRUFBb0I7QUFBQSxVQUNYeEIsT0FEVyxHQUNBd0IsS0FEQSxDQUNYeEIsT0FEVzs7QUFFbEIsVUFBTTZFLGNBQWM3RSxRQUFRLENBQVIsQ0FBcEI7QUFDQSxVQUFNOEUsYUFBYTlFLFFBQVFBLFFBQVFJLE1BQVIsR0FBaUIsQ0FBekIsQ0FBbkI7O0FBRUEsVUFBTTJFLFlBQVlGLFlBQVkxRSxRQUFaLEVBQWxCO0FBQ0EsVUFBTTZFLFVBQVVGLFdBQVd4RSxNQUFYLEVBQWhCO0FBQ0EsVUFBTTJFLGdCQUFnQkQsVUFBVUQsU0FBaEM7QUFDQSxRQUFJRyx1QkFBdUIsSUFBM0I7QUFDQSxRQUFJMUQsTUFBTTJELFVBQU4sSUFBb0IsSUFBeEIsRUFBOEI7QUFDNUJELDZCQUF1QixJQUF2QjtBQUNELEtBRkQsTUFFTyxJQUFJMUQsTUFBTTJELFVBQU4sSUFBb0IsR0FBeEIsRUFBNkI7QUFDbENELDZCQUF1QixHQUF2QjtBQUNELEtBRk0sTUFFQSxJQUFJMUQsTUFBTTJELFVBQU4sSUFBb0IsR0FBeEIsRUFBNkI7QUFDbENELDZCQUF1QixHQUF2QjtBQUNELEtBRk0sTUFFQTtBQUNMQSw2QkFBdUIsR0FBdkI7QUFDRDtBQUNELFVBQU1FLGdCQUFnQmhHLFNBQVM4RixvQkFBVCxFQUErQmxELEtBQUtxRCxJQUFMLENBQVVKLGdCQUFnQkMsb0JBQTFCLENBQS9CLENBQXRCOztBQUVBLFdBQU8sRUFBQ0wsV0FBRCxFQUFjQyxVQUFkLEVBQTBCQyxTQUExQixFQUFxQ0MsT0FBckMsRUFBOENDLGFBQTlDLEVBQTZERyxhQUE3RCxFQUFQO0FBQ0Q7O0FBRUQ3RCxXQUFTO0FBQ1AsV0FDRTtBQUFBO0FBQUEsUUFBSyxXQUFVLG9CQUFmO0FBQ0U7QUFBQTtBQUFBLFVBQUssV0FBVSxxQkFBZjtBQUNHLGFBQUsrRCxpQkFBTCxFQURIO0FBRUcsYUFBS0MsY0FBTCxFQUZIO0FBR0csYUFBSy9ELEtBQUwsQ0FBV3hCLE9BQVgsQ0FBbUJjLEdBQW5CLENBQXVCLEtBQUswRSxZQUE1QjtBQUhIO0FBREYsS0FERjtBQVNEOztBQUVERCxtQkFBaUI7QUFDZixXQUNFO0FBQUE7QUFBQSxRQUFLLFdBQVUsb0JBQWY7QUFBQTtBQUVHLFdBQUtmLEtBQUwsQ0FBV1ksYUFBWCxDQUF5QnRFLEdBQXpCLENBQTZCMkUsUUFBUTtBQUNwQyxjQUFNQyxVQUFVRCxPQUFPLEtBQUtqRSxLQUFMLENBQVcyRCxVQUFsQztBQUNBLGNBQU05QixRQUFRO0FBQ1pzQyxnQkFBTUQ7QUFETSxTQUFkO0FBR0EsZUFBTztBQUFBO0FBQUEsWUFBTSxXQUFVLDBCQUFoQixFQUEyQyxPQUFPckMsS0FBbEQsRUFBeUQsS0FBTSxNQUFLb0MsSUFBSyxFQUF6RTtBQUE2RUEsY0FBN0U7QUFBQTtBQUFBLFNBQVA7QUFDRCxPQU5BO0FBRkgsS0FERjtBQVlEOztBQUVESCxzQkFBb0I7QUFDbEIsV0FDRTtBQUFBO0FBQUEsUUFBSyxXQUFVLHdCQUFmO0FBQ0csV0FBS2QsS0FBTCxDQUFXWSxhQUFYLENBQXlCdEUsR0FBekIsQ0FBNkIyRSxRQUFRO0FBQ3BDLGNBQU1DLFVBQVVELE9BQU8sS0FBS2pFLEtBQUwsQ0FBVzJELFVBQWxDO0FBQ0EsY0FBTTlCLFFBQVE7QUFDWnNDLGdCQUFNRDtBQURNLFNBQWQ7QUFHQSxlQUFPLHdDQUFNLFdBQVUsdUJBQWhCLEVBQXdDLE9BQU9yQyxLQUEvQyxFQUFzRCxLQUFNLE1BQUtvQyxJQUFLLEVBQXRFLEdBQVA7QUFDRCxPQU5BO0FBREgsS0FERjtBQVdEOztBQUdERCxlQUFhM0YsTUFBYixFQUFxQkwsQ0FBckIsRUFBd0I7QUFDdEIsUUFBSUssT0FBT00sUUFBUCxPQUFzQixJQUF0QixJQUE4Qk4sT0FBT1MsTUFBUCxPQUFvQixJQUF0RCxFQUE0RDtBQUFFLGFBQU8sdUNBQUssS0FBS2QsQ0FBVixHQUFQO0FBQXlCOztBQUV2RixVQUFNb0csY0FBYy9GLE9BQU9NLFFBQVAsS0FBb0IsS0FBS3FFLEtBQUwsQ0FBV08sU0FBbkQ7QUFDQSxVQUFNaEQsV0FBV2xDLE9BQU9TLE1BQVAsS0FBa0JULE9BQU9NLFFBQVAsRUFBbkM7QUFDQSxVQUFNMEYsY0FBYztBQUNsQkYsWUFBTUMsY0FBYyxLQUFLcEUsS0FBTCxDQUFXMkQsVUFEYjtBQUVsQjdCLGFBQU92QixXQUFXLEtBQUtQLEtBQUwsQ0FBVzJEO0FBRlgsS0FBcEI7O0FBS0EsV0FDRTtBQUFBO0FBQUEsUUFBSyxXQUFVLGVBQWYsRUFBK0IsS0FBSzNGLENBQXBDO0FBQ0U7QUFBQTtBQUFBO0FBQ0UscUJBQVUscUJBRFo7QUFFRSxpQkFBTyxFQUFDcUMsYUFBYWdFLFlBQVlGLElBQVosR0FBbUJFLFlBQVl2QyxLQUE3QyxFQUZUO0FBRStEekQsZUFBT0M7QUFGdEUsT0FERjtBQUlFLG9DQUFDLFVBQUQsSUFBWSxXQUFVLGtCQUF0QixFQUF5QyxPQUFPK0YsV0FBaEQsRUFBNkQsUUFBUWhHLE1BQXJFO0FBSkYsS0FERjtBQVFEO0FBbEdxQyxDLFVBQy9CcUMsUyxHQUFZO0FBQ2pCbEMsV0FBUyxvQkFBVThGLE9BQVYsQ0FBa0Isb0JBQVUzRCxVQUFWLENBQXFCekMsTUFBckIsQ0FBbEIsRUFBZ0QwQyxVQUR4QztBQUVqQitDLGNBQVksb0JBQVVZLE1BQVYsQ0FBaUIzRDtBQUZaLEM7SUFxR2Y0RCxlLGtDQUFOLE1BQU1BLGVBQU4sU0FBOEIsZ0JBQU0xRSxTQUFwQyxDQUE4Qzs7QUFLNUNyQixjQUFZdUIsS0FBWixFQUFtQitDLE9BQW5CLEVBQTRCO0FBQzFCLFVBQU0vQyxLQUFOLEVBQWErQyxPQUFiO0FBQ0EsU0FBS0MsS0FBTCxHQUFhO0FBQ1hXLGtCQUFZLEdBREQ7QUFFWGMsaUJBQVc7QUFGQSxLQUFiO0FBSUQ7O0FBR0QxRSxXQUFTO0FBQUEsVUFDQXZCLE9BREEsR0FDVyxLQUFLd0IsS0FEaEIsQ0FDQXhCLE9BREE7O0FBRVAsVUFBTTZFLGNBQWM3RSxRQUFRLENBQVIsQ0FBcEI7QUFDQSxVQUFNOEUsYUFBYTlFLFFBQVFBLFFBQVFJLE1BQVIsR0FBaUIsQ0FBekIsQ0FBbkI7O0FBRUEsVUFBTTJFLFlBQVlGLFlBQVkxRSxRQUFaLEVBQWxCO0FBQ0EsVUFBTTZFLFVBQVVGLFdBQVd4RSxNQUFYLEVBQWhCO0FBQ0EsVUFBTXlCLFdBQVdpRCxVQUFVRCxTQUEzQjs7QUFFQSxXQUNFO0FBQUE7QUFBQSxRQUFLLFdBQVUsK0JBQWY7QUFDRTtBQUFBO0FBQUEsVUFBSyxXQUFVLGtCQUFmO0FBQ0U7QUFBQTtBQUFBLFlBQUssV0FBVSx1QkFBZjtBQUNFO0FBQUE7QUFBQSxjQUFNLFNBQVMsS0FBS21CLG1CQUFwQixFQUF5QyxXQUFVLGlCQUFuRDtBQUNHLGlCQUFLMUIsS0FBTCxDQUFXeUIsU0FBWCxHQUF1QixRQUF2QixHQUFrQztBQURyQyxXQURGO0FBSUcsZUFBS3pFLEtBQUwsQ0FBV3hCLE9BQVgsQ0FBbUJJLE1BSnRCO0FBQUE7QUFJNkM0QixlQUFLQyxLQUFMLENBQVdGLFFBQVgsQ0FKN0M7QUFBQTtBQUFBLFNBREY7QUFPRTtBQUFBO0FBQUEsWUFBSyxXQUFVLDJCQUFmO0FBQ0U7QUFBQTtBQUFBO0FBQ0UseUJBQVUsb0NBRFo7QUFFRSx1QkFBUyxLQUFLb0UsaUJBRmhCO0FBQUE7QUFBQSxXQURGO0FBSUUsNkRBQVMsTUFBSyxRQUFkLEdBSkY7QUFLRTtBQUNFLGtCQUFLLE9BRFA7QUFFRSx1QkFBVSxhQUZaO0FBR0UsaUJBQUssR0FIUDtBQUlFLGlCQUFLLENBSlA7QUFLRSxrQkFBTSxJQUxSO0FBTUUsbUJBQU8sS0FBSzNCLEtBQUwsQ0FBV1csVUFOcEI7QUFPRSxzQkFBVSxLQUFLaUI7QUFQakI7QUFMRjtBQVBGLE9BREY7QUF3QkcsV0FBSzVCLEtBQUwsQ0FBV3lCLFNBQVgsR0FBdUIsSUFBdkIsR0FBOEIsOEJBQUMsU0FBRCxJQUFXLFNBQVMsS0FBS3pFLEtBQUwsQ0FBV3hCLE9BQS9CLEVBQXdDLFlBQVksS0FBS3dFLEtBQUwsQ0FBV1csVUFBL0Q7QUF4QmpDLEtBREY7QUE0QkQ7O0FBR0RpQix5QkFBdUI1QyxDQUF2QixFQUEwQjtBQUN4QixTQUFLb0IsUUFBTCxDQUFjLEVBQUNPLFlBQVlrQixXQUFXN0MsRUFBRThDLE1BQUYsQ0FBU0MsS0FBcEIsQ0FBYixFQUFkO0FBQ0Q7O0FBR0RMLHNCQUFvQjFDLENBQXBCLEVBQXVCO0FBQ3JCLFNBQUtvQixRQUFMLENBQWM0QixNQUFNLEVBQUNQLFdBQVcsQ0FBQ08sRUFBRVAsU0FBZixFQUFOLENBQWQ7QUFDRDs7QUFHREUsb0JBQWtCM0MsQ0FBbEIsRUFBcUI7QUFDbkJBLE1BQUVpRCxjQUFGO0FBQ0EsVUFBTUMsT0FBT0MsS0FBS0MsU0FBTCxDQUFlLEtBQUtwRixLQUFMLENBQVd4QixPQUFYLENBQW1CYyxHQUFuQixDQUF1QitGLEtBQUtBLEVBQUUxRixTQUFGLEVBQTVCLENBQWYsRUFBMkQsSUFBM0QsRUFBaUUsSUFBakUsQ0FBYjtBQUNBLFVBQU0yRixTQUFTLHFCQUFlLEVBQUNDLE1BQU1MLElBQVAsRUFBZixDQUFmO0FBQ0F2SCxXQUFPNkgsY0FBUCxDQUFzQjtBQUNwQkMsbUJBQWE7QUFETyxLQUF0QixFQUVHQyxZQUFZO0FBQ2IsVUFBSSxDQUFDQSxRQUFMLEVBQWU7QUFBRTtBQUFTO0FBQzFCSixhQUFPSyxNQUFQLENBQWNELFFBQWQ7QUFDRCxLQUxEO0FBTUQ7QUExRTJDLEMsVUFDckNoRixTLEdBQVk7QUFDakJsQyxXQUFTLG9CQUFVOEYsT0FBVixDQUFrQixvQkFBVTNELFVBQVYsQ0FBcUJ6QyxNQUFyQixDQUFsQixFQUFnRDBDO0FBRHhDLEM7OztBQTZFckIsSUFBSXBDLFVBQVUsSUFBZDtBQUNBLElBQUlvSCxVQUFVLENBQWQ7QUFDQSxNQUFNQyxTQUFTLEVBQWY7QUFDQSxJQUFJQyxpQkFBaUIsSUFBckI7QUFDQSxJQUFJQyxjQUFjLElBQWxCOztJQUVxQkMsYyxrQ0FBTixNQUFNQSxjQUFOLFNBQTZCLGdCQUFNbEcsU0FBbkMsQ0FBNkM7O0FBTzFELFNBQU9tRyxjQUFQLEdBQXdCO0FBQ3RCLFFBQUl2RSxPQUFKO0FBQ0EsV0FBTztBQUNML0Isa0JBQVk7QUFBRSxlQUFPLEVBQUN1RyxjQUFjLGdCQUFmLEVBQVA7QUFBMEMsT0FEbkQ7QUFFTEMsZUFBUztBQUFFLGVBQU8sNkJBQVA7QUFBdUMsT0FGN0M7QUFHTEMsaUJBQVc7QUFBRSxlQUFPLDZCQUFQO0FBQXVDLE9BSC9DO0FBSUwsVUFBSTFFLE9BQUosR0FBYztBQUNaLFlBQUksQ0FBQ0EsT0FBTCxFQUFjO0FBQ1pBLG9CQUFVUSxTQUFTQyxhQUFULENBQXVCLEtBQXZCLENBQVY7QUFDQSw2QkFBU3BDLE1BQVQsQ0FBZ0IsOEJBQUMsY0FBRCxJQUFnQixXQUFXMkIsT0FBM0IsR0FBaEIsRUFBd0RBLE9BQXhEO0FBQ0Q7QUFDRCxlQUFPQSxPQUFQO0FBQ0Q7QUFWSSxLQUFQO0FBWUQ7O0FBRUQsU0FBT3ZELFdBQVAsR0FBcUI7QUFDbkIsV0FBTyxLQUFLOEgsY0FBTCxFQUFQO0FBQ0Q7O0FBRUQsU0FBT0ksY0FBUCxDQUFzQi9ILEtBQXRCLEVBQTZCO0FBQzNCLFVBQU1ELFNBQVMsSUFBSUgsTUFBSixDQUFXSSxLQUFYLEVBQWtCLE1BQU07QUFDckMwSCxxQkFBZU0sY0FBZjtBQUNELEtBRmMsQ0FBZjtBQUdBLFVBQU1uSCxNQUFNRCxZQUFZQyxHQUFaLEVBQVo7QUFDQSxRQUFJLENBQUNYLE9BQUQsSUFBYXNILGtCQUFrQnRGLEtBQUsrRixHQUFMLENBQVNwSCxNQUFNMkcsY0FBZixLQUFrQyxJQUFyRSxFQUE0RTtBQUMxRUY7QUFDQXBILGdCQUFVLEVBQVY7QUFDQXFILGFBQU9XLE9BQVAsQ0FBZSxFQUFDQyxJQUFJYixPQUFMLEVBQWNwSCxPQUFkLEVBQWY7QUFDQSxVQUFJcUgsT0FBT2pILE1BQVAsR0FBZ0IsR0FBcEIsRUFBeUI7QUFDdkJpSCxlQUFPYSxHQUFQO0FBQ0Q7QUFDRjtBQUNEWixxQkFBaUIzRyxHQUFqQjtBQUNBWCxZQUFRUCxJQUFSLENBQWFJLE1BQWI7QUFDQTJILG1CQUFlTSxjQUFmO0FBQ0EsV0FBT2pJLE1BQVA7QUFDRDs7QUFFRCxTQUFPc0ksWUFBUCxDQUFvQkMsS0FBcEIsRUFBMkI7QUFDekJoQjtBQUNBQyxXQUFPVyxPQUFQLENBQWUsRUFBQ0MsSUFBSWIsT0FBTCxFQUFjcEgsU0FBU29JLEtBQXZCLEVBQWY7QUFDQVosbUJBQWVNLGNBQWYsQ0FBOEIsSUFBOUI7QUFDRDs7QUFFRCxTQUFPQSxjQUFQLEdBQXlDO0FBQUEsUUFBbkJPLFNBQW1CLHVFQUFQLEtBQU87O0FBQ3ZDLFFBQUlkLFdBQUosRUFBaUI7QUFDZmUsbUJBQWFmLFdBQWI7QUFDRDs7QUFFREEsa0JBQWNnQixXQUFXLE1BQU07QUFDN0JmLHFCQUFlZ0IsT0FBZixDQUF1QkMsSUFBdkIsQ0FBNEIsWUFBNUI7QUFDRCxLQUZhLEVBRVhKLFlBQVksQ0FBWixHQUFnQixJQUZMLENBQWQ7QUFHRDs7QUFFRCxTQUFPSyxXQUFQLENBQW1CQyxRQUFuQixFQUE2QjtBQUMzQixXQUFPbkIsZUFBZWdCLE9BQWYsQ0FBdUJJLEVBQXZCLENBQTBCLFlBQTFCLEVBQXdDRCxRQUF4QyxDQUFQO0FBQ0Q7O0FBRURFLHNCQUFvQjtBQUNsQixTQUFLQyxhQUFMLEdBQXFCLGtDQUNuQnRCLGVBQWVrQixXQUFmLENBQTJCLE1BQU0sS0FBS0ssV0FBTCxFQUFqQyxDQURtQixFQUVuQmxGLEtBQUttRixTQUFMLENBQWVDLG9CQUFmLENBQW9DLFdBQVk7QUFBQSxVQUFWakYsSUFBVSxTQUFWQSxJQUFVOztBQUM5QyxVQUFJQSxLQUFLZCxPQUFMLEtBQWlCLEtBQUsxQixLQUFMLENBQVcwSCxTQUFoQyxFQUEyQztBQUN6QztBQUNBLDJCQUFTQyxzQkFBVCxDQUFnQyxLQUFLM0gsS0FBTCxDQUFXMEgsU0FBM0M7QUFDRDtBQUNGLEtBTEQsQ0FGbUIsQ0FBckI7QUFTRDs7QUFFRDdFLHlCQUF1QjtBQUNyQixTQUFLeUUsYUFBTCxDQUFtQjFFLE9BQW5CO0FBQ0Q7O0FBRUQ3QyxXQUFTO0FBQ1AsV0FDRTtBQUFBO0FBQUEsUUFBSyxXQUFVLHVCQUFmO0FBQ0U7QUFBQTtBQUFBLFVBQUssV0FBVSw4QkFBZjtBQUNFO0FBQUE7QUFBQSxZQUFRLFdBQVUsbUJBQWxCLEVBQXNDLFNBQVMsS0FBSzZILGlCQUFwRDtBQUFBO0FBQUE7QUFERixPQURGO0FBSUcvQixhQUFPdkcsR0FBUCxDQUFXLENBQUNzSCxLQUFELEVBQVFwSCxHQUFSLEtBQ1YsOEJBQUMsZUFBRCxJQUFpQixLQUFLb0gsTUFBTUgsRUFBNUIsRUFBZ0MsU0FBU0csTUFBTXBJLE9BQS9DLEdBREQ7QUFKSCxLQURGO0FBVUQ7O0FBR0RvSixvQkFBa0I1RixDQUFsQixFQUFxQjtBQUNuQkEsTUFBRWlELGNBQUY7QUFDQXRILFdBQU9rSyxjQUFQLENBQXNCO0FBQ3BCQyxrQkFBWSxDQUFDLFVBQUQ7QUFEUSxLQUF0QjtBQUFBLG9DQUVHLFdBQU1DLFNBQU4sRUFBbUI7QUFDcEIsWUFBSSxDQUFDQSxTQUFMLEVBQWdCO0FBQUU7QUFBUztBQUMzQixjQUFNckMsV0FBV3FDLFVBQVUsQ0FBVixDQUFqQjtBQUNBLFlBQUk7QUFDRixnQkFBTUMsV0FBVyxNQUFNLHVCQUFTdEMsUUFBVCxDQUF2QjtBQUNBLGdCQUFNdEgsT0FBTytHLEtBQUs4QyxLQUFMLENBQVdELFFBQVgsQ0FBYjtBQUNBLGdCQUFNRSxrQkFBa0I5SixLQUFLa0IsR0FBTCxDQUFTO0FBQUEsbUJBQVFwQixPQUFPQyxXQUFQLENBQW1CcUUsSUFBbkIsQ0FBUjtBQUFBLFdBQVQsQ0FBeEI7QUFDQXdELHlCQUFlVyxZQUFmLENBQTRCdUIsZUFBNUI7QUFDRCxTQUxELENBS0UsT0FBT0MsSUFBUCxFQUFhO0FBQ2I5RixlQUFLK0YsYUFBTCxDQUFtQkMsUUFBbkIsQ0FBNkIsaUNBQWdDM0MsUUFBUyxFQUF0RTtBQUNEO0FBQ0YsT0FiRDs7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQWNEO0FBaEh5RCxDLFVBQ25EaEYsUyxHQUFZO0FBQ2pCZ0gsYUFBVyxvQkFBVVksR0FBVixDQUFjMUg7QUFEUixDLFVBSVpvRyxPLEdBQVUsdUI7a0JBTEVoQixjIiwiZmlsZSI6ImdpdC10aW1pbmdzLXZpZXcuanMiLCJzb3VyY2VSb290IjoiL2hvbWUvdHJhdmlzL2J1aWxkL2F0b20vYXRvbS9vdXQvYXBwL25vZGVfbW9kdWxlcy9naXRodWIiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQge1RleHRCdWZmZXJ9IGZyb20gJ2F0b20nO1xuaW1wb3J0IHtFbWl0dGVyLCBDb21wb3NpdGVEaXNwb3NhYmxlfSBmcm9tICdldmVudC1raXQnO1xuaW1wb3J0IHtyZW1vdGV9IGZyb20gJ2VsZWN0cm9uJztcbmNvbnN0IHtkaWFsb2d9ID0gcmVtb3RlO1xuXG5pbXBvcnQgUmVhY3QgZnJvbSAncmVhY3QnO1xuaW1wb3J0IFJlYWN0RG9tIGZyb20gJ3JlYWN0LWRvbSc7XG5pbXBvcnQgUHJvcFR5cGVzIGZyb20gJ3Byb3AtdHlwZXMnO1xuaW1wb3J0IHthdXRvYmluZH0gZnJvbSAnY29yZS1kZWNvcmF0b3JzJztcbmltcG9ydCBtZW1vaXplIGZyb20gJ2xvZGFzaC5tZW1vaXplJztcblxuaW1wb3J0IHtyZWFkRmlsZX0gZnJvbSAnLi4vaGVscGVycyc7XG5pbXBvcnQgT2N0aWNvbiBmcm9tICcuL29jdGljb24nO1xuXG5jb25zdCBnZW5BcnJheSA9IG1lbW9pemUoZnVuY3Rpb24gZ2VuQXJyYXkoaW50ZXJ2YWwsIGNvdW50KSB7XG4gIGNvbnN0IGFyciA9IFtdO1xuICBmb3IgKGxldCBpID0gMTsgaSA8PSBjb3VudDsgaSsrKSB7XG4gICAgYXJyLnB1c2goaW50ZXJ2YWwgKiBpKTtcbiAgfVxuICByZXR1cm4gYXJyO1xufSwgKGludGVydmFsLCBjb3VudCkgPT4gYCR7aW50ZXJ2YWx9OiR7Y291bnR9YCk7XG5cbmNsYXNzIE1hcmtlciB7XG4gIHN0YXRpYyBkZXNlcmlhbGl6ZShkYXRhKSB7XG4gICAgY29uc3QgbWFya2VyID0gbmV3IE1hcmtlcihkYXRhLmxhYmVsLCAoKSA9PiB7fSk7XG4gICAgbWFya2VyLmVuZCA9IGRhdGEuZW5kO1xuICAgIG1hcmtlci5tYXJrZXJzID0gZGF0YS5tYXJrZXJzO1xuICAgIHJldHVybiBtYXJrZXI7XG4gIH1cblxuICBjb25zdHJ1Y3RvcihsYWJlbCwgZGlkVXBkYXRlKSB7XG4gICAgdGhpcy5sYWJlbCA9IGxhYmVsO1xuICAgIHRoaXMuZGlkVXBkYXRlID0gZGlkVXBkYXRlO1xuICAgIHRoaXMuZW5kID0gbnVsbDtcbiAgICB0aGlzLm1hcmtlcnMgPSBbXTtcbiAgfVxuXG4gIGdldFN0YXJ0KCkge1xuICAgIHJldHVybiB0aGlzLm1hcmtlcnMubGVuZ3RoID8gdGhpcy5tYXJrZXJzWzBdLnN0YXJ0IDogbnVsbDtcbiAgfVxuXG4gIGdldEVuZCgpIHtcbiAgICByZXR1cm4gdGhpcy5lbmQ7XG4gIH1cblxuICBtYXJrKHNlY3Rpb25OYW1lLCBzdGFydCkge1xuICAgIHRoaXMubWFya2Vycy5wdXNoKHtuYW1lOiBzZWN0aW9uTmFtZSwgc3RhcnQ6IHN0YXJ0IHx8IHBlcmZvcm1hbmNlLm5vdygpfSk7XG4gIH1cblxuICBmaW5hbGl6ZSgpIHtcbiAgICB0aGlzLmVuZCA9IHBlcmZvcm1hbmNlLm5vdygpO1xuICAgIHRoaXMuZGlkVXBkYXRlKCk7XG4gIH1cblxuICBnZXRUaW1pbmdzKCkge1xuICAgIHJldHVybiB0aGlzLm1hcmtlcnMubWFwKCh0aW1pbmcsIGlkeCwgYXJ5KSA9PiB7XG4gICAgICBjb25zdCBuZXh0ID0gYXJ5W2lkeCArIDFdO1xuICAgICAgY29uc3QgZW5kID0gbmV4dCA/IG5leHQuc3RhcnQgOiB0aGlzLmdldEVuZCgpO1xuICAgICAgcmV0dXJuIHsuLi50aW1pbmcsIGVuZH07XG4gICAgfSk7XG4gIH1cblxuICBzZXJpYWxpemUoKSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIGxhYmVsOiB0aGlzLmxhYmVsLFxuICAgICAgZW5kOiB0aGlzLmVuZCxcbiAgICAgIG1hcmtlcnM6IHRoaXMubWFya2Vycy5zbGljZSgpLFxuICAgIH07XG4gIH1cbn1cblxuXG5jbGFzcyBNYXJrZXJUb29sdGlwIGV4dGVuZHMgUmVhY3QuQ29tcG9uZW50IHtcbiAgc3RhdGljIHByb3BUeXBlcyA9IHtcbiAgICBtYXJrZXI6IFByb3BUeXBlcy5pbnN0YW5jZU9mKE1hcmtlcikuaXNSZXF1aXJlZCxcbiAgfVxuXG4gIHJlbmRlcigpIHtcbiAgICBjb25zdCB7bWFya2VyfSA9IHRoaXMucHJvcHM7XG4gICAgY29uc3QgdGltaW5ncyA9IG1hcmtlci5nZXRUaW1pbmdzKCk7XG5cbiAgICByZXR1cm4gKFxuICAgICAgPGRpdiBzdHlsZT17e3RleHRBbGlnbjogJ2xlZnQnLCBtYXhXaWR0aDogMzAwLCB3aGl0ZVNwYWNlOiAnaW5pdGlhbCd9fT5cbiAgICAgICAgPHN0cm9uZz48dHQ+e21hcmtlci5sYWJlbH08L3R0Pjwvc3Ryb25nPlxuICAgICAgICA8dWwgc3R5bGU9e3twYWRkaW5nTGVmdDogMjAsIG1hcmdpblRvcDogMTB9fT5cbiAgICAgICAgICB7dGltaW5ncy5tYXAoKHtuYW1lLCBzdGFydCwgZW5kfSkgPT4ge1xuICAgICAgICAgICAgY29uc3QgZHVyYXRpb24gPSBlbmQgLSBzdGFydDtcbiAgICAgICAgICAgIHJldHVybiA8bGkga2V5PXtuYW1lfT57bmFtZX06IHtNYXRoLmZsb29yKGR1cmF0aW9uICogMTAwKSAvIDEwMH1tczwvbGk+O1xuICAgICAgICAgIH0pfVxuICAgICAgICA8L3VsPlxuICAgICAgPC9kaXY+XG4gICAgKTtcbiAgfVxufVxuXG5jb25zdCBDT0xPUlMgPSB7XG4gIHF1ZXVlZDogJ3JlZCcsXG4gIHByZXBhcmU6ICdjeWFuJyxcbiAgbmV4dHRpY2s6ICd5ZWxsb3cnLFxuICBleGVjdXRlOiAnZ3JlZW4nLFxuICBpcGM6ICdwaW5rJyxcbn07XG5jbGFzcyBNYXJrZXJTcGFuIGV4dGVuZHMgUmVhY3QuQ29tcG9uZW50IHtcbiAgc3RhdGljIHByb3BUeXBlcyA9IHtcbiAgICBtYXJrZXI6IFByb3BUeXBlcy5pbnN0YW5jZU9mKE1hcmtlcikuaXNSZXF1aXJlZCxcbiAgfVxuXG4gIHJlbmRlcigpIHtcbiAgICBjb25zdCB7bWFya2VyLCAuLi5vdGhlcnN9ID0gdGhpcy5wcm9wcztcbiAgICBjb25zdCB0aW1pbmdzID0gbWFya2VyLmdldFRpbWluZ3MoKTtcbiAgICBjb25zdCB0b3RhbFRpbWUgPSBtYXJrZXIuZ2V0RW5kKCkgLSBtYXJrZXIuZ2V0U3RhcnQoKTtcbiAgICBjb25zdCBwZXJjZW50YWdlcyA9IHRpbWluZ3MubWFwKCh7bmFtZSwgc3RhcnQsIGVuZH0pID0+IHtcbiAgICAgIGNvbnN0IGR1cmF0aW9uID0gZW5kIC0gc3RhcnQ7XG4gICAgICByZXR1cm4ge2NvbG9yOiBDT0xPUlNbbmFtZV0sIHBlcmNlbnQ6IGR1cmF0aW9uIC8gdG90YWxUaW1lICogMTAwfTtcbiAgICB9KTtcbiAgICByZXR1cm4gKFxuICAgICAgPHNwYW5cbiAgICAgICAgey4uLm90aGVyc31cbiAgICAgICAgcmVmPXtjID0+IHsgdGhpcy5lbGVtZW50ID0gYzsgfX1cbiAgICAgICAgb25Nb3VzZU92ZXI9e3RoaXMuaGFuZGxlTW91c2VPdmVyfVxuICAgICAgICBvbk1vdXNlT3V0PXt0aGlzLmhhbmRsZU1vdXNlT3V0fT5cbiAgICAgICAge3BlcmNlbnRhZ2VzLm1hcCgoe2NvbG9yLCBwZXJjZW50fSwgaSkgPT4ge1xuICAgICAgICAgIGNvbnN0IHN0eWxlID0ge1xuICAgICAgICAgICAgd2lkdGg6IGAke3BlcmNlbnR9JWAsXG4gICAgICAgICAgICBiYWNrZ3JvdW5kOiBjb2xvcixcbiAgICAgICAgICB9O1xuICAgICAgICAgIHJldHVybiA8c3BhbiBjbGFzc05hbWU9XCJ3YXRlcmZhbGwtbWFya2VyLXNlY3Rpb25cIiBrZXk9e2l9IHN0eWxlPXtzdHlsZX0gLz47XG4gICAgICAgIH0pfVxuICAgICAgPC9zcGFuPlxuICAgICk7XG4gIH1cblxuICBAYXV0b2JpbmRcbiAgaGFuZGxlTW91c2VPdmVyKGUpIHtcbiAgICBjb25zdCBlbGVtID0gZG9jdW1lbnQuY3JlYXRlRWxlbWVudCgnZGl2Jyk7XG4gICAgUmVhY3REb20ucmVuZGVyKDxNYXJrZXJUb29sdGlwIG1hcmtlcj17dGhpcy5wcm9wcy5tYXJrZXJ9IC8+LCBlbGVtKTtcbiAgICB0aGlzLnRvb2x0aXBEaXNwb3NhYmxlID0gYXRvbS50b29sdGlwcy5hZGQodGhpcy5lbGVtZW50LCB7XG4gICAgICBpdGVtOiBlbGVtLFxuICAgICAgcGxhY2VtZW50OiAnYXV0byBib3R0b20nLFxuICAgICAgdHJpZ2dlcjogJ21hbnVhbCcsXG4gICAgfSk7XG4gIH1cblxuICBjbG9zZVRvb2x0aXAoKSB7XG4gICAgdGhpcy50b29sdGlwRGlzcG9zYWJsZSAmJiB0aGlzLnRvb2x0aXBEaXNwb3NhYmxlLmRpc3Bvc2UoKTtcbiAgICB0aGlzLnRvb2x0aXBEaXNwb3NhYmxlID0gbnVsbDtcbiAgfVxuXG4gIEBhdXRvYmluZFxuICBoYW5kbGVNb3VzZU91dChlKSB7XG4gICAgdGhpcy5jbG9zZVRvb2x0aXAoKTtcbiAgfVxuXG4gIGNvbXBvbmVudFdpbGxVbm1vdW50KCkge1xuICAgIHRoaXMuY2xvc2VUb29sdGlwKCk7XG4gIH1cbn1cblxuXG5jbGFzcyBXYXRlcmZhbGwgZXh0ZW5kcyBSZWFjdC5Db21wb25lbnQge1xuICBzdGF0aWMgcHJvcFR5cGVzID0ge1xuICAgIG1hcmtlcnM6IFByb3BUeXBlcy5hcnJheU9mKFByb3BUeXBlcy5pbnN0YW5jZU9mKE1hcmtlcikpLmlzUmVxdWlyZWQsXG4gICAgem9vbUZhY3RvcjogUHJvcFR5cGVzLm51bWJlci5pc1JlcXVpcmVkLFxuICB9XG5cbiAgY29uc3RydWN0b3IocHJvcHMsIGNvbnRleHQpIHtcbiAgICBzdXBlcihwcm9wcywgY29udGV4dCk7XG4gICAgdGhpcy5zdGF0ZSA9IHRoaXMuZ2V0TmV4dFN0YXRlKHByb3BzKTtcbiAgfVxuXG4gIGNvbXBvbmVudFdpbGxSZWNlaXZlUHJvcHMobmV4dFByb3BzKSB7XG4gICAgdGhpcy5zZXRTdGF0ZSh0aGlzLmdldE5leHRTdGF0ZShuZXh0UHJvcHMpKTtcbiAgfVxuXG4gIGdldE5leHRTdGF0ZShwcm9wcykge1xuICAgIGNvbnN0IHttYXJrZXJzfSA9IHByb3BzO1xuICAgIGNvbnN0IGZpcnN0TWFya2VyID0gbWFya2Vyc1swXTtcbiAgICBjb25zdCBsYXN0TWFya2VyID0gbWFya2Vyc1ttYXJrZXJzLmxlbmd0aCAtIDFdO1xuXG4gICAgY29uc3Qgc3RhcnRUaW1lID0gZmlyc3RNYXJrZXIuZ2V0U3RhcnQoKTtcbiAgICBjb25zdCBlbmRUaW1lID0gbGFzdE1hcmtlci5nZXRFbmQoKTtcbiAgICBjb25zdCB0b3RhbER1cmF0aW9uID0gZW5kVGltZSAtIHN0YXJ0VGltZTtcbiAgICBsZXQgdGltZWxpbmVNYXJrSW50ZXJ2YWwgPSBudWxsO1xuICAgIGlmIChwcm9wcy56b29tRmFjdG9yIDw9IDAuMTUpIHtcbiAgICAgIHRpbWVsaW5lTWFya0ludGVydmFsID0gMTAwMDtcbiAgICB9IGVsc2UgaWYgKHByb3BzLnpvb21GYWN0b3IgPD0gMC4zKSB7XG4gICAgICB0aW1lbGluZU1hcmtJbnRlcnZhbCA9IDUwMDtcbiAgICB9IGVsc2UgaWYgKHByb3BzLnpvb21GYWN0b3IgPD0gMC42KSB7XG4gICAgICB0aW1lbGluZU1hcmtJbnRlcnZhbCA9IDI1MDtcbiAgICB9IGVsc2Uge1xuICAgICAgdGltZWxpbmVNYXJrSW50ZXJ2YWwgPSAxMDA7XG4gICAgfVxuICAgIGNvbnN0IHRpbWVsaW5lTWFya3MgPSBnZW5BcnJheSh0aW1lbGluZU1hcmtJbnRlcnZhbCwgTWF0aC5jZWlsKHRvdGFsRHVyYXRpb24gLyB0aW1lbGluZU1hcmtJbnRlcnZhbCkpO1xuXG4gICAgcmV0dXJuIHtmaXJzdE1hcmtlciwgbGFzdE1hcmtlciwgc3RhcnRUaW1lLCBlbmRUaW1lLCB0b3RhbER1cmF0aW9uLCB0aW1lbGluZU1hcmtzfTtcbiAgfVxuXG4gIHJlbmRlcigpIHtcbiAgICByZXR1cm4gKFxuICAgICAgPGRpdiBjbGFzc05hbWU9XCJ3YXRlcmZhbGwtc2Nyb2xsZXJcIj5cbiAgICAgICAgPGRpdiBjbGFzc05hbWU9XCJ3YXRlcmZhbGwtY29udGFpbmVyXCI+XG4gICAgICAgICAge3RoaXMucmVuZGVyVGltZU1hcmtlcnMoKX1cbiAgICAgICAgICB7dGhpcy5yZW5kZXJUaW1lbGluZSgpfVxuICAgICAgICAgIHt0aGlzLnByb3BzLm1hcmtlcnMubWFwKHRoaXMucmVuZGVyTWFya2VyKX1cbiAgICAgICAgPC9kaXY+XG4gICAgICA8L2Rpdj5cbiAgICApO1xuICB9XG5cbiAgcmVuZGVyVGltZWxpbmUoKSB7XG4gICAgcmV0dXJuIChcbiAgICAgIDxkaXYgY2xhc3NOYW1lPVwid2F0ZXJmYWxsLXRpbWVsaW5lXCI+XG4gICAgICAgICZuYnNwO1xuICAgICAgICB7dGhpcy5zdGF0ZS50aW1lbGluZU1hcmtzLm1hcCh0aW1lID0+IHtcbiAgICAgICAgICBjb25zdCBsZWZ0UG9zID0gdGltZSAqIHRoaXMucHJvcHMuem9vbUZhY3RvcjtcbiAgICAgICAgICBjb25zdCBzdHlsZSA9IHtcbiAgICAgICAgICAgIGxlZnQ6IGxlZnRQb3MsXG4gICAgICAgICAgfTtcbiAgICAgICAgICByZXR1cm4gPHNwYW4gY2xhc3NOYW1lPVwid2F0ZXJmYWxsLXRpbWVsaW5lLWxhYmVsXCIgc3R5bGU9e3N0eWxlfSBrZXk9e2B0bDoke3RpbWV9YH0+e3RpbWV9bXM8L3NwYW4+O1xuICAgICAgICB9KX1cbiAgICAgIDwvZGl2PlxuICAgICk7XG4gIH1cblxuICByZW5kZXJUaW1lTWFya2VycygpIHtcbiAgICByZXR1cm4gKFxuICAgICAgPGRpdiBjbGFzc05hbWU9XCJ3YXRlcmZhbGwtdGltZS1tYXJrZXJzXCI+XG4gICAgICAgIHt0aGlzLnN0YXRlLnRpbWVsaW5lTWFya3MubWFwKHRpbWUgPT4ge1xuICAgICAgICAgIGNvbnN0IGxlZnRQb3MgPSB0aW1lICogdGhpcy5wcm9wcy56b29tRmFjdG9yO1xuICAgICAgICAgIGNvbnN0IHN0eWxlID0ge1xuICAgICAgICAgICAgbGVmdDogbGVmdFBvcyxcbiAgICAgICAgICB9O1xuICAgICAgICAgIHJldHVybiA8c3BhbiBjbGFzc05hbWU9XCJ3YXRlcmZhbGwtdGltZS1tYXJrZXJcIiBzdHlsZT17c3R5bGV9IGtleT17YHRtOiR7dGltZX1gfSAvPjtcbiAgICAgICAgfSl9XG4gICAgICA8L2Rpdj5cbiAgICApO1xuICB9XG5cbiAgQGF1dG9iaW5kXG4gIHJlbmRlck1hcmtlcihtYXJrZXIsIGkpIHtcbiAgICBpZiAobWFya2VyLmdldFN0YXJ0KCkgPT09IG51bGwgfHwgbWFya2VyLmdldEVuZCgpID09PSBudWxsKSB7IHJldHVybiA8ZGl2IGtleT17aX0gLz47IH1cblxuICAgIGNvbnN0IHN0YXJ0T2Zmc2V0ID0gbWFya2VyLmdldFN0YXJ0KCkgLSB0aGlzLnN0YXRlLnN0YXJ0VGltZTtcbiAgICBjb25zdCBkdXJhdGlvbiA9IG1hcmtlci5nZXRFbmQoKSAtIG1hcmtlci5nZXRTdGFydCgpO1xuICAgIGNvbnN0IG1hcmtlclN0eWxlID0ge1xuICAgICAgbGVmdDogc3RhcnRPZmZzZXQgKiB0aGlzLnByb3BzLnpvb21GYWN0b3IsXG4gICAgICB3aWR0aDogZHVyYXRpb24gKiB0aGlzLnByb3BzLnpvb21GYWN0b3IsXG4gICAgfTtcblxuICAgIHJldHVybiAoXG4gICAgICA8ZGl2IGNsYXNzTmFtZT1cIndhdGVyZmFsbC1yb3dcIiBrZXk9e2l9PlxuICAgICAgICA8c3BhblxuICAgICAgICAgIGNsYXNzTmFtZT1cIndhdGVyZmFsbC1yb3ctbGFiZWxcIlxuICAgICAgICAgIHN0eWxlPXt7cGFkZGluZ0xlZnQ6IG1hcmtlclN0eWxlLmxlZnQgKyBtYXJrZXJTdHlsZS53aWR0aH19PnttYXJrZXIubGFiZWx9PC9zcGFuPlxuICAgICAgICA8TWFya2VyU3BhbiBjbGFzc05hbWU9XCJ3YXRlcmZhbGwtbWFya2VyXCIgc3R5bGU9e21hcmtlclN0eWxlfSBtYXJrZXI9e21hcmtlcn0gLz5cbiAgICAgIDwvZGl2PlxuICAgICk7XG4gIH1cbn1cblxuXG5jbGFzcyBXYXRlcmZhbGxXaWRnZXQgZXh0ZW5kcyBSZWFjdC5Db21wb25lbnQge1xuICBzdGF0aWMgcHJvcFR5cGVzID0ge1xuICAgIG1hcmtlcnM6IFByb3BUeXBlcy5hcnJheU9mKFByb3BUeXBlcy5pbnN0YW5jZU9mKE1hcmtlcikpLmlzUmVxdWlyZWQsXG4gIH1cblxuICBjb25zdHJ1Y3Rvcihwcm9wcywgY29udGV4dCkge1xuICAgIHN1cGVyKHByb3BzLCBjb250ZXh0KTtcbiAgICB0aGlzLnN0YXRlID0ge1xuICAgICAgem9vbUZhY3RvcjogMC4zLFxuICAgICAgY29sbGFwc2VkOiBmYWxzZSxcbiAgICB9O1xuICB9XG5cblxuICByZW5kZXIoKSB7XG4gICAgY29uc3Qge21hcmtlcnN9ID0gdGhpcy5wcm9wcztcbiAgICBjb25zdCBmaXJzdE1hcmtlciA9IG1hcmtlcnNbMF07XG4gICAgY29uc3QgbGFzdE1hcmtlciA9IG1hcmtlcnNbbWFya2Vycy5sZW5ndGggLSAxXTtcblxuICAgIGNvbnN0IHN0YXJ0VGltZSA9IGZpcnN0TWFya2VyLmdldFN0YXJ0KCk7XG4gICAgY29uc3QgZW5kVGltZSA9IGxhc3RNYXJrZXIuZ2V0RW5kKCk7XG4gICAgY29uc3QgZHVyYXRpb24gPSBlbmRUaW1lIC0gc3RhcnRUaW1lO1xuXG4gICAgcmV0dXJuIChcbiAgICAgIDxkaXYgY2xhc3NOYW1lPVwid2F0ZXJmYWxsLXdpZGdldCBpbnNldC1wYW5uZWxcIj5cbiAgICAgICAgPGRpdiBjbGFzc05hbWU9XCJ3YXRlcmZhbGwtaGVhZGVyXCI+XG4gICAgICAgICAgPGRpdiBjbGFzc05hbWU9XCJ3YXRlcmZhbGwtaGVhZGVyLXRleHRcIj5cbiAgICAgICAgICAgIDxzcGFuIG9uQ2xpY2s9e3RoaXMuaGFuZGxlQ29sbGFwc2VDbGlja30gY2xhc3NOYW1lPVwiY29sbGFwc2UtdG9nZ2xlXCI+XG4gICAgICAgICAgICAgIHt0aGlzLnN0YXRlLmNvbGxhcHNlZCA/ICdcXHUyNWI2JyA6ICdcXHUyNWJjJ31cbiAgICAgICAgICAgIDwvc3Bhbj5cbiAgICAgICAgICAgIHt0aGlzLnByb3BzLm1hcmtlcnMubGVuZ3RofSBldmVudChzKSBvdmVyIHtNYXRoLmZsb29yKGR1cmF0aW9uKX1tc1xuICAgICAgICAgIDwvZGl2PlxuICAgICAgICAgIDxkaXYgY2xhc3NOYW1lPVwid2F0ZXJmYWxsLWhlYWRlci1jb250cm9sc1wiPlxuICAgICAgICAgICAgPGJ1dHRvblxuICAgICAgICAgICAgICBjbGFzc05hbWU9XCJ3YXRlcmZhbGwtZXhwb3J0LWJ1dHRvbiBidG4gYnRuLXNtXCJcbiAgICAgICAgICAgICAgb25DbGljaz17dGhpcy5oYW5kbGVFeHBvcnRDbGlja30+RXhwb3J0PC9idXR0b24+XG4gICAgICAgICAgICA8T2N0aWNvbiBpY29uPVwic2VhcmNoXCIgLz5cbiAgICAgICAgICAgIDxpbnB1dFxuICAgICAgICAgICAgICB0eXBlPVwicmFuZ2VcIlxuICAgICAgICAgICAgICBjbGFzc05hbWU9XCJpbnB1dC1yYW5nZVwiXG4gICAgICAgICAgICAgIG1pbj17MC4xfVxuICAgICAgICAgICAgICBtYXg9ezF9XG4gICAgICAgICAgICAgIHN0ZXA9ezAuMDF9XG4gICAgICAgICAgICAgIHZhbHVlPXt0aGlzLnN0YXRlLnpvb21GYWN0b3J9XG4gICAgICAgICAgICAgIG9uQ2hhbmdlPXt0aGlzLmhhbmRsZVpvb21GYWN0b3JDaGFuZ2V9XG4gICAgICAgICAgICAvPlxuICAgICAgICAgIDwvZGl2PlxuICAgICAgICA8L2Rpdj5cbiAgICAgICAge3RoaXMuc3RhdGUuY29sbGFwc2VkID8gbnVsbCA6IDxXYXRlcmZhbGwgbWFya2Vycz17dGhpcy5wcm9wcy5tYXJrZXJzfSB6b29tRmFjdG9yPXt0aGlzLnN0YXRlLnpvb21GYWN0b3J9IC8+fVxuICAgICAgPC9kaXY+XG4gICAgKTtcbiAgfVxuXG4gIEBhdXRvYmluZFxuICBoYW5kbGVab29tRmFjdG9yQ2hhbmdlKGUpIHtcbiAgICB0aGlzLnNldFN0YXRlKHt6b29tRmFjdG9yOiBwYXJzZUZsb2F0KGUudGFyZ2V0LnZhbHVlKX0pO1xuICB9XG5cbiAgQGF1dG9iaW5kXG4gIGhhbmRsZUNvbGxhcHNlQ2xpY2soZSkge1xuICAgIHRoaXMuc2V0U3RhdGUocyA9PiAoe2NvbGxhcHNlZDogIXMuY29sbGFwc2VkfSkpO1xuICB9XG5cbiAgQGF1dG9iaW5kXG4gIGhhbmRsZUV4cG9ydENsaWNrKGUpIHtcbiAgICBlLnByZXZlbnREZWZhdWx0KCk7XG4gICAgY29uc3QganNvbiA9IEpTT04uc3RyaW5naWZ5KHRoaXMucHJvcHMubWFya2Vycy5tYXAobSA9PiBtLnNlcmlhbGl6ZSgpKSwgbnVsbCwgJyAgJyk7XG4gICAgY29uc3QgYnVmZmVyID0gbmV3IFRleHRCdWZmZXIoe3RleHQ6IGpzb259KTtcbiAgICBkaWFsb2cuc2hvd1NhdmVEaWFsb2coe1xuICAgICAgZGVmYXVsdFBhdGg6ICdnaXQtdGltaW5ncy5qc29uJyxcbiAgICB9LCBmaWxlbmFtZSA9PiB7XG4gICAgICBpZiAoIWZpbGVuYW1lKSB7IHJldHVybjsgfVxuICAgICAgYnVmZmVyLnNhdmVBcyhmaWxlbmFtZSk7XG4gICAgfSk7XG4gIH1cbn1cblxuXG5sZXQgbWFya2VycyA9IG51bGw7XG5sZXQgZ3JvdXBJZCA9IDA7XG5jb25zdCBncm91cHMgPSBbXTtcbmxldCBsYXN0TWFya2VyVGltZSA9IG51bGw7XG5sZXQgdXBkYXRlVGltZXIgPSBudWxsO1xuXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBHaXRUaW1pbmdzVmlldyBleHRlbmRzIFJlYWN0LkNvbXBvbmVudCB7XG4gIHN0YXRpYyBwcm9wVHlwZXMgPSB7XG4gICAgY29udGFpbmVyOiBQcm9wVHlwZXMuYW55LmlzUmVxdWlyZWQsXG4gIH1cblxuICBzdGF0aWMgZW1pdHRlciA9IG5ldyBFbWl0dGVyKCk7XG5cbiAgc3RhdGljIGNyZWF0ZVBhbmVJdGVtKCkge1xuICAgIGxldCBlbGVtZW50O1xuICAgIHJldHVybiB7XG4gICAgICBzZXJpYWxpemUoKSB7IHJldHVybiB7ZGVzZXJpYWxpemVyOiAnR2l0VGltaW5nc1ZpZXcnfTsgfSxcbiAgICAgIGdldFVSSSgpIHsgcmV0dXJuICdhdG9tLWdpdGh1YjovL2RlYnVnL21hcmtlcnMnOyB9LFxuICAgICAgZ2V0VGl0bGUoKSB7IHJldHVybiAnR2l0SHViIFBhY2thZ2UgVGltaW5ncyBWaWV3JzsgfSxcbiAgICAgIGdldCBlbGVtZW50KCkge1xuICAgICAgICBpZiAoIWVsZW1lbnQpIHtcbiAgICAgICAgICBlbGVtZW50ID0gZG9jdW1lbnQuY3JlYXRlRWxlbWVudCgnZGl2Jyk7XG4gICAgICAgICAgUmVhY3REb20ucmVuZGVyKDxHaXRUaW1pbmdzVmlldyBjb250YWluZXI9e2VsZW1lbnR9IC8+LCBlbGVtZW50KTtcbiAgICAgICAgfVxuICAgICAgICByZXR1cm4gZWxlbWVudDtcbiAgICAgIH0sXG4gICAgfTtcbiAgfVxuXG4gIHN0YXRpYyBkZXNlcmlhbGl6ZSgpIHtcbiAgICByZXR1cm4gdGhpcy5jcmVhdGVQYW5lSXRlbSgpO1xuICB9XG5cbiAgc3RhdGljIGdlbmVyYXRlTWFya2VyKGxhYmVsKSB7XG4gICAgY29uc3QgbWFya2VyID0gbmV3IE1hcmtlcihsYWJlbCwgKCkgPT4ge1xuICAgICAgR2l0VGltaW5nc1ZpZXcuc2NoZWR1bGVVcGRhdGUoKTtcbiAgICB9KTtcbiAgICBjb25zdCBub3cgPSBwZXJmb3JtYW5jZS5ub3coKTtcbiAgICBpZiAoIW1hcmtlcnMgfHwgKGxhc3RNYXJrZXJUaW1lICYmIE1hdGguYWJzKG5vdyAtIGxhc3RNYXJrZXJUaW1lKSA+PSA1MDAwKSkge1xuICAgICAgZ3JvdXBJZCsrO1xuICAgICAgbWFya2VycyA9IFtdO1xuICAgICAgZ3JvdXBzLnVuc2hpZnQoe2lkOiBncm91cElkLCBtYXJrZXJzfSk7XG4gICAgICBpZiAoZ3JvdXBzLmxlbmd0aCA+IDEwMCkge1xuICAgICAgICBncm91cHMucG9wKCk7XG4gICAgICB9XG4gICAgfVxuICAgIGxhc3RNYXJrZXJUaW1lID0gbm93O1xuICAgIG1hcmtlcnMucHVzaChtYXJrZXIpO1xuICAgIEdpdFRpbWluZ3NWaWV3LnNjaGVkdWxlVXBkYXRlKCk7XG4gICAgcmV0dXJuIG1hcmtlcjtcbiAgfVxuXG4gIHN0YXRpYyByZXN0b3JlR3JvdXAoZ3JvdXApIHtcbiAgICBncm91cElkKys7XG4gICAgZ3JvdXBzLnVuc2hpZnQoe2lkOiBncm91cElkLCBtYXJrZXJzOiBncm91cH0pO1xuICAgIEdpdFRpbWluZ3NWaWV3LnNjaGVkdWxlVXBkYXRlKHRydWUpO1xuICB9XG5cbiAgc3RhdGljIHNjaGVkdWxlVXBkYXRlKGltbWVkaWF0ZSA9IGZhbHNlKSB7XG4gICAgaWYgKHVwZGF0ZVRpbWVyKSB7XG4gICAgICBjbGVhclRpbWVvdXQodXBkYXRlVGltZXIpO1xuICAgIH1cblxuICAgIHVwZGF0ZVRpbWVyID0gc2V0VGltZW91dCgoKSA9PiB7XG4gICAgICBHaXRUaW1pbmdzVmlldy5lbWl0dGVyLmVtaXQoJ2RpZC11cGRhdGUnKTtcbiAgICB9LCBpbW1lZGlhdGUgPyAwIDogMTAwMCk7XG4gIH1cblxuICBzdGF0aWMgb25EaWRVcGRhdGUoY2FsbGJhY2spIHtcbiAgICByZXR1cm4gR2l0VGltaW5nc1ZpZXcuZW1pdHRlci5vbignZGlkLXVwZGF0ZScsIGNhbGxiYWNrKTtcbiAgfVxuXG4gIGNvbXBvbmVudERpZE1vdW50KCkge1xuICAgIHRoaXMuc3Vic2NyaXB0aW9ucyA9IG5ldyBDb21wb3NpdGVEaXNwb3NhYmxlKFxuICAgICAgR2l0VGltaW5nc1ZpZXcub25EaWRVcGRhdGUoKCkgPT4gdGhpcy5mb3JjZVVwZGF0ZSgpKSxcbiAgICAgIGF0b20ud29ya3NwYWNlLm9uRGlkRGVzdHJveVBhbmVJdGVtKCh7aXRlbX0pID0+IHtcbiAgICAgICAgaWYgKGl0ZW0uZWxlbWVudCA9PT0gdGhpcy5wcm9wcy5jb250YWluZXIpIHtcbiAgICAgICAgICAvLyB3ZSBqdXN0IGdvdCBjbG9zZWRcbiAgICAgICAgICBSZWFjdERvbS51bm1vdW50Q29tcG9uZW50QXROb2RlKHRoaXMucHJvcHMuY29udGFpbmVyKTtcbiAgICAgICAgfVxuICAgICAgfSksXG4gICAgKTtcbiAgfVxuXG4gIGNvbXBvbmVudFdpbGxVbm1vdW50KCkge1xuICAgIHRoaXMuc3Vic2NyaXB0aW9ucy5kaXNwb3NlKCk7XG4gIH1cblxuICByZW5kZXIoKSB7XG4gICAgcmV0dXJuIChcbiAgICAgIDxkaXYgY2xhc3NOYW1lPVwiZ2l0aHViLUdpdFRpbWluZ3NWaWV3XCI+XG4gICAgICAgIDxkaXYgY2xhc3NOYW1lPVwiZ2l0aHViLUdpdFRpbWluZ3NWaWV3LWhlYWRlclwiPlxuICAgICAgICAgIDxidXR0b24gY2xhc3NOYW1lPVwiaW1wb3J0LWJ1dHRvbiBidG5cIiBvbkNsaWNrPXt0aGlzLmhhbmRsZUltcG9ydENsaWNrfT5JbXBvcnQ8L2J1dHRvbj5cbiAgICAgICAgPC9kaXY+XG4gICAgICAgIHtncm91cHMubWFwKChncm91cCwgaWR4KSA9PiAoXG4gICAgICAgICAgPFdhdGVyZmFsbFdpZGdldCBrZXk9e2dyb3VwLmlkfSBtYXJrZXJzPXtncm91cC5tYXJrZXJzfSAvPlxuICAgICAgICApKX1cbiAgICAgIDwvZGl2PlxuICAgICk7XG4gIH1cblxuICBAYXV0b2JpbmRcbiAgaGFuZGxlSW1wb3J0Q2xpY2soZSkge1xuICAgIGUucHJldmVudERlZmF1bHQoKTtcbiAgICBkaWFsb2cuc2hvd09wZW5EaWFsb2coe1xuICAgICAgcHJvcGVydGllczogWydvcGVuRmlsZSddLFxuICAgIH0sIGFzeW5jIGZpbGVuYW1lcyA9PiB7XG4gICAgICBpZiAoIWZpbGVuYW1lcykgeyByZXR1cm47IH1cbiAgICAgIGNvbnN0IGZpbGVuYW1lID0gZmlsZW5hbWVzWzBdO1xuICAgICAgdHJ5IHtcbiAgICAgICAgY29uc3QgY29udGVudHMgPSBhd2FpdCByZWFkRmlsZShmaWxlbmFtZSk7XG4gICAgICAgIGNvbnN0IGRhdGEgPSBKU09OLnBhcnNlKGNvbnRlbnRzKTtcbiAgICAgICAgY29uc3QgcmVzdG9yZWRNYXJrZXJzID0gZGF0YS5tYXAoaXRlbSA9PiBNYXJrZXIuZGVzZXJpYWxpemUoaXRlbSkpO1xuICAgICAgICBHaXRUaW1pbmdzVmlldy5yZXN0b3JlR3JvdXAocmVzdG9yZWRNYXJrZXJzKTtcbiAgICAgIH0gY2F0Y2ggKF9lcnIpIHtcbiAgICAgICAgYXRvbS5ub3RpZmljYXRpb25zLmFkZEVycm9yKGBDb3VsZCBub3QgaW1wb3J0IHRpbWluZ3MgZnJvbSAke2ZpbGVuYW1lfWApO1xuICAgICAgfVxuICAgIH0pO1xuICB9XG59XG4iXX0=