'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _eventKit = require('event-kit');

var _portal = require('./portal');

var _portal2 = _interopRequireDefault(_portal);

var _stubItem = require('../atom-items/stub-item');

var _stubItem2 = _interopRequireDefault(_stubItem);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

/**
 * `DockItem` adds its child to an Atom dock when rendered.
 * When the item is closed, the component's `onDidCloseItem` is called.
 * You should use this callback to set state so that the `DockItem` is no
 * longer rendered; you will get an error in your console if you forget.
 *
 * You may pass a `getItem` function that takes an object with `portal` and
 * `subtree` properties. `getItem` should return an item to be added to the
 * Dock. `portal` is an instance of th Portal component, and `subtree` is the
 * rendered subtree component built from the `children` prop. The default
 * implementation simply returns the Portal instance, which contains a
 * `getElement` method (to be compatible with Atom's view system).
 *
 * Unmounting the component when the item is open will close the item.
 */
let DockItem = (_temp = _class = class DockItem extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);

    this.dockItemPromise = new Promise(resolve => {
      this.resolveDockItemPromise = resolve;
    });
  }

  componentDidMount() {
    this.setupDockItem();
  }

  componentWillReceiveProps() {
    if (this.didCloseItem) {
      // eslint-disable-next-line no-console
      console.error('Unexpected update in `DockItem`: the contained item has been closed');
    }
  }

  render() {
    let getDOMNode;
    if (this.props.stubItemSelector) {
      getDOMNode = () => _stubItem2.default.getElementBySelector(this.props.stubItemSelector);
    }

    return _react2.default.createElement(
      _portal2.default,
      { ref: c => {
          this.portal = c;
        }, getDOMNode: getDOMNode },
      this.props.children
    );
  }

  setupDockItem() {
    if (this.dockItem) {
      return;
    }

    const itemToAdd = this.props.getItem({ portal: this.portal, subtree: this.portal.getRenderedSubtree() });

    this.subscriptions = new _eventKit.CompositeDisposable();
    if (itemToAdd.wasActivated) {
      this.subscriptions.add(this.props.workspace.onDidChangeActivePaneItem(activeItem => {
        if (activeItem === this.dockItem) {
          itemToAdd.wasActivated();
        }
      }));
    }

    let stub;
    if (this.props.stubItemSelector) {
      stub = _stubItem2.default.getBySelector(this.props.stubItemSelector);
    }

    if (stub) {
      stub.setRealItem(itemToAdd);
      this.dockItem = stub;
      this.resolveDockItemPromise(this.dockItem);
      if (this.props.activate) {
        this.activate();
      }
    } else {
      Promise.resolve(this.props.workspace.open(itemToAdd, { activatePane: false })).then(item => {
        this.dockItem = item;
        this.resolveDockItemPromise(this.dockItem);
        if (this.props.activate) {
          this.activate();
        }
      });
    }

    this.subscriptions.add(this.props.workspace.onDidDestroyPaneItem((_ref) => {
      let item = _ref.item;

      if (item === this.dockItem) {
        this.didCloseItem = true;
        this.props.onDidCloseItem(this.dockItem);
      }
    }));
  }

  componentWillUnmount() {
    this.subscriptions && this.subscriptions.dispose();
    if (this.dockItem && !this.didCloseItem) {
      const pane = this.props.workspace.paneForItem(this.dockItem);
      if (this.dockItem.destroy) {
        this.dockItem.destroy();
      }
      pane.destroyItem(this.dockItem);
    }
  }

  getDockItem() {
    return this.dockItem;
  }

  getDockItemPromise() {
    return this.dockItemPromise;
  }

  reveal() {
    var _this = this;

    return _asyncToGenerator(function* () {
      const dockItem = yield _this.getDockItemPromise();
      return _this.props.workspace.open(dockItem, {
        searchAllPanes: true
      });
    })();
  }

  hide() {
    var _this2 = this;

    return _asyncToGenerator(function* () {
      const dockItem = yield _this2.getDockItemPromise();
      return _this2.props.workspace.hide(dockItem);
    })();
  }

  activate() {
    setTimeout(() => {
      if (!this.dockItem || this.didCloseItem || this.props.workspace.isDestroyed()) {
        return;
      }

      const pane = this.props.workspace.paneForItem(this.dockItem);
      if (pane) {
        pane.activateItem(this.dockItem);
        const dock = this.props.workspace.getPaneContainers().find(container => container.getPanes().find(p => p.getItems().includes(this.dockItem)));
        if (dock && dock.show) {
          dock.show();
        }
      } else {
        throw new Error('Cannot find pane for item in `DockItem#activate`');
      }
    });
  }
}, _class.propTypes = {
  workspace: _propTypes2.default.object.isRequired,
  children: _propTypes2.default.element.isRequired,
  getItem: _propTypes2.default.func,
  onDidCloseItem: _propTypes2.default.func,
  stubItemSelector: _propTypes2.default.string,
  activate: _propTypes2.default.bool
}, _class.defaultProps = {
  getItem: (_ref2) => {
    let portal = _ref2.portal,
        subtree = _ref2.subtree;
    return portal.getView();
  },
  onDidCloseItem: dockItem => {}
}, _temp);
exports.default = DockItem;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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