'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _eventKit = require('event-kit');

var _portal = require('./portal');

var _portal2 = _interopRequireDefault(_portal);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

let Decoration = (_temp = _class = class Decoration extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);

    this.decoration = null;
    this.subscriptions = new _eventKit.CompositeDisposable();
  }

  usesItem() {
    return this.props.type === 'gutter' || this.props.type === 'overlay' || this.props.type === 'block';
  }

  componentWillReceiveProps(nextProps) {
    let recreationRequired = this.props.editor !== nextProps.editor || this.props.marker !== nextProps.marker || this.props.type !== nextProps.type || this.props.position !== nextProps.position || this.props.className !== nextProps.className || this.props.getItem !== nextProps.getItem || this.props.children !== nextProps.children;

    if (!recreationRequired) {
      // Compare additional options.
      const optionKeys = Object.keys(this.props.options);
      const nextOptionKeys = Object.keys(nextProps.options);

      if (optionKeys.length !== nextOptionKeys.length) {
        recreationRequired = true;
      } else {
        for (let i = 0; i < optionKeys.length; i++) {
          const key = optionKeys[i];
          if (this.props.options[key] !== nextProps.options[key]) {
            recreationRequired = true;
            break;
          }
        }
      }
    }

    if (recreationRequired) {
      this.decoration && this.decoration.destroy();
      this.setupDecoration(nextProps);
    }
  }

  componentDidMount() {
    this.setupDecoration(this.props);
  }

  render() {
    if (this.usesItem()) {
      return _react2.default.createElement(
        _portal2.default,
        { ref: c => {
            this.portal = c;
          } },
        this.props.children
      );
    } else {
      return null;
    }
  }

  setupDecoration(props) {
    if (this.decoration) {
      return;
    }

    let item = null;
    if (this.usesItem()) {
      item = props.getItem({ portal: this.portal, subtree: this.portal.getRenderedSubtree() });
    }

    const options = _extends({}, props.options, {
      type: props.type,
      position: props.position,
      class: props.className,
      item
    });

    this.decoration = props.editor.decorateMarker(props.marker, options);
    this.subscriptions.add(this.decoration.onDidDestroy(() => {
      this.decoration = null;
      this.subscriptions.dispose();
    }));
  }

  componentWillUnmount() {
    this.decoration && this.decoration.destroy();
    this.subscriptions.dispose();
  }
}, _class.propTypes = {
  editor: _propTypes2.default.object.isRequired,
  marker: _propTypes2.default.object.isRequired,
  type: _propTypes2.default.oneOf(['line', 'line-number', 'highlight', 'overlay', 'gutter', 'block']).isRequired,
  position: _propTypes2.default.oneOf(['head', 'tail', 'before', 'after']),
  className: _propTypes2.default.string,
  children: _propTypes2.default.element,
  getItem: _propTypes2.default.func,
  options: _propTypes2.default.object
}, _class.defaultProps = {
  options: {},
  position: 'head',
  getItem: (_ref) => {
    let portal = _ref.portal,
        subtree = _ref.subtree;
    return portal;
  }
}, _temp);
exports.default = Decoration;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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