'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _desc, _value, _class, _class2, _temp; /** @jsx etch.dom */
/* eslint react/no-unknown-property: "off" */

var _atom = require('atom');

var _eventKit = require('event-kit');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _coreDecorators = require('core-decorators');

var _helpers = require('../helpers');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

let CommitView = (_class = (_temp = _class2 = class CommitView {

  constructor(props) {
    this.props = props;

    _etch2.default.initialize(this);

    this.editor = this.refs.editor;
    // FIXME Use props-injected view registry instead of the Atom global
    this.editorElement = atom.views.getView(this.editor);
    this.editor.setText(this.props.message || '');
    this.subscriptions = new _eventKit.CompositeDisposable(this.editor.onDidChange(() => this.props.onChangeMessage && this.props.onChangeMessage(this.editor.getText())), this.editor.onDidChangeCursorPosition(() => {
      _etch2.default.update(this);
    }), props.commandRegistry.add('atom-workspace', { 'github:commit': this.commit }));
  }

  destroy() {
    this.subscriptions.dispose();
    _etch2.default.destroy(this);
  }

  update(props) {
    const previousMessage = this.props.message;
    this.props = _extends({}, this.props, props);
    const newMessage = this.props.message;
    if (this.editor && previousMessage !== newMessage && this.editor.getText() !== newMessage) {
      this.editor.setText(newMessage);
    }
    return _etch2.default.update(this);
  }

  render() {
    let remainingCharsClassName = '';
    if (this.getRemainingCharacters() < 0) {
      remainingCharsClassName = 'is-error';
    } else if (this.getRemainingCharacters() < this.props.maximumCharacterLimit / 4) {
      remainingCharsClassName = 'is-warning';
    }

    const showAbortMergeButton = this.props.isMerging || null;
    const showAmendBox = !this.props.isMerging && this.props.lastCommit.isPresent() && !this.props.lastCommit.isUnbornRef() || null;

    return _etch2.default.dom(
      'div',
      { className: 'github-CommitView', ref: 'CommitView' },
      _etch2.default.dom(
        'div',
        { className: 'github-CommitView-editor' },
        _etch2.default.dom(_atom.TextEditor, {
          ref: 'editor',
          softWrapped: true,
          placeholderText: 'Commit message',
          lineNumberGutterVisible: false,
          showInvisibles: false,
          autoHeight: false,
          scrollPastEnd: false
        })
      ),
      _etch2.default.dom(
        'footer',
        { className: 'github-CommitView-bar' },
        showAbortMergeButton && _etch2.default.dom(
          'button',
          { ref: 'abortMergeButton', className: 'btn github-CommitView-button is-secondary',
            onclick: this.abortMerge },
          'Abort Merge'
        ),
        showAmendBox && _etch2.default.dom(
          'label',
          { className: 'github-CommitView-label input-label' },
          _etch2.default.dom('input', {
            ref: 'amend',
            className: 'input-checkbox',
            type: 'checkbox',
            onclick: this.handleAmendBoxClick,
            checked: this.props.isAmending
          }),
          ' Amend'
        ),
        _etch2.default.dom(
          'button',
          { ref: 'commitButton', className: 'btn github-CommitView-button',
            onclick: this.commit,
            disabled: !this.isCommitButtonEnabled() },
          this.commitButtonText()
        ),
        _etch2.default.dom(
          'div',
          { ref: 'remainingCharacters',
            className: `github-CommitView-remaining-characters ${remainingCharsClassName}` },
          this.getRemainingCharacters()
        )
      )
    );
  }

  abortMerge() {
    this.props.abortMerge();
  }

  handleAmendBoxClick() {
    this.props.setAmending(this.refs.amend.checked);
  }

  commit() {
    var _this = this;

    return _asyncToGenerator(function* () {
      if ((yield _this.props.prepareToCommit()) && _this.isCommitButtonEnabled()) {
        yield _this.props.commit(_this.editor.getText());
      } else {
        _this.setFocus(CommitView.focus.EDITOR);
      }
    })();
  }

  getRemainingCharacters() {
    if (this.editor != null) {
      if (this.editor.getCursorBufferPosition().row === 0) {
        return (this.props.maximumCharacterLimit - this.editor.lineTextForBufferRow(0).length).toString();
      } else {
        return '∞';
      }
    } else {
      return this.props.maximumCharacterLimit || '';
    }
  }

  isCommitButtonEnabled() {
    return this.props.stagedChangesExist && !this.props.mergeConflictsExist && this.props.lastCommit.isPresent() && this.editor && this.editor.getText().length !== 0;
  }

  commitButtonText() {
    if (this.props.isAmending) {
      return `Amend commit (${(0, _helpers.shortenSha)(this.props.lastCommit.getSha())})`;
    } else {
      if (this.props.branchName) {
        return `Commit to ${this.props.branchName}`;
      } else {
        return 'Commit';
      }
    }
  }

  rememberFocus(event) {
    if (this.editorElement.contains(event.target)) {
      return CommitView.focus.EDITOR;
    }

    if (this.refs.abortMergeButton && this.refs.abortMergeButton.contains(event.target)) {
      return CommitView.focus.ABORT_MERGE_BUTTON;
    }

    if (this.refs.amend && this.refs.amend.contains(event.target)) {
      return CommitView.focus.AMEND_BOX;
    }

    if (this.refs.commitButton && this.refs.commitButton.contains(event.target)) {
      return CommitView.focus.COMMIT_BUTTON;
    }

    return null;
  }

  setFocus(focus) {
    let fallback = false;

    if (focus === CommitView.focus.EDITOR) {
      this.editorElement.focus();
      return true;
    }

    if (focus === CommitView.focus.ABORT_MERGE_BUTTON) {
      if (this.refs.abortMergeButton) {
        this.refs.abortMergeButton.focus();
        return true;
      } else {
        fallback = true;
      }
    }

    if (focus === CommitView.focus.AMEND_BOX) {
      if (this.refs.amend) {
        this.refs.amend.focus();
        return true;
      } else {
        fallback = true;
      }
    }

    if (focus === CommitView.focus.COMMIT_BUTTON) {
      if (this.refs.commitButton) {
        this.refs.commitButton.focus();
        return true;
      } else {
        fallback = true;
      }
    }

    if (fallback) {
      this.editorElement.focus();
      return true;
    }

    return false;
  }
}, _class2.focus = {
  EDITOR: Symbol('commit-editor'),
  ABORT_MERGE_BUTTON: Symbol('commit-abort-merge-button'),
  AMEND_BOX: Symbol('commit-amend-box'),
  COMMIT_BUTTON: Symbol('commit-button')
}, _temp), (_applyDecoratedDescriptor(_class.prototype, 'abortMerge', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'abortMerge'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'handleAmendBoxClick', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'handleAmendBoxClick'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'commit', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'commit'), _class.prototype)), _class);
exports.default = CommitView;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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