'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _desc, _value, _class, _class2, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _coreDecorators = require('core-decorators');

var _eventKit = require('event-kit');

var _url = require('url');

var _url2 = _interopRequireDefault(_url);

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _commands = require('./commands');

var _commands2 = _interopRequireDefault(_commands);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

let CloneDialog = (_class = (_temp = _class2 = class CloneDialog extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);

    this.state = {
      cloneDisabled: false
    };

    this.projectHome = this.props.config.get('core.projectHome');
    this.subs = new _eventKit.CompositeDisposable();
  }

  componentDidMount() {
    if (this.projectPathEditor) {
      this.projectPathEditor.setText(this.props.config.get('core.projectHome'));
      this.projectPathModified = false;
    }

    if (this.remoteUrlElement) {
      setTimeout(() => this.remoteUrlElement.focus());
    }
  }

  render() {
    if (!this.props.inProgress) {
      return this.renderDialog();
    } else {
      return this.renderSpinner();
    }
  }

  renderDialog() {
    return _react2.default.createElement(
      'div',
      { className: 'github-Dialog github-Clone modal' },
      _react2.default.createElement(
        _commands2.default,
        { registry: this.props.commandRegistry, target: '.github-Clone' },
        _react2.default.createElement(_commands.Command, { command: 'core:cancel', callback: this.cancel }),
        _react2.default.createElement(_commands.Command, { command: 'core:confirm', callback: this.clone })
      ),
      _react2.default.createElement(
        'main',
        { className: 'github-DialogInputs' },
        _react2.default.createElement(
          'label',
          { className: 'github-DialogLabel github-CloneUrl' },
          'Clone from',
          _react2.default.createElement('atom-text-editor', { mini: true, ref: this.editorRefs('remoteUrl'), tabIndex: '1' })
        ),
        _react2.default.createElement(
          'label',
          { className: 'github-DialogLabel github-ProjectPath' },
          'To directory',
          _react2.default.createElement('atom-text-editor', { mini: true, ref: this.editorRefs('projectPath'), tabIndex: '2' })
        )
      ),
      _react2.default.createElement(
        'div',
        { className: 'github-DialogButtons' },
        _react2.default.createElement(
          'button',
          { className: 'btn github-CancelButton', onClick: this.cancel, tabIndex: '3' },
          'Cancel'
        ),
        _react2.default.createElement(
          'button',
          {
            className: 'btn btn-primary icon icon-repo-clone',
            onClick: this.clone,
            disabled: this.state.cloneDisabled,
            tabIndex: '4' },
          'Clone'
        )
      )
    );
  }

  renderSpinner() {
    return _react2.default.createElement(
      'div',
      { className: 'github-Dialog github-Clone modal' },
      _react2.default.createElement(
        'main',
        { className: 'github-DialogSpinner' },
        _react2.default.createElement('span', { className: 'loading loading-spinner-small inline-block' }),
        _react2.default.createElement(
          'span',
          { className: 'github-DialogMessage inline-block' },
          'Cloning ',
          _react2.default.createElement(
            'strong',
            null,
            this.getRemoteUrl()
          )
        )
      )
    );
  }

  clone() {
    if (this.getRemoteUrl().length === 0 || this.getProjectPath().length === 0) {
      return;
    }

    this.props.didAccept(this.getRemoteUrl(), this.getProjectPath());
  }

  cancel() {
    this.props.didCancel();
  }

  didChangeRemoteUrl() {
    if (!this.projectPathModified) {
      const name = _path2.default.basename(_url2.default.parse(this.getRemoteUrl()).pathname, '.git') || '';

      if (name.length > 0) {
        const proposedPath = _path2.default.join(this.projectHome, name);
        this.projectPathEditor.setText(proposedPath);
        this.projectPathModified = false;
      }
    }

    this.setCloneEnablement();
  }

  didChangeProjectPath() {
    this.projectPathModified = true;
    this.setCloneEnablement();
  }

  editorRefs(baseName) {
    const elementName = `${baseName}Element`;
    const modelName = `${baseName}Editor`;
    const subName = `${baseName}Subs`;
    const changeMethodName = `didChange${baseName[0].toUpperCase()}${baseName.substring(1)}`;

    return element => {
      if (!element) {
        return;
      }

      this[elementName] = element;
      const editor = element.getModel();
      if (this[modelName] !== editor) {
        this[modelName] = editor;

        if (this[subName]) {
          this[subName].dispose();
          this.subs.remove(this[subName]);
        }

        this[subName] = editor.onDidChange(this[changeMethodName]);
        this.subs.add(this[subName]);
      }
    };
  }

  getProjectPath() {
    return this.projectPathEditor ? this.projectPathEditor.getText() : '';
  }

  getRemoteUrl() {
    return this.remoteUrlEditor ? this.remoteUrlEditor.getText() : '';
  }

  setCloneEnablement() {
    const disabled = this.getRemoteUrl().length === 0 || this.getProjectPath().length === 0;
    this.setState({ cloneDisabled: disabled });
  }
}, _class2.propTypes = {
  config: _propTypes2.default.object.isRequired,
  commandRegistry: _propTypes2.default.object.isRequired,
  inProgress: _propTypes2.default.bool,
  didAccept: _propTypes2.default.func,
  didCancel: _propTypes2.default.func
}, _class2.defaultProps = {
  inProgress: false,
  didAccept: () => {},
  didCancel: () => {}
}, _temp), (_applyDecoratedDescriptor(_class.prototype, 'clone', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'clone'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'cancel', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'cancel'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'didChangeRemoteUrl', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'didChangeRemoteUrl'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'didChangeProjectPath', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'didChangeProjectPath'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'editorRefs', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'editorRefs'), _class.prototype)), _class);
exports.default = CloneDialog;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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