'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CommitPropType = exports.BranchPropType = exports.RemotePropType = exports.DOMNodePropType = undefined;

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const DOMNodePropType = exports.DOMNodePropType = (props, propName, componentName) => {
  if (props[propName] instanceof HTMLElement) {
    return null;
  } else {
    return new Error(`Invalid prop '${propName}' supplied to '${componentName}'. Value is not DOM element.`);
  }
};

const RemotePropType = exports.RemotePropType = _propTypes2.default.shape({
  getName: _propTypes2.default.func.isRequired,
  getUrl: _propTypes2.default.func.isRequired,
  isGithubRepo: _propTypes2.default.func.isRequired,
  getOwner: _propTypes2.default.func.isRequired,
  getRepo: _propTypes2.default.func.isRequired
});

const BranchPropType = exports.BranchPropType = _propTypes2.default.shape({
  getName: _propTypes2.default.func.isRequired,
  isDetached: _propTypes2.default.func.isRequired,
  isPresent: _propTypes2.default.func.isRequired
});

const CommitPropType = exports.CommitPropType = _propTypes2.default.shape({
  getSha: _propTypes2.default.func.isRequired,
  getMessage: _propTypes2.default.func.isRequired,
  isUnbornRef: _propTypes2.default.func.isRequired,
  isPresent: _propTypes2.default.func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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