'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _compareSets2 = require('compare-sets');

var _compareSets3 = _interopRequireDefault(_compareSets2);

var _eventKit = require('event-kit');

var _workdirContext = require('./workdir-context');

var _workdirContext2 = _interopRequireDefault(_workdirContext);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Manage a WorkdirContext for each open directory.
 */
let WorkdirContextPool = class WorkdirContextPool {

  /**
   * Options will be passed to each `WorkdirContext` as it is created.
   */
  constructor() {
    let options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    this.options = options;

    this.contexts = new Map();
    this.emitter = new _eventKit.Emitter();
  }

  size() {
    return this.contexts.size;
  }

  /**
   * Access the context mapped to a known directory.
   */
  getContext(directory) {
    return this.contexts.get(directory) || _workdirContext2.default.absent();
  }

  add(directory) {
    let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    if (this.contexts.has(directory)) {
      return this.getContext(directory);
    }

    const context = new _workdirContext2.default(directory, _extends({}, this.options, options));
    this.contexts.set(directory, context);

    const disposable = new _eventKit.CompositeDisposable();

    const forwardEvent = (subMethod, emitEventName) => {
      const emit = () => this.emitter.emit(emitEventName, context);
      disposable.add(context[subMethod](emit));
    };

    forwardEvent('onDidStartObserver', 'did-start-observer');
    forwardEvent('onDidChangeWorkdirOrHead', 'did-change-workdir-or-head');
    forwardEvent('onDidChangeRepositoryState', 'did-change-repository-state');
    forwardEvent('onDidUpdateRepository', 'did-update-repository');
    forwardEvent('onDidDestroyRepository', 'did-destroy-repository');

    disposable.add(this.onDidRemoveContext(removed => {
      if (removed === context) {
        disposable.dispose();
      }
    }));

    return context;
  }

  replace(directory) {
    let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    this.remove(directory);
    this.add(directory, options);
  }

  remove(directory) {
    const existing = this.contexts.get(directory);
    this.contexts.delete(directory);

    if (existing) {
      this.emitter.emit('did-remove-context', existing);
      existing.destroy();
    }
  }

  set(directories) {
    let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    const previous = new Set(this.contexts.keys());

    var _compareSets = (0, _compareSets3.default)(previous, directories);

    const added = _compareSets.added,
          removed = _compareSets.removed;


    for (const directory of added) {
      this.add(directory, options);
    }
    for (const directory of removed) {
      this.remove(directory);
    }
  }

  withResidentContexts(callback) {
    for (const _ref of this.contexts) {
      var _ref2 = _slicedToArray(_ref, 2);

      const workdir = _ref2[0];
      const context = _ref2[1];

      callback(workdir, context);
    }
  }

  onDidStartObserver(callback) {
    return this.emitter.on('did-start-observer', callback);
  }

  onDidChangeWorkdirOrHead(callback) {
    return this.emitter.on('did-change-workdir-or-head', callback);
  }

  onDidRemoveContext(callback) {
    return this.emitter.on('did-remove-context', callback);
  }

  onDidChangeRepositoryState(callback) {
    return this.emitter.on('did-change-repository-state', callback);
  }

  onDidUpdateRepository(callback) {
    return this.emitter.on('did-update-repository', callback);
  }

  onDidDestroyRepository(callback) {
    return this.emitter.on('did-destroy-repository', callback);
  }

  clear() {
    this.withResidentContexts(workdir => this.remove(workdir));
    _workdirContext2.default.destroyAbsent();
  }
};
exports.default = WorkdirContextPool;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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