'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _fs = require('fs');

var _fs2 = _interopRequireDefault(_fs);

var _helpers = require('../helpers');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

/**
 * Locate the nearest git working directory above a given starting point, caching results.
 */
let WorkdirCache = class WorkdirCache {
  constructor() {
    let maxSize = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 1000;

    this.maxSize = maxSize;
    this.known = new Map();
  }

  find(startDir) {
    var _this = this;

    return _asyncToGenerator(function* () {
      try {
        const resolvedDir = yield _this.resolvePath(startDir);
        const cached = _this.known.get(resolvedDir);
        if (cached !== undefined) {
          return cached;
        }

        const workDir = yield _this.walkToRoot(resolvedDir);

        if (_this.known.size >= _this.maxSize) {
          _this.known.clear();
        }
        _this.known.set(resolvedDir, workDir);
        return workDir;
      } catch (e) {
        if (e.code === 'ENOENT') {
          return null;
        }

        throw e;
      }
    })();
  }

  invalidate(baseDir) {
    var _this2 = this;

    return _asyncToGenerator(function* () {
      const resolvedBase = yield _this2.resolvePath(baseDir);
      for (const cachedPath of _this2.known.keys()) {
        if (cachedPath.startsWith(resolvedBase)) {
          _this2.known.delete(cachedPath);
        }
      }
    })();
  }

  resolvePath(unresolvedPath) {
    return new Promise((resolve, reject) => {
      _fs2.default.realpath(unresolvedPath, (err, resolved) => err ? reject(err) : resolve(resolved));
    });
  }

  walkToRoot(initialDir) {
    return new Promise((resolve, reject) => {
      let currentDir = initialDir;

      const check = () => {
        const dotGit = _path2.default.join(currentDir, '.git');
        _fs2.default.stat(dotGit, (() => {
          var _ref = _asyncToGenerator(function* (statError, stat) {
            if (statError) {
              if (statError.code === 'ENOENT' || statError.code === 'ENOTDIR') {
                // File not found. This is not the directory we're looking for. Continue walking.
                return walk();
              }

              return reject(statError);
            }

            if (!stat.isDirectory()) {
              const contents = yield (0, _helpers.readFile)(dotGit, 'utf8');
              if (contents.startsWith('gitdir: ')) {
                return resolve(currentDir);
              } else {
                return walk();
              }
            }

            // .git directory found! Mission accomplished.
            return resolve(currentDir);
          });

          return function (_x2, _x3) {
            return _ref.apply(this, arguments);
          };
        })());
      };

      const walk = () => {
        const parentDir = _path2.default.resolve(currentDir, '..');
        if (parentDir === currentDir) {
          // Root directory. Traversal done, no working directory found.
          resolve(null);
          return;
        }

        currentDir = parentDir;
        check();
      };

      check();
    });
  }
};
exports.default = WorkdirCache;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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