'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _dec, _dec2, _dec3, _dec4, _dec5, _dec6, _dec7, _dec8, _dec9, _dec10, _dec11, _dec12, _dec13, _dec14, _dec15, _dec16, _dec17, _desc, _value, _class;

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _state = require('./state');

var _state2 = _interopRequireDefault(_state);

var _helpers = require('../../helpers');

var _workspaceChangeObserver = require('../workspace-change-observer');

var _filePatch = require('../file-patch');

var _filePatch2 = _interopRequireDefault(_filePatch);

var _hunk = require('../hunk');

var _hunk2 = _interopRequireDefault(_hunk);

var _hunkLine = require('../hunk-line');

var _hunkLine2 = _interopRequireDefault(_hunkLine);

var _discardHistory = require('../discard-history');

var _discardHistory2 = _interopRequireDefault(_discardHistory);

var _branch = require('../branch');

var _branch2 = _interopRequireDefault(_branch);

var _remote = require('../remote');

var _remote2 = _interopRequireDefault(_remote);

var _commit = require('../commit');

var _commit2 = _interopRequireDefault(_commit);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

/**
 * Decorator for an async method that invalidates the cache after execution (regardless of success or failure).
 * Optionally parameterized by a function that accepts the same arguments as the function that returns the list of cache
 * keys to invalidate.
 */
function invalidate(spec) {
  return function (target, name, descriptor) {
    const original = descriptor.value;
    descriptor.value = function () {
      for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      return original.apply(this, args).then(result => {
        this.acceptInvalidation(spec, args);
        return result;
      }, err => {
        this.acceptInvalidation(spec, args);
        return Promise.reject(err);
      });
    };
    return descriptor;
  };
}

/**
 * State used when the working directory contains a valid git repository and can be interacted with. Performs
 * actual git operations, caching the results, and broadcasts `onDidUpdate` events when write actions are
 * performed.
 */
let Present = (_dec = invalidate(paths => Keys.cacheOperationKeys(paths)), _dec2 = invalidate(paths => Keys.cacheOperationKeys(paths)), _dec3 = invalidate(paths => Keys.cacheOperationKeys(paths)), _dec4 = invalidate(filePatch => Keys.cacheOperationKeys([filePatch.getOldPath(), filePatch.getNewPath()])), _dec5 = invalidate(filePatch => Keys.workdirOperationKeys([filePatch.getOldPath(), filePatch.getNewPath()])), _dec6 = invalidate(() => [...Keys.headOperationKeys(), ...Keys.filePatch.eachWithOpts({ staged: true }), Keys.headDescription]), _dec7 = invalidate(() => [...Keys.headOperationKeys(), Keys.index.all, Keys.headDescription]), _dec8 = invalidate(() => [Keys.statusBundle, Keys.stagedChangesSinceParentCommit, Keys.filePatch.all, Keys.index.all]), _dec9 = invalidate(filePath => [Keys.statusBundle, Keys.stagedChangesSinceParentCommit, ...Keys.filePatch.eachWithFileOpts([filePath], [{ staged: false }, { staged: true }, { staged: true, amending: true }]), Keys.index.oneWith(filePath)]), _dec10 = invalidate(() => [Keys.stagedChangesSinceParentCommit, Keys.lastCommit, Keys.statusBundle, Keys.index.all, ...Keys.filePatch.eachWithOpts({ staged: true, amending: true }), Keys.headDescription]), _dec11 = invalidate(paths => [Keys.statusBundle, Keys.stagedChangesSinceParentCommit, ...paths.map(fileName => Keys.index.oneWith(fileName)), ...Keys.filePatch.eachWithFileOpts(paths, [{ staged: true }, { staged: true, amending: true }])]), _dec12 = invalidate(branchName => [Keys.statusBundle, Keys.headDescription]), _dec13 = invalidate(() => [...Keys.headOperationKeys(), Keys.index.all, Keys.headDescription]), _dec14 = invalidate(function (branchName) {
  let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

  const keys = [Keys.statusBundle, Keys.headDescription];

  if (options.setUpstream) {
    keys.push(...Keys.config.eachWithSetting(`branch.${branchName}.remote`));
  }

  return keys;
}), _dec15 = invalidate(setting => Keys.config.eachWithSetting(setting)), _dec16 = invalidate(setting => Keys.config.eachWithSetting(setting)), _dec17 = invalidate(paths => [Keys.statusBundle, ...paths.map(filePath => Keys.filePatch.oneWith(filePath, { staged: false }))]), (_class = class Present extends _state2.default {
  constructor(repository, history) {
    super(repository);

    this.cache = new Cache();

    this.discardHistory = new _discardHistory2.default(this.createBlob.bind(this), this.expandBlobToFile.bind(this), this.mergeFile.bind(this), this.workdir(), { maxHistoryLength: 60 });
  }

  isPresent() {
    return true;
  }

  showStatusBarTiles() {
    return true;
  }

  acceptInvalidation(spec, args) {
    const keys = spec(...args);
    this.cache.invalidate(keys);
    this.didUpdate();
  }

  observeFilesystemChange(paths) {
    const keys = new Set();
    for (let i = 0; i < paths.length; i++) {
      const fullPath = paths[i];

      if (fullPath === _workspaceChangeObserver.FOCUS) {
        keys.add(Keys.statusBundle);
        for (const k of Keys.filePatch.eachWithOpts({ staged: false })) {
          keys.add(k);
        }
        continue;
      }

      const endsWith = function () {
        return fullPath.endsWith(_path2.default.join(...arguments));
      };
      const includes = function () {
        return fullPath.includes(_path2.default.join(...arguments));
      };

      if (endsWith('.git', 'index')) {
        keys.add(Keys.stagedChangesSinceParentCommit);
        keys.add(Keys.filePatch.all);
        keys.add(Keys.index.all);
        keys.add(Keys.statusBundle);
        continue;
      }

      if (endsWith('.git', 'HEAD')) {
        keys.add(Keys.lastCommit);
        keys.add(Keys.statusBundle);
        keys.add(Keys.headDescription);
        continue;
      }

      if (includes('.git', 'refs', 'heads')) {
        keys.add(Keys.branches);
        keys.add(Keys.lastCommit);
        keys.add(Keys.headDescription);
        continue;
      }

      if (includes('.git', 'refs', 'remotes')) {
        keys.add(Keys.remotes);
        keys.add(Keys.statusBundle);
        keys.add(Keys.headDescription);
        continue;
      }

      if (endsWith('.git', 'config')) {
        keys.add(Keys.config.all);
        keys.add(Keys.statusBundle);
        continue;
      }

      // File change within the working directory
      const relativePath = _path2.default.relative(this.workdir(), fullPath);
      keys.add(Keys.filePatch.oneWith(relativePath, { staged: false }));
      keys.add(Keys.statusBundle);
    }

    if (keys.size > 0) {
      this.cache.invalidate(Array.from(keys));
      this.didUpdate();
    }
  }

  refresh() {
    this.cache.clear();
    this.didUpdate();
  }

  init() {
    return super.init().catch(e => {
      e.stdErr = 'This directory already contains a git repository';
      return Promise.reject(e);
    });
  }

  clone() {
    return super.clone().catch(e => {
      e.stdErr = 'This directory already contains a git repository';
      return Promise.reject(e);
    });
  }

  // Git operations ////////////////////////////////////////////////////////////////////////////////////////////////////

  // Staging and unstaging

  stageFiles(paths) {
    return this.git().stageFiles(paths);
  }

  unstageFiles(paths) {
    return this.git().unstageFiles(paths);
  }

  stageFilesFromParentCommit(paths) {
    return this.git().unstageFiles(paths, 'HEAD~');
  }

  applyPatchToIndex(filePatch) {
    const patchStr = filePatch.getHeaderString() + filePatch.toString();
    return this.git().applyPatch(patchStr, { index: true });
  }

  applyPatchToWorkdir(filePatch) {
    const patchStr = filePatch.getHeaderString() + filePatch.toString();
    return this.git().applyPatch(patchStr);
  }

  // Committing

  commit(message, options) {
    return this.git().commit(formatCommitMessage(message), options);
  }

  // Merging

  merge(branchName) {
    return this.git().merge(branchName);
  }

  abortMerge() {
    return this.git().abortMerge();
  }

  checkoutSide(side, paths) {
    return this.git().checkoutSide(side, paths);
  }

  mergeFile(oursPath, commonBasePath, theirsPath, resultPath) {
    return this.git().mergeFile(oursPath, commonBasePath, theirsPath, resultPath);
  }

  writeMergeConflictToIndex(filePath, commonBaseSha, oursSha, theirsSha) {
    return this.git().writeMergeConflictToIndex(filePath, commonBaseSha, oursSha, theirsSha);
  }

  // Checkout

  checkout(revision) {
    let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    return this.git().checkout(revision, options);
  }

  checkoutPathsAtRevision(paths) {
    let revision = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'HEAD';

    return this.git().checkoutFiles(paths, revision);
  }

  // Remote interactions

  fetch(branchName) {
    var _this = this;

    return _asyncToGenerator(function* () {
      const remote = yield _this.getRemoteForBranch(branchName);
      if (!remote.isPresent()) {
        return;
      }
      yield _this.git().fetch(remote.getName(), branchName);
    })();
  }

  pull(branchName) {
    var _this2 = this;

    return _asyncToGenerator(function* () {
      const remote = yield _this2.getRemoteForBranch(branchName);
      if (!remote.isPresent()) {
        return;
      }
      yield _this2.git().pull(remote.getName(), branchName);
    })();
  }

  push(branchName, options) {
    var _this3 = this;

    return _asyncToGenerator(function* () {
      const remote = yield _this3.getRemoteForBranch(branchName);
      return _this3.git().push(remote.getNameOr('origin'), branchName, options);
    })();
  }

  // Configuration

  setConfig(setting, value, options) {
    return this.git().setConfig(setting, value, options);
  }

  unsetConfig(setting) {
    return this.git().unsetConfig(setting);
  }

  // Direct blob interactions

  createBlob(options) {
    return this.git().createBlob(options);
  }

  expandBlobToFile(absFilePath, sha) {
    return this.git().expandBlobToFile(absFilePath, sha);
  }

  // Discard history

  createDiscardHistoryBlob() {
    return this.discardHistory.createHistoryBlob();
  }

  updateDiscardHistory() {
    var _this4 = this;

    return _asyncToGenerator(function* () {
      const history = yield _this4.loadHistoryPayload();
      _this4.discardHistory.updateHistory(history);
    })();
  }

  storeBeforeAndAfterBlobs(filePaths, isSafe, destructiveAction) {
    var _this5 = this;

    let partialDiscardFilePath = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
    return _asyncToGenerator(function* () {
      const snapshots = yield _this5.discardHistory.storeBeforeAndAfterBlobs(filePaths, isSafe, destructiveAction, partialDiscardFilePath);
      if (snapshots) {
        yield _this5.saveDiscardHistory();
      }
      return snapshots;
    })();
  }

  restoreLastDiscardInTempFiles(isSafe) {
    let partialDiscardFilePath = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;

    return this.discardHistory.restoreLastDiscardInTempFiles(isSafe, partialDiscardFilePath);
  }

  popDiscardHistory() {
    var _this6 = this;

    let partialDiscardFilePath = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
    return _asyncToGenerator(function* () {
      const removed = yield _this6.discardHistory.popHistory(partialDiscardFilePath);
      if (removed) {
        yield _this6.saveDiscardHistory();
      }
    })();
  }

  clearDiscardHistory() {
    let partialDiscardFilePath = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;

    this.discardHistory.clearHistory(partialDiscardFilePath);
    return this.saveDiscardHistory();
  }

  discardWorkDirChangesForPaths(paths) {
    var _this7 = this;

    return _asyncToGenerator(function* () {
      const untrackedFiles = yield _this7.git().getUntrackedFiles();

      var _partition = partition(paths, function (f) {
        return untrackedFiles.includes(f);
      }),
          _partition2 = _slicedToArray(_partition, 2);

      const filesToRemove = _partition2[0],
            filesToCheckout = _partition2[1];

      yield _this7.git().checkoutFiles(filesToCheckout);
      yield Promise.all(filesToRemove.map(function (filePath) {
        const absPath = _path2.default.join(_this7.workdir(), filePath);
        return (0, _helpers.deleteFileOrFolder)(absPath);
      }));
    })();
  }

  // Accessors /////////////////////////////////////////////////////////////////////////////////////////////////////////

  // Index queries

  getStatusBundle() {
    var _this8 = this;

    return this.cache.getOrSet(Keys.statusBundle, _asyncToGenerator(function* () {
      const bundle = yield _this8.git().getStatusBundle();
      const results = yield _this8.formatChangedFiles(bundle);
      results.branch = bundle.branch;
      if (!results.branch.aheadBehind) {
        results.branch.aheadBehind = { ahead: null, behind: null };
      }
      return results;
    }));
  }

  formatChangedFiles(_ref2) {
    var _this9 = this;

    let changedEntries = _ref2.changedEntries,
        untrackedEntries = _ref2.untrackedEntries,
        renamedEntries = _ref2.renamedEntries,
        unmergedEntries = _ref2.unmergedEntries;
    return _asyncToGenerator(function* () {
      const statusMap = {
        A: 'added',
        M: 'modified',
        D: 'deleted',
        U: 'modified'
      };

      const stagedFiles = {};
      const unstagedFiles = {};
      const mergeConflictFiles = {};

      changedEntries.forEach(function (entry) {
        if (entry.stagedStatus) {
          stagedFiles[entry.filePath] = statusMap[entry.stagedStatus];
        }
        if (entry.unstagedStatus) {
          unstagedFiles[entry.filePath] = statusMap[entry.unstagedStatus];
        }
      });

      untrackedEntries.forEach(function (entry) {
        unstagedFiles[entry.filePath] = statusMap.A;
      });

      renamedEntries.forEach(function (entry) {
        if (entry.stagedStatus === 'R') {
          stagedFiles[entry.filePath] = statusMap.A;
          stagedFiles[entry.origFilePath] = statusMap.D;
        }
        if (entry.unstagedStatus === 'R') {
          unstagedFiles[entry.filePath] = statusMap.A;
          unstagedFiles[entry.origFilePath] = statusMap.D;
        }
        if (entry.stagedStatus === 'C') {
          stagedFiles[entry.filePath] = statusMap.A;
        }
        if (entry.unstagedStatus === 'C') {
          unstagedFiles[entry.filePath] = statusMap.A;
        }
      });

      let statusToHead;

      for (let i = 0; i < unmergedEntries.length; i++) {
        var _unmergedEntries$i = unmergedEntries[i];
        const stagedStatus = _unmergedEntries$i.stagedStatus,
              unstagedStatus = _unmergedEntries$i.unstagedStatus,
              filePath = _unmergedEntries$i.filePath;

        if (stagedStatus === 'U' || unstagedStatus === 'U' || stagedStatus === 'A' && unstagedStatus === 'A') {
          // Skipping this check here because we only run a single `await`
          // and we only run it in the main, synchronous body of the for loop.
          // eslint-disable-next-line no-await-in-loop
          if (!statusToHead) {
            statusToHead = yield _this9.git().diffFileStatus({ target: 'HEAD' });
          }
          mergeConflictFiles[filePath] = {
            ours: statusMap[stagedStatus],
            theirs: statusMap[unstagedStatus],
            file: statusToHead[filePath] || 'equivalent'
          };
        }
      }

      return { stagedFiles, unstagedFiles, mergeConflictFiles };
    })();
  }

  getStatusesForChangedFiles() {
    var _this10 = this;

    return _asyncToGenerator(function* () {
      var _ref3 = yield _this10.getStatusBundle();

      const stagedFiles = _ref3.stagedFiles,
            unstagedFiles = _ref3.unstagedFiles,
            mergeConflictFiles = _ref3.mergeConflictFiles;

      return { stagedFiles, unstagedFiles, mergeConflictFiles };
    })();
  }

  getStagedChangesSinceParentCommit() {
    var _this11 = this;

    return this.cache.getOrSet(Keys.stagedChangesSinceParentCommit, _asyncToGenerator(function* () {
      try {
        const stagedFiles = yield _this11.git().diffFileStatus({ staged: true, target: 'HEAD~' });
        return Object.keys(stagedFiles).map(function (filePath) {
          return { filePath, status: stagedFiles[filePath] };
        });
      } catch (e) {
        if (e.message.includes('ambiguous argument \'HEAD~\'')) {
          return [];
        } else {
          throw e;
        }
      }
    }));
  }

  getFilePatchForPath(filePath) {
    var _this12 = this;

    var _ref5 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : { staged: false, amending: false };

    let staged = _ref5.staged,
        amending = _ref5.amending;

    return this.cache.getOrSet(Keys.filePatch.oneWith(filePath, { staged, amending }), _asyncToGenerator(function* () {
      const options = { staged, amending };
      if (amending) {
        options.baseCommit = 'HEAD~';
      }

      const rawDiff = yield _this12.git().getDiffForFilePath(filePath, options);
      if (rawDiff) {
        var _buildFilePatchesFrom = buildFilePatchesFromRawDiffs([rawDiff]),
            _buildFilePatchesFrom2 = _slicedToArray(_buildFilePatchesFrom, 1);

        const filePatch = _buildFilePatchesFrom2[0];

        return filePatch;
      } else {
        return null;
      }
    }));
  }

  readFileFromIndex(filePath) {
    return this.cache.getOrSet(Keys.index.oneWith(filePath), () => {
      return this.git().readFileFromIndex(filePath);
    });
  }

  // Commit access

  getLastCommit() {
    var _this13 = this;

    return this.cache.getOrSet(Keys.lastCommit, _asyncToGenerator(function* () {
      var _ref8 = yield _this13.git().getHeadCommit();

      const sha = _ref8.sha,
            message = _ref8.message,
            unbornRef = _ref8.unbornRef;

      return unbornRef ? _commit2.default.createUnborn() : new _commit2.default(sha, message);
    }));
  }

  // Branches

  getBranches() {
    var _this14 = this;

    return this.cache.getOrSet(Keys.branches, _asyncToGenerator(function* () {
      const branchNames = yield _this14.git().getBranches();
      return branchNames.map(function (branchName) {
        return new _branch2.default(branchName);
      });
    }));
  }

  getCurrentBranch() {
    var _this15 = this;

    return _asyncToGenerator(function* () {
      var _ref10 = yield _this15.getStatusBundle();

      const branch = _ref10.branch;

      if (branch.head === '(detached)') {
        const description = yield _this15.getHeadDescription();
        return _branch2.default.createDetached(description);
      } else {
        return new _branch2.default(branch.head);
      }
    })();
  }

  getHeadDescription() {
    return this.cache.getOrSet(Keys.headDescription, () => {
      return this.git().describeHead();
    });
  }

  // Merging and rebasing status

  isMerging() {
    return this.git().isMerging(this.repository.getGitDirectoryPath());
  }

  isRebasing() {
    return this.git().isRebasing(this.repository.getGitDirectoryPath());
  }

  // Remotes

  getRemotes() {
    var _this16 = this;

    return this.cache.getOrSet(Keys.remotes, _asyncToGenerator(function* () {
      const remotesInfo = yield _this16.git().getRemotes();
      return remotesInfo.map(function (_ref12) {
        let name = _ref12.name,
            url = _ref12.url;
        return new _remote2.default(name, url);
      });
    }));
  }

  getAheadCount(branchName) {
    var _this17 = this;

    return _asyncToGenerator(function* () {
      const bundle = yield _this17.getStatusBundle();
      return bundle.branch.aheadBehind.ahead;
    })();
  }

  getBehindCount(branchName) {
    var _this18 = this;

    return _asyncToGenerator(function* () {
      const bundle = yield _this18.getStatusBundle();
      return bundle.branch.aheadBehind.behind;
    })();
  }

  getConfig(option) {
    var _ref13 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : { local: false };

    let local = _ref13.local;

    return this.cache.getOrSet(Keys.config.oneWith(option, { local }), () => {
      return this.git().getConfig(option, { local });
    });
  }

  // Direct blob access

  getBlobContents(sha) {
    return this.cache.getOrSet(Keys.blob(sha), () => {
      return this.git().getBlobContents(sha);
    });
  }

  // Discard history

  hasDiscardHistory() {
    let partialDiscardFilePath = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;

    return this.discardHistory.hasHistory(partialDiscardFilePath);
  }

  getDiscardHistory() {
    let partialDiscardFilePath = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;

    return this.discardHistory.getHistory(partialDiscardFilePath);
  }

  getLastHistorySnapshots() {
    let partialDiscardFilePath = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;

    return this.discardHistory.getLastSnapshots(partialDiscardFilePath);
  }
}, (_applyDecoratedDescriptor(_class.prototype, 'stageFiles', [_dec], Object.getOwnPropertyDescriptor(_class.prototype, 'stageFiles'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'unstageFiles', [_dec2], Object.getOwnPropertyDescriptor(_class.prototype, 'unstageFiles'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'stageFilesFromParentCommit', [_dec3], Object.getOwnPropertyDescriptor(_class.prototype, 'stageFilesFromParentCommit'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'applyPatchToIndex', [_dec4], Object.getOwnPropertyDescriptor(_class.prototype, 'applyPatchToIndex'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'applyPatchToWorkdir', [_dec5], Object.getOwnPropertyDescriptor(_class.prototype, 'applyPatchToWorkdir'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'commit', [_dec6], Object.getOwnPropertyDescriptor(_class.prototype, 'commit'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'merge', [_dec7], Object.getOwnPropertyDescriptor(_class.prototype, 'merge'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'abortMerge', [_dec8], Object.getOwnPropertyDescriptor(_class.prototype, 'abortMerge'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'writeMergeConflictToIndex', [_dec9], Object.getOwnPropertyDescriptor(_class.prototype, 'writeMergeConflictToIndex'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'checkout', [_dec10], Object.getOwnPropertyDescriptor(_class.prototype, 'checkout'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'checkoutPathsAtRevision', [_dec11], Object.getOwnPropertyDescriptor(_class.prototype, 'checkoutPathsAtRevision'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'fetch', [_dec12], Object.getOwnPropertyDescriptor(_class.prototype, 'fetch'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'pull', [_dec13], Object.getOwnPropertyDescriptor(_class.prototype, 'pull'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'push', [_dec14], Object.getOwnPropertyDescriptor(_class.prototype, 'push'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'setConfig', [_dec15], Object.getOwnPropertyDescriptor(_class.prototype, 'setConfig'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'unsetConfig', [_dec16], Object.getOwnPropertyDescriptor(_class.prototype, 'unsetConfig'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'discardWorkDirChangesForPaths', [_dec17], Object.getOwnPropertyDescriptor(_class.prototype, 'discardWorkDirChangesForPaths'), _class.prototype)), _class));
exports.default = Present;


_state2.default.register(Present);

function partition(array, predicate) {
  const matches = [];
  const nonmatches = [];
  array.forEach(item => {
    if (predicate(item)) {
      matches.push(item);
    } else {
      nonmatches.push(item);
    }
  });
  return [matches, nonmatches];
}

function formatCommitMessage(message) {
  // strip out comments
  const messageWithoutComments = message.replace(/^#.*$/mg, '').trim();

  // hard wrap message (except for first line) at 72 characters
  let results = [];
  messageWithoutComments.split('\n').forEach((line, index) => {
    if (line.length <= 72 || index === 0) {
      results.push(line);
    } else {
      const matches = line.match(/.{1,72}(\s|$)|\S+?(\s|$)/g).map(match => {
        return match.endsWith('\n') ? match.substr(0, match.length - 1) : match;
      });
      results = results.concat(matches);
    }
  });

  return results.join('\n');
}

function buildFilePatchesFromRawDiffs(rawDiffs) {
  let diffLineNumber = 0;
  return rawDiffs.map(patch => {
    const hunks = patch.hunks.map(hunk => {
      let oldLineNumber = hunk.oldStartLine;
      let newLineNumber = hunk.newStartLine;
      const hunkLines = hunk.lines.map(line => {
        const status = _hunkLine2.default.statusMap[line[0]];
        const text = line.slice(1);
        let hunkLine;
        if (status === 'unchanged') {
          hunkLine = new _hunkLine2.default(text, status, oldLineNumber, newLineNumber, diffLineNumber++);
          oldLineNumber++;
          newLineNumber++;
        } else if (status === 'added') {
          hunkLine = new _hunkLine2.default(text, status, -1, newLineNumber, diffLineNumber++);
          newLineNumber++;
        } else if (status === 'deleted') {
          hunkLine = new _hunkLine2.default(text, status, oldLineNumber, -1, diffLineNumber++);
          oldLineNumber++;
        } else if (status === 'nonewline') {
          hunkLine = new _hunkLine2.default(text.substr(1), status, -1, -1, diffLineNumber++);
        } else {
          throw new Error(`unknow status type: ${status}`);
        }
        return hunkLine;
      });
      return new _hunk2.default(hunk.oldStartLine, hunk.newStartLine, hunk.oldLineCount, hunk.newLineCount, hunk.heading, hunkLines);
    });
    return new _filePatch2.default(patch.oldPath, patch.newPath, patch.status, hunks);
  });
}

let Cache = class Cache {
  constructor() {
    this.storage = new Map();
    this.byGroup = new Map();
  }

  getOrSet(key, operation) {
    const primary = key.getPrimary();
    const existing = this.storage.get(primary);
    if (existing !== undefined) {
      return existing;
    }

    const created = operation();

    this.storage.set(primary, created);

    const groups = key.getGroups();
    for (let i = 0; i < groups.length; i++) {
      const group = groups[i];
      let groupSet = this.byGroup.get(group);
      if (groupSet === undefined) {
        groupSet = new Set();
        this.byGroup.set(group, groupSet);
      }
      groupSet.add(key);
    }

    return created;
  }

  invalidate(keys) {
    for (let i = 0; i < keys.length; i++) {
      keys[i].removeFromCache(this);
    }
  }

  keysInGroup(group) {
    return this.byGroup.get(group) || [];
  }

  removePrimary(primary) {
    this.storage.delete(primary);
  }

  removeFromGroup(group, key) {
    const groupSet = this.byGroup.get(group);
    groupSet && groupSet.delete(key);
  }

  clear() {
    this.storage.clear();
    this.byGroup.clear();
  }
};
let CacheKey = class CacheKey {
  constructor(primary) {
    let groups = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];

    this.primary = primary;
    this.groups = groups;
  }

  getPrimary() {
    return this.primary;
  }

  getGroups() {
    return this.groups;
  }

  removeFromCache(cache) {
    let withoutGroup = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;

    cache.removePrimary(this.getPrimary());

    const groups = this.getGroups();
    for (let i = 0; i < groups.length; i++) {
      const group = groups[i];
      if (group === withoutGroup) {
        continue;
      }

      cache.removeFromGroup(group, this);
    }
  }
};
let GroupKey = class GroupKey {
  constructor(group) {
    this.group = group;
  }

  removeFromCache(cache) {
    for (const matchingKey of cache.keysInGroup(this.group)) {
      matchingKey.removeFromCache(cache, this.group);
    }
  }
};


const Keys = {
  statusBundle: new CacheKey('status-bundle'),

  stagedChangesSinceParentCommit: new CacheKey('staged-changes-since-parent-commit'),

  filePatch: {
    _optKey: (_ref14) => {
      let staged = _ref14.staged,
          amending = _ref14.amending;

      if (staged && amending) {
        return 'a';
      } else if (staged) {
        return 's';
      } else {
        return 'u';
      }
    },

    oneWith: (fileName, options) => {
      // <-- Keys.filePatch
      const optKey = Keys.filePatch._optKey(options);
      return new CacheKey(`file-patch:${optKey}:${fileName}`, ['file-patch', `file-patch:${optKey}`]);
    },

    eachWithFileOpts: (fileNames, opts) => {
      const keys = [];
      for (let i = 0; i < fileNames.length; i++) {
        for (let j = 0; j < opts.length; j++) {
          keys.push(Keys.filePatch.oneWith(fileNames[i], opts[j]));
        }
      }
      return keys;
    },

    eachWithOpts: function () {
      for (var _len2 = arguments.length, opts = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        opts[_key2] = arguments[_key2];
      }

      return opts.map(opt => new GroupKey(`file-patch:${Keys.filePatch._optKey(opt)}`));
    },

    all: new GroupKey('file-patch')
  },

  index: {
    oneWith: fileName => new CacheKey(`index:${fileName}`, ['index']),

    all: new GroupKey('index')
  },

  lastCommit: new CacheKey('last-commit'),

  branches: new CacheKey('branches'),

  headDescription: new CacheKey('head-description'),

  remotes: new CacheKey('remotes'),

  config: {
    _optKey: options => options.local ? 'l' : '',

    oneWith: (setting, options) => {
      const optKey = Keys.config._optKey(options);
      return new CacheKey(`config:${optKey}:${setting}`, ['config', `config:${optKey}`]);
    },

    eachWithSetting: setting => [Keys.config.oneWith(setting, { local: true }), Keys.config.oneWith(setting, { local: false })],

    all: new GroupKey('config')
  },

  blob: {
    oneWith: sha => `blob:${sha}`
  },

  // Common collections of keys and patterns for use with @invalidate().

  workdirOperationKeys: fileNames => [Keys.statusBundle, ...Keys.filePatch.eachWithFileOpts(fileNames, [{ staged: false }])],

  cacheOperationKeys: fileNames => [...Keys.workdirOperationKeys(fileNames), ...Keys.filePatch.eachWithFileOpts(fileNames, [{ staged: true }, { staged: true, amending: true }]), ...fileNames.map(Keys.index.oneWith), Keys.stagedChangesSinceParentCommit],

  headOperationKeys: () => [...Keys.filePatch.eachWithOpts({ staged: true, amending: true }), Keys.stagedChangesSinceParentCommit, Keys.lastCommit, Keys.statusBundle]
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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