'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _state = require('./state');

var _state2 = _interopRequireDefault(_state);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Initial state to be used when we anticipate that the workspace will contain a single project once bootstrapping
 * has completed. Presents in the UI like the Loading state.
 */
let LoadingGuess = class LoadingGuess extends _state2.default {
  isLoadingGuess() {
    return true;
  }

  isUndetermined() {
    return true;
  }

  showGitTabLoading() {
    return true;
  }

  showGitTabInit() {
    return false;
  }

  hasDirectory() {
    return false;
  }
};
exports.default = LoadingGuess;


_state2.default.register(LoadingGuess);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImxvYWRpbmctZ3Vlc3MuanMiXSwibmFtZXMiOlsiTG9hZGluZ0d1ZXNzIiwiaXNMb2FkaW5nR3Vlc3MiLCJpc1VuZGV0ZXJtaW5lZCIsInNob3dHaXRUYWJMb2FkaW5nIiwic2hvd0dpdFRhYkluaXQiLCJoYXNEaXJlY3RvcnkiLCJyZWdpc3RlciJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQUFBOzs7Ozs7QUFFQTs7OztJQUlxQkEsWSxHQUFOLE1BQU1BLFlBQU4seUJBQWlDO0FBQzlDQyxtQkFBaUI7QUFDZixXQUFPLElBQVA7QUFDRDs7QUFFREMsbUJBQWlCO0FBQ2YsV0FBTyxJQUFQO0FBQ0Q7O0FBRURDLHNCQUFvQjtBQUNsQixXQUFPLElBQVA7QUFDRDs7QUFFREMsbUJBQWlCO0FBQ2YsV0FBTyxLQUFQO0FBQ0Q7O0FBRURDLGlCQUFlO0FBQ2IsV0FBTyxLQUFQO0FBQ0Q7QUFuQjZDLEM7a0JBQTNCTCxZOzs7QUFzQnJCLGdCQUFNTSxRQUFOLENBQWVOLFlBQWYiLCJmaWxlIjoibG9hZGluZy1ndWVzcy5qcyIsInNvdXJjZVJvb3QiOiIvaG9tZS90cmF2aXMvYnVpbGQvYXRvbS9hdG9tL291dC9hcHAvbm9kZV9tb2R1bGVzL2dpdGh1YiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBTdGF0ZSBmcm9tICcuL3N0YXRlJztcblxuLyoqXG4gKiBJbml0aWFsIHN0YXRlIHRvIGJlIHVzZWQgd2hlbiB3ZSBhbnRpY2lwYXRlIHRoYXQgdGhlIHdvcmtzcGFjZSB3aWxsIGNvbnRhaW4gYSBzaW5nbGUgcHJvamVjdCBvbmNlIGJvb3RzdHJhcHBpbmdcbiAqIGhhcyBjb21wbGV0ZWQuIFByZXNlbnRzIGluIHRoZSBVSSBsaWtlIHRoZSBMb2FkaW5nIHN0YXRlLlxuICovXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBMb2FkaW5nR3Vlc3MgZXh0ZW5kcyBTdGF0ZSB7XG4gIGlzTG9hZGluZ0d1ZXNzKCkge1xuICAgIHJldHVybiB0cnVlO1xuICB9XG5cbiAgaXNVbmRldGVybWluZWQoKSB7XG4gICAgcmV0dXJuIHRydWU7XG4gIH1cblxuICBzaG93R2l0VGFiTG9hZGluZygpIHtcbiAgICByZXR1cm4gdHJ1ZTtcbiAgfVxuXG4gIHNob3dHaXRUYWJJbml0KCkge1xuICAgIHJldHVybiBmYWxzZTtcbiAgfVxuXG4gIGhhc0RpcmVjdG9yeSgpIHtcbiAgICByZXR1cm4gZmFsc2U7XG4gIH1cbn1cblxuU3RhdGUucmVnaXN0ZXIoTG9hZGluZ0d1ZXNzKTtcbiJdfQ==