'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _state = require('./state');

var _state2 = _interopRequireDefault(_state);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

/**
 * Git is asynchronously initializing a new repository in this working directory.
 */
let Initializing = class Initializing extends _state2.default {
  start() {
    var _this = this;

    return _asyncToGenerator(function* () {
      yield _this.doInit(_this.workdir());

      yield _this.transitionTo('Loading');
    })();
  }

  showGitTabLoading() {
    return true;
  }

  directInit(workdir) {
    return this.git().init(workdir);
  }
};
exports.default = Initializing;


_state2.default.register(Initializing);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImluaXRpYWxpemluZy5qcyJdLCJuYW1lcyI6WyJJbml0aWFsaXppbmciLCJzdGFydCIsImRvSW5pdCIsIndvcmtkaXIiLCJ0cmFuc2l0aW9uVG8iLCJzaG93R2l0VGFiTG9hZGluZyIsImRpcmVjdEluaXQiLCJnaXQiLCJpbml0IiwicmVnaXN0ZXIiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7QUFBQTs7Ozs7Ozs7QUFFQTs7O0lBR3FCQSxZLEdBQU4sTUFBTUEsWUFBTix5QkFBaUM7QUFDeENDLE9BQU4sR0FBYztBQUFBOztBQUFBO0FBQ1osWUFBTSxNQUFLQyxNQUFMLENBQVksTUFBS0MsT0FBTCxFQUFaLENBQU47O0FBRUEsWUFBTSxNQUFLQyxZQUFMLENBQWtCLFNBQWxCLENBQU47QUFIWTtBQUliOztBQUVEQyxzQkFBb0I7QUFDbEIsV0FBTyxJQUFQO0FBQ0Q7O0FBRURDLGFBQVdILE9BQVgsRUFBb0I7QUFDbEIsV0FBTyxLQUFLSSxHQUFMLEdBQVdDLElBQVgsQ0FBZ0JMLE9BQWhCLENBQVA7QUFDRDtBQWI2QyxDO2tCQUEzQkgsWTs7O0FBZ0JyQixnQkFBTVMsUUFBTixDQUFlVCxZQUFmIiwiZmlsZSI6ImluaXRpYWxpemluZy5qcyIsInNvdXJjZVJvb3QiOiIvaG9tZS90cmF2aXMvYnVpbGQvYXRvbS9hdG9tL291dC9hcHAvbm9kZV9tb2R1bGVzL2dpdGh1YiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBTdGF0ZSBmcm9tICcuL3N0YXRlJztcblxuLyoqXG4gKiBHaXQgaXMgYXN5bmNocm9ub3VzbHkgaW5pdGlhbGl6aW5nIGEgbmV3IHJlcG9zaXRvcnkgaW4gdGhpcyB3b3JraW5nIGRpcmVjdG9yeS5cbiAqL1xuZXhwb3J0IGRlZmF1bHQgY2xhc3MgSW5pdGlhbGl6aW5nIGV4dGVuZHMgU3RhdGUge1xuICBhc3luYyBzdGFydCgpIHtcbiAgICBhd2FpdCB0aGlzLmRvSW5pdCh0aGlzLndvcmtkaXIoKSk7XG5cbiAgICBhd2FpdCB0aGlzLnRyYW5zaXRpb25UbygnTG9hZGluZycpO1xuICB9XG5cbiAgc2hvd0dpdFRhYkxvYWRpbmcoKSB7XG4gICAgcmV0dXJuIHRydWU7XG4gIH1cblxuICBkaXJlY3RJbml0KHdvcmtkaXIpIHtcbiAgICByZXR1cm4gdGhpcy5naXQoKS5pbml0KHdvcmtkaXIpO1xuICB9XG59XG5cblN0YXRlLnJlZ2lzdGVyKEluaXRpYWxpemluZyk7XG4iXX0=