'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _state = require('./state');

var _state2 = _interopRequireDefault(_state);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * The working directory exists, but contains no git repository yet.
 */
let Empty = class Empty extends _state2.default {
  isEmpty() {
    return true;
  }

  init() {
    return this.transitionTo('Initializing');
  }

  clone(remoteUrl) {
    return this.transitionTo('Cloning', remoteUrl);
  }

  showGitTabInit() {
    return true;
  }
};
exports.default = Empty;


_state2.default.register(Empty);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImVtcHR5LmpzIl0sIm5hbWVzIjpbIkVtcHR5IiwiaXNFbXB0eSIsImluaXQiLCJ0cmFuc2l0aW9uVG8iLCJjbG9uZSIsInJlbW90ZVVybCIsInNob3dHaXRUYWJJbml0IiwicmVnaXN0ZXIiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7QUFBQTs7Ozs7O0FBRUE7OztJQUdxQkEsSyxHQUFOLE1BQU1BLEtBQU4seUJBQTBCO0FBQ3ZDQyxZQUFVO0FBQ1IsV0FBTyxJQUFQO0FBQ0Q7O0FBRURDLFNBQU87QUFDTCxXQUFPLEtBQUtDLFlBQUwsQ0FBa0IsY0FBbEIsQ0FBUDtBQUNEOztBQUVEQyxRQUFNQyxTQUFOLEVBQWlCO0FBQ2YsV0FBTyxLQUFLRixZQUFMLENBQWtCLFNBQWxCLEVBQTZCRSxTQUE3QixDQUFQO0FBQ0Q7O0FBRURDLG1CQUFpQjtBQUNmLFdBQU8sSUFBUDtBQUNEO0FBZnNDLEM7a0JBQXBCTixLOzs7QUFrQnJCLGdCQUFNTyxRQUFOLENBQWVQLEtBQWYiLCJmaWxlIjoiZW1wdHkuanMiLCJzb3VyY2VSb290IjoiL2hvbWUvdHJhdmlzL2J1aWxkL2F0b20vYXRvbS9vdXQvYXBwL25vZGVfbW9kdWxlcy9naXRodWIiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgU3RhdGUgZnJvbSAnLi9zdGF0ZSc7XG5cbi8qKlxuICogVGhlIHdvcmtpbmcgZGlyZWN0b3J5IGV4aXN0cywgYnV0IGNvbnRhaW5zIG5vIGdpdCByZXBvc2l0b3J5IHlldC5cbiAqL1xuZXhwb3J0IGRlZmF1bHQgY2xhc3MgRW1wdHkgZXh0ZW5kcyBTdGF0ZSB7XG4gIGlzRW1wdHkoKSB7XG4gICAgcmV0dXJuIHRydWU7XG4gIH1cblxuICBpbml0KCkge1xuICAgIHJldHVybiB0aGlzLnRyYW5zaXRpb25UbygnSW5pdGlhbGl6aW5nJyk7XG4gIH1cblxuICBjbG9uZShyZW1vdGVVcmwpIHtcbiAgICByZXR1cm4gdGhpcy50cmFuc2l0aW9uVG8oJ0Nsb25pbmcnLCByZW1vdGVVcmwpO1xuICB9XG5cbiAgc2hvd0dpdFRhYkluaXQoKSB7XG4gICAgcmV0dXJuIHRydWU7XG4gIH1cbn1cblxuU3RhdGUucmVnaXN0ZXIoRW1wdHkpO1xuIl19