'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
let Remote = class Remote {
  constructor(name, url) {
    this.name = name;
    this.url = url;

    var _githubInfoFromRemote = githubInfoFromRemote(url);

    const isGithubRepo = _githubInfoFromRemote.isGithubRepo,
          owner = _githubInfoFromRemote.owner,
          repo = _githubInfoFromRemote.repo;

    this.githubRepo = isGithubRepo;
    this.owner = owner;
    this.repo = repo;
  }

  getName() {
    return this.name;
  }

  getUrl() {
    return this.url;
  }

  isGithubRepo() {
    return this.githubRepo;
  }

  getOwner() {
    return this.owner;
  }

  getRepo() {
    return this.repo;
  }

  getNameOr(fallback) {
    return this.getName();
  }

  isPresent() {
    return true;
  }
};
exports.default = Remote;


function githubInfoFromRemote(remoteUrl) {
  if (!remoteUrl) {
    return {
      isGithubRepo: false,
      owner: null,
      repo: null
    };
  }

  //             proto       login   domain         owner    repo
  const regex = /(?:.+:\/\/)?(?:.+@)?github\.com[:/]([^/]+)\/(.+)/;
  const match = remoteUrl.match(regex);
  if (match) {
    return {
      isGithubRepo: true,
      owner: match[1],
      repo: match[2].replace(/\.git$/, '')
    };
  } else {
    return {
      isGithubRepo: false,
      owner: null,
      repo: null
    };
  }
}

const nullRemote = exports.nullRemote = {
  getName() {
    return '';
  },

  getUrl() {
    return '';
  },

  isGithubRepo() {
    return false;
  },

  getOwner() {
    return null;
  },

  getRepo() {
    return null;
  },

  getNameOr(fallback) {
    return fallback;
  },

  isPresent() {
    return false;
  }
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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