"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
let statePerType = new WeakMap();

let _default = class _default {
  static clearSavedState() {
    statePerType = new WeakMap();
  }

  constructor(type, _ref) {
    let initialModel = _ref.initialModel,
        save = _ref.save,
        restore = _ref.restore;

    this.saveData = save;
    this.restoreData = restore;
    if (statePerType.has(type)) {
      this.statePerModel = statePerType.get(type);
    } else {
      this.statePerModel = new WeakMap();
      statePerType.set(type, this.statePerModel);
    }
    this.setModel(initialModel);
  }

  setModel(model) {
    if (model !== this.model) {
      this.save();
      this.restore(model);
    }
  }

  save() {
    this.model && this.statePerModel.set(this.model, this.saveData());
  }

  restore(model) {
    model && this.restoreData(this.statePerModel.get(model));
    this.model = model;
  }
};

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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