"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

let ModelObserver = class ModelObserver {
  constructor(_ref) {
    let fetchData = _ref.fetchData,
        didUpdate = _ref.didUpdate;

    this.fetchData = fetchData || (() => {});
    this.didUpdate = didUpdate || (() => {});
    this.activeModel = null;
    this.activeModelData = null;
    this.activeModelUpdateSubscription = null;
    this.inProgress = false;
    this.pending = false;
  }

  setActiveModel(model) {
    if (model !== this.activeModel) {
      if (this.activeModelUpdateSubscription) {
        this.activeModelUpdateSubscription.dispose();
        this.activeModelUpdateSubscription = null;
      }
      this.activeModel = model;
      this.activeModelData = null;
      this.inProgress = false;
      this.pending = false;
      this.didUpdate(model);
      if (model) {
        this.activeModelUpdateSubscription = model.onDidUpdate(() => this.refreshModelData(model));
        return this.refreshModelData(model);
      }
    }
    return null;
  }

  refreshModelData() {
    let model = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.activeModel;

    if (this.inProgress) {
      this.pending = true;
      return null;
    }
    this.lastModelDataRefreshPromise = this._refreshModelData(model);
    return this.lastModelDataRefreshPromise;
  }

  _refreshModelData(model) {
    var _this = this;

    return _asyncToGenerator(function* () {
      try {
        _this.inProgress = true;
        const fetchDataPromise = _this.fetchData(model);
        _this.lastFetchDataPromise = fetchDataPromise;
        const modelData = yield fetchDataPromise;
        // Since we re-fetch immediately when the model changes,
        // we need to ensure a fetch for an old active model
        // does not trample the newer fetch for the newer active model.
        if (fetchDataPromise === _this.lastFetchDataPromise) {
          _this.activeModel = model;
          _this.activeModelData = modelData;
          _this.didUpdate(model);
        }
      } finally {
        _this.inProgress = false;
        if (_this.pending) {
          _this.pending = false;
          _this.refreshModelData();
        }
      }
    })();
  }

  getActiveModel() {
    return this.activeModel;
  }

  getActiveModelData() {
    return this.activeModelData;
  }

  getLastModelDataRefreshPromise() {
    return this.lastModelDataRefreshPromise;
  }

  destroy() {
    if (this.activeModelUpdateSubscription) {
      this.activeModelUpdateSubscription.dispose();
    }
  }
};
exports.default = ModelObserver;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIm1vZGVsLW9ic2VydmVyLmpzIl0sIm5hbWVzIjpbIk1vZGVsT2JzZXJ2ZXIiLCJjb25zdHJ1Y3RvciIsImZldGNoRGF0YSIsImRpZFVwZGF0ZSIsImFjdGl2ZU1vZGVsIiwiYWN0aXZlTW9kZWxEYXRhIiwiYWN0aXZlTW9kZWxVcGRhdGVTdWJzY3JpcHRpb24iLCJpblByb2dyZXNzIiwicGVuZGluZyIsInNldEFjdGl2ZU1vZGVsIiwibW9kZWwiLCJkaXNwb3NlIiwib25EaWRVcGRhdGUiLCJyZWZyZXNoTW9kZWxEYXRhIiwibGFzdE1vZGVsRGF0YVJlZnJlc2hQcm9taXNlIiwiX3JlZnJlc2hNb2RlbERhdGEiLCJmZXRjaERhdGFQcm9taXNlIiwibGFzdEZldGNoRGF0YVByb21pc2UiLCJtb2RlbERhdGEiLCJnZXRBY3RpdmVNb2RlbCIsImdldEFjdGl2ZU1vZGVsRGF0YSIsImdldExhc3RNb2RlbERhdGFSZWZyZXNoUHJvbWlzZSIsImRlc3Ryb3kiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7O0lBQXFCQSxhLEdBQU4sTUFBTUEsYUFBTixDQUFvQjtBQUNqQ0Msb0JBQW9DO0FBQUEsUUFBdkJDLFNBQXVCLFFBQXZCQSxTQUF1QjtBQUFBLFFBQVpDLFNBQVksUUFBWkEsU0FBWTs7QUFDbEMsU0FBS0QsU0FBTCxHQUFpQkEsY0FBYyxNQUFNLENBQUUsQ0FBdEIsQ0FBakI7QUFDQSxTQUFLQyxTQUFMLEdBQWlCQSxjQUFjLE1BQU0sQ0FBRSxDQUF0QixDQUFqQjtBQUNBLFNBQUtDLFdBQUwsR0FBbUIsSUFBbkI7QUFDQSxTQUFLQyxlQUFMLEdBQXVCLElBQXZCO0FBQ0EsU0FBS0MsNkJBQUwsR0FBcUMsSUFBckM7QUFDQSxTQUFLQyxVQUFMLEdBQWtCLEtBQWxCO0FBQ0EsU0FBS0MsT0FBTCxHQUFlLEtBQWY7QUFDRDs7QUFFREMsaUJBQWVDLEtBQWYsRUFBc0I7QUFDcEIsUUFBSUEsVUFBVSxLQUFLTixXQUFuQixFQUFnQztBQUM5QixVQUFJLEtBQUtFLDZCQUFULEVBQXdDO0FBQ3RDLGFBQUtBLDZCQUFMLENBQW1DSyxPQUFuQztBQUNBLGFBQUtMLDZCQUFMLEdBQXFDLElBQXJDO0FBQ0Q7QUFDRCxXQUFLRixXQUFMLEdBQW1CTSxLQUFuQjtBQUNBLFdBQUtMLGVBQUwsR0FBdUIsSUFBdkI7QUFDQSxXQUFLRSxVQUFMLEdBQWtCLEtBQWxCO0FBQ0EsV0FBS0MsT0FBTCxHQUFlLEtBQWY7QUFDQSxXQUFLTCxTQUFMLENBQWVPLEtBQWY7QUFDQSxVQUFJQSxLQUFKLEVBQVc7QUFDVCxhQUFLSiw2QkFBTCxHQUFxQ0ksTUFBTUUsV0FBTixDQUFrQixNQUFNLEtBQUtDLGdCQUFMLENBQXNCSCxLQUF0QixDQUF4QixDQUFyQztBQUNBLGVBQU8sS0FBS0csZ0JBQUwsQ0FBc0JILEtBQXRCLENBQVA7QUFDRDtBQUNGO0FBQ0QsV0FBTyxJQUFQO0FBQ0Q7O0FBRURHLHFCQUEyQztBQUFBLFFBQTFCSCxLQUEwQix1RUFBbEIsS0FBS04sV0FBYTs7QUFDekMsUUFBSSxLQUFLRyxVQUFULEVBQXFCO0FBQ25CLFdBQUtDLE9BQUwsR0FBZSxJQUFmO0FBQ0EsYUFBTyxJQUFQO0FBQ0Q7QUFDRCxTQUFLTSwyQkFBTCxHQUFtQyxLQUFLQyxpQkFBTCxDQUF1QkwsS0FBdkIsQ0FBbkM7QUFDQSxXQUFPLEtBQUtJLDJCQUFaO0FBQ0Q7O0FBRUtDLG1CQUFOLENBQXdCTCxLQUF4QixFQUErQjtBQUFBOztBQUFBO0FBQzdCLFVBQUk7QUFDRixjQUFLSCxVQUFMLEdBQWtCLElBQWxCO0FBQ0EsY0FBTVMsbUJBQW1CLE1BQUtkLFNBQUwsQ0FBZVEsS0FBZixDQUF6QjtBQUNBLGNBQUtPLG9CQUFMLEdBQTRCRCxnQkFBNUI7QUFDQSxjQUFNRSxZQUFZLE1BQU1GLGdCQUF4QjtBQUNBO0FBQ0E7QUFDQTtBQUNBLFlBQUlBLHFCQUFxQixNQUFLQyxvQkFBOUIsRUFBb0Q7QUFDbEQsZ0JBQUtiLFdBQUwsR0FBbUJNLEtBQW5CO0FBQ0EsZ0JBQUtMLGVBQUwsR0FBdUJhLFNBQXZCO0FBQ0EsZ0JBQUtmLFNBQUwsQ0FBZU8sS0FBZjtBQUNEO0FBQ0YsT0FiRCxTQWFVO0FBQ1IsY0FBS0gsVUFBTCxHQUFrQixLQUFsQjtBQUNBLFlBQUksTUFBS0MsT0FBVCxFQUFrQjtBQUNoQixnQkFBS0EsT0FBTCxHQUFlLEtBQWY7QUFDQSxnQkFBS0ssZ0JBQUw7QUFDRDtBQUNGO0FBcEI0QjtBQXFCOUI7O0FBRURNLG1CQUFpQjtBQUNmLFdBQU8sS0FBS2YsV0FBWjtBQUNEOztBQUVEZ0IsdUJBQXFCO0FBQ25CLFdBQU8sS0FBS2YsZUFBWjtBQUNEOztBQUVEZ0IsbUNBQWlDO0FBQy9CLFdBQU8sS0FBS1AsMkJBQVo7QUFDRDs7QUFFRFEsWUFBVTtBQUNSLFFBQUksS0FBS2hCLDZCQUFULEVBQXdDO0FBQUUsV0FBS0EsNkJBQUwsQ0FBbUNLLE9BQW5DO0FBQStDO0FBQzFGO0FBNUVnQyxDO2tCQUFkWCxhIiwiZmlsZSI6Im1vZGVsLW9ic2VydmVyLmpzIiwic291cmNlUm9vdCI6Ii9ob21lL3RyYXZpcy9idWlsZC9hdG9tL2F0b20vb3V0L2FwcC9ub2RlX21vZHVsZXMvZ2l0aHViIiwic291cmNlc0NvbnRlbnQiOlsiZXhwb3J0IGRlZmF1bHQgY2xhc3MgTW9kZWxPYnNlcnZlciB7XG4gIGNvbnN0cnVjdG9yKHtmZXRjaERhdGEsIGRpZFVwZGF0ZX0pIHtcbiAgICB0aGlzLmZldGNoRGF0YSA9IGZldGNoRGF0YSB8fCAoKCkgPT4ge30pO1xuICAgIHRoaXMuZGlkVXBkYXRlID0gZGlkVXBkYXRlIHx8ICgoKSA9PiB7fSk7XG4gICAgdGhpcy5hY3RpdmVNb2RlbCA9IG51bGw7XG4gICAgdGhpcy5hY3RpdmVNb2RlbERhdGEgPSBudWxsO1xuICAgIHRoaXMuYWN0aXZlTW9kZWxVcGRhdGVTdWJzY3JpcHRpb24gPSBudWxsO1xuICAgIHRoaXMuaW5Qcm9ncmVzcyA9IGZhbHNlO1xuICAgIHRoaXMucGVuZGluZyA9IGZhbHNlO1xuICB9XG5cbiAgc2V0QWN0aXZlTW9kZWwobW9kZWwpIHtcbiAgICBpZiAobW9kZWwgIT09IHRoaXMuYWN0aXZlTW9kZWwpIHtcbiAgICAgIGlmICh0aGlzLmFjdGl2ZU1vZGVsVXBkYXRlU3Vic2NyaXB0aW9uKSB7XG4gICAgICAgIHRoaXMuYWN0aXZlTW9kZWxVcGRhdGVTdWJzY3JpcHRpb24uZGlzcG9zZSgpO1xuICAgICAgICB0aGlzLmFjdGl2ZU1vZGVsVXBkYXRlU3Vic2NyaXB0aW9uID0gbnVsbDtcbiAgICAgIH1cbiAgICAgIHRoaXMuYWN0aXZlTW9kZWwgPSBtb2RlbDtcbiAgICAgIHRoaXMuYWN0aXZlTW9kZWxEYXRhID0gbnVsbDtcbiAgICAgIHRoaXMuaW5Qcm9ncmVzcyA9IGZhbHNlO1xuICAgICAgdGhpcy5wZW5kaW5nID0gZmFsc2U7XG4gICAgICB0aGlzLmRpZFVwZGF0ZShtb2RlbCk7XG4gICAgICBpZiAobW9kZWwpIHtcbiAgICAgICAgdGhpcy5hY3RpdmVNb2RlbFVwZGF0ZVN1YnNjcmlwdGlvbiA9IG1vZGVsLm9uRGlkVXBkYXRlKCgpID0+IHRoaXMucmVmcmVzaE1vZGVsRGF0YShtb2RlbCkpO1xuICAgICAgICByZXR1cm4gdGhpcy5yZWZyZXNoTW9kZWxEYXRhKG1vZGVsKTtcbiAgICAgIH1cbiAgICB9XG4gICAgcmV0dXJuIG51bGw7XG4gIH1cblxuICByZWZyZXNoTW9kZWxEYXRhKG1vZGVsID0gdGhpcy5hY3RpdmVNb2RlbCkge1xuICAgIGlmICh0aGlzLmluUHJvZ3Jlc3MpIHtcbiAgICAgIHRoaXMucGVuZGluZyA9IHRydWU7XG4gICAgICByZXR1cm4gbnVsbDtcbiAgICB9XG4gICAgdGhpcy5sYXN0TW9kZWxEYXRhUmVmcmVzaFByb21pc2UgPSB0aGlzLl9yZWZyZXNoTW9kZWxEYXRhKG1vZGVsKTtcbiAgICByZXR1cm4gdGhpcy5sYXN0TW9kZWxEYXRhUmVmcmVzaFByb21pc2U7XG4gIH1cblxuICBhc3luYyBfcmVmcmVzaE1vZGVsRGF0YShtb2RlbCkge1xuICAgIHRyeSB7XG4gICAgICB0aGlzLmluUHJvZ3Jlc3MgPSB0cnVlO1xuICAgICAgY29uc3QgZmV0Y2hEYXRhUHJvbWlzZSA9IHRoaXMuZmV0Y2hEYXRhKG1vZGVsKTtcbiAgICAgIHRoaXMubGFzdEZldGNoRGF0YVByb21pc2UgPSBmZXRjaERhdGFQcm9taXNlO1xuICAgICAgY29uc3QgbW9kZWxEYXRhID0gYXdhaXQgZmV0Y2hEYXRhUHJvbWlzZTtcbiAgICAgIC8vIFNpbmNlIHdlIHJlLWZldGNoIGltbWVkaWF0ZWx5IHdoZW4gdGhlIG1vZGVsIGNoYW5nZXMsXG4gICAgICAvLyB3ZSBuZWVkIHRvIGVuc3VyZSBhIGZldGNoIGZvciBhbiBvbGQgYWN0aXZlIG1vZGVsXG4gICAgICAvLyBkb2VzIG5vdCB0cmFtcGxlIHRoZSBuZXdlciBmZXRjaCBmb3IgdGhlIG5ld2VyIGFjdGl2ZSBtb2RlbC5cbiAgICAgIGlmIChmZXRjaERhdGFQcm9taXNlID09PSB0aGlzLmxhc3RGZXRjaERhdGFQcm9taXNlKSB7XG4gICAgICAgIHRoaXMuYWN0aXZlTW9kZWwgPSBtb2RlbDtcbiAgICAgICAgdGhpcy5hY3RpdmVNb2RlbERhdGEgPSBtb2RlbERhdGE7XG4gICAgICAgIHRoaXMuZGlkVXBkYXRlKG1vZGVsKTtcbiAgICAgIH1cbiAgICB9IGZpbmFsbHkge1xuICAgICAgdGhpcy5pblByb2dyZXNzID0gZmFsc2U7XG4gICAgICBpZiAodGhpcy5wZW5kaW5nKSB7XG4gICAgICAgIHRoaXMucGVuZGluZyA9IGZhbHNlO1xuICAgICAgICB0aGlzLnJlZnJlc2hNb2RlbERhdGEoKTtcbiAgICAgIH1cbiAgICB9XG4gIH1cblxuICBnZXRBY3RpdmVNb2RlbCgpIHtcbiAgICByZXR1cm4gdGhpcy5hY3RpdmVNb2RlbDtcbiAgfVxuXG4gIGdldEFjdGl2ZU1vZGVsRGF0YSgpIHtcbiAgICByZXR1cm4gdGhpcy5hY3RpdmVNb2RlbERhdGE7XG4gIH1cblxuICBnZXRMYXN0TW9kZWxEYXRhUmVmcmVzaFByb21pc2UoKSB7XG4gICAgcmV0dXJuIHRoaXMubGFzdE1vZGVsRGF0YVJlZnJlc2hQcm9taXNlO1xuICB9XG5cbiAgZGVzdHJveSgpIHtcbiAgICBpZiAodGhpcy5hY3RpdmVNb2RlbFVwZGF0ZVN1YnNjcmlwdGlvbikgeyB0aGlzLmFjdGl2ZU1vZGVsVXBkYXRlU3Vic2NyaXB0aW9uLmRpc3Bvc2UoKTsgfVxuICB9XG59XG4iXX0=