'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
let Hunk = class Hunk {
  constructor(oldStartRow, newStartRow, oldRowCount, newRowCount, sectionHeading, lines) {
    this.oldStartRow = oldStartRow;
    this.newStartRow = newStartRow;
    this.oldRowCount = oldRowCount;
    this.newRowCount = newRowCount;
    this.sectionHeading = sectionHeading;
    this.lines = lines;
  }

  copy() {
    return new Hunk(this.getOldStartRow(), this.getNewStartRow(), this.getOldRowCount(), this.getNewRowCount(), this.getSectionHeading(), this.getLines().map(l => l.copy()));
  }

  getOldStartRow() {
    return this.oldStartRow;
  }

  getNewStartRow() {
    return this.newStartRow;
  }

  getOldRowCount() {
    return this.oldRowCount;
  }

  getNewRowCount() {
    return this.newRowCount;
  }

  getLines() {
    return this.lines;
  }

  getHeader() {
    return `@@ -${this.oldStartRow},${this.oldRowCount} +${this.newStartRow},${this.newRowCount} @@\n`;
  }

  getSectionHeading() {
    return this.sectionHeading;
  }

  invert() {
    const invertedLines = [];
    let addedLines = [];
    for (const line of this.getLines()) {
      const invertedLine = line.invert();
      if (invertedLine.getStatus() === 'added') {
        addedLines.push(invertedLine);
      } else if (invertedLine.getStatus() === 'deleted') {
        invertedLines.push(invertedLine);
      } else {
        invertedLines.push(...addedLines);
        invertedLines.push(invertedLine);
        addedLines = [];
      }
    }
    invertedLines.push(...addedLines);
    return new Hunk(this.getNewStartRow(), this.getOldStartRow(), this.getNewRowCount(), this.getOldRowCount(), this.getSectionHeading(), invertedLines);
  }

  toString() {
    return this.getLines().reduce((a, b) => a + b.toString() + '\n', this.getHeader());
  }
};
exports.default = Hunk;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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