'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.InMemoryStrategy = exports.SecurityBinaryStrategy = exports.KeytarStrategy = exports.UNAUTHENTICATED = undefined;

var _child_process = require('child_process');

var _keytar = require('keytar');

var _keytar2 = _interopRequireDefault(_keytar);

var _eventKit = require('event-kit');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

const UNAUTHENTICATED = exports.UNAUTHENTICATED = Symbol('UNAUTHENTICATED');

let KeytarStrategy = exports.KeytarStrategy = class KeytarStrategy {
  static isValid() {
    return _asyncToGenerator(function* () {
      try {
        const rand = Math.floor(Math.random() * 10e20).toString(16);
        yield _keytar2.default.setPassword('atom-test-service', rand, rand);
        const pass = yield _keytar2.default.getPassword('atom-test-service', rand);
        const success = pass === rand;
        _keytar2.default.deletePassword('atom-test-service', rand);
        return success;
      } catch (err) {
        return false;
      }
    })();
  }

  getPassword(service, account) {
    return _keytar2.default.getPassword(service, account);
  }

  replacePassword(service, account, password) {
    return _keytar2.default.setPassword(service, account, password);
  }

  deletePassword(service, account) {
    return _keytar2.default.deletePassword(service, account);
  }
};
let SecurityBinaryStrategy = exports.SecurityBinaryStrategy = class SecurityBinaryStrategy {
  static isValid() {
    return process.platform === 'darwin';
  }

  getPassword(service, account) {
    var _this = this;

    return _asyncToGenerator(function* () {
      try {
        const password = yield _this.exec(['find-generic-password', '-s', service, '-a', account, '-w']);
        return password.trim() || UNAUTHENTICATED;
      } catch (err) {
        return UNAUTHENTICATED;
      }
    })();
  }

  replacePassword(service, account, newPassword) {
    return this.exec(['add-generic-password', '-s', service, '-a', account, '-w', newPassword, '-U']);
  }

  deletePassword(service, account) {
    return this.exec(['delete-generic-password', '-s', service, '-a', account]);
  }

  exec(securityArgs) {
    var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : { binary: 'security' };

    let binary = _ref.binary;

    return new Promise((resolve, reject) => {
      (0, _child_process.execFile)(binary, securityArgs, (error, stdout) => {
        if (error) {
          return reject(error);
        }
        return resolve(stdout);
      });
    });
  }
};
let InMemoryStrategy = exports.InMemoryStrategy = class InMemoryStrategy {
  static isValid() {
    return true;
  }

  constructor() {
    if (!atom.inSpecMode()) {
      // eslint-disable-next-line no-console
      console.warn('Using an InMemoryStrategy strategy for storing tokens. ' + 'The tokens will only be stored for the current window.');
    }
    this.passwordsByService = new Map();
  }

  getPassword(service, account) {
    const passwords = this.passwordsByService.get(service) || new Map();
    const password = passwords.get(account);
    return password || UNAUTHENTICATED;
  }

  replacePassword(service, account, newPassword) {
    const passwords = this.passwordsByService.get(service) || new Map();
    passwords.set(account, newPassword);
    this.passwordsByService.set(service, passwords);
  }

  deletePassword(service, account) {
    const passwords = this.passwordsByService.get(service);
    if (passwords) {
      passwords.delete(account);
    }
  }
};


let instance = null;
const strategies = [KeytarStrategy, SecurityBinaryStrategy, InMemoryStrategy];
let GithubLoginModel = class GithubLoginModel {
  static get() {
    if (!instance) {
      instance = new GithubLoginModel();
    }
    return instance;
  }

  constructor(Strategy) {
    this._Strategy = Strategy;
    this._strategy = null;
    this.emitter = new _eventKit.Emitter();
  }

  getStrategy() {
    var _this2 = this;

    return _asyncToGenerator(function* () {
      if (_this2._strategy) {
        return _this2._strategy;
      }

      if (_this2._Strategy) {
        _this2._strategy = new _this2._Strategy();
        return _this2._strategy;
      }

      let Strategy;
      for (let i = 0; i < strategies.length; i++) {
        const strat = strategies[i];
        const isValid = yield strat.isValid();
        if (isValid) {
          Strategy = strat;
          break;
        }
      }
      // const Strategy = this._Strategy || strategies.find(strat => strat.isValid());
      if (!Strategy) {
        throw new Error('None of the listed GithubLoginModel strategies returned true for `isValid`');
      }
      _this2._strategy = new Strategy();
      return _this2._strategy;
    })();
  }

  getToken(account) {
    var _this3 = this;

    return _asyncToGenerator(function* () {
      const strategy = yield _this3.getStrategy();
      let password = yield strategy.getPassword('atom-github', account);
      if (!password) {
        // User is not logged in
        password = UNAUTHENTICATED;
      }
      return password;
    })();
  }

  setToken(account, token) {
    var _this4 = this;

    return _asyncToGenerator(function* () {
      const strategy = yield _this4.getStrategy();
      yield strategy.replacePassword('atom-github', account, token);
      _this4.didUpdate();
    })();
  }

  removeToken(account) {
    var _this5 = this;

    return _asyncToGenerator(function* () {
      const strategy = yield _this5.getStrategy();
      yield strategy.deletePassword('atom-github', account);
      _this5.didUpdate();
    })();
  }

  didUpdate() {
    this.emitter.emit('did-update');
  }

  onDidUpdate(cb) {
    return this.emitter.on('did-update', cb);
  }

  destroy() {
    this.emitter.dispose();
  }
};
exports.default = GithubLoginModel;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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