"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

let PartialFileDiscardHistory = exports.PartialFileDiscardHistory = class PartialFileDiscardHistory {
  constructor(maxHistoryLength) {
    this.blobHistoryByFilePath = {};
    this.maxHistoryLength = maxHistoryLength || 60;
  }

  getHistoryForPath(filePath) {
    const history = this.blobHistoryByFilePath[filePath];
    if (history) {
      return history;
    } else {
      this.setHistoryForPath(filePath, []);
      return this.blobHistoryByFilePath[filePath];
    }
  }

  setHistoryForPath(filePath, history) {
    this.blobHistoryByFilePath[filePath] = history;
  }

  getHistory() {
    return this.blobHistoryByFilePath;
  }

  setHistory(history) {
    this.blobHistoryByFilePath = history;
  }

  popHistoryForPath(filePath) {
    return this.getHistoryForPath(filePath).pop();
  }

  addHistory(filePath, snapshots) {
    const history = this.getHistoryForPath(filePath);
    history.push(snapshots);
    if (history.length >= this.maxHistoryLength) {
      this.setHistoryForPath(filePath, history.slice(Math.ceil(this.maxHistoryLength / 2)));
    }
  }

  getLastSnapshotsForPath(filePath) {
    const history = this.getHistoryForPath(filePath);
    const snapshots = history[history.length - 1];
    if (!snapshots) {
      return null;
    }
    return _extends({ filePath }, snapshots);
  }

  clearHistoryForPath(filePath) {
    this.setHistoryForPath(filePath, []);
  }
};
let WholeFileDiscardHistory = exports.WholeFileDiscardHistory = class WholeFileDiscardHistory {
  constructor(maxHistoryLength) {
    this.blobHistory = [];
    this.maxHistoryLength = maxHistoryLength || 60;
  }

  getHistory() {
    return this.blobHistory;
  }

  setHistory(history) {
    this.blobHistory = history;
  }

  popHistory() {
    return this.getHistory().pop();
  }

  addHistory(snapshotsByPath) {
    const history = this.getHistory();
    history.push(snapshotsByPath);
    if (history.length >= this.maxHistoryLength) {
      this.setHistory(history.slice(Math.ceil(this.maxHistoryLength / 2)));
    }
  }

  getLastSnapshots() {
    const history = this.getHistory();
    const snapshotsByPath = history[history.length - 1] || {};
    return Object.keys(snapshotsByPath).map(p => {
      return _extends({ filePath: p }, snapshotsByPath[p]);
    });
  }

  clearHistory() {
    this.setHistory([]);
  }
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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