'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
let Source = class Source {
  constructor(name, uiString, cssClass) {
    this.name = name.toLowerCase();

    this.uiString = uiString;
    this.cssClass = cssClass;
  }

  when(actions) {
    const chosen = actions[this.name] || actions.default || (() => {
      throw new Error(`Unexpected conflict side source: ${this.name}`);
    });
    return chosen();
  }

  getName() {
    return this.name;
  }

  getCSSClass() {
    return this.cssClass;
  }

  getBannerCSSClass() {
    return this.cssClass + 'Banner';
  }

  getBlockCSSClass() {
    return this.cssClass + 'Block';
  }

  toUIString() {
    return this.uiString;
  }

  toString() {
    return `<Source: ${this.name.toUpperCase()}>`;
  }
};
const OURS = exports.OURS = new Source('OURS', 'our changes', 'github-ConflictOurs');
const THEIRS = exports.THEIRS = new Source('THEIRS', 'their changes', 'github-ConflictTheirs');
const BASE = exports.BASE = new Source('BASE', 'common ancestor', 'github-ConflictBase');
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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