'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _markerTools = require('./marker-tools');

let Banner = class Banner {
  constructor(editor, marker, description, originalText) {
    this.editor = editor;
    this.marker = marker;
    this.description = description;
    this.originalText = originalText;
  }

  getMarker() {
    return this.marker;
  }

  getRange() {
    return this.marker.getBufferRange();
  }

  isModified() {
    const chomp = line => line.replace(/\r?\n$/, '');

    const text = this.editor.getTextInBufferRange(this.marker.getBufferRange());
    return chomp(text) !== chomp(this.originalText);
  }

  revert() {
    const range = this.getMarker().getBufferRange();
    this.editor.setTextInBufferRange(range, this.originalText);
  }

  delete() {
    (0, _markerTools.deleteMarkerIn)(this.getMarker(), this.editor);
  }
};
exports.default = Banner;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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