'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
const DETACHED = {};

let Branch = class Branch {
  constructor(name) {
    let detached = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;

    this.name = name;
    this.detached = detached === DETACHED;
  }

  static createDetached(describe) {
    return new Branch(describe, DETACHED);
  }

  getName() {
    return this.name;
  }

  isDetached() {
    return this.detached;
  }

  isPresent() {
    return true;
  }
};
exports.default = Branch;
const nullBranch = exports.nullBranch = {
  getName() {
    return '';
  },

  isDetached() {
    return false;
  },

  isPresent() {
    return false;
  }
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImJyYW5jaC5qcyJdLCJuYW1lcyI6WyJERVRBQ0hFRCIsIkJyYW5jaCIsImNvbnN0cnVjdG9yIiwibmFtZSIsImRldGFjaGVkIiwiY3JlYXRlRGV0YWNoZWQiLCJkZXNjcmliZSIsImdldE5hbWUiLCJpc0RldGFjaGVkIiwiaXNQcmVzZW50IiwibnVsbEJyYW5jaCJdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSxNQUFNQSxXQUFXLEVBQWpCOztJQUVxQkMsTSxHQUFOLE1BQU1BLE1BQU4sQ0FBYTtBQUMxQkMsY0FBWUMsSUFBWixFQUFtQztBQUFBLFFBQWpCQyxRQUFpQix1RUFBTixJQUFNOztBQUNqQyxTQUFLRCxJQUFMLEdBQVlBLElBQVo7QUFDQSxTQUFLQyxRQUFMLEdBQWdCQSxhQUFhSixRQUE3QjtBQUNEOztBQUVELFNBQU9LLGNBQVAsQ0FBc0JDLFFBQXRCLEVBQWdDO0FBQzlCLFdBQU8sSUFBSUwsTUFBSixDQUFXSyxRQUFYLEVBQXFCTixRQUFyQixDQUFQO0FBQ0Q7O0FBRURPLFlBQVU7QUFDUixXQUFPLEtBQUtKLElBQVo7QUFDRDs7QUFFREssZUFBYTtBQUNYLFdBQU8sS0FBS0osUUFBWjtBQUNEOztBQUVESyxjQUFZO0FBQ1YsV0FBTyxJQUFQO0FBQ0Q7QUFwQnlCLEM7a0JBQVBSLE07QUF1QmQsTUFBTVMsa0NBQWE7QUFDeEJILFlBQVU7QUFDUixXQUFPLEVBQVA7QUFDRCxHQUh1Qjs7QUFLeEJDLGVBQWE7QUFDWCxXQUFPLEtBQVA7QUFDRCxHQVB1Qjs7QUFTeEJDLGNBQVk7QUFDVixXQUFPLEtBQVA7QUFDRDtBQVh1QixDQUFuQiIsImZpbGUiOiJicmFuY2guanMiLCJzb3VyY2VSb290IjoiL2hvbWUvdHJhdmlzL2J1aWxkL2F0b20vYXRvbS9vdXQvYXBwL25vZGVfbW9kdWxlcy9naXRodWIiLCJzb3VyY2VzQ29udGVudCI6WyJjb25zdCBERVRBQ0hFRCA9IHt9O1xuXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBCcmFuY2gge1xuICBjb25zdHJ1Y3RvcihuYW1lLCBkZXRhY2hlZCA9IG51bGwpIHtcbiAgICB0aGlzLm5hbWUgPSBuYW1lO1xuICAgIHRoaXMuZGV0YWNoZWQgPSBkZXRhY2hlZCA9PT0gREVUQUNIRUQ7XG4gIH1cblxuICBzdGF0aWMgY3JlYXRlRGV0YWNoZWQoZGVzY3JpYmUpIHtcbiAgICByZXR1cm4gbmV3IEJyYW5jaChkZXNjcmliZSwgREVUQUNIRUQpO1xuICB9XG5cbiAgZ2V0TmFtZSgpIHtcbiAgICByZXR1cm4gdGhpcy5uYW1lO1xuICB9XG5cbiAgaXNEZXRhY2hlZCgpIHtcbiAgICByZXR1cm4gdGhpcy5kZXRhY2hlZDtcbiAgfVxuXG4gIGlzUHJlc2VudCgpIHtcbiAgICByZXR1cm4gdHJ1ZTtcbiAgfVxufVxuXG5leHBvcnQgY29uc3QgbnVsbEJyYW5jaCA9IHtcbiAgZ2V0TmFtZSgpIHtcbiAgICByZXR1cm4gJyc7XG4gIH0sXG5cbiAgaXNEZXRhY2hlZCgpIHtcbiAgICByZXR1cm4gZmFsc2U7XG4gIH0sXG5cbiAgaXNQcmVzZW50KCkge1xuICAgIHJldHVybiBmYWxzZTtcbiAgfSxcbn07XG4iXX0=