'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.classNameForStatus = exports.isFileExecutable = undefined;

let isFileExecutable = exports.isFileExecutable = (() => {
  var _ref = _asyncToGenerator(function* (absoluteFilePath) {
    const stat = yield fsStat(absoluteFilePath);
    return stat.mode & _fsExtra2.default.constants.S_IXUSR; // eslint-disable-line no-bitwise
  });

  return function isFileExecutable(_x3) {
    return _ref.apply(this, arguments);
  };
})();

exports.getPackageRoot = getPackageRoot;
exports.getDugitePath = getDugitePath;
exports.isBinary = isBinary;
exports.firstImplementer = firstImplementer;
exports.readFile = readFile;
exports.fileExists = fileExists;
exports.writeFile = writeFile;
exports.deleteFileOrFolder = deleteFileOrFolder;
exports.copyFile = copyFile;
exports.getTempDir = getTempDir;
exports.fsStat = fsStat;
exports.mkdirs = mkdirs;
exports.shortenSha = shortenSha;
exports.normalizeGitHelperPath = normalizeGitHelperPath;
exports.toNativePathSep = toNativePathSep;
exports.toGitPathSep = toGitPathSep;

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _fsExtra = require('fs-extra');

var _fsExtra2 = _interopRequireDefault(_fsExtra);

var _temp = require('temp');

var _temp2 = _interopRequireDefault(_temp);

var _ncp = require('ncp');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

function getPackageRoot() {
  var _atom$getLoadSettings = atom.getLoadSettings();

  const resourcePath = _atom$getLoadSettings.resourcePath;

  const currentFileWasRequiredFromSnapshot = !_path2.default.isAbsolute(__dirname);
  if (currentFileWasRequiredFromSnapshot) {
    return _path2.default.join(resourcePath, 'node_modules', 'github');
  } else {
    const packageRoot = _path2.default.resolve(__dirname, '..');
    if (_path2.default.extname(resourcePath) === '.asar') {
      if (packageRoot.indexOf(resourcePath) === 0) {
        return _path2.default.join(`${resourcePath}.unpacked`, 'node_modules', 'github');
      }
    }
    return packageRoot;
  }
}

let DUGITE_PATH;
function getDugitePath() {
  if (!DUGITE_PATH) {
    DUGITE_PATH = require.resolve('dugite');
    if (!_path2.default.isAbsolute(DUGITE_PATH)) {
      // Assume we're snapshotted
      var _atom$getLoadSettings2 = atom.getLoadSettings();

      const resourcePath = _atom$getLoadSettings2.resourcePath;

      if (_path2.default.extname(resourcePath) === '.asar') {
        DUGITE_PATH = _path2.default.join(`${resourcePath}.unpacked`, 'node_modules', 'dugite');
      } else {
        DUGITE_PATH = _path2.default.join(resourcePath, 'node_modules', 'dugite');
      }
    }
  }

  return DUGITE_PATH;
}

function isBinary(data) {
  for (let i = 0; i < 50; i++) {
    const code = data.charCodeAt(i);
    // Char code 65533 is the "replacement character";
    // 8 and below are control characters.
    if (code === 65533 || code < 9) {
      return true;
    }
  }

  return false;
}

function descriptorsFromProto(proto) {
  return Object.getOwnPropertyNames(proto).reduce((acc, name) => {
    Object.assign(acc, {
      [name]: Reflect.getOwnPropertyDescriptor(proto, name)
    });
    return acc;
  }, {});
}

/**
 * Takes an array of targets and returns a proxy. The proxy intercepts property accessor calls and
 * returns the value of that property on the first object in `targets` where the target implements that property.
 */
function firstImplementer() {
  for (var _len = arguments.length, targets = Array(_len), _key = 0; _key < _len; _key++) {
    targets[_key] = arguments[_key];
  }

  return new Proxy({ __implementations: targets }, {
    get(target, name) {
      if (name === 'getImplementers') {
        return () => targets;
      }

      if (Reflect.has(target, name)) {
        return target[name];
      }

      const firstValidTarget = targets.find(t => Reflect.has(t, name));
      if (firstValidTarget) {
        return firstValidTarget[name];
      } else {
        return undefined;
      }
    },

    set(target, name, value) {
      const firstValidTarget = targets.find(t => Reflect.has(t, name));
      if (firstValidTarget) {
        // eslint-disable-next-line no-return-assign
        return firstValidTarget[name] = value;
      } else {
        // eslint-disable-next-line no-return-assign
        return target[name] = value;
      }
    },

    // Used by sinon
    getOwnPropertyDescriptor(target, name) {
      const firstValidTarget = targets.find(t => Reflect.getOwnPropertyDescriptor(t, name));
      const compositeOwnPropertyDescriptor = Reflect.getOwnPropertyDescriptor(target, name);
      if (firstValidTarget) {
        return Reflect.getOwnPropertyDescriptor(firstValidTarget, name);
      } else if (compositeOwnPropertyDescriptor) {
        return compositeOwnPropertyDescriptor;
      } else {
        return undefined;
      }
    },

    // Used by sinon
    getPrototypeOf(target) {
      return targets.reduceRight((acc, t) => {
        return Object.create(acc, descriptorsFromProto(Object.getPrototypeOf(t)));
      }, Object.prototype);
    }
  });
}

function readFile(absoluteFilePath) {
  let encoding = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'utf8';

  return new Promise((resolve, reject) => {
    _fsExtra2.default.readFile(absoluteFilePath, encoding, (err, contents) => {
      if (err) {
        reject(err);
      } else {
        resolve(contents);
      }
    });
  });
}

function fileExists(absoluteFilePath) {
  return new Promise((resolve, reject) => {
    _fsExtra2.default.access(absoluteFilePath, err => {
      if (err) {
        if (err.code === 'ENOENT') {
          resolve(false);
        } else {
          reject(err);
        }
      } else {
        resolve(true);
      }
    });
  });
}

function writeFile(absoluteFilePath, contents) {
  return new Promise((resolve, reject) => {
    _fsExtra2.default.writeFile(absoluteFilePath, contents, err => {
      if (err) {
        return reject(err);
      } else {
        return resolve();
      }
    });
  });
}

function deleteFileOrFolder(fileOrFolder) {
  return new Promise((resolve, reject) => {
    _fsExtra2.default.remove(fileOrFolder, err => {
      if (err) {
        return reject(err);
      } else {
        return resolve();
      }
    });
  });
}

function copyFile(source, target) {
  return new Promise((resolve, reject) => {
    (0, _ncp.ncp)(source, target, err => {
      if (err) {
        return reject(err);
      } else {
        return resolve(target);
      }
    });
  });
}

function getTempDir() {
  let prefix = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';

  return new Promise((resolve, reject) => {
    _temp2.default.mkdir(prefix, (tempError, folder) => {
      if (tempError) {
        reject(tempError);
        return;
      }

      _fsExtra2.default.realpath(folder, (realError, rpath) => realError ? reject(realError) : resolve(rpath));
    });
  });
}

function fsStat(absoluteFilePath) {
  return new Promise((resolve, reject) => {
    _fsExtra2.default.stat(absoluteFilePath, (err, stats) => {
      if (err) {
        reject(err);
      } else {
        resolve(stats);
      }
    });
  });
}

function mkdirs(directory) {
  return new Promise((resolve, reject) => {
    _fsExtra2.default.mkdirs(directory, err => err ? reject(err) : resolve());
  });
}

function shortenSha(sha) {
  return sha.slice(0, 8);
}

const classNameForStatus = exports.classNameForStatus = {
  added: 'added',
  deleted: 'removed',
  modified: 'modified',
  equivalent: 'ignored'
};

/*
 * Apply any platform-specific munging to a path before presenting it as
 * a git environment variable or option.
 *
 * Convert a Windows-style "C:\foo\bar\baz" path to a "/c/foo/bar/baz" UNIX-y
 * path that the sh.exe used to execute git's credential helpers will
 * understand.
 */
function normalizeGitHelperPath(inPath) {
  if (process.platform === 'win32') {
    return inPath.replace(/\\/g, '/').replace(/^([^:]+):/, '/$1');
  } else {
    return inPath;
  }
}

/*
 * On Windows, git commands report paths with / delimiters. Convert them to \-delimited paths
 * so that Atom unifromly treats paths with native path separators.
 */
function toNativePathSep(rawPath) {
  if (process.platform !== 'win32') {
    return rawPath;
  } else {
    return rawPath.split('/').join(_path2.default.sep);
  }
}

/*
 * Convert Windows paths back to /-delimited paths to be presented to git.
 */
function toGitPathSep(rawPath) {
  if (process.platform !== 'win32') {
    return rawPath;
  } else {
    return rawPath.split(_path2.default.sep).join('/');
  }
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImhlbHBlcnMuanMiXSwibmFtZXMiOlsiYWJzb2x1dGVGaWxlUGF0aCIsInN0YXQiLCJmc1N0YXQiLCJtb2RlIiwiY29uc3RhbnRzIiwiU19JWFVTUiIsImlzRmlsZUV4ZWN1dGFibGUiLCJnZXRQYWNrYWdlUm9vdCIsImdldER1Z2l0ZVBhdGgiLCJpc0JpbmFyeSIsImZpcnN0SW1wbGVtZW50ZXIiLCJyZWFkRmlsZSIsImZpbGVFeGlzdHMiLCJ3cml0ZUZpbGUiLCJkZWxldGVGaWxlT3JGb2xkZXIiLCJjb3B5RmlsZSIsImdldFRlbXBEaXIiLCJta2RpcnMiLCJzaG9ydGVuU2hhIiwibm9ybWFsaXplR2l0SGVscGVyUGF0aCIsInRvTmF0aXZlUGF0aFNlcCIsInRvR2l0UGF0aFNlcCIsImF0b20iLCJnZXRMb2FkU2V0dGluZ3MiLCJyZXNvdXJjZVBhdGgiLCJjdXJyZW50RmlsZVdhc1JlcXVpcmVkRnJvbVNuYXBzaG90IiwiaXNBYnNvbHV0ZSIsIl9fZGlybmFtZSIsImpvaW4iLCJwYWNrYWdlUm9vdCIsInJlc29sdmUiLCJleHRuYW1lIiwiaW5kZXhPZiIsIkRVR0lURV9QQVRIIiwicmVxdWlyZSIsImRhdGEiLCJpIiwiY29kZSIsImNoYXJDb2RlQXQiLCJkZXNjcmlwdG9yc0Zyb21Qcm90byIsInByb3RvIiwiT2JqZWN0IiwiZ2V0T3duUHJvcGVydHlOYW1lcyIsInJlZHVjZSIsImFjYyIsIm5hbWUiLCJhc3NpZ24iLCJSZWZsZWN0IiwiZ2V0T3duUHJvcGVydHlEZXNjcmlwdG9yIiwidGFyZ2V0cyIsIlByb3h5IiwiX19pbXBsZW1lbnRhdGlvbnMiLCJnZXQiLCJ0YXJnZXQiLCJoYXMiLCJmaXJzdFZhbGlkVGFyZ2V0IiwiZmluZCIsInQiLCJ1bmRlZmluZWQiLCJzZXQiLCJ2YWx1ZSIsImNvbXBvc2l0ZU93blByb3BlcnR5RGVzY3JpcHRvciIsImdldFByb3RvdHlwZU9mIiwicmVkdWNlUmlnaHQiLCJjcmVhdGUiLCJwcm90b3R5cGUiLCJlbmNvZGluZyIsIlByb21pc2UiLCJyZWplY3QiLCJlcnIiLCJjb250ZW50cyIsImFjY2VzcyIsImZpbGVPckZvbGRlciIsInJlbW92ZSIsInNvdXJjZSIsInByZWZpeCIsIm1rZGlyIiwidGVtcEVycm9yIiwiZm9sZGVyIiwicmVhbHBhdGgiLCJyZWFsRXJyb3IiLCJycGF0aCIsInN0YXRzIiwiZGlyZWN0b3J5Iiwic2hhIiwic2xpY2UiLCJjbGFzc05hbWVGb3JTdGF0dXMiLCJhZGRlZCIsImRlbGV0ZWQiLCJtb2RpZmllZCIsImVxdWl2YWxlbnQiLCJpblBhdGgiLCJwcm9jZXNzIiwicGxhdGZvcm0iLCJyZXBsYWNlIiwicmF3UGF0aCIsInNwbGl0Iiwic2VwIl0sIm1hcHBpbmdzIjoiOzs7Ozs7OzsrQkEwTE8sV0FBZ0NBLGdCQUFoQyxFQUFrRDtBQUN2RCxVQUFNQyxPQUFPLE1BQU1DLE9BQU9GLGdCQUFQLENBQW5CO0FBQ0EsV0FBT0MsS0FBS0UsSUFBTCxHQUFZLGtCQUFHQyxTQUFILENBQWFDLE9BQWhDLENBRnVELENBRWQ7QUFDMUMsRzs7a0JBSHFCQyxnQjs7Ozs7UUFyTE5DLGMsR0FBQUEsYztRQWlCQUMsYSxHQUFBQSxhO1FBaUJBQyxRLEdBQUFBLFE7UUEwQkFDLGdCLEdBQUFBLGdCO1FBb0RBQyxRLEdBQUFBLFE7UUFRQUMsVSxHQUFBQSxVO1FBZ0JBQyxTLEdBQUFBLFM7UUFRQUMsa0IsR0FBQUEsa0I7UUFRQUMsUSxHQUFBQSxRO1FBUUFDLFUsR0FBQUEsVTtRQWFBZCxNLEdBQUFBLE07UUFhQWUsTSxHQUFBQSxNO1FBTUFDLFUsR0FBQUEsVTtRQW1CQUMsc0IsR0FBQUEsc0I7UUFZQUMsZSxHQUFBQSxlO1FBV0FDLFksR0FBQUEsWTs7QUEvT2hCOzs7O0FBQ0E7Ozs7QUFDQTs7OztBQUNBOzs7Ozs7QUFFTyxTQUFTZCxjQUFULEdBQTBCO0FBQUEsOEJBQ1JlLEtBQUtDLGVBQUwsRUFEUTs7QUFBQSxRQUN4QkMsWUFEd0IseUJBQ3hCQSxZQUR3Qjs7QUFFL0IsUUFBTUMscUNBQXFDLENBQUMsZUFBS0MsVUFBTCxDQUFnQkMsU0FBaEIsQ0FBNUM7QUFDQSxNQUFJRixrQ0FBSixFQUF3QztBQUN0QyxXQUFPLGVBQUtHLElBQUwsQ0FBVUosWUFBVixFQUF3QixjQUF4QixFQUF3QyxRQUF4QyxDQUFQO0FBQ0QsR0FGRCxNQUVPO0FBQ0wsVUFBTUssY0FBYyxlQUFLQyxPQUFMLENBQWFILFNBQWIsRUFBd0IsSUFBeEIsQ0FBcEI7QUFDQSxRQUFJLGVBQUtJLE9BQUwsQ0FBYVAsWUFBYixNQUErQixPQUFuQyxFQUE0QztBQUMxQyxVQUFJSyxZQUFZRyxPQUFaLENBQW9CUixZQUFwQixNQUFzQyxDQUExQyxFQUE2QztBQUMzQyxlQUFPLGVBQUtJLElBQUwsQ0FBVyxHQUFFSixZQUFhLFdBQTFCLEVBQXNDLGNBQXRDLEVBQXNELFFBQXRELENBQVA7QUFDRDtBQUNGO0FBQ0QsV0FBT0ssV0FBUDtBQUNEO0FBQ0Y7O0FBRUQsSUFBSUksV0FBSjtBQUNPLFNBQVN6QixhQUFULEdBQXlCO0FBQzlCLE1BQUksQ0FBQ3lCLFdBQUwsRUFBa0I7QUFDaEJBLGtCQUFjQyxRQUFRSixPQUFSLENBQWdCLFFBQWhCLENBQWQ7QUFDQSxRQUFJLENBQUMsZUFBS0osVUFBTCxDQUFnQk8sV0FBaEIsQ0FBTCxFQUFtQztBQUNqQztBQURpQyxtQ0FFVlgsS0FBS0MsZUFBTCxFQUZVOztBQUFBLFlBRTFCQyxZQUYwQiwwQkFFMUJBLFlBRjBCOztBQUdqQyxVQUFJLGVBQUtPLE9BQUwsQ0FBYVAsWUFBYixNQUErQixPQUFuQyxFQUE0QztBQUMxQ1Msc0JBQWMsZUFBS0wsSUFBTCxDQUFXLEdBQUVKLFlBQWEsV0FBMUIsRUFBc0MsY0FBdEMsRUFBc0QsUUFBdEQsQ0FBZDtBQUNELE9BRkQsTUFFTztBQUNMUyxzQkFBYyxlQUFLTCxJQUFMLENBQVVKLFlBQVYsRUFBd0IsY0FBeEIsRUFBd0MsUUFBeEMsQ0FBZDtBQUNEO0FBQ0Y7QUFDRjs7QUFFRCxTQUFPUyxXQUFQO0FBQ0Q7O0FBRU0sU0FBU3hCLFFBQVQsQ0FBa0IwQixJQUFsQixFQUF3QjtBQUM3QixPQUFLLElBQUlDLElBQUksQ0FBYixFQUFnQkEsSUFBSSxFQUFwQixFQUF3QkEsR0FBeEIsRUFBNkI7QUFDM0IsVUFBTUMsT0FBT0YsS0FBS0csVUFBTCxDQUFnQkYsQ0FBaEIsQ0FBYjtBQUNBO0FBQ0E7QUFDQSxRQUFJQyxTQUFTLEtBQVQsSUFBa0JBLE9BQU8sQ0FBN0IsRUFBZ0M7QUFDOUIsYUFBTyxJQUFQO0FBQ0Q7QUFDRjs7QUFFRCxTQUFPLEtBQVA7QUFDRDs7QUFFRCxTQUFTRSxvQkFBVCxDQUE4QkMsS0FBOUIsRUFBcUM7QUFDbkMsU0FBT0MsT0FBT0MsbUJBQVAsQ0FBMkJGLEtBQTNCLEVBQWtDRyxNQUFsQyxDQUF5QyxDQUFDQyxHQUFELEVBQU1DLElBQU4sS0FBZTtBQUM3REosV0FBT0ssTUFBUCxDQUFjRixHQUFkLEVBQW1CO0FBQ2pCLE9BQUNDLElBQUQsR0FBUUUsUUFBUUMsd0JBQVIsQ0FBaUNSLEtBQWpDLEVBQXdDSyxJQUF4QztBQURTLEtBQW5CO0FBR0EsV0FBT0QsR0FBUDtBQUNELEdBTE0sRUFLSixFQUxJLENBQVA7QUFNRDs7QUFFRDs7OztBQUlPLFNBQVNsQyxnQkFBVCxHQUFzQztBQUFBLG9DQUFUdUMsT0FBUztBQUFUQSxXQUFTO0FBQUE7O0FBQzNDLFNBQU8sSUFBSUMsS0FBSixDQUFVLEVBQUNDLG1CQUFtQkYsT0FBcEIsRUFBVixFQUF3QztBQUM3Q0csUUFBSUMsTUFBSixFQUFZUixJQUFaLEVBQWtCO0FBQ2hCLFVBQUlBLFNBQVMsaUJBQWIsRUFBZ0M7QUFDOUIsZUFBTyxNQUFNSSxPQUFiO0FBQ0Q7O0FBRUQsVUFBSUYsUUFBUU8sR0FBUixDQUFZRCxNQUFaLEVBQW9CUixJQUFwQixDQUFKLEVBQStCO0FBQzdCLGVBQU9RLE9BQU9SLElBQVAsQ0FBUDtBQUNEOztBQUVELFlBQU1VLG1CQUFtQk4sUUFBUU8sSUFBUixDQUFhQyxLQUFLVixRQUFRTyxHQUFSLENBQVlHLENBQVosRUFBZVosSUFBZixDQUFsQixDQUF6QjtBQUNBLFVBQUlVLGdCQUFKLEVBQXNCO0FBQ3BCLGVBQU9BLGlCQUFpQlYsSUFBakIsQ0FBUDtBQUNELE9BRkQsTUFFTztBQUNMLGVBQU9hLFNBQVA7QUFDRDtBQUNGLEtBaEI0Qzs7QUFrQjdDQyxRQUFJTixNQUFKLEVBQVlSLElBQVosRUFBa0JlLEtBQWxCLEVBQXlCO0FBQ3ZCLFlBQU1MLG1CQUFtQk4sUUFBUU8sSUFBUixDQUFhQyxLQUFLVixRQUFRTyxHQUFSLENBQVlHLENBQVosRUFBZVosSUFBZixDQUFsQixDQUF6QjtBQUNBLFVBQUlVLGdCQUFKLEVBQXNCO0FBQ3BCO0FBQ0EsZUFBT0EsaUJBQWlCVixJQUFqQixJQUF5QmUsS0FBaEM7QUFDRCxPQUhELE1BR087QUFDTDtBQUNBLGVBQU9QLE9BQU9SLElBQVAsSUFBZWUsS0FBdEI7QUFDRDtBQUNGLEtBM0I0Qzs7QUE2QjdDO0FBQ0FaLDZCQUF5QkssTUFBekIsRUFBaUNSLElBQWpDLEVBQXVDO0FBQ3JDLFlBQU1VLG1CQUFtQk4sUUFBUU8sSUFBUixDQUFhQyxLQUFLVixRQUFRQyx3QkFBUixDQUFpQ1MsQ0FBakMsRUFBb0NaLElBQXBDLENBQWxCLENBQXpCO0FBQ0EsWUFBTWdCLGlDQUFpQ2QsUUFBUUMsd0JBQVIsQ0FBaUNLLE1BQWpDLEVBQXlDUixJQUF6QyxDQUF2QztBQUNBLFVBQUlVLGdCQUFKLEVBQXNCO0FBQ3BCLGVBQU9SLFFBQVFDLHdCQUFSLENBQWlDTyxnQkFBakMsRUFBbURWLElBQW5ELENBQVA7QUFDRCxPQUZELE1BRU8sSUFBSWdCLDhCQUFKLEVBQW9DO0FBQ3pDLGVBQU9BLDhCQUFQO0FBQ0QsT0FGTSxNQUVBO0FBQ0wsZUFBT0gsU0FBUDtBQUNEO0FBQ0YsS0F4QzRDOztBQTBDN0M7QUFDQUksbUJBQWVULE1BQWYsRUFBdUI7QUFDckIsYUFBT0osUUFBUWMsV0FBUixDQUFvQixDQUFDbkIsR0FBRCxFQUFNYSxDQUFOLEtBQVk7QUFDckMsZUFBT2hCLE9BQU91QixNQUFQLENBQWNwQixHQUFkLEVBQW1CTCxxQkFBcUJFLE9BQU9xQixjQUFQLENBQXNCTCxDQUF0QixDQUFyQixDQUFuQixDQUFQO0FBQ0QsT0FGTSxFQUVKaEIsT0FBT3dCLFNBRkgsQ0FBUDtBQUdEO0FBL0M0QyxHQUF4QyxDQUFQO0FBaUREOztBQUVNLFNBQVN0RCxRQUFULENBQWtCWCxnQkFBbEIsRUFBdUQ7QUFBQSxNQUFuQmtFLFFBQW1CLHVFQUFSLE1BQVE7O0FBQzVELFNBQU8sSUFBSUMsT0FBSixDQUFZLENBQUNyQyxPQUFELEVBQVVzQyxNQUFWLEtBQXFCO0FBQ3RDLHNCQUFHekQsUUFBSCxDQUFZWCxnQkFBWixFQUE4QmtFLFFBQTlCLEVBQXdDLENBQUNHLEdBQUQsRUFBTUMsUUFBTixLQUFtQjtBQUN6RCxVQUFJRCxHQUFKLEVBQVM7QUFBRUQsZUFBT0MsR0FBUDtBQUFjLE9BQXpCLE1BQStCO0FBQUV2QyxnQkFBUXdDLFFBQVI7QUFBb0I7QUFDdEQsS0FGRDtBQUdELEdBSk0sQ0FBUDtBQUtEOztBQUVNLFNBQVMxRCxVQUFULENBQW9CWixnQkFBcEIsRUFBc0M7QUFDM0MsU0FBTyxJQUFJbUUsT0FBSixDQUFZLENBQUNyQyxPQUFELEVBQVVzQyxNQUFWLEtBQXFCO0FBQ3RDLHNCQUFHRyxNQUFILENBQVV2RSxnQkFBVixFQUE0QnFFLE9BQU87QUFDakMsVUFBSUEsR0FBSixFQUFTO0FBQ1AsWUFBSUEsSUFBSWhDLElBQUosS0FBYSxRQUFqQixFQUEyQjtBQUN6QlAsa0JBQVEsS0FBUjtBQUNELFNBRkQsTUFFTztBQUNMc0MsaUJBQU9DLEdBQVA7QUFDRDtBQUNGLE9BTkQsTUFNTztBQUNMdkMsZ0JBQVEsSUFBUjtBQUNEO0FBQ0YsS0FWRDtBQVdELEdBWk0sQ0FBUDtBQWFEOztBQUVNLFNBQVNqQixTQUFULENBQW1CYixnQkFBbkIsRUFBcUNzRSxRQUFyQyxFQUErQztBQUNwRCxTQUFPLElBQUlILE9BQUosQ0FBWSxDQUFDckMsT0FBRCxFQUFVc0MsTUFBVixLQUFxQjtBQUN0QyxzQkFBR3ZELFNBQUgsQ0FBYWIsZ0JBQWIsRUFBK0JzRSxRQUEvQixFQUF5Q0QsT0FBTztBQUM5QyxVQUFJQSxHQUFKLEVBQVM7QUFBRSxlQUFPRCxPQUFPQyxHQUFQLENBQVA7QUFBcUIsT0FBaEMsTUFBc0M7QUFBRSxlQUFPdkMsU0FBUDtBQUFtQjtBQUM1RCxLQUZEO0FBR0QsR0FKTSxDQUFQO0FBS0Q7O0FBRU0sU0FBU2hCLGtCQUFULENBQTRCMEQsWUFBNUIsRUFBMEM7QUFDL0MsU0FBTyxJQUFJTCxPQUFKLENBQVksQ0FBQ3JDLE9BQUQsRUFBVXNDLE1BQVYsS0FBcUI7QUFDdEMsc0JBQUdLLE1BQUgsQ0FBVUQsWUFBVixFQUF3QkgsT0FBTztBQUM3QixVQUFJQSxHQUFKLEVBQVM7QUFBRSxlQUFPRCxPQUFPQyxHQUFQLENBQVA7QUFBcUIsT0FBaEMsTUFBc0M7QUFBRSxlQUFPdkMsU0FBUDtBQUFtQjtBQUM1RCxLQUZEO0FBR0QsR0FKTSxDQUFQO0FBS0Q7O0FBRU0sU0FBU2YsUUFBVCxDQUFrQjJELE1BQWxCLEVBQTBCckIsTUFBMUIsRUFBa0M7QUFDdkMsU0FBTyxJQUFJYyxPQUFKLENBQVksQ0FBQ3JDLE9BQUQsRUFBVXNDLE1BQVYsS0FBcUI7QUFDdEMsa0JBQUlNLE1BQUosRUFBWXJCLE1BQVosRUFBb0JnQixPQUFPO0FBQ3pCLFVBQUlBLEdBQUosRUFBUztBQUFFLGVBQU9ELE9BQU9DLEdBQVAsQ0FBUDtBQUFxQixPQUFoQyxNQUFzQztBQUFFLGVBQU92QyxRQUFRdUIsTUFBUixDQUFQO0FBQXlCO0FBQ2xFLEtBRkQ7QUFHRCxHQUpNLENBQVA7QUFLRDs7QUFFTSxTQUFTckMsVUFBVCxHQUFpQztBQUFBLE1BQWIyRCxNQUFhLHVFQUFKLEVBQUk7O0FBQ3RDLFNBQU8sSUFBSVIsT0FBSixDQUFZLENBQUNyQyxPQUFELEVBQVVzQyxNQUFWLEtBQXFCO0FBQ3RDLG1CQUFLUSxLQUFMLENBQVdELE1BQVgsRUFBbUIsQ0FBQ0UsU0FBRCxFQUFZQyxNQUFaLEtBQXVCO0FBQ3hDLFVBQUlELFNBQUosRUFBZTtBQUNiVCxlQUFPUyxTQUFQO0FBQ0E7QUFDRDs7QUFFRCx3QkFBR0UsUUFBSCxDQUFZRCxNQUFaLEVBQW9CLENBQUNFLFNBQUQsRUFBWUMsS0FBWixLQUF1QkQsWUFBWVosT0FBT1ksU0FBUCxDQUFaLEdBQWdDbEQsUUFBUW1ELEtBQVIsQ0FBM0U7QUFDRCxLQVBEO0FBUUQsR0FUTSxDQUFQO0FBVUQ7O0FBRU0sU0FBUy9FLE1BQVQsQ0FBZ0JGLGdCQUFoQixFQUFrQztBQUN2QyxTQUFPLElBQUltRSxPQUFKLENBQVksQ0FBQ3JDLE9BQUQsRUFBVXNDLE1BQVYsS0FBcUI7QUFDdEMsc0JBQUduRSxJQUFILENBQVFELGdCQUFSLEVBQTBCLENBQUNxRSxHQUFELEVBQU1hLEtBQU4sS0FBZ0I7QUFDeEMsVUFBSWIsR0FBSixFQUFTO0FBQUVELGVBQU9DLEdBQVA7QUFBYyxPQUF6QixNQUErQjtBQUFFdkMsZ0JBQVFvRCxLQUFSO0FBQWlCO0FBQ25ELEtBRkQ7QUFHRCxHQUpNLENBQVA7QUFLRDs7QUFPTSxTQUFTakUsTUFBVCxDQUFnQmtFLFNBQWhCLEVBQTJCO0FBQ2hDLFNBQU8sSUFBSWhCLE9BQUosQ0FBWSxDQUFDckMsT0FBRCxFQUFVc0MsTUFBVixLQUFxQjtBQUN0QyxzQkFBR25ELE1BQUgsQ0FBVWtFLFNBQVYsRUFBcUJkLE9BQVFBLE1BQU1ELE9BQU9DLEdBQVAsQ0FBTixHQUFvQnZDLFNBQWpEO0FBQ0QsR0FGTSxDQUFQO0FBR0Q7O0FBRU0sU0FBU1osVUFBVCxDQUFvQmtFLEdBQXBCLEVBQXlCO0FBQzlCLFNBQU9BLElBQUlDLEtBQUosQ0FBVSxDQUFWLEVBQWEsQ0FBYixDQUFQO0FBQ0Q7O0FBRU0sTUFBTUMsa0RBQXFCO0FBQ2hDQyxTQUFPLE9BRHlCO0FBRWhDQyxXQUFTLFNBRnVCO0FBR2hDQyxZQUFVLFVBSHNCO0FBSWhDQyxjQUFZO0FBSm9CLENBQTNCOztBQU9QOzs7Ozs7OztBQVFPLFNBQVN2RSxzQkFBVCxDQUFnQ3dFLE1BQWhDLEVBQXdDO0FBQzdDLE1BQUlDLFFBQVFDLFFBQVIsS0FBcUIsT0FBekIsRUFBa0M7QUFDaEMsV0FBT0YsT0FBT0csT0FBUCxDQUFlLEtBQWYsRUFBc0IsR0FBdEIsRUFBMkJBLE9BQTNCLENBQW1DLFdBQW5DLEVBQWdELEtBQWhELENBQVA7QUFDRCxHQUZELE1BRU87QUFDTCxXQUFPSCxNQUFQO0FBQ0Q7QUFDRjs7QUFFRDs7OztBQUlPLFNBQVN2RSxlQUFULENBQXlCMkUsT0FBekIsRUFBa0M7QUFDdkMsTUFBSUgsUUFBUUMsUUFBUixLQUFxQixPQUF6QixFQUFrQztBQUNoQyxXQUFPRSxPQUFQO0FBQ0QsR0FGRCxNQUVPO0FBQ0wsV0FBT0EsUUFBUUMsS0FBUixDQUFjLEdBQWQsRUFBbUJwRSxJQUFuQixDQUF3QixlQUFLcUUsR0FBN0IsQ0FBUDtBQUNEO0FBQ0Y7O0FBRUQ7OztBQUdPLFNBQVM1RSxZQUFULENBQXNCMEUsT0FBdEIsRUFBK0I7QUFDcEMsTUFBSUgsUUFBUUMsUUFBUixLQUFxQixPQUF6QixFQUFrQztBQUNoQyxXQUFPRSxPQUFQO0FBQ0QsR0FGRCxNQUVPO0FBQ0wsV0FBT0EsUUFBUUMsS0FBUixDQUFjLGVBQUtDLEdBQW5CLEVBQXdCckUsSUFBeEIsQ0FBNkIsR0FBN0IsQ0FBUDtBQUNEO0FBQ0YiLCJmaWxlIjoiaGVscGVycy5qcyIsInNvdXJjZVJvb3QiOiIvaG9tZS90cmF2aXMvYnVpbGQvYXRvbS9hdG9tL291dC9hcHAvbm9kZV9tb2R1bGVzL2dpdGh1YiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBwYXRoIGZyb20gJ3BhdGgnO1xuaW1wb3J0IGZzIGZyb20gJ2ZzLWV4dHJhJztcbmltcG9ydCB0ZW1wIGZyb20gJ3RlbXAnO1xuaW1wb3J0IHtuY3B9IGZyb20gJ25jcCc7XG5cbmV4cG9ydCBmdW5jdGlvbiBnZXRQYWNrYWdlUm9vdCgpIHtcbiAgY29uc3Qge3Jlc291cmNlUGF0aH0gPSBhdG9tLmdldExvYWRTZXR0aW5ncygpO1xuICBjb25zdCBjdXJyZW50RmlsZVdhc1JlcXVpcmVkRnJvbVNuYXBzaG90ID0gIXBhdGguaXNBYnNvbHV0ZShfX2Rpcm5hbWUpO1xuICBpZiAoY3VycmVudEZpbGVXYXNSZXF1aXJlZEZyb21TbmFwc2hvdCkge1xuICAgIHJldHVybiBwYXRoLmpvaW4ocmVzb3VyY2VQYXRoLCAnbm9kZV9tb2R1bGVzJywgJ2dpdGh1YicpO1xuICB9IGVsc2Uge1xuICAgIGNvbnN0IHBhY2thZ2VSb290ID0gcGF0aC5yZXNvbHZlKF9fZGlybmFtZSwgJy4uJyk7XG4gICAgaWYgKHBhdGguZXh0bmFtZShyZXNvdXJjZVBhdGgpID09PSAnLmFzYXInKSB7XG4gICAgICBpZiAocGFja2FnZVJvb3QuaW5kZXhPZihyZXNvdXJjZVBhdGgpID09PSAwKSB7XG4gICAgICAgIHJldHVybiBwYXRoLmpvaW4oYCR7cmVzb3VyY2VQYXRofS51bnBhY2tlZGAsICdub2RlX21vZHVsZXMnLCAnZ2l0aHViJyk7XG4gICAgICB9XG4gICAgfVxuICAgIHJldHVybiBwYWNrYWdlUm9vdDtcbiAgfVxufVxuXG5sZXQgRFVHSVRFX1BBVEg7XG5leHBvcnQgZnVuY3Rpb24gZ2V0RHVnaXRlUGF0aCgpIHtcbiAgaWYgKCFEVUdJVEVfUEFUSCkge1xuICAgIERVR0lURV9QQVRIID0gcmVxdWlyZS5yZXNvbHZlKCdkdWdpdGUnKTtcbiAgICBpZiAoIXBhdGguaXNBYnNvbHV0ZShEVUdJVEVfUEFUSCkpIHtcbiAgICAgIC8vIEFzc3VtZSB3ZSdyZSBzbmFwc2hvdHRlZFxuICAgICAgY29uc3Qge3Jlc291cmNlUGF0aH0gPSBhdG9tLmdldExvYWRTZXR0aW5ncygpO1xuICAgICAgaWYgKHBhdGguZXh0bmFtZShyZXNvdXJjZVBhdGgpID09PSAnLmFzYXInKSB7XG4gICAgICAgIERVR0lURV9QQVRIID0gcGF0aC5qb2luKGAke3Jlc291cmNlUGF0aH0udW5wYWNrZWRgLCAnbm9kZV9tb2R1bGVzJywgJ2R1Z2l0ZScpO1xuICAgICAgfSBlbHNlIHtcbiAgICAgICAgRFVHSVRFX1BBVEggPSBwYXRoLmpvaW4ocmVzb3VyY2VQYXRoLCAnbm9kZV9tb2R1bGVzJywgJ2R1Z2l0ZScpO1xuICAgICAgfVxuICAgIH1cbiAgfVxuXG4gIHJldHVybiBEVUdJVEVfUEFUSDtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGlzQmluYXJ5KGRhdGEpIHtcbiAgZm9yIChsZXQgaSA9IDA7IGkgPCA1MDsgaSsrKSB7XG4gICAgY29uc3QgY29kZSA9IGRhdGEuY2hhckNvZGVBdChpKTtcbiAgICAvLyBDaGFyIGNvZGUgNjU1MzMgaXMgdGhlIFwicmVwbGFjZW1lbnQgY2hhcmFjdGVyXCI7XG4gICAgLy8gOCBhbmQgYmVsb3cgYXJlIGNvbnRyb2wgY2hhcmFjdGVycy5cbiAgICBpZiAoY29kZSA9PT0gNjU1MzMgfHwgY29kZSA8IDkpIHtcbiAgICAgIHJldHVybiB0cnVlO1xuICAgIH1cbiAgfVxuXG4gIHJldHVybiBmYWxzZTtcbn1cblxuZnVuY3Rpb24gZGVzY3JpcHRvcnNGcm9tUHJvdG8ocHJvdG8pIHtcbiAgcmV0dXJuIE9iamVjdC5nZXRPd25Qcm9wZXJ0eU5hbWVzKHByb3RvKS5yZWR1Y2UoKGFjYywgbmFtZSkgPT4ge1xuICAgIE9iamVjdC5hc3NpZ24oYWNjLCB7XG4gICAgICBbbmFtZV06IFJlZmxlY3QuZ2V0T3duUHJvcGVydHlEZXNjcmlwdG9yKHByb3RvLCBuYW1lKSxcbiAgICB9KTtcbiAgICByZXR1cm4gYWNjO1xuICB9LCB7fSk7XG59XG5cbi8qKlxuICogVGFrZXMgYW4gYXJyYXkgb2YgdGFyZ2V0cyBhbmQgcmV0dXJucyBhIHByb3h5LiBUaGUgcHJveHkgaW50ZXJjZXB0cyBwcm9wZXJ0eSBhY2Nlc3NvciBjYWxscyBhbmRcbiAqIHJldHVybnMgdGhlIHZhbHVlIG9mIHRoYXQgcHJvcGVydHkgb24gdGhlIGZpcnN0IG9iamVjdCBpbiBgdGFyZ2V0c2Agd2hlcmUgdGhlIHRhcmdldCBpbXBsZW1lbnRzIHRoYXQgcHJvcGVydHkuXG4gKi9cbmV4cG9ydCBmdW5jdGlvbiBmaXJzdEltcGxlbWVudGVyKC4uLnRhcmdldHMpIHtcbiAgcmV0dXJuIG5ldyBQcm94eSh7X19pbXBsZW1lbnRhdGlvbnM6IHRhcmdldHN9LCB7XG4gICAgZ2V0KHRhcmdldCwgbmFtZSkge1xuICAgICAgaWYgKG5hbWUgPT09ICdnZXRJbXBsZW1lbnRlcnMnKSB7XG4gICAgICAgIHJldHVybiAoKSA9PiB0YXJnZXRzO1xuICAgICAgfVxuXG4gICAgICBpZiAoUmVmbGVjdC5oYXModGFyZ2V0LCBuYW1lKSkge1xuICAgICAgICByZXR1cm4gdGFyZ2V0W25hbWVdO1xuICAgICAgfVxuXG4gICAgICBjb25zdCBmaXJzdFZhbGlkVGFyZ2V0ID0gdGFyZ2V0cy5maW5kKHQgPT4gUmVmbGVjdC5oYXModCwgbmFtZSkpO1xuICAgICAgaWYgKGZpcnN0VmFsaWRUYXJnZXQpIHtcbiAgICAgICAgcmV0dXJuIGZpcnN0VmFsaWRUYXJnZXRbbmFtZV07XG4gICAgICB9IGVsc2Uge1xuICAgICAgICByZXR1cm4gdW5kZWZpbmVkO1xuICAgICAgfVxuICAgIH0sXG5cbiAgICBzZXQodGFyZ2V0LCBuYW1lLCB2YWx1ZSkge1xuICAgICAgY29uc3QgZmlyc3RWYWxpZFRhcmdldCA9IHRhcmdldHMuZmluZCh0ID0+IFJlZmxlY3QuaGFzKHQsIG5hbWUpKTtcbiAgICAgIGlmIChmaXJzdFZhbGlkVGFyZ2V0KSB7XG4gICAgICAgIC8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBuby1yZXR1cm4tYXNzaWduXG4gICAgICAgIHJldHVybiBmaXJzdFZhbGlkVGFyZ2V0W25hbWVdID0gdmFsdWU7XG4gICAgICB9IGVsc2Uge1xuICAgICAgICAvLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUgbm8tcmV0dXJuLWFzc2lnblxuICAgICAgICByZXR1cm4gdGFyZ2V0W25hbWVdID0gdmFsdWU7XG4gICAgICB9XG4gICAgfSxcblxuICAgIC8vIFVzZWQgYnkgc2lub25cbiAgICBnZXRPd25Qcm9wZXJ0eURlc2NyaXB0b3IodGFyZ2V0LCBuYW1lKSB7XG4gICAgICBjb25zdCBmaXJzdFZhbGlkVGFyZ2V0ID0gdGFyZ2V0cy5maW5kKHQgPT4gUmVmbGVjdC5nZXRPd25Qcm9wZXJ0eURlc2NyaXB0b3IodCwgbmFtZSkpO1xuICAgICAgY29uc3QgY29tcG9zaXRlT3duUHJvcGVydHlEZXNjcmlwdG9yID0gUmVmbGVjdC5nZXRPd25Qcm9wZXJ0eURlc2NyaXB0b3IodGFyZ2V0LCBuYW1lKTtcbiAgICAgIGlmIChmaXJzdFZhbGlkVGFyZ2V0KSB7XG4gICAgICAgIHJldHVybiBSZWZsZWN0LmdldE93blByb3BlcnR5RGVzY3JpcHRvcihmaXJzdFZhbGlkVGFyZ2V0LCBuYW1lKTtcbiAgICAgIH0gZWxzZSBpZiAoY29tcG9zaXRlT3duUHJvcGVydHlEZXNjcmlwdG9yKSB7XG4gICAgICAgIHJldHVybiBjb21wb3NpdGVPd25Qcm9wZXJ0eURlc2NyaXB0b3I7XG4gICAgICB9IGVsc2Uge1xuICAgICAgICByZXR1cm4gdW5kZWZpbmVkO1xuICAgICAgfVxuICAgIH0sXG5cbiAgICAvLyBVc2VkIGJ5IHNpbm9uXG4gICAgZ2V0UHJvdG90eXBlT2YodGFyZ2V0KSB7XG4gICAgICByZXR1cm4gdGFyZ2V0cy5yZWR1Y2VSaWdodCgoYWNjLCB0KSA9PiB7XG4gICAgICAgIHJldHVybiBPYmplY3QuY3JlYXRlKGFjYywgZGVzY3JpcHRvcnNGcm9tUHJvdG8oT2JqZWN0LmdldFByb3RvdHlwZU9mKHQpKSk7XG4gICAgICB9LCBPYmplY3QucHJvdG90eXBlKTtcbiAgICB9LFxuICB9KTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIHJlYWRGaWxlKGFic29sdXRlRmlsZVBhdGgsIGVuY29kaW5nID0gJ3V0ZjgnKSB7XG4gIHJldHVybiBuZXcgUHJvbWlzZSgocmVzb2x2ZSwgcmVqZWN0KSA9PiB7XG4gICAgZnMucmVhZEZpbGUoYWJzb2x1dGVGaWxlUGF0aCwgZW5jb2RpbmcsIChlcnIsIGNvbnRlbnRzKSA9PiB7XG4gICAgICBpZiAoZXJyKSB7IHJlamVjdChlcnIpOyB9IGVsc2UgeyByZXNvbHZlKGNvbnRlbnRzKTsgfVxuICAgIH0pO1xuICB9KTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGZpbGVFeGlzdHMoYWJzb2x1dGVGaWxlUGF0aCkge1xuICByZXR1cm4gbmV3IFByb21pc2UoKHJlc29sdmUsIHJlamVjdCkgPT4ge1xuICAgIGZzLmFjY2VzcyhhYnNvbHV0ZUZpbGVQYXRoLCBlcnIgPT4ge1xuICAgICAgaWYgKGVycikge1xuICAgICAgICBpZiAoZXJyLmNvZGUgPT09ICdFTk9FTlQnKSB7XG4gICAgICAgICAgcmVzb2x2ZShmYWxzZSk7XG4gICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgcmVqZWN0KGVycik7XG4gICAgICAgIH1cbiAgICAgIH0gZWxzZSB7XG4gICAgICAgIHJlc29sdmUodHJ1ZSk7XG4gICAgICB9XG4gICAgfSk7XG4gIH0pO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gd3JpdGVGaWxlKGFic29sdXRlRmlsZVBhdGgsIGNvbnRlbnRzKSB7XG4gIHJldHVybiBuZXcgUHJvbWlzZSgocmVzb2x2ZSwgcmVqZWN0KSA9PiB7XG4gICAgZnMud3JpdGVGaWxlKGFic29sdXRlRmlsZVBhdGgsIGNvbnRlbnRzLCBlcnIgPT4ge1xuICAgICAgaWYgKGVycikgeyByZXR1cm4gcmVqZWN0KGVycik7IH0gZWxzZSB7IHJldHVybiByZXNvbHZlKCk7IH1cbiAgICB9KTtcbiAgfSk7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBkZWxldGVGaWxlT3JGb2xkZXIoZmlsZU9yRm9sZGVyKSB7XG4gIHJldHVybiBuZXcgUHJvbWlzZSgocmVzb2x2ZSwgcmVqZWN0KSA9PiB7XG4gICAgZnMucmVtb3ZlKGZpbGVPckZvbGRlciwgZXJyID0+IHtcbiAgICAgIGlmIChlcnIpIHsgcmV0dXJuIHJlamVjdChlcnIpOyB9IGVsc2UgeyByZXR1cm4gcmVzb2x2ZSgpOyB9XG4gICAgfSk7XG4gIH0pO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gY29weUZpbGUoc291cmNlLCB0YXJnZXQpIHtcbiAgcmV0dXJuIG5ldyBQcm9taXNlKChyZXNvbHZlLCByZWplY3QpID0+IHtcbiAgICBuY3Aoc291cmNlLCB0YXJnZXQsIGVyciA9PiB7XG4gICAgICBpZiAoZXJyKSB7IHJldHVybiByZWplY3QoZXJyKTsgfSBlbHNlIHsgcmV0dXJuIHJlc29sdmUodGFyZ2V0KTsgfVxuICAgIH0pO1xuICB9KTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGdldFRlbXBEaXIocHJlZml4ID0gJycpIHtcbiAgcmV0dXJuIG5ldyBQcm9taXNlKChyZXNvbHZlLCByZWplY3QpID0+IHtcbiAgICB0ZW1wLm1rZGlyKHByZWZpeCwgKHRlbXBFcnJvciwgZm9sZGVyKSA9PiB7XG4gICAgICBpZiAodGVtcEVycm9yKSB7XG4gICAgICAgIHJlamVjdCh0ZW1wRXJyb3IpO1xuICAgICAgICByZXR1cm47XG4gICAgICB9XG5cbiAgICAgIGZzLnJlYWxwYXRoKGZvbGRlciwgKHJlYWxFcnJvciwgcnBhdGgpID0+IChyZWFsRXJyb3IgPyByZWplY3QocmVhbEVycm9yKSA6IHJlc29sdmUocnBhdGgpKSk7XG4gICAgfSk7XG4gIH0pO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gZnNTdGF0KGFic29sdXRlRmlsZVBhdGgpIHtcbiAgcmV0dXJuIG5ldyBQcm9taXNlKChyZXNvbHZlLCByZWplY3QpID0+IHtcbiAgICBmcy5zdGF0KGFic29sdXRlRmlsZVBhdGgsIChlcnIsIHN0YXRzKSA9PiB7XG4gICAgICBpZiAoZXJyKSB7IHJlamVjdChlcnIpOyB9IGVsc2UgeyByZXNvbHZlKHN0YXRzKTsgfVxuICAgIH0pO1xuICB9KTtcbn1cblxuZXhwb3J0IGFzeW5jIGZ1bmN0aW9uIGlzRmlsZUV4ZWN1dGFibGUoYWJzb2x1dGVGaWxlUGF0aCkge1xuICBjb25zdCBzdGF0ID0gYXdhaXQgZnNTdGF0KGFic29sdXRlRmlsZVBhdGgpO1xuICByZXR1cm4gc3RhdC5tb2RlICYgZnMuY29uc3RhbnRzLlNfSVhVU1I7IC8vIGVzbGludC1kaXNhYmxlLWxpbmUgbm8tYml0d2lzZVxufVxuXG5leHBvcnQgZnVuY3Rpb24gbWtkaXJzKGRpcmVjdG9yeSkge1xuICByZXR1cm4gbmV3IFByb21pc2UoKHJlc29sdmUsIHJlamVjdCkgPT4ge1xuICAgIGZzLm1rZGlycyhkaXJlY3RvcnksIGVyciA9PiAoZXJyID8gcmVqZWN0KGVycikgOiByZXNvbHZlKCkpKTtcbiAgfSk7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBzaG9ydGVuU2hhKHNoYSkge1xuICByZXR1cm4gc2hhLnNsaWNlKDAsIDgpO1xufVxuXG5leHBvcnQgY29uc3QgY2xhc3NOYW1lRm9yU3RhdHVzID0ge1xuICBhZGRlZDogJ2FkZGVkJyxcbiAgZGVsZXRlZDogJ3JlbW92ZWQnLFxuICBtb2RpZmllZDogJ21vZGlmaWVkJyxcbiAgZXF1aXZhbGVudDogJ2lnbm9yZWQnLFxufTtcblxuLypcbiAqIEFwcGx5IGFueSBwbGF0Zm9ybS1zcGVjaWZpYyBtdW5naW5nIHRvIGEgcGF0aCBiZWZvcmUgcHJlc2VudGluZyBpdCBhc1xuICogYSBnaXQgZW52aXJvbm1lbnQgdmFyaWFibGUgb3Igb3B0aW9uLlxuICpcbiAqIENvbnZlcnQgYSBXaW5kb3dzLXN0eWxlIFwiQzpcXGZvb1xcYmFyXFxiYXpcIiBwYXRoIHRvIGEgXCIvYy9mb28vYmFyL2JhelwiIFVOSVgteVxuICogcGF0aCB0aGF0IHRoZSBzaC5leGUgdXNlZCB0byBleGVjdXRlIGdpdCdzIGNyZWRlbnRpYWwgaGVscGVycyB3aWxsXG4gKiB1bmRlcnN0YW5kLlxuICovXG5leHBvcnQgZnVuY3Rpb24gbm9ybWFsaXplR2l0SGVscGVyUGF0aChpblBhdGgpIHtcbiAgaWYgKHByb2Nlc3MucGxhdGZvcm0gPT09ICd3aW4zMicpIHtcbiAgICByZXR1cm4gaW5QYXRoLnJlcGxhY2UoL1xcXFwvZywgJy8nKS5yZXBsYWNlKC9eKFteOl0rKTovLCAnLyQxJyk7XG4gIH0gZWxzZSB7XG4gICAgcmV0dXJuIGluUGF0aDtcbiAgfVxufVxuXG4vKlxuICogT24gV2luZG93cywgZ2l0IGNvbW1hbmRzIHJlcG9ydCBwYXRocyB3aXRoIC8gZGVsaW1pdGVycy4gQ29udmVydCB0aGVtIHRvIFxcLWRlbGltaXRlZCBwYXRoc1xuICogc28gdGhhdCBBdG9tIHVuaWZyb21seSB0cmVhdHMgcGF0aHMgd2l0aCBuYXRpdmUgcGF0aCBzZXBhcmF0b3JzLlxuICovXG5leHBvcnQgZnVuY3Rpb24gdG9OYXRpdmVQYXRoU2VwKHJhd1BhdGgpIHtcbiAgaWYgKHByb2Nlc3MucGxhdGZvcm0gIT09ICd3aW4zMicpIHtcbiAgICByZXR1cm4gcmF3UGF0aDtcbiAgfSBlbHNlIHtcbiAgICByZXR1cm4gcmF3UGF0aC5zcGxpdCgnLycpLmpvaW4ocGF0aC5zZXApO1xuICB9XG59XG5cbi8qXG4gKiBDb252ZXJ0IFdpbmRvd3MgcGF0aHMgYmFjayB0byAvLWRlbGltaXRlZCBwYXRocyB0byBiZSBwcmVzZW50ZWQgdG8gZ2l0LlxuICovXG5leHBvcnQgZnVuY3Rpb24gdG9HaXRQYXRoU2VwKHJhd1BhdGgpIHtcbiAgaWYgKHByb2Nlc3MucGxhdGZvcm0gIT09ICd3aW4zMicpIHtcbiAgICByZXR1cm4gcmF3UGF0aDtcbiAgfSBlbHNlIHtcbiAgICByZXR1cm4gcmF3UGF0aC5zcGxpdChwYXRoLnNlcCkuam9pbignLycpO1xuICB9XG59XG4iXX0=