'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _net = require('net');

var _net2 = _interopRequireDefault(_net);

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _eventKit = require('event-kit');

var _helpers = require('./helpers');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

function getAtomHelperPath() {
  if (process.platform === 'darwin') {
    const beta = atom.appVersion.match(/-beta/);
    const appName = beta ? 'Atom Beta Helper' : 'Atom Helper';
    return _path2.default.resolve(process.resourcesPath, '..', 'Frameworks', `${appName}.app`, 'Contents', 'MacOS', appName);
  } else {
    return process.execPath;
  }
}

let GitPromptServer = class GitPromptServer {
  constructor() {
    this.emitter = new _eventKit.Emitter();
  }

  start(promptForInput) {
    var _this = this;

    return _asyncToGenerator(function* () {
      // TODO: [mkt] Windows?? yes.
      _this.promptForInput = promptForInput;
      const windows = process.platform === 'win32';
      _this.tmpFolderPath = yield (0, _helpers.getTempDir)('github-');

      const credentialHelper = {};
      const askPass = {};
      const sshWrapper = {};

      const sourceFiles = {
        'git-credential-atom.js': function (outfile) {
          return credentialHelper.script = outfile;
        },
        'git-credential-atom.sh': function (outfile) {
          return credentialHelper.launcher = outfile;
        },
        'git-askpass-atom.js': function (outfile) {
          return askPass.script = outfile;
        },
        'git-askpass-atom.sh': function (outfile) {
          return askPass.launcher = outfile;
        },
        'linux-ssh-wrapper.sh': function (outfile) {
          return sshWrapper.script = outfile;
        }
      };

      yield Promise.all(Object.keys(sourceFiles).map(function (filename) {
        return (0, _helpers.copyFile)(_path2.default.resolve((0, _helpers.getPackageRoot)(), 'bin', filename), _path2.default.join(_this.tmpFolderPath, filename)).then(sourceFiles[filename]);
      }));

      const socketPath = _path2.default.join(_this.tmpFolderPath, 'helper.sock');
      const namedPipePath = _path2.default.join('\\\\?\\pipe\\', 'gh-' + require('crypto').randomBytes(8).toString('hex'), 'helper.sock');
      _this.server = yield _this.startListening(windows ? namedPipePath : socketPath);

      return {
        socket: windows ? namedPipePath : socketPath,
        electron: getAtomHelperPath(),
        credentialHelper,
        askPass,
        sshWrapper
      };
    })();
  }

  startListening(socketPath) {
    return new Promise(resolve => {
      const server = _net2.default.createServer(connection => {
        connection.setEncoding('utf8');

        const parts = [];

        connection.on('data', data => {
          const nullIndex = data.indexOf('\u0000');
          if (nullIndex === -1) {
            parts.push(data);
          } else {
            parts.push(data.substring(0, nullIndex));
            this.handleData(connection, parts.join(''));
          }
        });
      });

      server.listen(socketPath, () => resolve(server));
    });
  }

  handleData(connection, data) {
    let query;
    try {
      query = JSON.parse(data);
    } catch (e) {
      this.emitter.emit('did-cancel');
    }

    Promise.resolve(this.promptForInput(query)).then(answer => connection.end(JSON.stringify(answer), 'utf-8')).catch(() => this.emitter.emit('did-cancel', { handlerPid: query.pid }));
  }

  onDidCancel(cb) {
    return this.emitter.on('did-cancel', cb);
  }

  terminate() {
    var _this2 = this;

    return _asyncToGenerator(function* () {
      yield new Promise(function (resolve) {
        return _this2.server.close(resolve);
      });
      yield (0, _helpers.deleteFileOrFolder)(_this2.tmpFolderPath);
      _this2.emitter.dispose();
    })();
  }
};
exports.default = GitPromptServer;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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