'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _desc, _value, _class;

var _electron = require('electron');

var _eventKit = require('event-kit');

var _coreDecorators = require('core-decorators');

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

let DeferredCallbackQueue = (_class = class DeferredCallbackQueue {
  constructor(wait, callback) {
    let options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

    this.wait = wait;
    const currentWindow = _electron.remote.getCurrentWindow();

    const onDidFocus = options.onDidFocus || function (cb) {
      currentWindow.on('focus', cb);
      return new _eventKit.Disposable(() => {
        currentWindow.removeListener('focus', cb);
      });
    };
    const onDidBlur = options.onDidBlur || function (cb) {
      if (atom.inSpecMode()) {
        return new _eventKit.Disposable();
      }
      currentWindow.on('blur', cb);
      return new _eventKit.Disposable(() => {
        currentWindow.removeListener('blur', cb);
      });
    };

    this.callback = callback;
    this.subscriptions = new _eventKit.CompositeDisposable();
    this.items = new Set();

    this.paused = !currentWindow.isFocused() && !atom.inSpecMode();
    this.subscriptions.add(onDidFocus(this.resume));
    this.subscriptions.add(onDidBlur(this.pause));
  }

  pause() {
    if (this.paused) {
      return;
    }
    this.paused = true;
  }

  resume() {
    if (!this.paused) {
      return;
    }
    this.paused = false;
    if (this.timer) {
      clearTimeout(this.timer);
    }
    this.flush();
  }

  resetTimer() {
    if (this.timer) {
      clearTimeout(this.timer);
    }
    this.timer = setTimeout(this.flush, this.wait);
  }

  flush() {
    delete this.timer;
    if (this.items.size) {
      this.callback([...this.items]);
      this.items.clear();
    }
  }

  push() {
    for (var _len = arguments.length, items = Array(_len), _key = 0; _key < _len; _key++) {
      items[_key] = arguments[_key];
    }

    if (this.paused) {
      items.forEach(item => this.items.add(item));
      this.resetTimer();
    } else {
      this.callback(items);
    }
  }

  destroy() {
    this.subscriptions.dispose();
  }
}, (_applyDecoratedDescriptor(_class.prototype, 'pause', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'pause'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'resume', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'resume'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'flush', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'flush'), _class.prototype)), _class);
exports.default = DeferredCallbackQueue;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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