'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

exports.default = ObserveModelDecorator;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _hoistNonReactStatics = require('hoist-non-react-statics');

var _hoistNonReactStatics2 = _interopRequireDefault(_hoistNonReactStatics);

var _modelObserver = require('../models/model-observer');

var _modelObserver2 = _interopRequireDefault(_modelObserver);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Wraps a component in a HOC that watches for a model to change
 * and passes data to the wrapped component as props.
 * Utilizes `ModelObserver` to watch for model changes.
 *
 *   @ObserveModelDecorator({
 *     // getModel takes the props passed to the outer component
 *     // and should return the model to watch; defaults to `props.model`
 *     getModel: props => props.repository,
 *     // fetchData takes the model instance and the props passed
 *     // to the outer component and should return an object (or promise
 *     // of an object) specifying the data to be passed to the
 *     // inner component as props
 *     fetchData: (repo, props) => ({ stuff: repo.getStuff() }),
 *   })
 *   class MyComponent extends React.Component { ... }
 */
function ObserveModelDecorator(spec) {
  const getModel = spec.getModel || (props => props.model);
  const fetchData = spec.fetchData || (() => {});

  return function (Target) {
    var _class, _temp;

    let Wrapper = (_temp = _class = class Wrapper extends _react2.default.Component {

      static getWrappedComponentClass() {
        return Target;
      }

      constructor(props, context) {
        super(props, context);
        this.mounted = true;
        this.resolve = () => {};

        this.state = {
          modelData: {}
        };

        this.modelObserver = new _modelObserver2.default({
          fetchData: model => fetchData(model, this.props),
          didUpdate: () => {
            if (this.mounted) {
              this.setState({ modelData: this.modelObserver.getActiveModelData() }, () => {
                /* eslint-disable react/prop-types */
                if (this.props.switchboard) {
                  this.props.switchboard.didFinishRender('ObserveModel.didUpdate');
                }
                /* eslint-enable react/prop-types */
                this.resolve();
              });
            }
          }
        });
      }

      componentWillMount() {
        this.modelObserver.setActiveModel(getModel(this.props));
      }

      componentWillReceiveProps(nextProps) {
        this.modelObserver.setActiveModel(getModel(nextProps));
      }

      render() {
        const data = this.state.modelData;
        return _react2.default.createElement(Target, _extends({ ref: c => {
            this.wrapped = c;
          } }, data, this.props));
      }

      getWrappedComponentInstance() {
        return this.wrapped;
      }

      componentWillUnmount() {
        this.mounted = false;
        this.modelObserver.destroy();
      }

      refreshModelData() {
        return new Promise(resolve => {
          this.resolve = resolve;

          const model = getModel(this.props);
          if (model !== this.modelObserver.getActiveModel()) {
            this.modelObserver.setActiveModel(model);
          } else {
            this.modelObserver.refreshModelData();
          }
        });
      }
    }, _class.displayName = `ObserveModelDecorator(${Target.name})`, _temp);


    (0, _hoistNonReactStatics2.default)(Wrapper, Target);

    return Wrapper;
  };
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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