'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _dec, _class, _desc, _value, _class2, _class3, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _coreDecorators = require('core-decorators');

var _yubikiri = require('yubikiri');

var _yubikiri2 = _interopRequireDefault(_yubikiri);

var _propTypes3 = require('../prop-types');

var _observeModel = require('../decorators/observe-model');

var _observeModel2 = _interopRequireDefault(_observeModel);

var _githubLoginView = require('../views/github-login-view');

var _githubLoginView2 = _interopRequireDefault(_githubLoginView);

var _githubLoginModel = require('../models/github-login-model');

var _remote = require('../models/remote');

var _prInfoController = require('./pr-info-controller');

var _prInfoController2 = _interopRequireDefault(_prInfoController);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

let RemotePrController = (_dec = (0, _observeModel2.default)({
  getModel: props => props.loginModel,
  fetchData: (loginModel, _ref) => {
    let host = _ref.host;

    return (0, _yubikiri2.default)({
      token: loginModel.getToken(host)
    });
  }
}), _dec(_class = (_class2 = (_temp = _class3 = class RemotePrController extends _react2.default.Component {

  render() {
    var _props = this.props;
    const host = _props.host,
          remote = _props.remote,
          currentBranchName = _props.currentBranchName,
          token = _props.token,
          loginModel = _props.loginModel,
          selectedPrUrl = _props.selectedPrUrl,
          onSelectPr = _props.onSelectPr,
          onUnpinPr = _props.onUnpinPr;

    return _react2.default.createElement(
      'div',
      { className: 'github-RemotePrController' },
      token && token !== _githubLoginModel.UNAUTHENTICATED && _react2.default.createElement(_prInfoController2.default, _extends({ host, remote, currentBranchName, token, loginModel, selectedPrUrl, onSelectPr, onUnpinPr }, {
        onLogin: this.handleLogin
      })),
      (!token || token === _githubLoginModel.UNAUTHENTICATED) && _react2.default.createElement(_githubLoginView2.default, { onLogin: this.handleLogin })
    );
  }

  handleLogin(token) {
    this.props.loginModel.setToken(this.props.host, token);
  }
}, _class3.propTypes = {
  loginModel: _propTypes2.default.object.isRequired,
  host: _propTypes2.default.string, // fully qualified URI to the API endpoint, e.g. 'https://api.github.com'
  remote: _propTypes3.RemotePropType.isRequired,
  token: _propTypes2.default.oneOfType([_propTypes2.default.string, _propTypes2.default.symbol]),
  currentBranchName: _propTypes2.default.string.isRequired,
  onSelectPr: _propTypes2.default.func.isRequired,
  selectedPrUrl: _propTypes2.default.string,
  onUnpinPr: _propTypes2.default.func.isRequired
}, _class3.defaultProps = {
  host: 'https://api.github.com',
  remote: _remote.nullRemote,
  token: null
}, _temp), (_applyDecoratedDescriptor(_class2.prototype, 'handleLogin', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class2.prototype, 'handleLogin'), _class2.prototype)), _class2)) || _class);
exports.default = RemotePrController;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInJlbW90ZS1wci1jb250cm9sbGVyLmpzIl0sIm5hbWVzIjpbIlJlbW90ZVByQ29udHJvbGxlciIsImdldE1vZGVsIiwicHJvcHMiLCJsb2dpbk1vZGVsIiwiZmV0Y2hEYXRhIiwiaG9zdCIsInRva2VuIiwiZ2V0VG9rZW4iLCJDb21wb25lbnQiLCJyZW5kZXIiLCJyZW1vdGUiLCJjdXJyZW50QnJhbmNoTmFtZSIsInNlbGVjdGVkUHJVcmwiLCJvblNlbGVjdFByIiwib25VbnBpblByIiwiaGFuZGxlTG9naW4iLCJzZXRUb2tlbiIsInByb3BUeXBlcyIsIm9iamVjdCIsImlzUmVxdWlyZWQiLCJzdHJpbmciLCJvbmVPZlR5cGUiLCJzeW1ib2wiLCJmdW5jIiwiZGVmYXVsdFByb3BzIl0sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7OztBQUFBOzs7O0FBQ0E7Ozs7QUFDQTs7QUFDQTs7OztBQUVBOztBQUNBOzs7O0FBQ0E7Ozs7QUFDQTs7QUFDQTs7QUFDQTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7SUFVcUJBLGtCLFdBUnBCLDRCQUFzQjtBQUNyQkMsWUFBVUMsU0FBU0EsTUFBTUMsVUFESjtBQUVyQkMsYUFBVyxDQUFDRCxVQUFELFdBQXdCO0FBQUEsUUFBVkUsSUFBVSxRQUFWQSxJQUFVOztBQUNqQyxXQUFPLHdCQUFTO0FBQ2RDLGFBQU9ILFdBQVdJLFFBQVgsQ0FBb0JGLElBQXBCO0FBRE8sS0FBVCxDQUFQO0FBR0Q7QUFOb0IsQ0FBdEIsQyw4Q0FRYyxNQUFNTCxrQkFBTixTQUFpQyxnQkFBTVEsU0FBdkMsQ0FBaUQ7O0FBcUI5REMsV0FBUztBQUFBLGlCQUM0RixLQUFLUCxLQURqRztBQUFBLFVBQ0FHLElBREEsVUFDQUEsSUFEQTtBQUFBLFVBQ01LLE1BRE4sVUFDTUEsTUFETjtBQUFBLFVBQ2NDLGlCQURkLFVBQ2NBLGlCQURkO0FBQUEsVUFDaUNMLEtBRGpDLFVBQ2lDQSxLQURqQztBQUFBLFVBQ3dDSCxVQUR4QyxVQUN3Q0EsVUFEeEM7QUFBQSxVQUNvRFMsYUFEcEQsVUFDb0RBLGFBRHBEO0FBQUEsVUFDbUVDLFVBRG5FLFVBQ21FQSxVQURuRTtBQUFBLFVBQytFQyxTQUQvRSxVQUMrRUEsU0FEL0U7O0FBRVAsV0FDRTtBQUFBO0FBQUEsUUFBSyxXQUFVLDJCQUFmO0FBQ0dSLGVBQVNBLDJDQUFULElBQXNDLG1FQUNqQyxFQUFDRCxJQUFELEVBQU9LLE1BQVAsRUFBZUMsaUJBQWYsRUFBa0NMLEtBQWxDLEVBQXlDSCxVQUF6QyxFQUFxRFMsYUFBckQsRUFBb0VDLFVBQXBFLEVBQWdGQyxTQUFoRixFQURpQztBQUVyQyxpQkFBUyxLQUFLQztBQUZ1QixTQUR6QztBQU1HLE9BQUMsQ0FBQ1QsS0FBRCxJQUFVQSwyQ0FBWCxLQUF5QywyREFBaUIsU0FBUyxLQUFLUyxXQUEvQjtBQU41QyxLQURGO0FBVUQ7O0FBR0RBLGNBQVlULEtBQVosRUFBbUI7QUFDakIsU0FBS0osS0FBTCxDQUFXQyxVQUFYLENBQXNCYSxRQUF0QixDQUErQixLQUFLZCxLQUFMLENBQVdHLElBQTFDLEVBQWdEQyxLQUFoRDtBQUNEO0FBdEM2RCxDLFVBQ3ZEVyxTLEdBQVk7QUFDakJkLGNBQVksb0JBQVVlLE1BQVYsQ0FBaUJDLFVBRFo7QUFFakJkLFFBQU0sb0JBQVVlLE1BRkMsRUFFTztBQUN4QlYsVUFBUSwyQkFBZVMsVUFITjtBQUlqQmIsU0FBTyxvQkFBVWUsU0FBVixDQUFvQixDQUN6QixvQkFBVUQsTUFEZSxFQUV6QixvQkFBVUUsTUFGZSxDQUFwQixDQUpVO0FBUWpCWCxxQkFBbUIsb0JBQVVTLE1BQVYsQ0FBaUJELFVBUm5CO0FBU2pCTixjQUFZLG9CQUFVVSxJQUFWLENBQWVKLFVBVFY7QUFVakJQLGlCQUFlLG9CQUFVUSxNQVZSO0FBV2pCTixhQUFXLG9CQUFVUyxJQUFWLENBQWVKO0FBWFQsQyxVQWNaSyxZLEdBQWU7QUFDcEJuQixRQUFNLHdCQURjO0FBRXBCSyw0QkFGb0I7QUFHcEJKLFNBQU87QUFIYSxDO2tCQWZITixrQiIsImZpbGUiOiJyZW1vdGUtcHItY29udHJvbGxlci5qcyIsInNvdXJjZVJvb3QiOiIvaG9tZS90cmF2aXMvYnVpbGQvYXRvbS9hdG9tL291dC9hcHAvbm9kZV9tb2R1bGVzL2dpdGh1YiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBSZWFjdCBmcm9tICdyZWFjdCc7XG5pbXBvcnQgUHJvcFR5cGVzIGZyb20gJ3Byb3AtdHlwZXMnO1xuaW1wb3J0IHthdXRvYmluZH0gZnJvbSAnY29yZS1kZWNvcmF0b3JzJztcbmltcG9ydCB5dWJpa2lyaSBmcm9tICd5dWJpa2lyaSc7XG5cbmltcG9ydCB7UmVtb3RlUHJvcFR5cGV9IGZyb20gJy4uL3Byb3AtdHlwZXMnO1xuaW1wb3J0IE9ic2VydmVNb2RlbERlY29yYXRvciBmcm9tICcuLi9kZWNvcmF0b3JzL29ic2VydmUtbW9kZWwnO1xuaW1wb3J0IEdpdGh1YkxvZ2luVmlldyBmcm9tICcuLi92aWV3cy9naXRodWItbG9naW4tdmlldyc7XG5pbXBvcnQge1VOQVVUSEVOVElDQVRFRH0gZnJvbSAnLi4vbW9kZWxzL2dpdGh1Yi1sb2dpbi1tb2RlbCc7XG5pbXBvcnQge251bGxSZW1vdGV9IGZyb20gJy4uL21vZGVscy9yZW1vdGUnO1xuaW1wb3J0IFBySW5mb0NvbnRyb2xsZXIgZnJvbSAnLi9wci1pbmZvLWNvbnRyb2xsZXInO1xuXG5AT2JzZXJ2ZU1vZGVsRGVjb3JhdG9yKHtcbiAgZ2V0TW9kZWw6IHByb3BzID0+IHByb3BzLmxvZ2luTW9kZWwsXG4gIGZldGNoRGF0YTogKGxvZ2luTW9kZWwsIHtob3N0fSkgPT4ge1xuICAgIHJldHVybiB5dWJpa2lyaSh7XG4gICAgICB0b2tlbjogbG9naW5Nb2RlbC5nZXRUb2tlbihob3N0KSxcbiAgICB9KTtcbiAgfSxcbn0pXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBSZW1vdGVQckNvbnRyb2xsZXIgZXh0ZW5kcyBSZWFjdC5Db21wb25lbnQge1xuICBzdGF0aWMgcHJvcFR5cGVzID0ge1xuICAgIGxvZ2luTW9kZWw6IFByb3BUeXBlcy5vYmplY3QuaXNSZXF1aXJlZCxcbiAgICBob3N0OiBQcm9wVHlwZXMuc3RyaW5nLCAvLyBmdWxseSBxdWFsaWZpZWQgVVJJIHRvIHRoZSBBUEkgZW5kcG9pbnQsIGUuZy4gJ2h0dHBzOi8vYXBpLmdpdGh1Yi5jb20nXG4gICAgcmVtb3RlOiBSZW1vdGVQcm9wVHlwZS5pc1JlcXVpcmVkLFxuICAgIHRva2VuOiBQcm9wVHlwZXMub25lT2ZUeXBlKFtcbiAgICAgIFByb3BUeXBlcy5zdHJpbmcsXG4gICAgICBQcm9wVHlwZXMuc3ltYm9sLFxuICAgIF0pLFxuICAgIGN1cnJlbnRCcmFuY2hOYW1lOiBQcm9wVHlwZXMuc3RyaW5nLmlzUmVxdWlyZWQsXG4gICAgb25TZWxlY3RQcjogUHJvcFR5cGVzLmZ1bmMuaXNSZXF1aXJlZCxcbiAgICBzZWxlY3RlZFByVXJsOiBQcm9wVHlwZXMuc3RyaW5nLFxuICAgIG9uVW5waW5QcjogUHJvcFR5cGVzLmZ1bmMuaXNSZXF1aXJlZCxcbiAgfVxuXG4gIHN0YXRpYyBkZWZhdWx0UHJvcHMgPSB7XG4gICAgaG9zdDogJ2h0dHBzOi8vYXBpLmdpdGh1Yi5jb20nLFxuICAgIHJlbW90ZTogbnVsbFJlbW90ZSxcbiAgICB0b2tlbjogbnVsbCxcbiAgfVxuXG4gIHJlbmRlcigpIHtcbiAgICBjb25zdCB7aG9zdCwgcmVtb3RlLCBjdXJyZW50QnJhbmNoTmFtZSwgdG9rZW4sIGxvZ2luTW9kZWwsIHNlbGVjdGVkUHJVcmwsIG9uU2VsZWN0UHIsIG9uVW5waW5Qcn0gPSB0aGlzLnByb3BzO1xuICAgIHJldHVybiAoXG4gICAgICA8ZGl2IGNsYXNzTmFtZT1cImdpdGh1Yi1SZW1vdGVQckNvbnRyb2xsZXJcIj5cbiAgICAgICAge3Rva2VuICYmIHRva2VuICE9PSBVTkFVVEhFTlRJQ0FURUQgJiYgPFBySW5mb0NvbnRyb2xsZXJcbiAgICAgICAgICB7Li4ue2hvc3QsIHJlbW90ZSwgY3VycmVudEJyYW5jaE5hbWUsIHRva2VuLCBsb2dpbk1vZGVsLCBzZWxlY3RlZFByVXJsLCBvblNlbGVjdFByLCBvblVucGluUHJ9fVxuICAgICAgICAgIG9uTG9naW49e3RoaXMuaGFuZGxlTG9naW59XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIC8+XG4gICAgICAgICAgfVxuICAgICAgICB7KCF0b2tlbiB8fCB0b2tlbiA9PT0gVU5BVVRIRU5USUNBVEVEKSAmJiA8R2l0aHViTG9naW5WaWV3IG9uTG9naW49e3RoaXMuaGFuZGxlTG9naW59IC8+fVxuICAgICAgPC9kaXY+XG4gICAgKTtcbiAgfVxuXG4gIEBhdXRvYmluZFxuICBoYW5kbGVMb2dpbih0b2tlbikge1xuICAgIHRoaXMucHJvcHMubG9naW5Nb2RlbC5zZXRUb2tlbih0aGlzLnByb3BzLmhvc3QsIHRva2VuKTtcbiAgfVxufVxuIl19