'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _desc, _value, _class, _class2, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _coreDecorators = require('core-decorators');

var _propTypes3 = require('../prop-types');

var _relayRootContainer = require('../containers/relay-root-container');

var _relayRootContainer2 = _interopRequireDefault(_relayRootContainer);

var _prSelectionByUrlContainer = require('../containers/pr-selection-by-url-container');

var _prSelectionByUrlContainer2 = _interopRequireDefault(_prSelectionByUrlContainer);

var _prSelectionByBranchContainer = require('../containers/pr-selection-by-branch-container');

var _prSelectionByBranchContainer2 = _interopRequireDefault(_prSelectionByBranchContainer);

var _githubLoginView = require('../views/github-login-view');

var _githubLoginView2 = _interopRequireDefault(_githubLoginView);

var _prInfoByBranchRoute = require('../routes/pr-info-by-branch-route');

var _prInfoByBranchRoute2 = _interopRequireDefault(_prInfoByBranchRoute);

var _prInfoByUrlRoute = require('../routes/pr-info-by-url-route');

var _prInfoByUrlRoute2 = _interopRequireDefault(_prInfoByUrlRoute);

var _relayNetworkLayerManager = require('../relay-network-layer-manager');

var _relayNetworkLayerManager2 = _interopRequireDefault(_relayNetworkLayerManager);

var _githubLoginModel = require('../models/github-login-model');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

let PrInfoController = (_class = (_temp = _class2 = class PrInfoController extends _react2.default.Component {

  render() {
    if (this.props.token === _githubLoginModel.UNAUTHENTICATED) {
      return null;
    }

    if (this.props.selectedPrUrl) {
      return this.renderSpecificPr();
    } else {
      return this.renderPrByBranchName();
    }
  }

  renderSpecificPr() {
    var _props = this.props;
    const token = _props.token,
          host = _props.host;


    const route = new _prInfoByUrlRoute2.default({
      prUrl: this.props.selectedPrUrl
    });

    const environment = _relayNetworkLayerManager2.default.getEnvironmentForHost(host, token);
    const Component = _prSelectionByUrlContainer2.default;

    return _react2.default.createElement(_relayRootContainer2.default, {
      Component: Component,
      route: route,
      environment: environment,
      renderFetched: props => {
        return _react2.default.createElement(Component, _extends({}, props, { onSelectPr: this.props.onSelectPr, onUnpinPr: this.props.onUnpinPr }));
      },
      renderLoading: this.renderLoading,
      renderFailure: this.renderSpecificPrFailure
    });
  }

  renderPrByBranchName() {
    var _props2 = this.props;
    const token = _props2.token,
          host = _props2.host;


    const route = new _prInfoByBranchRoute2.default({
      repoOwner: this.props.remote.getOwner(),
      repoName: this.props.remote.getRepo(),
      branchName: this.props.currentBranchName
    });

    const environment = _relayNetworkLayerManager2.default.getEnvironmentForHost(host, token);
    const Component = _prSelectionByBranchContainer2.default;

    return _react2.default.createElement(_relayRootContainer2.default, {
      Component: Component,
      route: route,
      environment: environment,
      renderFetched: props => {
        return _react2.default.createElement(Component, _extends({}, props, { onSelectPr: this.props.onSelectPr, onUnpinPr: this.props.onUnpinPr }));
      },
      renderLoading: this.renderLoading,
      renderFailure: this.renderFailure
    });
  }

  renderLoading() {
    return _react2.default.createElement(
      'div',
      { className: 'github-Loader' },
      _react2.default.createElement('span', { className: 'github-Spinner' })
    );
  }

  renderSpecificPrFailure(err, retry) {
    if (this.isNotFoundError(err)) {
      return _react2.default.createElement(_prSelectionByUrlContainer2.default, {
        prUrl: this.props.selectedPrUrl,
        query: null,
        onSelectPr: this.props.onSelectPr,
        onUnpinPr: this.props.onUnpinPr
      });
    } else {
      return this.renderFailure(err, retry);
    }
  }

  renderFailure(err, retry) {
    if (err.response && err.response.status === 401) {
      return _react2.default.createElement(
        'div',
        { className: 'github-GithubLoginView-Container' },
        _react2.default.createElement(
          _githubLoginView2.default,
          { onLogin: this.props.onLogin },
          _react2.default.createElement(
            'p',
            null,
            'The API endpoint returned a unauthorized error. Please try to re-authenticate with the endpoint.'
          )
        )
      );
    } else {
      return _react2.default.createElement(
        'div',
        { className: 'unknown-fatal-error' },
        _react2.default.createElement(
          'div',
          null,
          'An unknown error occurred.'
        ),
        _react2.default.createElement(
          'button',
          { onClick: retry },
          'Try Again'
        )
      );
    }
  }

  isNotFoundError(err) {
    return err.source && err.source.errors && err.source.errors[0] && err.source.errors[0].type === 'NOT_FOUND';
  }
}, _class2.propTypes = {
  token: _propTypes2.default.oneOfType([_propTypes2.default.string, _propTypes2.default.symbol]).isRequired,
  host: _propTypes2.default.string.isRequired,
  currentBranchName: _propTypes2.default.string.isRequired,
  onLogin: _propTypes2.default.func.isRequired,
  remote: _propTypes3.RemotePropType.isRequired,
  onSelectPr: _propTypes2.default.func.isRequired,
  selectedPrUrl: _propTypes2.default.string,
  onUnpinPr: _propTypes2.default.func.isRequired
}, _temp), (_applyDecoratedDescriptor(_class.prototype, 'renderLoading', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'renderLoading'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'renderSpecificPrFailure', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'renderSpecificPrFailure'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'renderFailure', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'renderFailure'), _class.prototype)), _class);
exports.default = PrInfoController;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInByLWluZm8tY29udHJvbGxlci5qcyJdLCJuYW1lcyI6WyJQckluZm9Db250cm9sbGVyIiwiQ29tcG9uZW50IiwicmVuZGVyIiwicHJvcHMiLCJ0b2tlbiIsInNlbGVjdGVkUHJVcmwiLCJyZW5kZXJTcGVjaWZpY1ByIiwicmVuZGVyUHJCeUJyYW5jaE5hbWUiLCJob3N0Iiwicm91dGUiLCJwclVybCIsImVudmlyb25tZW50IiwiZ2V0RW52aXJvbm1lbnRGb3JIb3N0Iiwib25TZWxlY3RQciIsIm9uVW5waW5QciIsInJlbmRlckxvYWRpbmciLCJyZW5kZXJTcGVjaWZpY1ByRmFpbHVyZSIsInJlcG9Pd25lciIsInJlbW90ZSIsImdldE93bmVyIiwicmVwb05hbWUiLCJnZXRSZXBvIiwiYnJhbmNoTmFtZSIsImN1cnJlbnRCcmFuY2hOYW1lIiwicmVuZGVyRmFpbHVyZSIsImVyciIsInJldHJ5IiwiaXNOb3RGb3VuZEVycm9yIiwicmVzcG9uc2UiLCJzdGF0dXMiLCJvbkxvZ2luIiwic291cmNlIiwiZXJyb3JzIiwidHlwZSIsInByb3BUeXBlcyIsIm9uZU9mVHlwZSIsInN0cmluZyIsInN5bWJvbCIsImlzUmVxdWlyZWQiLCJmdW5jIl0sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7OztBQUFBOzs7O0FBQ0E7Ozs7QUFDQTs7QUFFQTs7QUFDQTs7OztBQUNBOzs7O0FBQ0E7Ozs7QUFDQTs7OztBQUNBOzs7O0FBQ0E7Ozs7QUFDQTs7OztBQUNBOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7SUFFcUJBLGdCLGdDQUFOLE1BQU1BLGdCQUFOLFNBQStCLGdCQUFNQyxTQUFyQyxDQUErQzs7QUFlNURDLFdBQVM7QUFDUCxRQUFJLEtBQUtDLEtBQUwsQ0FBV0MsS0FBWCxzQ0FBSixFQUEwQztBQUN4QyxhQUFPLElBQVA7QUFDRDs7QUFFRCxRQUFJLEtBQUtELEtBQUwsQ0FBV0UsYUFBZixFQUE4QjtBQUM1QixhQUFPLEtBQUtDLGdCQUFMLEVBQVA7QUFDRCxLQUZELE1BRU87QUFDTCxhQUFPLEtBQUtDLG9CQUFMLEVBQVA7QUFDRDtBQUNGOztBQUVERCxxQkFBbUI7QUFBQSxpQkFDSyxLQUFLSCxLQURWO0FBQUEsVUFDVkMsS0FEVSxVQUNWQSxLQURVO0FBQUEsVUFDSEksSUFERyxVQUNIQSxJQURHOzs7QUFHakIsVUFBTUMsUUFBUSwrQkFBcUI7QUFDakNDLGFBQU8sS0FBS1AsS0FBTCxDQUFXRTtBQURlLEtBQXJCLENBQWQ7O0FBSUEsVUFBTU0sY0FBYyxtQ0FBeUJDLHFCQUF6QixDQUErQ0osSUFBL0MsRUFBcURKLEtBQXJELENBQXBCO0FBQ0EsVUFBTUgsK0NBQU47O0FBRUEsV0FDRTtBQUNFLGlCQUFXQSxTQURiO0FBRUUsYUFBT1EsS0FGVDtBQUdFLG1CQUFhRSxXQUhmO0FBSUUscUJBQWVSLFNBQVM7QUFDdEIsZUFBTyw4QkFBQyxTQUFELGVBQWVBLEtBQWYsSUFBc0IsWUFBWSxLQUFLQSxLQUFMLENBQVdVLFVBQTdDLEVBQXlELFdBQVcsS0FBS1YsS0FBTCxDQUFXVyxTQUEvRSxJQUFQO0FBQ0QsT0FOSDtBQU9FLHFCQUFlLEtBQUtDLGFBUHRCO0FBUUUscUJBQWUsS0FBS0M7QUFSdEIsTUFERjtBQVlEOztBQUVEVCx5QkFBdUI7QUFBQSxrQkFDQyxLQUFLSixLQUROO0FBQUEsVUFDZEMsS0FEYyxXQUNkQSxLQURjO0FBQUEsVUFDUEksSUFETyxXQUNQQSxJQURPOzs7QUFHckIsVUFBTUMsUUFBUSxrQ0FBd0I7QUFDcENRLGlCQUFXLEtBQUtkLEtBQUwsQ0FBV2UsTUFBWCxDQUFrQkMsUUFBbEIsRUFEeUI7QUFFcENDLGdCQUFVLEtBQUtqQixLQUFMLENBQVdlLE1BQVgsQ0FBa0JHLE9BQWxCLEVBRjBCO0FBR3BDQyxrQkFBWSxLQUFLbkIsS0FBTCxDQUFXb0I7QUFIYSxLQUF4QixDQUFkOztBQU1BLFVBQU1aLGNBQWMsbUNBQXlCQyxxQkFBekIsQ0FBK0NKLElBQS9DLEVBQXFESixLQUFyRCxDQUFwQjtBQUNBLFVBQU1ILGtEQUFOOztBQUVBLFdBQ0U7QUFDRSxpQkFBV0EsU0FEYjtBQUVFLGFBQU9RLEtBRlQ7QUFHRSxtQkFBYUUsV0FIZjtBQUlFLHFCQUFlUixTQUFTO0FBQ3RCLGVBQU8sOEJBQUMsU0FBRCxlQUFlQSxLQUFmLElBQXNCLFlBQVksS0FBS0EsS0FBTCxDQUFXVSxVQUE3QyxFQUF5RCxXQUFXLEtBQUtWLEtBQUwsQ0FBV1csU0FBL0UsSUFBUDtBQUNELE9BTkg7QUFPRSxxQkFBZSxLQUFLQyxhQVB0QjtBQVFFLHFCQUFlLEtBQUtTO0FBUnRCLE1BREY7QUFZRDs7QUFHRFQsa0JBQWdCO0FBQ2QsV0FDRTtBQUFBO0FBQUEsUUFBSyxXQUFVLGVBQWY7QUFDRSw4Q0FBTSxXQUFVLGdCQUFoQjtBQURGLEtBREY7QUFLRDs7QUFHREMsMEJBQXdCUyxHQUF4QixFQUE2QkMsS0FBN0IsRUFBb0M7QUFDbEMsUUFBSSxLQUFLQyxlQUFMLENBQXFCRixHQUFyQixDQUFKLEVBQStCO0FBQzdCLGFBQ0U7QUFDRSxlQUFPLEtBQUt0QixLQUFMLENBQVdFLGFBRHBCO0FBRUUsZUFBTyxJQUZUO0FBR0Usb0JBQVksS0FBS0YsS0FBTCxDQUFXVSxVQUh6QjtBQUlFLG1CQUFXLEtBQUtWLEtBQUwsQ0FBV1c7QUFKeEIsUUFERjtBQVFELEtBVEQsTUFTTztBQUNMLGFBQU8sS0FBS1UsYUFBTCxDQUFtQkMsR0FBbkIsRUFBd0JDLEtBQXhCLENBQVA7QUFDRDtBQUNGOztBQUdERixnQkFBY0MsR0FBZCxFQUFtQkMsS0FBbkIsRUFBMEI7QUFDeEIsUUFBSUQsSUFBSUcsUUFBSixJQUFnQkgsSUFBSUcsUUFBSixDQUFhQyxNQUFiLEtBQXdCLEdBQTVDLEVBQWlEO0FBQy9DLGFBQ0U7QUFBQTtBQUFBLFVBQUssV0FBVSxrQ0FBZjtBQUNFO0FBQUE7QUFBQSxZQUFpQixTQUFTLEtBQUsxQixLQUFMLENBQVcyQixPQUFyQztBQUNFO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFERjtBQURGLE9BREY7QUFTRCxLQVZELE1BVU87QUFDTCxhQUNFO0FBQUE7QUFBQSxVQUFLLFdBQVUscUJBQWY7QUFDRTtBQUFBO0FBQUE7QUFBQTtBQUFBLFNBREY7QUFJRTtBQUFBO0FBQUEsWUFBUSxTQUFTSixLQUFqQjtBQUFBO0FBQUE7QUFKRixPQURGO0FBUUQ7QUFDRjs7QUFFREMsa0JBQWdCRixHQUFoQixFQUFxQjtBQUNuQixXQUFPQSxJQUFJTSxNQUFKLElBQ0xOLElBQUlNLE1BQUosQ0FBV0MsTUFETixJQUVMUCxJQUFJTSxNQUFKLENBQVdDLE1BQVgsQ0FBa0IsQ0FBbEIsQ0FGSyxJQUdMUCxJQUFJTSxNQUFKLENBQVdDLE1BQVgsQ0FBa0IsQ0FBbEIsRUFBcUJDLElBQXJCLEtBQThCLFdBSGhDO0FBSUQ7QUFuSTJELEMsVUFDckRDLFMsR0FBWTtBQUNqQjlCLFNBQU8sb0JBQVUrQixTQUFWLENBQW9CLENBQ3pCLG9CQUFVQyxNQURlLEVBRXpCLG9CQUFVQyxNQUZlLENBQXBCLEVBR0pDLFVBSmM7QUFLakI5QixRQUFNLG9CQUFVNEIsTUFBVixDQUFpQkUsVUFMTjtBQU1qQmYscUJBQW1CLG9CQUFVYSxNQUFWLENBQWlCRSxVQU5uQjtBQU9qQlIsV0FBUyxvQkFBVVMsSUFBVixDQUFlRCxVQVBQO0FBUWpCcEIsVUFBUSwyQkFBZW9CLFVBUk47QUFTakJ6QixjQUFZLG9CQUFVMEIsSUFBVixDQUFlRCxVQVRWO0FBVWpCakMsaUJBQWUsb0JBQVUrQixNQVZSO0FBV2pCdEIsYUFBVyxvQkFBVXlCLElBQVYsQ0FBZUQ7QUFYVCxDO2tCQURBdEMsZ0IiLCJmaWxlIjoicHItaW5mby1jb250cm9sbGVyLmpzIiwic291cmNlUm9vdCI6Ii9ob21lL3RyYXZpcy9idWlsZC9hdG9tL2F0b20vb3V0L2FwcC9ub2RlX21vZHVsZXMvZ2l0aHViIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0IGZyb20gJ3JlYWN0JztcbmltcG9ydCBQcm9wVHlwZXMgZnJvbSAncHJvcC10eXBlcyc7XG5pbXBvcnQge2F1dG9iaW5kfSBmcm9tICdjb3JlLWRlY29yYXRvcnMnO1xuXG5pbXBvcnQge1JlbW90ZVByb3BUeXBlfSBmcm9tICcuLi9wcm9wLXR5cGVzJztcbmltcG9ydCBSZWxheVJvb3RDb250YWluZXIgZnJvbSAnLi4vY29udGFpbmVycy9yZWxheS1yb290LWNvbnRhaW5lcic7XG5pbXBvcnQgUHJTZWxlY3Rpb25CeVVybENvbnRhaW5lciBmcm9tICcuLi9jb250YWluZXJzL3ByLXNlbGVjdGlvbi1ieS11cmwtY29udGFpbmVyJztcbmltcG9ydCBQclNlbGVjdGlvbkJ5QnJhbmNoQ29udGFpbmVyIGZyb20gJy4uL2NvbnRhaW5lcnMvcHItc2VsZWN0aW9uLWJ5LWJyYW5jaC1jb250YWluZXInO1xuaW1wb3J0IEdpdGh1YkxvZ2luVmlldyBmcm9tICcuLi92aWV3cy9naXRodWItbG9naW4tdmlldyc7XG5pbXBvcnQgUHJJbmZvQnlCcmFuY2hSb3V0ZSBmcm9tICcuLi9yb3V0ZXMvcHItaW5mby1ieS1icmFuY2gtcm91dGUnO1xuaW1wb3J0IFBySW5mb0J5VXJsUm91dGUgZnJvbSAnLi4vcm91dGVzL3ByLWluZm8tYnktdXJsLXJvdXRlJztcbmltcG9ydCBSZWxheU5ldHdvcmtMYXllck1hbmFnZXIgZnJvbSAnLi4vcmVsYXktbmV0d29yay1sYXllci1tYW5hZ2VyJztcbmltcG9ydCB7VU5BVVRIRU5USUNBVEVEfSBmcm9tICcuLi9tb2RlbHMvZ2l0aHViLWxvZ2luLW1vZGVsJztcblxuZXhwb3J0IGRlZmF1bHQgY2xhc3MgUHJJbmZvQ29udHJvbGxlciBleHRlbmRzIFJlYWN0LkNvbXBvbmVudCB7XG4gIHN0YXRpYyBwcm9wVHlwZXMgPSB7XG4gICAgdG9rZW46IFByb3BUeXBlcy5vbmVPZlR5cGUoW1xuICAgICAgUHJvcFR5cGVzLnN0cmluZyxcbiAgICAgIFByb3BUeXBlcy5zeW1ib2wsXG4gICAgXSkuaXNSZXF1aXJlZCxcbiAgICBob3N0OiBQcm9wVHlwZXMuc3RyaW5nLmlzUmVxdWlyZWQsXG4gICAgY3VycmVudEJyYW5jaE5hbWU6IFByb3BUeXBlcy5zdHJpbmcuaXNSZXF1aXJlZCxcbiAgICBvbkxvZ2luOiBQcm9wVHlwZXMuZnVuYy5pc1JlcXVpcmVkLFxuICAgIHJlbW90ZTogUmVtb3RlUHJvcFR5cGUuaXNSZXF1aXJlZCxcbiAgICBvblNlbGVjdFByOiBQcm9wVHlwZXMuZnVuYy5pc1JlcXVpcmVkLFxuICAgIHNlbGVjdGVkUHJVcmw6IFByb3BUeXBlcy5zdHJpbmcsXG4gICAgb25VbnBpblByOiBQcm9wVHlwZXMuZnVuYy5pc1JlcXVpcmVkLFxuICB9XG5cbiAgcmVuZGVyKCkge1xuICAgIGlmICh0aGlzLnByb3BzLnRva2VuID09PSBVTkFVVEhFTlRJQ0FURUQpIHtcbiAgICAgIHJldHVybiBudWxsO1xuICAgIH1cblxuICAgIGlmICh0aGlzLnByb3BzLnNlbGVjdGVkUHJVcmwpIHtcbiAgICAgIHJldHVybiB0aGlzLnJlbmRlclNwZWNpZmljUHIoKTtcbiAgICB9IGVsc2Uge1xuICAgICAgcmV0dXJuIHRoaXMucmVuZGVyUHJCeUJyYW5jaE5hbWUoKTtcbiAgICB9XG4gIH1cblxuICByZW5kZXJTcGVjaWZpY1ByKCkge1xuICAgIGNvbnN0IHt0b2tlbiwgaG9zdH0gPSB0aGlzLnByb3BzO1xuXG4gICAgY29uc3Qgcm91dGUgPSBuZXcgUHJJbmZvQnlVcmxSb3V0ZSh7XG4gICAgICBwclVybDogdGhpcy5wcm9wcy5zZWxlY3RlZFByVXJsLFxuICAgIH0pO1xuXG4gICAgY29uc3QgZW52aXJvbm1lbnQgPSBSZWxheU5ldHdvcmtMYXllck1hbmFnZXIuZ2V0RW52aXJvbm1lbnRGb3JIb3N0KGhvc3QsIHRva2VuKTtcbiAgICBjb25zdCBDb21wb25lbnQgPSBQclNlbGVjdGlvbkJ5VXJsQ29udGFpbmVyO1xuXG4gICAgcmV0dXJuIChcbiAgICAgIDxSZWxheVJvb3RDb250YWluZXJcbiAgICAgICAgQ29tcG9uZW50PXtDb21wb25lbnR9XG4gICAgICAgIHJvdXRlPXtyb3V0ZX1cbiAgICAgICAgZW52aXJvbm1lbnQ9e2Vudmlyb25tZW50fVxuICAgICAgICByZW5kZXJGZXRjaGVkPXtwcm9wcyA9PiB7XG4gICAgICAgICAgcmV0dXJuIDxDb21wb25lbnQgey4uLnByb3BzfSBvblNlbGVjdFByPXt0aGlzLnByb3BzLm9uU2VsZWN0UHJ9IG9uVW5waW5Qcj17dGhpcy5wcm9wcy5vblVucGluUHJ9IC8+O1xuICAgICAgICB9fVxuICAgICAgICByZW5kZXJMb2FkaW5nPXt0aGlzLnJlbmRlckxvYWRpbmd9XG4gICAgICAgIHJlbmRlckZhaWx1cmU9e3RoaXMucmVuZGVyU3BlY2lmaWNQckZhaWx1cmV9XG4gICAgICAvPlxuICAgICk7XG4gIH1cblxuICByZW5kZXJQckJ5QnJhbmNoTmFtZSgpIHtcbiAgICBjb25zdCB7dG9rZW4sIGhvc3R9ID0gdGhpcy5wcm9wcztcblxuICAgIGNvbnN0IHJvdXRlID0gbmV3IFBySW5mb0J5QnJhbmNoUm91dGUoe1xuICAgICAgcmVwb093bmVyOiB0aGlzLnByb3BzLnJlbW90ZS5nZXRPd25lcigpLFxuICAgICAgcmVwb05hbWU6IHRoaXMucHJvcHMucmVtb3RlLmdldFJlcG8oKSxcbiAgICAgIGJyYW5jaE5hbWU6IHRoaXMucHJvcHMuY3VycmVudEJyYW5jaE5hbWUsXG4gICAgfSk7XG5cbiAgICBjb25zdCBlbnZpcm9ubWVudCA9IFJlbGF5TmV0d29ya0xheWVyTWFuYWdlci5nZXRFbnZpcm9ubWVudEZvckhvc3QoaG9zdCwgdG9rZW4pO1xuICAgIGNvbnN0IENvbXBvbmVudCA9IFByU2VsZWN0aW9uQnlCcmFuY2hDb250YWluZXI7XG5cbiAgICByZXR1cm4gKFxuICAgICAgPFJlbGF5Um9vdENvbnRhaW5lclxuICAgICAgICBDb21wb25lbnQ9e0NvbXBvbmVudH1cbiAgICAgICAgcm91dGU9e3JvdXRlfVxuICAgICAgICBlbnZpcm9ubWVudD17ZW52aXJvbm1lbnR9XG4gICAgICAgIHJlbmRlckZldGNoZWQ9e3Byb3BzID0+IHtcbiAgICAgICAgICByZXR1cm4gPENvbXBvbmVudCB7Li4ucHJvcHN9IG9uU2VsZWN0UHI9e3RoaXMucHJvcHMub25TZWxlY3RQcn0gb25VbnBpblByPXt0aGlzLnByb3BzLm9uVW5waW5Qcn0gLz47XG4gICAgICAgIH19XG4gICAgICAgIHJlbmRlckxvYWRpbmc9e3RoaXMucmVuZGVyTG9hZGluZ31cbiAgICAgICAgcmVuZGVyRmFpbHVyZT17dGhpcy5yZW5kZXJGYWlsdXJlfVxuICAgICAgLz5cbiAgICApO1xuICB9XG5cbiAgQGF1dG9iaW5kXG4gIHJlbmRlckxvYWRpbmcoKSB7XG4gICAgcmV0dXJuIChcbiAgICAgIDxkaXYgY2xhc3NOYW1lPVwiZ2l0aHViLUxvYWRlclwiPlxuICAgICAgICA8c3BhbiBjbGFzc05hbWU9XCJnaXRodWItU3Bpbm5lclwiIC8+XG4gICAgICA8L2Rpdj5cbiAgICApO1xuICB9XG5cbiAgQGF1dG9iaW5kXG4gIHJlbmRlclNwZWNpZmljUHJGYWlsdXJlKGVyciwgcmV0cnkpIHtcbiAgICBpZiAodGhpcy5pc05vdEZvdW5kRXJyb3IoZXJyKSkge1xuICAgICAgcmV0dXJuIChcbiAgICAgICAgPFByU2VsZWN0aW9uQnlVcmxDb250YWluZXJcbiAgICAgICAgICBwclVybD17dGhpcy5wcm9wcy5zZWxlY3RlZFByVXJsfVxuICAgICAgICAgIHF1ZXJ5PXtudWxsfVxuICAgICAgICAgIG9uU2VsZWN0UHI9e3RoaXMucHJvcHMub25TZWxlY3RQcn1cbiAgICAgICAgICBvblVucGluUHI9e3RoaXMucHJvcHMub25VbnBpblByfVxuICAgICAgICAvPlxuICAgICAgKTtcbiAgICB9IGVsc2Uge1xuICAgICAgcmV0dXJuIHRoaXMucmVuZGVyRmFpbHVyZShlcnIsIHJldHJ5KTtcbiAgICB9XG4gIH1cblxuICBAYXV0b2JpbmRcbiAgcmVuZGVyRmFpbHVyZShlcnIsIHJldHJ5KSB7XG4gICAgaWYgKGVyci5yZXNwb25zZSAmJiBlcnIucmVzcG9uc2Uuc3RhdHVzID09PSA0MDEpIHtcbiAgICAgIHJldHVybiAoXG4gICAgICAgIDxkaXYgY2xhc3NOYW1lPVwiZ2l0aHViLUdpdGh1YkxvZ2luVmlldy1Db250YWluZXJcIj5cbiAgICAgICAgICA8R2l0aHViTG9naW5WaWV3IG9uTG9naW49e3RoaXMucHJvcHMub25Mb2dpbn0+XG4gICAgICAgICAgICA8cD5cbiAgICAgICAgICAgICAgVGhlIEFQSSBlbmRwb2ludCByZXR1cm5lZCBhIHVuYXV0aG9yaXplZCBlcnJvci4gUGxlYXNlIHRyeSB0byByZS1hdXRoZW50aWNhdGUgd2l0aCB0aGUgZW5kcG9pbnQuXG4gICAgICAgICAgICA8L3A+XG4gICAgICAgICAgPC9HaXRodWJMb2dpblZpZXc+XG4gICAgICAgIDwvZGl2PlxuICAgICAgKTtcbiAgICB9IGVsc2Uge1xuICAgICAgcmV0dXJuIChcbiAgICAgICAgPGRpdiBjbGFzc05hbWU9XCJ1bmtub3duLWZhdGFsLWVycm9yXCI+XG4gICAgICAgICAgPGRpdj5cbiAgICAgICAgICAgIEFuIHVua25vd24gZXJyb3Igb2NjdXJyZWQuXG4gICAgICAgICAgPC9kaXY+XG4gICAgICAgICAgPGJ1dHRvbiBvbkNsaWNrPXtyZXRyeX0+VHJ5IEFnYWluPC9idXR0b24+XG4gICAgICAgIDwvZGl2PlxuICAgICAgKTtcbiAgICB9XG4gIH1cblxuICBpc05vdEZvdW5kRXJyb3IoZXJyKSB7XG4gICAgcmV0dXJuIGVyci5zb3VyY2UgJiZcbiAgICAgIGVyci5zb3VyY2UuZXJyb3JzICYmXG4gICAgICBlcnIuc291cmNlLmVycm9yc1swXSAmJlxuICAgICAgZXJyLnNvdXJjZS5lcnJvcnNbMF0udHlwZSA9PT0gJ05PVF9GT1VORCc7XG4gIH1cbn1cbiJdfQ==