'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _desc, _value, _class, _class2, _temp; /** @jsx etch.dom */
/* eslint react/no-unknown-property: "off" */

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _eventKit = require('event-kit');

var _gitTabView = require('../views/git-tab-view');

var _gitTabView2 = _interopRequireDefault(_gitTabView);

var _modelObserver = require('../models/model-observer');

var _modelObserver2 = _interopRequireDefault(_modelObserver);

var _branch = require('../models/branch');

var _commit = require('../models/commit');

var _coreDecorators = require('core-decorators');

var _yubikiri = require('yubikiri');

var _yubikiri2 = _interopRequireDefault(_yubikiri);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

let GitTabController = (_class = (_temp = _class2 = class GitTabController {

  constructor(props) {
    this.props = props;
    this.stagingOperationInProgress = false;
    this.lastFocus = _gitTabView2.default.focus.STAGING;

    this.repositoryObserver = new _modelObserver2.default({
      fetchData: this.fetchRepositoryData,
      didUpdate: () => {
        this.refreshResolutionProgress(false, false);
        return this.update();
      }
    });
    this.repositoryObserver.setActiveModel(props.repository);
    _etch2.default.initialize(this);

    this.element.addEventListener('focusin', this.rememberLastFocus);
    this.subscriptions = new _eventKit.Disposable(() => this.element.removeEventListener('focusin', this.rememberLastFocus));
  }

  serialize() {
    return {
      deserializer: 'GitTabControllerStub'
    };
  }

  render() {
    const modelData = this.repositoryObserver.getActiveModelData() || this.defaultRepositoryData();
    const hasUndoHistory = this.props.repository ? this.hasUndoHistory() : false;
    return _etch2.default.dom(_gitTabView2.default, _extends({
      ref: 'gitTab'
    }, modelData, {
      repository: this.props.repository,
      resolutionProgress: this.props.resolutionProgress,
      workspace: this.props.workspace,
      commandRegistry: this.props.commandRegistry,
      notificationManager: this.props.notificationManager,
      initializeRepo: this.props.initializeRepo,
      didSelectFilePath: this.props.didSelectFilePath,
      didDiveIntoFilePath: this.props.didDiveIntoFilePath,
      didSelectMergeConflictFile: this.props.didSelectMergeConflictFile,
      didDiveIntoMergeConflictPath: this.props.didDiveIntoMergeConflictPath,
      focusFilePatchView: this.props.focusFilePatchView,
      stageFilePatch: this.stageFilePatch,
      unstageFilePatch: this.unstageFilePatch,
      openFiles: this.props.openFiles,
      discardWorkDirChangesForPaths: this.props.discardWorkDirChangesForPaths,
      attemptFileStageOperation: this.attemptFileStageOperation,
      prepareToCommit: this.prepareToCommit,
      commit: this.commit,
      setAmending: this.setAmending,
      isAmending: this.props.isAmending,
      hasUndoHistory: hasUndoHistory,
      undoLastDiscard: this.props.undoLastDiscard,
      abortMerge: this.abortMerge,
      resolveAsOurs: this.resolveAsOurs,
      resolveAsTheirs: this.resolveAsTheirs,
      push: this.push,
      pull: this.pull,
      fetch: this.fetch,
      checkout: this.checkout
    }));
  }

  update(props) {
    var _this = this;

    return _asyncToGenerator(function* () {
      const oldProps = _this.props;
      _this.props = _extends({}, _this.props, props);
      if (_this.props.repository !== oldProps.repository) {
        yield _this.repositoryObserver.setActiveModel(props.repository);
      } else if (_this.props.isAmending !== oldProps.isAmending) {
        yield _this.repositoryObserver.refreshModelData(_this.getActiveRepository());
      }
      return _etch2.default.update(_this);
    })();
  }

  destroy() {
    this.subscriptions.dispose();
    this.repositoryObserver.destroy();
  }

  getTitle() {
    return 'Git';
  }

  getIconName() {
    return 'git-commit';
  }

  getDefaultLocation() {
    return 'right';
  }

  getPreferredWidth() {
    return 400;
  }

  getURI() {
    return 'atom-github://stub-uri/git-tab-controller';
  }

  getWorkingDirectory() {
    return this.props.repository.getWorkingDirectoryPath();
  }

  getLastModelDataRefreshPromise() {
    return this.repositoryObserver.getLastModelDataRefreshPromise();
  }

  getActiveRepository() {
    return this.repositoryObserver.getActiveModel();
  }

  refreshModelData() {
    return this.repositoryObserver.refreshModelData();
  }

  fetchRepositoryData(repository) {
    return (0, _yubikiri2.default)({
      lastCommit: repository.getLastCommit(),
      isMerging: repository.isMerging(),
      isRebasing: repository.isRebasing(),
      currentBranch: repository.getCurrentBranch(),
      unstagedChanges: repository.getUnstagedChanges(),
      stagedChanges: this.fetchStagedChanges(repository),
      mergeConflicts: repository.getMergeConflicts(),
      workingDirectoryPath: repository.getWorkingDirectoryPath(),
      mergeMessage: (() => {
        var _ref = _asyncToGenerator(function* (query) {
          const isMerging = yield query.isMerging;
          return isMerging ? repository.getMergeMessage() : null;
        });

        return function mergeMessage(_x) {
          return _ref.apply(this, arguments);
        };
      })(),
      fetchInProgress: Promise.resolve(false)
    });
  }

  defaultRepositoryData() {
    return {
      lastCommit: _commit.nullCommit,
      isMerging: false,
      isRebasing: false,
      currentBranch: _branch.nullBranch,
      unstagedChanges: [],
      stagedChanges: [],
      mergeConflicts: [],
      workingDirectoryPath: this.props.repository.getWorkingDirectoryPath(),
      mergeMessage: null,
      fetchInProgress: true
    };
  }

  fetchStagedChanges(repository) {
    if (this.props.isAmending) {
      return repository.getStagedChangesSinceParentCommit();
    } else {
      return repository.getStagedChanges();
    }
  }

  /*
   * Begin (but don't await) an async conflict-counting task for each merge conflict path that has no conflict
   * marker count yet. Omit any path that's already open in a TextEditor or that has already been counted.
   *
   * includeOpen - update marker counts for files that are currently open in TextEditors
   * includeCounts - update marker counts for files that have been counted before
   */
  refreshResolutionProgress(includeOpen, includeCounted) {
    const data = this.repositoryObserver.getActiveModelData();
    if (!data) {
      return;
    }

    const openPaths = new Set(this.props.workspace.getTextEditors().map(editor => editor.getPath()));
    for (let i = 0; i < data.mergeConflicts.length; i++) {
      const conflictPath = _path2.default.join(data.workingDirectoryPath, data.mergeConflicts[i].filePath);

      if (!includeOpen && openPaths.has(conflictPath)) {
        continue;
      }

      if (!includeCounted && this.props.resolutionProgress.getRemaining(conflictPath) !== undefined) {
        continue;
      }

      this.props.refreshResolutionProgress(conflictPath);
    }
  }

  unstageFilePatch(filePatch) {
    return this.getActiveRepository().applyPatchToIndex(filePatch.getUnstagePatch());
  }

  attemptFileStageOperation(filePaths, stageStatus) {
    if (this.stagingOperationInProgress) {
      return {
        stageOperationPromise: Promise.resolve(),
        selectionUpdatePromise: Promise.resolve()
      };
    }

    this.stagingOperationInProgress = true;

    const fileListUpdatePromise = this.refs.gitTab.refs.stagingView.getNextListUpdatePromise();
    let stageOperationPromise;
    if (stageStatus === 'staged') {
      stageOperationPromise = this.unstageFiles(filePaths);
    } else {
      stageOperationPromise = this.stageFiles(filePaths);
    }
    const selectionUpdatePromise = fileListUpdatePromise.then(() => {
      this.stagingOperationInProgress = false;
    });

    return { stageOperationPromise, selectionUpdatePromise };
  }

  stageFiles(filePaths) {
    var _this2 = this;

    return _asyncToGenerator(function* () {
      const pathsToIgnore = [];
      const repository = _this2.getActiveRepository();
      for (const filePath of filePaths) {
        if (yield repository.pathHasMergeMarkers(filePath)) {
          // eslint-disable-line no-await-in-loop
          const choice = atom.confirm({
            message: 'File contains merge markers: ',
            detailedMessage: `Do you still want to stage this file?\n${filePath}`,
            buttons: ['Stage', 'Cancel']
          });
          if (choice !== 0) {
            pathsToIgnore.push(filePath);
          }
        }
      }
      const pathsToStage = filePaths.filter(function (filePath) {
        return !pathsToIgnore.includes(filePath);
      });
      return repository.stageFiles(pathsToStage);
    })();
  }

  unstageFiles(filePaths) {
    const repository = this.getActiveRepository();
    if (this.props.isAmending) {
      return repository.stageFilesFromParentCommit(filePaths);
    } else {
      return repository.unstageFiles(filePaths);
    }
  }

  prepareToCommit() {
    var _this3 = this;

    return _asyncToGenerator(function* () {
      return !(yield _this3.props.ensureGitTab());
    })();
  }

  commit(message) {
    var _this4 = this;

    return _asyncToGenerator(function* () {
      try {
        yield _this4.getActiveRepository().commit(message, { amend: _this4.props.isAmending });
        _this4.setAmending(false);
      } catch (e) {
        if (e.code === 'ECONFLICT') {
          _this4.props.notificationManager.addError('Cannot commit without resolving all the merge conflicts first.', { dismissable: true });
        } else {
          throw e;
        }
      }
    })();
  }

  setAmending(isAmending) {
    this.props.didChangeAmending(isAmending);
  }

  abortMerge() {
    var _this5 = this;

    return _asyncToGenerator(function* () {
      const choice = atom.confirm({
        message: 'Abort merge',
        detailedMessage: 'Are you sure?',
        buttons: ['Abort', 'Cancel']
      });
      if (choice !== 0) {
        return null;
      }

      try {
        yield _this5.getActiveRepository().abortMerge();
      } catch (e) {
        if (e.code === 'EDIRTYSTAGED') {
          _this5.props.notificationManager.addError(`Cannot abort because ${e.path} is both dirty and staged.`, { dismissable: true });
        } else {
          throw e;
        }
      }
      return _etch2.default.update(_this5);
    })();
  }

  resolveAsOurs(paths) {
    var _this6 = this;

    return _asyncToGenerator(function* () {
      const data = _this6.repositoryObserver.getActiveModelData();
      if (!data) {
        return;
      }
      const side = data.isRebasing ? 'theirs' : 'ours';
      yield _this6.getActiveRepository().checkoutSide(side, paths);
      _this6.refreshResolutionProgress(false, true);
    })();
  }

  resolveAsTheirs(paths) {
    var _this7 = this;

    return _asyncToGenerator(function* () {
      const data = _this7.repositoryObserver.getActiveModelData();
      if (!data) {
        return;
      }
      const side = data.isRebasing ? 'ours' : 'theirs';
      yield _this7.getActiveRepository().checkoutSide(side, paths);
      _this7.refreshResolutionProgress(false, true);
    })();
  }

  checkout(branchName, options) {
    return this.getActiveRepository().checkout(branchName, options);
  }

  rememberLastFocus(event) {
    this.lastFocus = this.refs.gitTab.rememberFocus(event) || _gitTabView2.default.focus.STAGING;
  }

  restoreFocus() {
    this.refs.gitTab.setFocus(this.lastFocus);
  }

  hasFocus() {
    return this.element.contains(document.activeElement);
  }

  wasActivated() {
    process.nextTick(() => this.restoreFocus());
  }

  focusAndSelectStagingItem(filePath, stagingStatus) {
    return this.refs.gitTab.focusAndSelectStagingItem(filePath, stagingStatus);
  }

  quietlySelectItem(filePath, stagingStatus) {
    return this.refs.gitTab.quietlySelectItem(filePath, stagingStatus);
  }

  hasUndoHistory() {
    return this.props.repository.hasDiscardHistory();
  }
}, _class2.focus = _extends({}, _gitTabView2.default.focus), _temp), (_applyDecoratedDescriptor(_class.prototype, 'fetchRepositoryData', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'fetchRepositoryData'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'attemptFileStageOperation', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'attemptFileStageOperation'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'unstageFiles', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'unstageFiles'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'prepareToCommit', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'prepareToCommit'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'commit', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'commit'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'setAmending', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'setAmending'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'abortMerge', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'abortMerge'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'resolveAsOurs', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'resolveAsOurs'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'resolveAsTheirs', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'resolveAsTheirs'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'checkout', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'checkout'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'rememberLastFocus', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'rememberLastFocus'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'quietlySelectItem', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'quietlySelectItem'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'hasUndoHistory', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'hasUndoHistory'), _class.prototype)), _class);
exports.default = GitTabController;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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