'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IssueComment = undefined;

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRelay = require('react-relay');

var _reactRelay2 = _interopRequireDefault(_reactRelay);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _octicon = require('../../views/octicon');

var _octicon2 = _interopRequireDefault(_octicon);

var _timeago = require('../../views/timeago');

var _timeago2 = _interopRequireDefault(_timeago);

var _githubDotcomMarkdown = require('../../views/github-dotcom-markdown');

var _githubDotcomMarkdown2 = _interopRequireDefault(_githubDotcomMarkdown);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

let IssueComment = exports.IssueComment = (_temp = _class = class IssueComment extends _react2.default.Component {

  render() {
    const comment = this.props.item;
    return _react2.default.createElement(
      'div',
      { className: 'issue' },
      _react2.default.createElement(
        'div',
        { className: 'info-row' },
        _react2.default.createElement(_octicon2.default, { className: 'pre-timeline-item-icon', icon: 'comment' }),
        _react2.default.createElement('img', { className: 'author-avatar', src: comment.author.avatarUrl, title: comment.author.login }),
        _react2.default.createElement(
          'span',
          { className: 'comment-message-header' },
          comment.author.login,
          ' commented on ',
          _react2.default.createElement(_timeago2.default, { time: comment.createdAt })
        )
      ),
      _react2.default.createElement(_githubDotcomMarkdown2.default, { html: comment.bodyHTML, switchToIssueish: this.props.switchToIssueish })
    );
  }
}, _class.propTypes = {
  switchToIssueish: _propTypes2.default.func.isRequired,
  item: _propTypes2.default.object.isRequired
}, _temp);
exports.default = _reactRelay2.default.createContainer(IssueComment, {
  fragments: {
    item: () => function () {
      return {
        children: [{
          children: [{
            fieldName: 'avatarUrl',
            kind: 'Field',
            metadata: {},
            type: 'URI'
          }, {
            fieldName: 'login',
            kind: 'Field',
            metadata: {},
            type: 'String'
          }, {
            fieldName: '__typename',
            kind: 'Field',
            metadata: {
              isGenerated: true,
              isRequisite: true
            },
            type: 'String'
          }, {
            children: [{
              fieldName: 'id',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'ID'
            }, {
              fieldName: '__typename',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'String'
            }],
            id: _reactRelay2.default.QL.__id(),
            kind: 'Fragment',
            metadata: {
              isAbstract: true
            },
            name: 'IdFragment',
            type: 'Node'
          }],
          fieldName: 'author',
          kind: 'Field',
          metadata: {
            canHaveSubselections: true,
            inferredRootCallName: 'node',
            inferredPrimaryKey: 'id',
            isAbstract: true
          },
          type: 'Actor'
        }, {
          fieldName: 'bodyHTML',
          kind: 'Field',
          metadata: {},
          type: 'HTML'
        }, {
          fieldName: 'createdAt',
          kind: 'Field',
          metadata: {},
          type: 'DateTime'
        }, {
          fieldName: 'id',
          kind: 'Field',
          metadata: {
            isGenerated: true,
            isRequisite: true
          },
          type: 'ID'
        }],
        id: _reactRelay2.default.QL.__id(),
        kind: 'Fragment',
        metadata: {},
        name: 'Issue_ItemRelayQL',
        type: 'IssueComment'
      };
    }()
  }
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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