'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Commit = undefined;

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRelay = require('react-relay');

var _reactRelay2 = _interopRequireDefault(_reactRelay);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _octicon = require('../../views/octicon');

var _octicon2 = _interopRequireDefault(_octicon);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

let Commit = exports.Commit = (_temp = _class = class Commit extends _react2.default.Component {

  authoredByCommitter(commit) {
    if (commit.authoredByCommitter) {
      return true;
    }
    // If you commit on GitHub online the committer details would be:
    //
    //    name: "GitHub"
    //    email: "noreply@github.com"
    //    user: null
    //
    if (commit.committer.email === 'noreply@github.com') {
      return true;
    }
    if (commit.committer.name === 'GitHub' && commit.committer.user === null) {
      return true;
    }

    return false;
  }

  renderCommitter(commit) {
    if (!this.authoredByCommitter(commit)) {
      return _react2.default.createElement('img', {
        className: 'author-avatar', src: commit.committer.avatarUrl,
        title: commit.committer.user ? commit.committer.user.login : commit.committer.name
      });
    } else {
      return null;
    }
  }
  render() {
    const commit = this.props.item;
    return _react2.default.createElement(
      'div',
      { className: 'commit' },
      _react2.default.createElement(_octicon2.default, { className: 'pre-timeline-item-icon', icon: 'git-commit' }),
      _react2.default.createElement(
        'span',
        { className: 'commit-author' },
        _react2.default.createElement('img', {
          className: 'author-avatar', src: commit.author.avatarUrl,
          title: commit.author.user ? commit.author.user.login : commit.author.name
        }),
        this.renderCommitter(commit)
      ),
      _react2.default.createElement('span', {
        className: 'commit-message-headline',
        title: commit.message,
        dangerouslySetInnerHTML: { __html: commit.messageHeadlineHTML }
      }),
      _react2.default.createElement(
        'span',
        { className: 'commit-sha' },
        commit.oid.slice(0, 8)
      )
    );
  }
}, _class.propTypes = {
  item: _propTypes2.default.object.isRequired
}, _temp);
exports.default = _reactRelay2.default.createContainer(Commit, {
  fragments: {
    item: () => function () {
      return {
        children: [{
          children: [{
            fieldName: 'name',
            kind: 'Field',
            metadata: {},
            type: 'String'
          }, {
            fieldName: 'avatarUrl',
            kind: 'Field',
            metadata: {},
            type: 'URI'
          }, {
            children: [{
              fieldName: 'login',
              kind: 'Field',
              metadata: {},
              type: 'String'
            }, {
              fieldName: 'id',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'ID'
            }],
            fieldName: 'user',
            kind: 'Field',
            metadata: {
              canHaveSubselections: true,
              inferredRootCallName: 'node',
              inferredPrimaryKey: 'id'
            },
            type: 'User'
          }],
          fieldName: 'author',
          kind: 'Field',
          metadata: {
            canHaveSubselections: true
          },
          type: 'GitActor'
        }, {
          children: [{
            fieldName: 'name',
            kind: 'Field',
            metadata: {},
            type: 'String'
          }, {
            fieldName: 'avatarUrl',
            kind: 'Field',
            metadata: {},
            type: 'URI'
          }, {
            children: [{
              fieldName: 'login',
              kind: 'Field',
              metadata: {},
              type: 'String'
            }, {
              fieldName: 'id',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'ID'
            }],
            fieldName: 'user',
            kind: 'Field',
            metadata: {
              canHaveSubselections: true,
              inferredRootCallName: 'node',
              inferredPrimaryKey: 'id'
            },
            type: 'User'
          }],
          fieldName: 'committer',
          kind: 'Field',
          metadata: {
            canHaveSubselections: true
          },
          type: 'GitActor'
        }, {
          fieldName: 'authoredByCommitter',
          kind: 'Field',
          metadata: {},
          type: 'Boolean'
        }, {
          fieldName: 'oid',
          kind: 'Field',
          metadata: {},
          type: 'GitObjectID'
        }, {
          fieldName: 'message',
          kind: 'Field',
          metadata: {},
          type: 'String'
        }, {
          fieldName: 'messageHeadlineHTML',
          kind: 'Field',
          metadata: {},
          type: 'HTML'
        }, {
          fieldName: 'id',
          kind: 'Field',
          metadata: {
            isGenerated: true,
            isRequisite: true
          },
          type: 'ID'
        }],
        id: _reactRelay2.default.QL.__id(),
        kind: 'Fragment',
        metadata: {},
        name: 'Commit_ItemRelayQL',
        type: 'Commit'
      };
    }()
  }
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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