'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = RelayRootContainer;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRelay = require('react-relay');

var _reactRelay2 = _interopRequireDefault(_reactRelay);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * This is a copy of `RelayRootContainer` from the Relay
 * codebase, but with an optional `environment` prop
 * that can be used instead of the singleton `RelayStore`.
 */
function RelayRootContainer(_ref) {
  let Component = _ref.Component,
      forceFetch = _ref.forceFetch,
      onReadyStateChange = _ref.onReadyStateChange,
      renderFailure = _ref.renderFailure,
      renderFetched = _ref.renderFetched,
      renderLoading = _ref.renderLoading,
      route = _ref.route,
      shouldFetch = _ref.shouldFetch,
      environment = _ref.environment;

  return _react2.default.createElement(_reactRelay2.default.Renderer, {
    Container: Component,
    forceFetch: forceFetch,
    onReadyStateChange: onReadyStateChange,
    queryConfig: route,
    environment: environment || _reactRelay2.default.Store,
    shouldFetch: shouldFetch,
    render: (_ref2) => {
      let done = _ref2.done,
          error = _ref2.error,
          props = _ref2.props,
          retry = _ref2.retry,
          stale = _ref2.stale;

      if (error) {
        if (renderFailure) {
          return renderFailure(error, retry);
        }
      } else if (props) {
        if (renderFetched) {
          return renderFetched(props, { done, stale });
        } else {
          return _react2.default.createElement(Component, props);
        }
      } else {
        if (renderLoading) {
          return renderLoading();
        }
      }
      return undefined;
    }
  });
}

RelayRootContainer.propTypes = {
  Component: _reactRelay2.default.PropTypes.Container,
  forceFetch: _propTypes2.default.bool,
  onReadyStateChange: _propTypes2.default.func,
  renderFailure: _propTypes2.default.func,
  renderFetched: _propTypes2.default.func,
  renderLoading: _propTypes2.default.func,
  route: _reactRelay2.default.PropTypes.QueryConfig.isRequired,
  shouldFetch: _propTypes2.default.bool,
  environment: _propTypes2.default.object
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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