'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrSelectionByBranch = undefined;

var _desc, _value, _class, _class2, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRelay = require('react-relay');

var _reactRelay2 = _interopRequireDefault(_reactRelay);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _coreDecorators = require('core-decorators');

var _prInfoContainer = require('./pr-info-container');

var _prInfoContainer2 = _interopRequireDefault(_prInfoContainer);

var _prUrlInputBox = require('../views/pr-url-input-box');

var _prUrlInputBox2 = _interopRequireDefault(_prUrlInputBox);

var _octicon = require('../views/octicon');

var _octicon2 = _interopRequireDefault(_octicon);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

let PrSelectionByBranch = exports.PrSelectionByBranch = (_class = (_temp = _class2 = class PrSelectionByBranch extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);
    this.state = { displayInputBox: false };
  }

  render() {
    return _react2.default.createElement(
      'div',
      { className: 'github-PrSelectionByBranch' },
      this.renderSubview()
    );
  }

  renderSubview() {
    const repo = this.props.query.repository;
    const variables = this.props.relay.variables;

    if (!repo || !repo.pullRequests.edges.length) {
      return _react2.default.createElement(
        'div',
        { className: 'github-PrUrlInputBox-Container' },
        _react2.default.createElement(
          _prUrlInputBox2.default,
          { onSubmit: this.props.onSelectPr },
          _react2.default.createElement('p', { className: 'icon icon-git-pull-request' }),
          _react2.default.createElement(
            'p',
            null,
            'No pull request could be found for the branch ',
            _react2.default.createElement(
              'span',
              { className: 'highlight' },
              variables.branchName
            ),
            'on the repository ',
            _react2.default.createElement(
              'span',
              { className: 'highlight' },
              variables.repoOwner,
              '/',
              variables.repoName
            ),
            '.'
          ),
          _react2.default.createElement(
            'p',
            null,
            'You can manually pin a GitHub pull request to the current branch by entering its URL:'
          )
        )
      );
    }

    const edges = repo.pullRequests.edges;
    if (edges.length === 1) {
      return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(
          'div',
          null,
          _react2.default.createElement(
            'div',
            { className: 'github-PrUrlInputBox-pinButton', onClick: this.toggleInputBoxVisibility },
            _react2.default.createElement(_octicon2.default, {
              title: 'Click here to select another PR.',
              icon: 'pin',
              className: 'pinned-by-url'
            }),
            'Specify Pull Request URL to pin'
          ),
          this.state.displayInputBox && _react2.default.createElement(
            _prUrlInputBox2.default,
            { onSubmit: this.props.onSelectPr },
            _react2.default.createElement(
              'p',
              null,
              'We found a pull request associated with the branch ',
              variables.branchName,
              ' on the repository ',
              variables.repoOwner,
              '/',
              variables.repoName,
              '.'
            ),
            _react2.default.createElement(
              'p',
              null,
              'You can manually pin a different GitHub pull request to the current branch by entering its URL:'
            )
          )
        ),
        _react2.default.createElement(_prInfoContainer2.default, { pullRequest: edges[0].node })
      );
    }

    return this.renderPrSelectionList(edges, repo.pullRequests.totalCount);
  }

  toggleInputBoxVisibility() {
    this.setState({ displayInputBox: !this.state.displayInputBox });
  }

  renderPrSelectionList(edges, totalCount) {
    const variables = this.props.relay.variables;

    return _react2.default.createElement(
      'div',
      { className: 'github-PrSelectionByBranch-listContainer' },
      _react2.default.createElement(
        'div',
        { className: 'github-PrSelectionByBranch-message' },
        'We found ',
        totalCount,
        ' pull requests associated with a branch named ',
        _react2.default.createElement(
          'span',
          { className: 'highlight' },
          variables.branchName
        ),
        ' on the repository ',
        _react2.default.createElement(
          'span',
          { className: 'highlight' },
          variables.repoOwner,
          '/',
          variables.repoName
        ),
        '. Select a pull request below to display it, or specify any pull request URL to pin it manually:'
      ),
      _react2.default.createElement(
        'div',
        { className: 'github-PrSelectionByBranch-input' },
        _react2.default.createElement(_prUrlInputBox2.default, { onSubmit: this.props.onSelectPr })
      ),
      _react2.default.createElement(
        'ul',
        { className: 'github-PrSelectionByBranch-list' },
        edges.map(this.displayPullRequestItem)
      )
    );
  }

  displayPullRequestItem(_ref) {
    let node = _ref.node;

    return _react2.default.createElement(
      'li',
      { key: node.id, onClick: e => this.selectPullRequest(e, node) },
      '#',
      node.number,
      ': ',
      node.title
    );
  }

  setPr(prLink) {
    this.props.onSelectPr(prLink);
  }

  selectPullRequest(event, node) {
    event.preventDefault();
    this.setPr(node.url);
  }
}, _class2.propTypes = {
  query: _propTypes2.default.shape({
    repository: _propTypes2.default.shape({
      pullRequests: _propTypes2.default.shape({
        totalCount: _propTypes2.default.number
      })
    })
  }),
  relay: _propTypes2.default.shape({
    variables: _propTypes2.default.object
  }),
  onSelectPr: _propTypes2.default.func.isRequired,
  onUnpinPr: _propTypes2.default.func.isRequired
}, _temp), (_applyDecoratedDescriptor(_class.prototype, 'toggleInputBoxVisibility', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'toggleInputBoxVisibility'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'displayPullRequestItem', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'displayPullRequestItem'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'setPr', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'setPr'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'selectPullRequest', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'selectPullRequest'), _class.prototype)), _class);
exports.default = _reactRelay2.default.createContainer(PrSelectionByBranch, {
  initialVariables: {
    repoOwner: null,
    repoName: null,
    branchName: null
  },

  fragments: {
    query: () => function (RQL_0) {
      return {
        children: [{
          calls: [{
            kind: 'Call',
            metadata: {},
            name: 'owner',
            value: {
              kind: 'CallVariable',
              callVariableName: 'repoOwner'
            }
          }, {
            kind: 'Call',
            metadata: {},
            name: 'name',
            value: {
              kind: 'CallVariable',
              callVariableName: 'repoName'
            }
          }],
          children: [{
            calls: [{
              kind: 'Call',
              metadata: {},
              name: 'first',
              value: {
                kind: 'CallValue',
                callValue: 30
              }
            }, {
              kind: 'Call',
              metadata: {},
              name: 'headRefName',
              value: {
                kind: 'CallVariable',
                callVariableName: 'branchName'
              }
            }],
            children: [{
              fieldName: 'totalCount',
              kind: 'Field',
              metadata: {},
              type: 'Int'
            }, {
              children: [{
                children: [].concat.apply([], [{
                  fieldName: 'id',
                  kind: 'Field',
                  metadata: {
                    isRequisite: true
                  },
                  type: 'ID'
                }, {
                  fieldName: 'number',
                  kind: 'Field',
                  metadata: {},
                  type: 'Int'
                }, {
                  fieldName: 'title',
                  kind: 'Field',
                  metadata: {},
                  type: 'String'
                }, {
                  fieldName: 'url',
                  kind: 'Field',
                  metadata: {},
                  type: 'URI'
                }, _reactRelay2.default.QL.__frag(RQL_0)]),
                fieldName: 'node',
                kind: 'Field',
                metadata: {
                  canHaveSubselections: true,
                  inferredRootCallName: 'node',
                  inferredPrimaryKey: 'id',
                  isRequisite: true
                },
                type: 'PullRequest'
              }, {
                fieldName: 'cursor',
                kind: 'Field',
                metadata: {
                  isGenerated: true,
                  isRequisite: true
                },
                type: 'String'
              }],
              fieldName: 'edges',
              kind: 'Field',
              metadata: {
                canHaveSubselections: true,
                isPlural: true
              },
              type: 'PullRequestEdge'
            }, {
              children: [{
                fieldName: 'hasNextPage',
                kind: 'Field',
                metadata: {
                  isGenerated: true,
                  isRequisite: true
                },
                type: 'Boolean'
              }, {
                fieldName: 'hasPreviousPage',
                kind: 'Field',
                metadata: {
                  isGenerated: true,
                  isRequisite: true
                },
                type: 'Boolean'
              }],
              fieldName: 'pageInfo',
              kind: 'Field',
              metadata: {
                canHaveSubselections: true,
                isGenerated: true,
                isRequisite: true
              },
              type: 'PageInfo'
            }],
            fieldName: 'pullRequests',
            kind: 'Field',
            metadata: {
              canHaveSubselections: true,
              isConnection: true
            },
            type: 'PullRequestConnection'
          }, {
            fieldName: 'id',
            kind: 'Field',
            metadata: {
              isGenerated: true,
              isRequisite: true
            },
            type: 'ID'
          }],
          fieldName: 'repository',
          kind: 'Field',
          metadata: {
            canHaveSubselections: true,
            inferredRootCallName: 'node',
            inferredPrimaryKey: 'id'
          },
          type: 'Repository'
        }],
        id: _reactRelay2.default.QL.__id(),
        kind: 'Fragment',
        metadata: {},
        name: 'Pr_QueryRelayQL',
        type: 'Query'
      };
    }(_prInfoContainer2.default.getFragment('pullRequest'))
  }
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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