'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IssueishLookupByNumber = undefined;

var _desc, _value, _class, _class2, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRelay = require('react-relay');

var _reactRelay2 = _interopRequireDefault(_reactRelay);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _coreDecorators = require('core-decorators');

var _issueishPaneItemContainer = require('./issueish-pane-item-container');

var _issueishPaneItemContainer2 = _interopRequireDefault(_issueishPaneItemContainer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

let IssueishLookupByNumber = exports.IssueishLookupByNumber = (_class = (_temp = _class2 = class IssueishLookupByNumber extends _react2.default.Component {

  componentDidMount() {
    this.updateTitle();
  }

  componentDidUpdate() {
    this.updateTitle();
  }

  updateTitle() {
    const repository = this.props.query.repository;

    if (repository && repository.issueish) {
      var _props$relay$variable = this.props.relay.variables;
      const repoOwner = _props$relay$variable.repoOwner,
            repoName = _props$relay$variable.repoName,
            issueishNumber = _props$relay$variable.issueishNumber;
      // eslint-disable-next-line no-irregular-whitespace

      let title = `${repoOwner}/${repoName}#${issueishNumber} — ${repository.issueish.title}`;
      if (repository.issueish.__typename === 'Issue') {
        title = 'Issue: ' + title;
      } else {
        title = 'PR: ' + title;
      }
      this.props.onTitleChange(title);
    }
  }

  render() {
    const repo = this.props.query.repository;
    if (!repo || !repo.issueish) {
      return _react2.default.createElement(
        'div',
        null,
        'Issue/PR #',
        this.props.relay.variables.issueishNumber,
        ' not found'
      ); // TODO: no PRs
    }
    return _react2.default.createElement(_issueishPaneItemContainer2.default, { repository: repo, issueish: repo.issueish, switchToIssueish: this.switchToIssueish });
  }

  switchToIssueish(repoOwner, repoName, issueishNumber) {
    this.props.relay.setVariables({ repoOwner, repoName, issueishNumber });
  }
}, _class2.propTypes = {
  onTitleChange: _propTypes2.default.func.isRequired,
  query: _propTypes2.default.shape({
    repository: _propTypes2.default.object
  }),
  relay: _propTypes2.default.shape({
    setVariables: _propTypes2.default.func.isRequired,
    variables: _propTypes2.default.shape({
      repoOwner: _propTypes2.default.string.isRequired,
      repoName: _propTypes2.default.string.isRequired,
      issueishNumber: _propTypes2.default.number.isRequired
    }).isRequired
  }).isRequired
}, _temp), (_applyDecoratedDescriptor(_class.prototype, 'switchToIssueish', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'switchToIssueish'), _class.prototype)), _class);
exports.default = _reactRelay2.default.createContainer(IssueishLookupByNumber, {
  initialVariables: {
    repoOwner: null,
    repoName: null,
    issueishNumber: null
  },

  // TOOD: remove issueish/PR hack once GraphQL is fixed
  fragments: {
    query: () => function (RQL_0, RQL_1, RQL_2) {
      return {
        children: [{
          calls: [{
            kind: 'Call',
            metadata: {},
            name: 'owner',
            value: {
              kind: 'CallVariable',
              callVariableName: 'repoOwner'
            }
          }, {
            kind: 'Call',
            metadata: {},
            name: 'name',
            value: {
              kind: 'CallVariable',
              callVariableName: 'repoName'
            }
          }],
          children: [].concat.apply([], [{
            alias: 'issueish',
            calls: [{
              kind: 'Call',
              metadata: {},
              name: 'number',
              value: {
                kind: 'CallVariable',
                callVariableName: 'issueishNumber'
              }
            }],
            children: [{
              fieldName: '__typename',
              kind: 'Field',
              metadata: {
                isRequisite: true
              },
              type: 'String'
            }, {
              children: [].concat.apply([], [{
                fieldName: 'title',
                kind: 'Field',
                metadata: {},
                type: 'String'
              }, {
                fieldName: 'id',
                kind: 'Field',
                metadata: {
                  isGenerated: true,
                  isRequisite: true
                },
                type: 'ID'
              }, _reactRelay2.default.QL.__frag(RQL_1)]),
              id: _reactRelay2.default.QL.__id(),
              kind: 'Fragment',
              metadata: {},
              name: 'Issue',
              type: 'Issue'
            }, {
              children: [].concat.apply([], [{
                fieldName: 'title',
                kind: 'Field',
                metadata: {},
                type: 'String'
              }, {
                fieldName: 'id',
                kind: 'Field',
                metadata: {
                  isGenerated: true,
                  isRequisite: true
                },
                type: 'ID'
              }, _reactRelay2.default.QL.__frag(RQL_2)]),
              id: _reactRelay2.default.QL.__id(),
              kind: 'Fragment',
              metadata: {},
              name: 'PullRequest',
              type: 'PullRequest'
            }, {
              children: [{
                fieldName: 'id',
                kind: 'Field',
                metadata: {
                  isGenerated: true,
                  isRequisite: true
                },
                type: 'ID'
              }, {
                fieldName: '__typename',
                kind: 'Field',
                metadata: {
                  isGenerated: true,
                  isRequisite: true
                },
                type: 'String'
              }],
              id: _reactRelay2.default.QL.__id(),
              kind: 'Fragment',
              metadata: {
                isAbstract: true
              },
              name: 'IdFragment',
              type: 'Node'
            }],
            fieldName: 'issueOrPullRequest',
            kind: 'Field',
            metadata: {
              canHaveSubselections: true,
              inferredRootCallName: 'node',
              inferredPrimaryKey: 'id',
              isAbstract: true
            },
            type: 'IssueOrPullRequest'
          }, {
            fieldName: 'id',
            kind: 'Field',
            metadata: {
              isGenerated: true,
              isRequisite: true
            },
            type: 'ID'
          }, _reactRelay2.default.QL.__frag(RQL_0)]),
          fieldName: 'repository',
          kind: 'Field',
          metadata: {
            canHaveSubselections: true,
            inferredRootCallName: 'node',
            inferredPrimaryKey: 'id'
          },
          type: 'Repository'
        }],
        id: _reactRelay2.default.QL.__id(),
        kind: 'Fragment',
        metadata: {},
        name: 'Issueish_QueryRelayQL',
        type: 'Query'
      };
    }(_issueishPaneItemContainer2.default.getFragment('repository'), _issueishPaneItemContainer2.default.getFragment('issueish'), _issueishPaneItemContainer2.default.getFragment('issueish'))
  }
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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