Object.defineProperty(exports, '__esModule', {
  value: true
});

var _slicedToArray = (function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i['return']) _i['return'](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError('Invalid attempt to destructure non-iterable instance'); } }; })();

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/** @babel */

var _atom = require('atom');

var _humanizePlus = require('humanize-plus');

var _humanizePlus2 = _interopRequireDefault(_humanizePlus);

var _fuzzyFinderView = require('./fuzzy-finder-view');

var _fuzzyFinderView2 = _interopRequireDefault(_fuzzyFinderView);

var _pathLoader = require('./path-loader');

var _pathLoader2 = _interopRequireDefault(_pathLoader);

var ProjectView = (function (_FuzzyFinderView) {
  _inherits(ProjectView, _FuzzyFinderView);

  function ProjectView(paths) {
    var _this = this;

    _classCallCheck(this, ProjectView);

    _get(Object.getPrototypeOf(ProjectView.prototype), 'constructor', this).call(this);
    this.disposables = new _atom.CompositeDisposable();
    this.paths = paths;
    this.reloadPaths = !this.paths || this.paths.length === 0;
    this.reloadAfterFirstLoad = false;

    var windowFocused = function windowFocused() {
      if (_this.paths) {
        _this.reloadPaths = true;
      } else {
        // The window gained focused while the first task was still running
        // so let it complete but reload the paths on the next populate call.
        _this.reloadAfterFirstLoad = true;
      }
    };
    window.addEventListener('focus', windowFocused);
    this.disposables.add(new _atom.Disposable(function () {
      window.removeEventListener('focus', windowFocused);
    }));

    this.disposables.add(atom.config.onDidChange('fuzzy-finder.ignoredNames', function () {
      _this.reloadPaths = true;
    }));
    this.disposables.add(atom.config.onDidChange('core.followSymlinks', function () {
      _this.reloadPaths = true;
    }));
    this.disposables.add(atom.config.onDidChange('core.ignoredNames', function () {
      _this.reloadPaths = true;
    }));
    this.disposables.add(atom.config.onDidChange('core.excludeVcsIgnoredPaths', function () {
      _this.reloadPaths = true;
    }));
    this.disposables.add(atom.project.onDidChangePaths(function () {
      _this.reloadPaths = true;
      _this.paths = null;
    }));
  }

  _createClass(ProjectView, [{
    key: 'destroy',
    value: function destroy() {
      if (this.loadPathsTask) {
        this.loadPathsTask.terminate();
      }

      this.disposables.dispose();
      return _get(Object.getPrototypeOf(ProjectView.prototype), 'destroy', this).call(this);
    }
  }, {
    key: 'toggle',
    value: _asyncToGenerator(function* () {
      if (this.panel && this.panel.isVisible()) {
        this.cancel();
      } else {
        this.show();
        yield this.populate();
      }
    })
  }, {
    key: 'populate',
    value: _asyncToGenerator(function* () {
      var _this2 = this;

      if (atom.project.getPaths().length === 0) {
        yield this.setItems([]);
        return;
      }

      yield this.setItems(this.paths || []);

      if (this.reloadPaths) {
        this.reloadPaths = false;
        var task = null;
        try {
          task = this.runLoadPathsTask(function () {
            if (_this2.reloadAfterFirstLoad) {
              _this2.reloadPaths = true;
              _this2.reloadAfterFirstLoad = false;
            }

            _this2.populate();
          });
        } catch (error) {
          // If, for example, a network drive is unmounted, @runLoadPathsTask will
          // throw ENOENT when it tries to get the realpath of all the project paths.
          // This catch block allows the file finder to still operate on the last
          // set of paths and still let the user know that something is wrong.
          if (error.code === 'ENOENT' || error.code === 'EPERM') {
            atom.notifications.addError('Project path not found!', { detail: error.message });
          } else {
            throw error;
          }
        }

        if (this.paths) {
          yield this.selectListView.update({ loadingMessage: 'Reindexing project…' });
        } else {
          yield this.selectListView.update({ loadingMessage: 'Indexing project…', loadingBadge: '0' });
          if (task) {
            (function () {
              var pathsFound = 0;
              task.on('load-paths:paths-found', function (paths) {
                pathsFound += paths.length;
                _this2.selectListView.update({ loadingMessage: 'Indexing project…', loadingBadge: _humanizePlus2['default'].intComma(pathsFound) });
              });
            })();
          }
        }
      }
    })
  }, {
    key: 'getEmptyMessage',
    value: function getEmptyMessage() {
      return 'Project is empty';
    }
  }, {
    key: 'projectRelativePathsForFilePaths',
    value: function projectRelativePathsForFilePaths(filePaths) {
      var projectRelativePaths = _get(Object.getPrototypeOf(ProjectView.prototype), 'projectRelativePathsForFilePaths', this).call(this, filePaths);
      var lastOpenedPath = this.getLastOpenedPath();
      if (lastOpenedPath) {
        for (var i = 0; i < projectRelativePaths.length; i++) {
          var filePath = projectRelativePaths[i].filePath;

          if (filePath === lastOpenedPath) {
            var _projectRelativePaths$splice = projectRelativePaths.splice(i, 1);

            var _projectRelativePaths$splice2 = _slicedToArray(_projectRelativePaths$splice, 1);

            var entry = _projectRelativePaths$splice2[0];

            projectRelativePaths.unshift(entry);
            break;
          }
        }
      }

      return projectRelativePaths;
    }
  }, {
    key: 'getLastOpenedPath',
    value: function getLastOpenedPath() {
      var activePath = null;
      var activePaneItem = atom.workspace.getActivePaneItem();
      if (activePaneItem && activePaneItem.getPath) {
        activePath = activePaneItem.getPath();
      }

      var lastOpenedEditor = null;
      for (var editor of atom.workspace.getTextEditors()) {
        var filePath = editor.getPath();
        if (!filePath) {
          continue;
        }

        if (activePath === filePath) {
          continue;
        }

        if (!lastOpenedEditor) {
          lastOpenedEditor = editor;
        }

        if (editor.lastOpened > lastOpenedEditor.lastOpened) {
          lastOpenedEditor = editor;
        }
      }

      return lastOpenedEditor ? lastOpenedEditor.getPath() : null;
    }
  }, {
    key: 'runLoadPathsTask',
    value: function runLoadPathsTask(fn) {
      var _this3 = this;

      if (this.loadPathsTask) {
        this.loadPathsTask.terminate();
      }

      this.loadPathsTask = _pathLoader2['default'].startTask(function (paths) {
        _this3.paths = paths;
        _this3.reloadPaths = false;
        if (fn) {
          fn();
        }
      });
      return this.loadPathsTask;
    }
  }]);

  return ProjectView;
})(_fuzzyFinderView2['default']);

exports['default'] = ProjectView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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