(function() {
  var _, escapeHtml, escapeNode, escapeRegex, getReplacementResultsMessage, getSearchResultsMessage, sanitizePattern, showIf;

  _ = require('underscore-plus');

  escapeNode = null;

  escapeHtml = function(str) {
    if (escapeNode == null) {
      escapeNode = document.createElement('div');
    }
    escapeNode.innerText = str;
    return escapeNode.innerHTML;
  };

  escapeRegex = function(str) {
    return str.replace(/[.?*+^$[\]\\(){}|-]/g, function(match) {
      return "\\" + match;
    });
  };

  sanitizePattern = function(pattern) {
    pattern = escapeHtml(pattern);
    return pattern.replace(/\n/g, '\\n').replace(/\t/g, '\\t');
  };

  getReplacementResultsMessage = function(arg) {
    var findPattern, replacePattern, replacedPathCount, replacementCount;
    findPattern = arg.findPattern, replacePattern = arg.replacePattern, replacedPathCount = arg.replacedPathCount, replacementCount = arg.replacementCount;
    if (replacedPathCount) {
      return "<span class=\"text-highlight\">Replaced <span class=\"highlight-error\">" + (sanitizePattern(findPattern)) + "</span> with <span class=\"highlight-success\">" + (sanitizePattern(replacePattern)) + "</span> " + (_.pluralize(replacementCount, 'time')) + " in " + (_.pluralize(replacedPathCount, 'file')) + "</span>";
    } else {
      return "<span class=\"text-highlight\">Nothing replaced</span>";
    }
  };

  getSearchResultsMessage = function(results) {
    var findPattern, matchCount, pathCount, replacedPathCount;
    if ((results != null ? results.findPattern : void 0) != null) {
      findPattern = results.findPattern, matchCount = results.matchCount, pathCount = results.pathCount, replacedPathCount = results.replacedPathCount;
      if (matchCount) {
        return (_.pluralize(matchCount, 'result')) + " found in " + (_.pluralize(pathCount, 'file')) + " for <span class=\"highlight-info\">" + (sanitizePattern(findPattern)) + "</span>";
      } else {
        return "No " + (replacedPathCount != null ? 'more' : '') + " results found for '" + (sanitizePattern(findPattern)) + "'";
      }
    } else {
      return '';
    }
  };

  showIf = function(condition) {
    if (condition) {
      return null;
    } else {
      return {
        display: 'none'
      };
    }
  };

  module.exports = {
    escapeHtml: escapeHtml,
    escapeRegex: escapeRegex,
    sanitizePattern: sanitizePattern,
    getReplacementResultsMessage: getReplacementResultsMessage,
    getSearchResultsMessage: getSearchResultsMessage,
    showIf: showIf
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
