Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _os = require('os');

var _os2 = _interopRequireDefault(_os);

var _stackTrace = require('stack-trace');

var _stackTrace2 = _interopRequireDefault(_stackTrace);

var _fsPlus = require('fs-plus');

var _fsPlus2 = _interopRequireDefault(_fsPlus);

var API_KEY = '7ddca14cb60cbd1cd12d1b252473b076';
var LIB_VERSION = require('../package.json')['version'];
var StackTraceCache = new WeakMap();

var Reporter = (function () {
  function Reporter() {
    var params = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];

    _classCallCheck(this, Reporter);

    this.request = params.request || window.fetch;
    this.alwaysReport = params.hasOwnProperty('alwaysReport') ? params.alwaysReport : false;
    this.reportPreviousErrors = params.hasOwnProperty('reportPreviousErrors') ? params.reportPreviousErrors : true;
    this.reportedErrors = [];
    this.reportedAssertionFailures = [];
  }

  _createClass(Reporter, [{
    key: 'buildNotificationJSON',
    value: function buildNotificationJSON(error, params) {
      return {
        apiKey: API_KEY,
        notifier: {
          name: 'Atom',
          version: LIB_VERSION,
          url: 'https://www.atom.io'
        },
        events: [{
          payloadVersion: "2",
          exceptions: [this.buildExceptionJSON(error, params.projectRoot)],
          severity: params.severity,
          user: {
            id: params.userId
          },
          app: {
            version: params.appVersion,
            releaseStage: params.releaseStage
          },
          device: {
            osVersion: params.osVersion
          },
          metaData: error.metadata
        }]
      };
    }
  }, {
    key: 'buildExceptionJSON',
    value: function buildExceptionJSON(error, projectRoot) {
      return {
        errorClass: error.constructor.name,
        message: error.message,
        stacktrace: this.buildStackTraceJSON(error, projectRoot)
      };
    }
  }, {
    key: 'buildStackTraceJSON',
    value: function buildStackTraceJSON(error, projectRoot) {
      var _this = this;

      return this.parseStackTrace(error).map(function (callSite) {
        return {
          file: _this.normalizePath(callSite.getFileName()),
          method: callSite.getMethodName() || callSite.getFunctionName() || "none",
          lineNumber: callSite.getLineNumber(),
          columnNumber: callSite.getColumnNumber(),
          inProject: !/node_modules/.test(callSite.getFileName())
        };
      });
    }
  }, {
    key: 'normalizePath',
    value: function normalizePath(path) {
      return path.replace('file:///', '') // Randomly inserted file url protocols
      .replace(/[/]/g, '\\') // Temp switch for Windows home matching
      .replace(_fsPlus2['default'].getHomeDirectory(), '~') // Remove users home dir for apm-dev'ed packages
      .replace(/\\/g, '/') // Switch \ back to / for everyone
      .replace(/.*(\/(app\.asar|packages\/).*)/, '$1'); // Remove everything before app.asar or pacakges
    }
  }, {
    key: 'getDefaultNotificationParams',
    value: function getDefaultNotificationParams() {
      return {
        userId: atom.config.get('exception-reporting.userId'),
        appVersion: atom.getVersion(),
        releaseStage: this.getReleaseChannel(atom.getVersion()),
        projectRoot: atom.getLoadSettings().resourcePath,
        osVersion: _os2['default'].platform() + '-' + _os2['default'].arch() + '-' + _os2['default'].release()
      };
    }
  }, {
    key: 'getReleaseChannel',
    value: function getReleaseChannel(version) {
      return version.indexOf('beta') > -1 ? 'beta' : version.indexOf('dev') > -1 ? 'dev' : 'stable';
    }
  }, {
    key: 'performRequest',
    value: function performRequest(json) {
      this.request.call(null, 'https://notify.bugsnag.com', {
        method: 'POST',
        headers: new Headers({ 'Content-Type': 'application/json' }),
        body: JSON.stringify(json)
      });
    }
  }, {
    key: 'shouldReport',
    value: function shouldReport(error) {
      if (this.alwaysReport) return true; // Used in specs
      if (atom.config.get('core.telemetryConsent') !== 'limited') return false;
      if (atom.inDevMode()) return false;

      var topFrame = this.parseStackTrace(error)[0];
      return topFrame && topFrame.getFileName() && topFrame.getFileName().indexOf(atom.getLoadSettings().resourcePath) === 0;
    }
  }, {
    key: 'parseStackTrace',
    value: function parseStackTrace(error) {
      var callSites = StackTraceCache.get(error);
      if (callSites) {
        return callSites;
      } else {
        callSites = _stackTrace2['default'].parse(error);
        StackTraceCache.set(error, callSites);
        return callSites;
      }
    }
  }, {
    key: 'requestPrivateMetadataConsent',
    value: function requestPrivateMetadataConsent(error, message, reportFn) {
      var notification = undefined,
          dismissSubscription = undefined;

      function reportWithoutPrivateMetadata() {
        if (dismissSubscription) {
          dismissSubscription.dispose();
        }
        delete error.privateMetadata;
        delete error.privateMetadataDescription;
        reportFn(error);
        if (notification) {
          notification.dismiss();
        }
      }

      function reportWithPrivateMetadata() {
        if (error.metadata == null) {
          error.metadata = {};
        }
        for (var key in error.privateMetadata) {
          var value = error.privateMetadata[key];
          error.metadata[key] = value;
        }
        reportWithoutPrivateMetadata();
      }

      var name = error.privateMetadataRequestName;
      if (name != null) {
        if (localStorage.getItem('private-metadata-request:' + name)) {
          return reportWithoutPrivateMetadata(error);
        } else {
          localStorage.setItem('private-metadata-request:' + name, true);
        }
      }

      notification = atom.notifications.addInfo(message, {
        detail: error.privateMetadataDescription,
        description: "Are you willing to submit this information to a private server for debugging purposes?",
        dismissable: true,
        buttons: [{
          text: "No",
          onDidClick: reportWithoutPrivateMetadata
        }, {
          text: "Yes, Submit for Debugging",
          onDidClick: reportWithPrivateMetadata
        }]
      });

      dismissSubscription = notification.onDidDismiss(reportWithoutPrivateMetadata);
    }
  }, {
    key: 'addPackageMetadata',
    value: function addPackageMetadata(error) {
      var activePackages = atom.packages.getActivePackages();
      if (activePackages.length > 0) {
        var userPackages = {};
        var bundledPackages = {};
        for (var pack of atom.packages.getActivePackages()) {
          if (/\/app\.asar\//.test(pack.path)) {
            bundledPackages[pack.name] = pack.metadata.version;
          } else {
            userPackages[pack.name] = pack.metadata.version;
          }
        }

        if (error.metadata == null) {
          error.metadata = {};
        }
        error.metadata.bundledPackages = bundledPackages;
        error.metadata.userPackages = userPackages;
      }
    }
  }, {
    key: 'addPreviousErrorsMetadata',
    value: function addPreviousErrorsMetadata(error) {
      if (!this.reportPreviousErrors) return;
      if (!error.metadata) error.metadata = {};
      error.metadata.previousErrors = this.reportedErrors.map(function (error) {
        return error.message;
      });
      error.metadata.previousAssertionFailures = this.reportedAssertionFailures.map(function (error) {
        return error.message;
      });
    }
  }, {
    key: 'reportUncaughtException',
    value: function reportUncaughtException(error) {
      var _this2 = this;

      if (!this.shouldReport(error)) return;

      this.addPackageMetadata(error);
      this.addPreviousErrorsMetadata(error);

      if (error.privateMetadata != null && error.privateMetadataDescription != null) {
        this.requestPrivateMetadataConsent(error, "The Atom team would like to collect the following information to resolve this error:", function (error) {
          return _this2.reportUncaughtException(error);
        });
        return;
      }

      var params = this.getDefaultNotificationParams();
      params.severity = "error";
      this.performRequest(this.buildNotificationJSON(error, params));
      this.reportedErrors.push(error);
    }
  }, {
    key: 'reportFailedAssertion',
    value: function reportFailedAssertion(error) {
      var _this3 = this;

      if (!this.shouldReport(error)) return;

      this.addPackageMetadata(error);
      this.addPreviousErrorsMetadata(error);

      if (error.privateMetadata != null && error.privateMetadataDescription != null) {
        this.requestPrivateMetadataConsent(error, "The Atom team would like to collect some information to resolve an unexpected condition:", function (error) {
          return _this3.reportFailedAssertion(error);
        });
        return;
      }

      var params = this.getDefaultNotificationParams();
      params.severity = "warning";
      this.performRequest(this.buildNotificationJSON(error, params));
      this.reportedAssertionFailures.push(error);
    }

    // Used in specs
  }, {
    key: 'setRequestFunction',
    value: function setRequestFunction(requestFunction) {
      this.request = requestFunction;
    }
  }]);

  return Reporter;
})();

exports['default'] = Reporter;

Reporter.API_KEY = API_KEY;
Reporter.LIB_VERSION = LIB_VERSION;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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