Object.defineProperty(exports, '__esModule', {
  value: true
});
/** @babel */

var _atom = require('atom');

var reporter = undefined;

function getReporter() {
  if (!reporter) {
    var Reporter = require('./reporter');
    reporter = new Reporter();
  }
  return reporter;
}

exports['default'] = {
  activate: function activate() {
    this.subscriptions = new _atom.CompositeDisposable();

    if (!atom.config.get('exception-reporting.userId')) {
      atom.config.set('exception-reporting.userId', require('node-uuid').v4());
    }

    this.subscriptions.add(atom.onDidThrowError(function (_ref) {
      var message = _ref.message;
      var url = _ref.url;
      var line = _ref.line;
      var column = _ref.column;
      var originalError = _ref.originalError;

      try {
        getReporter().reportUncaughtException(originalError);
      } catch (secondaryException) {
        try {
          console.error("Error reporting uncaught exception", secondaryException);
          getReporter().reportUncaughtException(secondaryException);
        } catch (error) {}
      }
    }));

    if (atom.onDidFailAssertion != null) {
      this.subscriptions.add(atom.onDidFailAssertion(function (error) {
        try {
          getReporter().reportFailedAssertion(error);
        } catch (secondaryException) {
          try {
            console.error("Error reporting assertion failure", secondaryException);
            getReporter().reportUncaughtException(secondaryException);
          } catch (error) {}
        }
      }));
    }
  }
};
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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