Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _atom = require('atom');

var EncodingStatusView = (function () {
  function EncodingStatusView(statusBar, encodings) {
    var _this = this;

    _classCallCheck(this, EncodingStatusView);

    this.statusBar = statusBar;
    this.encodings = encodings;
    this.element = document.createElement('encoding-selector-status');
    this.element.classList.add('encoding-status', 'inline-block');
    this.encodingLink = document.createElement('a');
    this.encodingLink.classList.add('inline-block');
    this.encodingLink.href = '#';
    this.element.appendChild(this.encodingLink);

    // TODO[v1.19]: Remove conditional once atom.workspace.observeActiveTextEditor ships in Atom v1.19
    if (atom.workspace.observeActiveTextEditor) {
      this.activeItemSubscription = atom.workspace.observeActiveTextEditor(this.subscribeToActiveTextEditor.bind(this));
    } else {
      this.activeItemSubscription = atom.workspace.observeActivePaneItem(this.subscribeToActiveTextEditor.bind(this));
    }

    var clickHandler = function clickHandler(event) {
      event.preventDefault();
      atom.commands.dispatch(atom.workspace.getActiveTextEditor().element, 'encoding-selector:show');
    };
    this.element.addEventListener('click', clickHandler);
    this.clickSubscription = new _atom.Disposable(function () {
      return _this.element.removeEventListener('click', clickHandler);
    });
  }

  _createClass(EncodingStatusView, [{
    key: 'destroy',
    value: function destroy() {
      if (this.activeItemSubscription) {
        this.activeItemSubscription.dispose();
      }

      if (this.encodingSubscription) {
        this.encodingSubscription.dispose();
      }

      if (this.clickSubscription) {
        this.clickSubscription.dispose();
      }

      if (this.tile) {
        this.tile.destroy();
      }

      if (this.tooltip) {
        this.tooltip.dispose();
      }
    }
  }, {
    key: 'attach',
    value: function attach() {
      this.tile = this.statusBar.addRightTile({ priority: 11, item: this.element });
    }
  }, {
    key: 'subscribeToActiveTextEditor',
    value: function subscribeToActiveTextEditor() {
      if (this.encodingSubscription) {
        this.encodingSubscription.dispose();
      }

      var editor = atom.workspace.getActiveTextEditor();
      if (editor) {
        this.encodingSubscription = editor.onDidChangeEncoding(this.updateEncodingText.bind(this));
      }
      this.updateEncodingText();
    }
  }, {
    key: 'updateEncodingText',
    value: function updateEncodingText() {
      var _this2 = this;

      atom.views.updateDocument(function () {
        var editor = atom.workspace.getActiveTextEditor();
        if (editor && editor.getEncoding()) {
          var editorEncoding = editor.getEncoding().toLowerCase().replace(/[^0-9a-z]|:\d{4}$/g, '');
          var encodingLabel = _this2.encodings[editorEncoding] || { status: editorEncoding };
          _this2.encodingLink.textContent = encodingLabel.status;
          _this2.encodingLink.dataset.encoding = editorEncoding;
          _this2.element.style.display = '';

          if (_this2.tooltip) {
            _this2.tooltip.dispose();
          }
          _this2.tooltip = atom.tooltips.add(_this2.encodingLink, { title: 'This file uses ' + encodingLabel.list + ' encoding' });
        } else {
          _this2.element.style.display = 'none';
        }
      });
    }
  }]);

  return EncodingStatusView;
})();

exports['default'] = EncodingStatusView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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