Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _iconvLite = require('iconv-lite');

var _iconvLite2 = _interopRequireDefault(_iconvLite);

var _jschardet = require('jschardet');

var _jschardet2 = _interopRequireDefault(_jschardet);

var _fs = require('fs');

var _fs2 = _interopRequireDefault(_fs);

var _atomSelectList = require('atom-select-list');

var _atomSelectList2 = _interopRequireDefault(_atomSelectList);

var EncodingListView = (function () {
  function EncodingListView(encodings) {
    var _this = this;

    _classCallCheck(this, EncodingListView);

    this.encodings = encodings;
    this.selectListView = new _atomSelectList2['default']({
      itemsClassList: ['mark-active'],
      items: [],
      filterKeyForItem: function filterKeyForItem(encoding) {
        return encoding.name;
      },
      elementForItem: function elementForItem(encoding) {
        var element = document.createElement('li');
        if (encoding.id === _this.currentEncoding) {
          element.classList.add('active');
        }
        element.textContent = encoding.name;
        element.dataset.encoding = encoding.id;
        return element;
      },
      didConfirmSelection: function didConfirmSelection(encoding) {
        _this.cancel();
        if (encoding.id === 'detect') {
          _this.detectEncoding();
        } else {
          atom.workspace.getActiveTextEditor().setEncoding(encoding.id);
        }
      },
      didCancelSelection: function didCancelSelection() {
        _this.cancel();
      }
    });
    this.selectListView.element.classList.add('encoding-selector');
  }

  _createClass(EncodingListView, [{
    key: 'destroy',
    value: function destroy() {
      this.cancel();
      return this.selectListView.destroy();
    }
  }, {
    key: 'cancel',
    value: function cancel() {
      if (this.panel != null) {
        this.panel.destroy();
      }
      this.panel = null;
      this.currentEncoding = null;
      if (this.previouslyFocusedElement) {
        this.previouslyFocusedElement.focus();
        this.previouslyFocusedElement = null;
      }
    }
  }, {
    key: 'attach',
    value: function attach() {
      this.previouslyFocusedElement = document.activeElement;
      if (this.panel == null) {
        this.panel = atom.workspace.addModalPanel({ item: this.selectListView });
      }
      this.selectListView.focus();
      this.selectListView.reset();
    }
  }, {
    key: 'toggle',
    value: _asyncToGenerator(function* () {
      if (this.panel != null) {
        this.cancel();
      } else if (atom.workspace.getActiveTextEditor()) {
        var editor = atom.workspace.getActiveTextEditor();
        this.currentEncoding = editor.getEncoding();
        var encodingItems = [];

        if (_fs2['default'].existsSync(editor.getPath())) {
          encodingItems.push({ id: 'detect', name: 'Auto Detect' });
        }

        for (var id in this.encodings) {
          encodingItems.push({ id: id, name: this.encodings[id].list });
        }

        yield this.selectListView.update({ items: encodingItems });
        this.attach();
      }
    })
  }, {
    key: 'detectEncoding',
    value: function detectEncoding() {
      var editor = atom.workspace.getActiveTextEditor();
      var filePath = editor.getPath();
      if (_fs2['default'].existsSync(filePath)) {
        _fs2['default'].readFile(filePath, function (error, buffer) {
          if (!error) {
            var _ref = _jschardet2['default'].detect(buffer) || {};

            var encoding = _ref.encoding;

            if (encoding === 'ascii') {
              encoding = 'utf8';
            }

            if (_iconvLite2['default'].encodingExists(encoding)) {
              editor.setEncoding(encoding.toLowerCase().replace(/[^0-9a-z]|:\d{4}$/g, ''));
            }
          }
        });
      }
    }
  }]);

  return EncodingListView;
})();

exports['default'] = EncodingListView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi9ob21lL3RyYXZpcy9idWlsZC9hdG9tL2F0b20vb3V0L2FwcC9ub2RlX21vZHVsZXMvZW5jb2Rpbmctc2VsZWN0b3IvbGliL2VuY29kaW5nLWxpc3Qtdmlldy5qcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7Ozs7Ozt5QkFFa0IsWUFBWTs7Ozt5QkFDUixXQUFXOzs7O2tCQUNsQixJQUFJOzs7OzhCQUNRLGtCQUFrQjs7OztJQUV4QixnQkFBZ0I7QUFDdkIsV0FETyxnQkFBZ0IsQ0FDdEIsU0FBUyxFQUFFOzs7MEJBREwsZ0JBQWdCOztBQUVqQyxRQUFJLENBQUMsU0FBUyxHQUFHLFNBQVMsQ0FBQTtBQUMxQixRQUFJLENBQUMsY0FBYyxHQUFHLGdDQUFtQjtBQUN2QyxvQkFBYyxFQUFFLENBQUMsYUFBYSxDQUFDO0FBQy9CLFdBQUssRUFBRSxFQUFFO0FBQ1Qsc0JBQWdCLEVBQUUsMEJBQUMsUUFBUTtlQUFLLFFBQVEsQ0FBQyxJQUFJO09BQUE7QUFDN0Msb0JBQWMsRUFBRSx3QkFBQyxRQUFRLEVBQUs7QUFDNUIsWUFBTSxPQUFPLEdBQUcsUUFBUSxDQUFDLGFBQWEsQ0FBQyxJQUFJLENBQUMsQ0FBQTtBQUM1QyxZQUFJLFFBQVEsQ0FBQyxFQUFFLEtBQUssTUFBSyxlQUFlLEVBQUU7QUFDeEMsaUJBQU8sQ0FBQyxTQUFTLENBQUMsR0FBRyxDQUFDLFFBQVEsQ0FBQyxDQUFBO1NBQ2hDO0FBQ0QsZUFBTyxDQUFDLFdBQVcsR0FBRyxRQUFRLENBQUMsSUFBSSxDQUFBO0FBQ25DLGVBQU8sQ0FBQyxPQUFPLENBQUMsUUFBUSxHQUFHLFFBQVEsQ0FBQyxFQUFFLENBQUE7QUFDdEMsZUFBTyxPQUFPLENBQUE7T0FDZjtBQUNELHlCQUFtQixFQUFFLDZCQUFDLFFBQVEsRUFBSztBQUNqQyxjQUFLLE1BQU0sRUFBRSxDQUFBO0FBQ2IsWUFBSSxRQUFRLENBQUMsRUFBRSxLQUFLLFFBQVEsRUFBRTtBQUM1QixnQkFBSyxjQUFjLEVBQUUsQ0FBQTtTQUN0QixNQUFNO0FBQ0wsY0FBSSxDQUFDLFNBQVMsQ0FBQyxtQkFBbUIsRUFBRSxDQUFDLFdBQVcsQ0FBQyxRQUFRLENBQUMsRUFBRSxDQUFDLENBQUE7U0FDOUQ7T0FDRjtBQUNELHdCQUFrQixFQUFFLDhCQUFNO0FBQ3hCLGNBQUssTUFBTSxFQUFFLENBQUE7T0FDZDtLQUNGLENBQUMsQ0FBQTtBQUNGLFFBQUksQ0FBQyxjQUFjLENBQUMsT0FBTyxDQUFDLFNBQVMsQ0FBQyxHQUFHLENBQUMsbUJBQW1CLENBQUMsQ0FBQTtHQUMvRDs7ZUE3QmtCLGdCQUFnQjs7V0ErQjNCLG1CQUFHO0FBQ1QsVUFBSSxDQUFDLE1BQU0sRUFBRSxDQUFBO0FBQ2IsYUFBTyxJQUFJLENBQUMsY0FBYyxDQUFDLE9BQU8sRUFBRSxDQUFBO0tBQ3JDOzs7V0FFTSxrQkFBRztBQUNSLFVBQUksSUFBSSxDQUFDLEtBQUssSUFBSSxJQUFJLEVBQUU7QUFDdEIsWUFBSSxDQUFDLEtBQUssQ0FBQyxPQUFPLEVBQUUsQ0FBQTtPQUNyQjtBQUNELFVBQUksQ0FBQyxLQUFLLEdBQUcsSUFBSSxDQUFBO0FBQ2pCLFVBQUksQ0FBQyxlQUFlLEdBQUcsSUFBSSxDQUFBO0FBQzNCLFVBQUksSUFBSSxDQUFDLHdCQUF3QixFQUFFO0FBQ2pDLFlBQUksQ0FBQyx3QkFBd0IsQ0FBQyxLQUFLLEVBQUUsQ0FBQTtBQUNyQyxZQUFJLENBQUMsd0JBQXdCLEdBQUcsSUFBSSxDQUFBO09BQ3JDO0tBQ0Y7OztXQUVNLGtCQUFHO0FBQ1IsVUFBSSxDQUFDLHdCQUF3QixHQUFHLFFBQVEsQ0FBQyxhQUFhLENBQUE7QUFDdEQsVUFBSSxJQUFJLENBQUMsS0FBSyxJQUFJLElBQUksRUFBRTtBQUN0QixZQUFJLENBQUMsS0FBSyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsYUFBYSxDQUFDLEVBQUMsSUFBSSxFQUFFLElBQUksQ0FBQyxjQUFjLEVBQUMsQ0FBQyxDQUFBO09BQ3ZFO0FBQ0QsVUFBSSxDQUFDLGNBQWMsQ0FBQyxLQUFLLEVBQUUsQ0FBQTtBQUMzQixVQUFJLENBQUMsY0FBYyxDQUFDLEtBQUssRUFBRSxDQUFBO0tBQzVCOzs7NkJBRVksYUFBRztBQUNkLFVBQUksSUFBSSxDQUFDLEtBQUssSUFBSSxJQUFJLEVBQUU7QUFDdEIsWUFBSSxDQUFDLE1BQU0sRUFBRSxDQUFBO09BQ2QsTUFBTSxJQUFJLElBQUksQ0FBQyxTQUFTLENBQUMsbUJBQW1CLEVBQUUsRUFBRTtBQUMvQyxZQUFNLE1BQU0sR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLG1CQUFtQixFQUFFLENBQUE7QUFDbkQsWUFBSSxDQUFDLGVBQWUsR0FBRyxNQUFNLENBQUMsV0FBVyxFQUFFLENBQUE7QUFDM0MsWUFBTSxhQUFhLEdBQUcsRUFBRSxDQUFBOztBQUV4QixZQUFJLGdCQUFHLFVBQVUsQ0FBQyxNQUFNLENBQUMsT0FBTyxFQUFFLENBQUMsRUFBRTtBQUNuQyx1QkFBYSxDQUFDLElBQUksQ0FBQyxFQUFDLEVBQUUsRUFBRSxRQUFRLEVBQUUsSUFBSSxFQUFFLGFBQWEsRUFBQyxDQUFDLENBQUE7U0FDeEQ7O0FBRUQsYUFBSyxJQUFJLEVBQUUsSUFBSSxJQUFJLENBQUMsU0FBUyxFQUFFO0FBQzdCLHVCQUFhLENBQUMsSUFBSSxDQUFDLEVBQUMsRUFBRSxFQUFGLEVBQUUsRUFBRSxJQUFJLEVBQUUsSUFBSSxDQUFDLFNBQVMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxJQUFJLEVBQUMsQ0FBQyxDQUFBO1NBQ3hEOztBQUVELGNBQU0sSUFBSSxDQUFDLGNBQWMsQ0FBQyxNQUFNLENBQUMsRUFBQyxLQUFLLEVBQUUsYUFBYSxFQUFDLENBQUMsQ0FBQTtBQUN4RCxZQUFJLENBQUMsTUFBTSxFQUFFLENBQUE7T0FDZDtLQUNGOzs7V0FFYywwQkFBRztBQUNoQixVQUFNLE1BQU0sR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLG1CQUFtQixFQUFFLENBQUE7QUFDbkQsVUFBTSxRQUFRLEdBQUcsTUFBTSxDQUFDLE9BQU8sRUFBRSxDQUFBO0FBQ2pDLFVBQUksZ0JBQUcsVUFBVSxDQUFDLFFBQVEsQ0FBQyxFQUFFO0FBQzNCLHdCQUFHLFFBQVEsQ0FBQyxRQUFRLEVBQUUsVUFBQyxLQUFLLEVBQUUsTUFBTSxFQUFLO0FBQ3ZDLGNBQUksQ0FBQyxLQUFLLEVBQUU7dUJBQ08sdUJBQVUsTUFBTSxDQUFDLE1BQU0sQ0FBQyxJQUFJLEVBQUU7O2dCQUExQyxRQUFRLFFBQVIsUUFBUTs7QUFDYixnQkFBSSxRQUFRLEtBQUssT0FBTyxFQUFFO0FBQ3hCLHNCQUFRLEdBQUcsTUFBTSxDQUFBO2FBQ2xCOztBQUVELGdCQUFJLHVCQUFNLGNBQWMsQ0FBQyxRQUFRLENBQUMsRUFBRTtBQUNsQyxvQkFBTSxDQUFDLFdBQVcsQ0FBQyxRQUFRLENBQUMsV0FBVyxFQUFFLENBQUMsT0FBTyxDQUFDLG9CQUFvQixFQUFFLEVBQUUsQ0FBQyxDQUFDLENBQUE7YUFDN0U7V0FDRjtTQUNGLENBQUMsQ0FBQTtPQUNIO0tBQ0Y7OztTQS9Ga0IsZ0JBQWdCOzs7cUJBQWhCLGdCQUFnQiIsImZpbGUiOiIvaG9tZS90cmF2aXMvYnVpbGQvYXRvbS9hdG9tL291dC9hcHAvbm9kZV9tb2R1bGVzL2VuY29kaW5nLXNlbGVjdG9yL2xpYi9lbmNvZGluZy1saXN0LXZpZXcuanMiLCJzb3VyY2VzQ29udGVudCI6WyIvKiogQGJhYmVsICovXG5cbmltcG9ydCBpY29udiBmcm9tICdpY29udi1saXRlJ1xuaW1wb3J0IGpzY2hhcmRldCBmcm9tICdqc2NoYXJkZXQnXG5pbXBvcnQgZnMgZnJvbSAnZnMnXG5pbXBvcnQgU2VsZWN0TGlzdFZpZXcgZnJvbSAnYXRvbS1zZWxlY3QtbGlzdCdcblxuZXhwb3J0IGRlZmF1bHQgY2xhc3MgRW5jb2RpbmdMaXN0VmlldyB7XG4gIGNvbnN0cnVjdG9yIChlbmNvZGluZ3MpIHtcbiAgICB0aGlzLmVuY29kaW5ncyA9IGVuY29kaW5nc1xuICAgIHRoaXMuc2VsZWN0TGlzdFZpZXcgPSBuZXcgU2VsZWN0TGlzdFZpZXcoe1xuICAgICAgaXRlbXNDbGFzc0xpc3Q6IFsnbWFyay1hY3RpdmUnXSxcbiAgICAgIGl0ZW1zOiBbXSxcbiAgICAgIGZpbHRlcktleUZvckl0ZW06IChlbmNvZGluZykgPT4gZW5jb2RpbmcubmFtZSxcbiAgICAgIGVsZW1lbnRGb3JJdGVtOiAoZW5jb2RpbmcpID0+IHtcbiAgICAgICAgY29uc3QgZWxlbWVudCA9IGRvY3VtZW50LmNyZWF0ZUVsZW1lbnQoJ2xpJylcbiAgICAgICAgaWYgKGVuY29kaW5nLmlkID09PSB0aGlzLmN1cnJlbnRFbmNvZGluZykge1xuICAgICAgICAgIGVsZW1lbnQuY2xhc3NMaXN0LmFkZCgnYWN0aXZlJylcbiAgICAgICAgfVxuICAgICAgICBlbGVtZW50LnRleHRDb250ZW50ID0gZW5jb2RpbmcubmFtZVxuICAgICAgICBlbGVtZW50LmRhdGFzZXQuZW5jb2RpbmcgPSBlbmNvZGluZy5pZFxuICAgICAgICByZXR1cm4gZWxlbWVudFxuICAgICAgfSxcbiAgICAgIGRpZENvbmZpcm1TZWxlY3Rpb246IChlbmNvZGluZykgPT4ge1xuICAgICAgICB0aGlzLmNhbmNlbCgpXG4gICAgICAgIGlmIChlbmNvZGluZy5pZCA9PT0gJ2RldGVjdCcpIHtcbiAgICAgICAgICB0aGlzLmRldGVjdEVuY29kaW5nKClcbiAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICBhdG9tLndvcmtzcGFjZS5nZXRBY3RpdmVUZXh0RWRpdG9yKCkuc2V0RW5jb2RpbmcoZW5jb2RpbmcuaWQpXG4gICAgICAgIH1cbiAgICAgIH0sXG4gICAgICBkaWRDYW5jZWxTZWxlY3Rpb246ICgpID0+IHtcbiAgICAgICAgdGhpcy5jYW5jZWwoKVxuICAgICAgfVxuICAgIH0pXG4gICAgdGhpcy5zZWxlY3RMaXN0Vmlldy5lbGVtZW50LmNsYXNzTGlzdC5hZGQoJ2VuY29kaW5nLXNlbGVjdG9yJylcbiAgfVxuXG4gIGRlc3Ryb3kgKCkge1xuICAgIHRoaXMuY2FuY2VsKClcbiAgICByZXR1cm4gdGhpcy5zZWxlY3RMaXN0Vmlldy5kZXN0cm95KClcbiAgfVxuXG4gIGNhbmNlbCAoKSB7XG4gICAgaWYgKHRoaXMucGFuZWwgIT0gbnVsbCkge1xuICAgICAgdGhpcy5wYW5lbC5kZXN0cm95KClcbiAgICB9XG4gICAgdGhpcy5wYW5lbCA9IG51bGxcbiAgICB0aGlzLmN1cnJlbnRFbmNvZGluZyA9IG51bGxcbiAgICBpZiAodGhpcy5wcmV2aW91c2x5Rm9jdXNlZEVsZW1lbnQpIHtcbiAgICAgIHRoaXMucHJldmlvdXNseUZvY3VzZWRFbGVtZW50LmZvY3VzKClcbiAgICAgIHRoaXMucHJldmlvdXNseUZvY3VzZWRFbGVtZW50ID0gbnVsbFxuICAgIH1cbiAgfVxuXG4gIGF0dGFjaCAoKSB7XG4gICAgdGhpcy5wcmV2aW91c2x5Rm9jdXNlZEVsZW1lbnQgPSBkb2N1bWVudC5hY3RpdmVFbGVtZW50XG4gICAgaWYgKHRoaXMucGFuZWwgPT0gbnVsbCkge1xuICAgICAgdGhpcy5wYW5lbCA9IGF0b20ud29ya3NwYWNlLmFkZE1vZGFsUGFuZWwoe2l0ZW06IHRoaXMuc2VsZWN0TGlzdFZpZXd9KVxuICAgIH1cbiAgICB0aGlzLnNlbGVjdExpc3RWaWV3LmZvY3VzKClcbiAgICB0aGlzLnNlbGVjdExpc3RWaWV3LnJlc2V0KClcbiAgfVxuXG4gIGFzeW5jIHRvZ2dsZSAoKSB7XG4gICAgaWYgKHRoaXMucGFuZWwgIT0gbnVsbCkge1xuICAgICAgdGhpcy5jYW5jZWwoKVxuICAgIH0gZWxzZSBpZiAoYXRvbS53b3Jrc3BhY2UuZ2V0QWN0aXZlVGV4dEVkaXRvcigpKSB7XG4gICAgICBjb25zdCBlZGl0b3IgPSBhdG9tLndvcmtzcGFjZS5nZXRBY3RpdmVUZXh0RWRpdG9yKClcbiAgICAgIHRoaXMuY3VycmVudEVuY29kaW5nID0gZWRpdG9yLmdldEVuY29kaW5nKClcbiAgICAgIGNvbnN0IGVuY29kaW5nSXRlbXMgPSBbXVxuXG4gICAgICBpZiAoZnMuZXhpc3RzU3luYyhlZGl0b3IuZ2V0UGF0aCgpKSkge1xuICAgICAgICBlbmNvZGluZ0l0ZW1zLnB1c2goe2lkOiAnZGV0ZWN0JywgbmFtZTogJ0F1dG8gRGV0ZWN0J30pXG4gICAgICB9XG5cbiAgICAgIGZvciAobGV0IGlkIGluIHRoaXMuZW5jb2RpbmdzKSB7XG4gICAgICAgIGVuY29kaW5nSXRlbXMucHVzaCh7aWQsIG5hbWU6IHRoaXMuZW5jb2RpbmdzW2lkXS5saXN0fSlcbiAgICAgIH1cblxuICAgICAgYXdhaXQgdGhpcy5zZWxlY3RMaXN0Vmlldy51cGRhdGUoe2l0ZW1zOiBlbmNvZGluZ0l0ZW1zfSlcbiAgICAgIHRoaXMuYXR0YWNoKClcbiAgICB9XG4gIH1cblxuICBkZXRlY3RFbmNvZGluZyAoKSB7XG4gICAgY29uc3QgZWRpdG9yID0gYXRvbS53b3Jrc3BhY2UuZ2V0QWN0aXZlVGV4dEVkaXRvcigpXG4gICAgY29uc3QgZmlsZVBhdGggPSBlZGl0b3IuZ2V0UGF0aCgpXG4gICAgaWYgKGZzLmV4aXN0c1N5bmMoZmlsZVBhdGgpKSB7XG4gICAgICBmcy5yZWFkRmlsZShmaWxlUGF0aCwgKGVycm9yLCBidWZmZXIpID0+IHtcbiAgICAgICAgaWYgKCFlcnJvcikge1xuICAgICAgICAgIGxldCB7ZW5jb2Rpbmd9ID0ganNjaGFyZGV0LmRldGVjdChidWZmZXIpIHx8IHt9XG4gICAgICAgICAgaWYgKGVuY29kaW5nID09PSAnYXNjaWknKSB7XG4gICAgICAgICAgICBlbmNvZGluZyA9ICd1dGY4J1xuICAgICAgICAgIH1cblxuICAgICAgICAgIGlmIChpY29udi5lbmNvZGluZ0V4aXN0cyhlbmNvZGluZykpIHtcbiAgICAgICAgICAgIGVkaXRvci5zZXRFbmNvZGluZyhlbmNvZGluZy50b0xvd2VyQ2FzZSgpLnJlcGxhY2UoL1teMC05YS16XXw6XFxkezR9JC9nLCAnJykpXG4gICAgICAgICAgfVxuICAgICAgICB9XG4gICAgICB9KVxuICAgIH1cbiAgfVxufVxuIl19