(function() {
  var BaseThemeWatcher, PackageWatcher, UIWatcher, _,
    bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };

  _ = require('underscore-plus');

  BaseThemeWatcher = require('./base-theme-watcher');

  PackageWatcher = require('./package-watcher');

  module.exports = UIWatcher = (function() {
    function UIWatcher() {
      this.reloadAll = bind(this.reloadAll, this);
      this.watchers = [];
      this.baseTheme = this.createWatcher(BaseThemeWatcher);
      this.watchPackages();
    }

    UIWatcher.prototype.watchPackages = function() {
      var i, j, len, len1, pack, ref, ref1, theme;
      this.watchedThemes = {};
      this.watchedPackages = {};
      ref = atom.themes.getActiveThemes();
      for (i = 0, len = ref.length; i < len; i++) {
        theme = ref[i];
        this.watchTheme(theme);
      }
      ref1 = atom.packages.getLoadedPackages();
      for (j = 0, len1 = ref1.length; j < len1; j++) {
        pack = ref1[j];
        this.watchPackage(pack);
      }
      return this.watchForPackageChanges();
    };

    UIWatcher.prototype.watchForPackageChanges = function() {
      return atom.themes.onDidChangeActiveThemes((function(_this) {
        return function() {
          var i, len, name, ref, ref1, theme, watcher;
          ref = _this.watchedThemes;
          for (name in ref) {
            watcher = ref[name];
            watcher.destroy();
          }
          _this.watchedThemes = {};
          ref1 = atom.themes.getActiveThemes();
          for (i = 0, len = ref1.length; i < len; i++) {
            theme = ref1[i];
            _this.watchTheme(theme);
          }
          return null;
        };
      })(this));
    };

    UIWatcher.prototype.watchTheme = function(theme) {
      if (PackageWatcher.supportsPackage(theme, 'theme')) {
        return this.watchedThemes[theme.name] = this.createWatcher(PackageWatcher, theme);
      }
    };

    UIWatcher.prototype.watchPackage = function(pack) {
      if (PackageWatcher.supportsPackage(pack, 'atom')) {
        return this.watchedPackages[pack.name] = this.createWatcher(PackageWatcher, pack);
      }
    };

    UIWatcher.prototype.createWatcher = function(type, object) {
      var watcher;
      watcher = new type(object);
      watcher.onDidChangeGlobals((function(_this) {
        return function() {
          console.log('Global changed, reloading all styles');
          return _this.reloadAll();
        };
      })(this));
      watcher.onDidDestroy((function(_this) {
        return function() {
          return _this.watchers = _.without(_this.watchers, watcher);
        };
      })(this));
      this.watchers.push(watcher);
      return watcher;
    };

    UIWatcher.prototype.reloadAll = function() {
      var i, j, len, len1, pack, ref, ref1, results;
      this.baseTheme.loadAllStylesheets();
      ref = atom.packages.getActivePackages();
      for (i = 0, len = ref.length; i < len; i++) {
        pack = ref[i];
        if (PackageWatcher.supportsPackage(pack, 'atom')) {
          pack.reloadStylesheets();
        }
      }
      ref1 = atom.themes.getActiveThemes();
      results = [];
      for (j = 0, len1 = ref1.length; j < len1; j++) {
        pack = ref1[j];
        if (PackageWatcher.supportsPackage(pack, 'theme')) {
          results.push(pack.reloadStylesheets());
        }
      }
      return results;
    };

    UIWatcher.prototype.destroy = function() {
      var name, ref, ref1, results, watcher;
      this.baseTheme.destroy();
      ref = this.watchedPackages;
      for (name in ref) {
        watcher = ref[name];
        watcher.destroy();
      }
      ref1 = this.watchedThemes;
      results = [];
      for (name in ref1) {
        watcher = ref1[name];
        results.push(watcher.destroy());
      }
      return results;
    };

    return UIWatcher;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
